/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class MappedFile
extends File {
    private static final char[] HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private File source;
    private String hash;

    public MappedFile(File source, String destName) {
        super(destName);
        this.source = source;
        this.hash = null;
    }

    public boolean canExecute() {
        return this.source.canExecute();
    }

    public boolean canRead() {
        return this.source.canExecute();
    }

    public boolean canWrite() {
        return this.source.canExecute();
    }

    public boolean isDirectory() {
        return this.source.isDirectory();
    }

    public boolean isHidden() {
        return this.source.isHidden();
    }

    public long lastModified() {
        return this.source.lastModified();
    }

    public long length() {
        return this.source.length();
    }

    public String getContentHash() throws IOException {
        if (this.hash == null) {
            this.hash = this.computeContentHash();
        }
        return this.hash;
    }

    public InputStream getInputStream() throws FileNotFoundException {
        return new FileInputStream(this.source);
    }

    public File getSourceFile() {
        return this.source;
    }

    public String[] list() {
        return this.source.list();
    }

    public String[] list(final FilenameFilter filter) {
        final MappedFile targetDir = this;
        return this.source.list(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return filter.accept(targetDir, name);
            }
        });
    }

    public MappedFile[] listFiles() {
        return this.listFilesInner(null);
    }

    public MappedFile[] listFiles(FilenameFilter filter) {
        return this.listFilesInner(filter);
    }

    public MappedFile[] listFiles(final FileFilter filter) {
        FilenameFilter nameFilter = filter == null ? null : new FilenameFilter(){

            public boolean accept(File dir, String name) {
                File file = new File(dir, name);
                return filter.accept(file);
            }
        };
        return this.listFilesInner(nameFilter);
    }

    private String computeContentHash() throws IOException {
        InputStream s = this.getInputStream();
        byte[] buf = new byte[4096];
        try {
            int num_read;
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            while ((num_read = s.read(buf)) != -1) {
                digest.update(buf, 0, num_read);
            }
            StringBuffer builder = new StringBuffer(40);
            int i = 0;
            for (byte b : digest.digest()) {
                if (i > 0 && i % 4 == 0) {
                    builder.append('_');
                }
                builder.append(HEX[b >> 4 & 0xF]);
                builder.append(HEX[b & 0xF]);
                ++i;
            }
            return builder.toString();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private MappedFile[] listFilesInner(FilenameFilter filter) {
        String[] childNames = filter == null ? this.list() : this.list(filter);
        MappedFile[] rtn = new MappedFile[childNames.length];
        for (int i = 0; i < childNames.length; ++i) {
            rtn[i] = new MappedFile(new File(this.source, childNames[i]), new File(this, childNames[i]).getPath());
        }
        return rtn;
    }
}

