/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.MappedFile;
import java.io.File;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappedFileIterator
implements Iterator<MappedFile>,
Iterable<MappedFile> {
    private LinkedList<MappedFile> dirs;
    private Iterator<MappedFile> files;
    private MappedFile next;

    public MappedFileIterator(File source, String targetPrefix) {
        this.next = new MappedFile(source, targetPrefix);
        this.dirs = new LinkedList();
        if (source.isDirectory()) {
            this.files = Arrays.asList(this.next.listFiles()).iterator();
        }
    }

    public MappedFileIterator(MappedFile root) {
        this.next = root;
        this.dirs = new LinkedList();
        if (root.isDirectory()) {
            this.files = Arrays.asList(this.next.listFiles()).iterator();
        }
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public MappedFile next() {
        if (this.next == null) {
            throw new NoSuchElementException();
        }
        return this._next();
    }

    private MappedFile _next() {
        MappedFile result;
        block5: {
            result = this.next;
            this.next = null;
            if (this.files != null) {
                try {
                    this.next = this.files.next();
                    if (this.next.isDirectory()) {
                        this.dirs.add(this.next);
                    }
                }
                catch (NoSuchElementException ex) {
                    if (this.dirs.isEmpty()) {
                        this.files = null;
                    }
                    this.files = Arrays.asList(this.dirs.removeFirst().listFiles()).iterator();
                    if (!this.files.hasNext()) break block5;
                    this.next = this.files.next();
                    if (!this.next.isDirectory()) break block5;
                    this.dirs.add(this.next);
                }
            }
        }
        return result;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<MappedFile> iterator() {
        return this;
    }
}

