/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.security;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.Permission;
import java.security.Policy;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecurityManagerInstaller {
    private static final transient Logger logger = Logger.getLogger(SecurityManagerInstaller.class.getName());
    private static final String EXT_DIRS_PROPERTY = "java.ext.dirs";
    private static boolean isInstalled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void install(URL ... urls) {
        File file;
        if (isInstalled) {
            return;
        }
        try {
            file = SecurityManagerInstaller.generatePolicyFile(urls);
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot generate policy file.", ex);
        }
        try {
            if (System.getSecurityManager() != null) {
                throw new IllegalStateException("SecurityManager already installed: " + System.getSecurityManager());
            }
            System.setProperty("java.security.policy", "=" + file.getPath());
            System.setSecurityManager(new SecurityManager());
            Policy.getPolicy().refresh();
        }
        finally {
            if (!file.delete()) {
                logger.warning("Unable to delete dynamic policy file: " + file);
            }
        }
        isInstalled = true;
    }

    private static File generatePolicyFile(URL[] urls) throws IOException {
        ClassLoader ourClassLoader = SecurityManagerInstaller.class.getClassLoader();
        if (ourClassLoader != ClassLoader.getSystemClassLoader()) {
            throw new IllegalStateException("SecurityManagerInstaller must be loaded in the system ClassLoader; was " + ourClassLoader);
        }
        if (!(ourClassLoader instanceof URLClassLoader)) {
            throw new ClassCastException("System ClassLoader is " + ourClassLoader + ", not a URLClassLoader.");
        }
        URLClassLoader urlClassLoader = (URLClassLoader)ourClassLoader;
        File file = File.createTempFile("test", ".policy");
        logger.info("Auto-generating policy file at: " + file);
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        for (URL url : urlClassLoader.getURLs()) {
            SecurityManagerInstaller.grantToUrl(url.toString(), AllPermission.class, writer);
        }
        for (URL url : urls) {
            SecurityManagerInstaller.grantToUrl(url.toString(), AllPermission.class, writer);
        }
        SecurityManagerInstaller.grantToExtDirs(AllPermission.class, writer);
        writer.close();
        return file;
    }

    private static void grantToExtDirs(Class<? extends Permission> permissionClass, PrintWriter writer) {
        StringTokenizer tokenizer = new StringTokenizer(System.getProperty(EXT_DIRS_PROPERTY), File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            File extDir = new File(tokenizer.nextToken());
            try {
                String urlPattern = extDir.toURI().toURL() + "/-";
                SecurityManagerInstaller.grantToUrl(urlPattern, permissionClass, writer);
            }
            catch (MalformedURLException ex) {
                logger.log(Level.WARNING, "Ignoring unreadable JRE extension directory: " + extDir, ex);
            }
        }
    }

    private static void grantToUrl(String urlPattern, Class<? extends Permission> permissionClass, PrintWriter writer) {
        String permissionClassName = permissionClass.getName();
        logger.fine("Granting " + urlPattern + " rights to use " + permissionClassName);
        writer.println("grant codebase \"" + urlPattern + "\" {");
        writer.println("  permission " + permissionClassName + ";");
        writer.println("};");
        writer.println();
    }
}

