/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.AppAdminFactory;
import com.google.appengine.tools.util.ClientCookieManager;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServerConnection {
    private static final String POST = "POST";
    private static final String GET = "GET";
    protected AppAdminFactory.ConnectOptions options;
    private static Logger logger = Logger.getLogger(ServerConnection.class.getName());
    private ClientCookieManager cookies;

    protected ServerConnection() {
    }

    public ServerConnection(AppAdminFactory.ConnectOptions options) {
        this.options = options;
        this.cookies = options.getCookies();
        if (this.cookies == null) {
            this.cookies = new ClientCookieManager();
        }
        if (System.getProperty("http.proxyHost") != null) {
            logger.info("proxying HTTP through " + System.getProperty("http.proxyHost") + ":" + System.getProperty("http.proxyPort"));
        }
        if (System.getProperty("https.proxyHost") != null) {
            logger.info("proxying HTTPS through " + System.getProperty("https.proxyHost") + ":" + System.getProperty("https.proxyPort"));
        }
    }

    public void saveCookies() {
        if (this.options.getUserId() == null) {
            return;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            new ObjectOutputStream(out).writeObject(this.cookies);
            byte[] bytes = out.toByteArray();
            Preferences prefs = Preferences.userNodeForPackage(ServerConnection.class);
            prefs.put("email", this.options.getUserId());
            prefs.putByteArray("cookies", bytes);
        }
        catch (IOException ex) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public String post(String url, String payload, String ... params) throws IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int i = 0; i < params.length; i += 2) {
            paramMap.put(params[i], params[i + 1]);
        }
        return this.send(POST, url, new StringPoster(payload), null, paramMap);
    }

    public String post(String url, String payload, Map<String, String> params) throws IOException {
        return this.send(POST, url, new StringPoster(payload), null, params);
    }

    public String post(String url, File payload, String contentType, String ... params) throws IOException {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        for (int i = 0; i < params.length; i += 2) {
            paramMap.put(params[i], params[i + 1]);
        }
        return this.send(POST, url, new FilePoster(payload), contentType, paramMap);
    }

    public String post(String url, File payload, String contentType, Map<String, String> params) throws IOException {
        return this.send(POST, url, new FilePoster(payload), contentType, params);
    }

    public String get(String url, Map<String, String> params) throws IOException {
        return this.send(GET, url, null, null, params);
    }

    private URL buildURL(String path) throws MalformedURLException {
        String protocol = this.options.getSecure() ? "https" : "http";
        return new URL(protocol + "://" + this.options.getServer() + path);
    }

    private String send(String method, String path, DataPoster payload, String content_type, Map<String, String> params) throws IOException, ClientLoginException {
        URL url = this.buildURL(path + '?' + this.buildQuery(params));
        if (content_type == null) {
            content_type = "application/octet-stream";
        }
        int tries = 0;
        while (true) {
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.setRequestProperty("Content-type", content_type);
            conn.setRequestProperty("X-appcfg-api-version", "1");
            if (this.options.getHost() != null) {
                conn.setRequestProperty("Host", this.options.getHost());
            }
            IOException ioe = this.connect(method, conn, payload);
            int status = conn.getResponseCode();
            BufferedReader reader = this.getReader(conn);
            if (status == 200) {
                StringBuffer response = new StringBuffer();
                String line = null;
                while ((line = reader.readLine()) != null) {
                    response.append(line);
                    response.append("\n");
                }
                return response.toString();
            }
            logger.finer("Got http error " + status + ". this is try #" + tries);
            if (++tries > 3) {
                throw new IOException(this.constructHttpErrorMessage(conn, reader));
            }
            if (status == 401) {
                this.authenticate(url.getHost(), null);
                continue;
            }
            if (status == 403) {
                System.out.println(this.constructHttpErrorMessage(conn, reader));
                this.authenticate(url.getHost(), null);
                continue;
            }
            if (status >= 500 && status <= 600 || status != 302) continue;
            Map<String, List<String>> headers = conn.getHeaderFields();
            String location = headers.get("Location").get(0);
            if (location.startsWith("https://www.google.com/accounts/ServiceLogin")) {
                this.authenticate(url.getHost(), null);
                continue;
            }
            if (!location.matches("https://www.google.com/a/[a-z0-9.-]+/ServiceLogin.*")) continue;
            this.authenticate(url.getHost(), "HOSTED");
        }
    }

    private String constructHttpErrorMessage(HttpURLConnection conn, BufferedReader reader) throws IOException {
        StringBuilder sb = new StringBuilder("Error posting to URL: ");
        sb.append(conn.getURL());
        sb.append('\n');
        sb.append(conn.getResponseCode());
        sb.append(' ');
        sb.append(conn.getResponseMessage());
        sb.append('\n');
        if (reader != null) {
            String line;
            while ((line = reader.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
        }
        return sb.toString();
    }

    private String buildQuery(Map<String, String> params) throws UnsupportedEncodingException {
        StringBuffer buf = new StringBuffer();
        for (String key : params.keySet()) {
            buf.append(URLEncoder.encode(key, "UTF-8"));
            buf.append('=');
            buf.append(URLEncoder.encode(params.get(key), "UTF-8"));
            buf.append('&');
        }
        return buf.toString();
    }

    private void authenticate(String host, String account_type) throws ClientLoginException, IOException {
        int unused = 1;
        while (true) {
            try {
                String authToken = this.getAuthToken(host, account_type);
                this.getAuthCookie(authToken);
                return;
            }
            catch (ClientLoginException e) {
                if (unused >= 3) {
                    throw e;
                }
                ++unused;
                continue;
            }
            break;
        }
    }

    private String getAuthToken(String host, String accountType) throws IOException, ClientLoginException {
        if (accountType == null) {
            accountType = host.endsWith(".google.com") ? "HOSTED_OR_GOOGLE" : (this.options.getHost() != null && this.options.getHost().endsWith(".google.com") ? "HOSTED_OR_GOOGLE" : "GOOGLE");
        }
        URL url = new URL("https://www.google.com/accounts/ClientLogin");
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        String password = this.options.getPasswordPrompt().getPassword();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("Email", this.options.getUserId());
        params.put("Passwd", password);
        params.put("service", "ah");
        params.put("source", "Google-appcfg-java-unknown");
        params.put("accountType", accountType);
        IOException ioe = this.connect(POST, conn, new StringPoster(this.buildQuery(params)));
        BufferedReader reader = this.getReader(conn);
        HashMap<String, String> response = new HashMap<String, String>();
        String line = null;
        while ((line = reader.readLine()) != null) {
            String[] pair = line.split("=", 2);
            if (pair.length != 2) continue;
            response.put(pair[0], pair[1]);
        }
        if (conn.getResponseCode() == 200) {
            return (String)response.get("Auth");
        }
        if (conn.getResponseCode() == 403) {
            String reason = (String)response.get("Error");
            if ("BadAuthentication".equals(reason)) {
                throw new ClientLoginException("Email \"" + this.options.getUserId() + "\" and password do not match.", ioe);
            }
            if ("CaptchaRequired".equals(reason)) {
                throw new ClientLoginException("Please go to https://www.google.com/accounts/DisplayUnlockCaptcha and verify you are a human. Then try again.");
            }
            if ("NotVerified".equals(reason)) {
                throw new ClientLoginException("Your account has not yet been verfied. Please check your email to do that, then try again.");
            }
            if ("TermsNotAgreed".equals(reason)) {
                throw new ClientLoginException("You have not yet agreed to the Terms of Service on your account. Please do that, then try again.");
            }
            if ("AccountDeleted".equals(reason)) {
                throw new ClientLoginException("Your user account has been deleted. If this is an error, contact account support at http://www.google.com/support/accounts/");
            }
            if ("AccountDisabled".equals(reason)) {
                throw new ClientLoginException("Your user account has been disabled. If this is an error, contact account support at http://www.google.com/support/accounts/");
            }
            if ("ServiceUnavailable".equals(reason)) {
                throw new ClientLoginException("The service is currently unavailable; try again later.");
            }
            throw new ClientLoginException((String)response.get("Error"), ioe);
        }
        if (conn.getResponseCode() == 401) {
            throw new ClientAuthFailException("Email \"" + this.options.getUserId() + "\" and password do not match.", ioe);
        }
        throw new RuntimeException("Bad authentication response: " + conn.getResponseCode() + " " + conn.getResponseMessage(), ioe);
    }

    private void getAuthCookie(String token) throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("continue", "http://localhost/");
        params.put("auth", token);
        String query = this.buildQuery(params);
        URL url = this.buildURL("/_ah/login?" + query);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        if (this.options.getHost() != null) {
            conn.setRequestProperty("Host", this.options.getHost());
        }
        IOException ioe = this.connect(POST, conn, null);
        if (conn.getResponseCode() != 302 || !"http://localhost/".equals(conn.getHeaderField("Location"))) {
            throw new RuntimeException("Bad authentication response: " + conn.getResponseCode() + " " + conn.getResponseMessage());
        }
        if (ioe != null) {
            throw ioe;
        }
    }

    private IOException connect(String method, HttpURLConnection conn, DataPoster data) throws IOException {
        this.cookies.writeCookies(conn);
        conn.setInstanceFollowRedirects(false);
        conn.setRequestMethod(method);
        if (POST.equals(method)) {
            conn.setDoOutput(true);
            OutputStream out = conn.getOutputStream();
            if (data != null) {
                data.post(out);
            }
            out.close();
        }
        this.cookies.readCookies(conn);
        try {
            conn.getInputStream();
        }
        catch (IOException ex) {
            return ex;
        }
        return null;
    }

    private BufferedReader getReader(HttpURLConnection conn) {
        InputStream is;
        try {
            is = conn.getInputStream();
        }
        catch (IOException ex) {
            is = conn.getErrorStream();
        }
        if (is == null) {
            return null;
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        return reader;
    }

    private static class FilePoster
    implements DataPoster {
        private File file;

        public FilePoster(File file) {
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void post(OutputStream out) throws IOException {
            FileInputStream in = new FileInputStream(this.file);
            try {
                int len;
                byte[] buf = new byte[4096];
                while ((len = ((InputStream)in).read(buf)) != -1) {
                    out.write(buf, 0, len);
                }
            }
            finally {
                ((InputStream)in).close();
            }
        }
    }

    private static class StringPoster
    implements DataPoster {
        private String str;

        public StringPoster(String s) {
            this.str = s;
        }

        public void post(OutputStream s) throws IOException {
            s.write(this.str.getBytes("UTF-8"));
        }
    }

    private static interface DataPoster {
        public void post(OutputStream var1) throws IOException;
    }

    public class ClientAuthFailException
    extends ClientLoginException {
        public ClientAuthFailException(String s) {
            super(s);
        }

        public ClientAuthFailException(String s, Throwable c) {
            super(s, c);
        }
    }

    public class ClientLoginException
    extends IOException {
        public ClientLoginException(String s) {
            super(s);
        }

        public ClientLoginException(String s, Throwable c) {
            super(s);
            this.initCause(c);
        }
    }
}

