/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.api.client.extensions.java6.auth.oauth2;

import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.AuthorizationCodeFlow;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.AuthorizationCodeRequestUrl;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.Credential;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.TokenResponse;
import com.google.appengine.repackaged.com.google.api.client.extensions.java6.auth.oauth2.VerificationCodeReceiver;
import com.google.appengine.repackaged.com.google.api.client.util.Preconditions;
import java.awt.Desktop;
import java.io.IOException;
import java.net.URI;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AuthorizationCodeInstalledApp {
    private final AuthorizationCodeFlow flow;
    private final VerificationCodeReceiver receiver;
    private static final Logger LOGGER = Logger.getLogger(AuthorizationCodeInstalledApp.class.getName());

    public AuthorizationCodeInstalledApp(AuthorizationCodeFlow flow, VerificationCodeReceiver receiver) {
        this.flow = Preconditions.checkNotNull(flow);
        this.receiver = Preconditions.checkNotNull(receiver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credential authorize(String userId) throws IOException {
        try {
            Credential credential = this.flow.loadCredential(userId);
            if (credential != null && (credential.getRefreshToken() != null || credential.getExpiresInSeconds() > 60L)) {
                Credential credential2 = credential;
                return credential2;
            }
            String redirectUri = this.receiver.getRedirectUri();
            AuthorizationCodeRequestUrl authorizationUrl = this.flow.newAuthorizationUrl().setRedirectUri(redirectUri);
            this.onAuthorization(authorizationUrl);
            String code = this.receiver.waitForCode();
            TokenResponse response = this.flow.newTokenRequest(code).setRedirectUri(redirectUri).execute();
            Credential credential3 = this.flow.createAndStoreCredential(response, userId);
            return credential3;
        }
        finally {
            this.receiver.stop();
        }
    }

    protected void onAuthorization(AuthorizationCodeRequestUrl authorizationUrl) throws IOException {
        AuthorizationCodeInstalledApp.browse(authorizationUrl.build());
    }

    public static void browse(String url) {
        Preconditions.checkNotNull(url);
        System.out.println("Please open the following address in your browser:");
        String string = String.valueOf(url);
        System.out.println(string.length() != 0 ? "  ".concat(string) : new String("  "));
        try {
            Desktop desktop;
            if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
                System.out.println("Attempting to open that address in the default browser now...");
                desktop.browse(URI.create(url));
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Unable to open browser", e);
        }
        catch (InternalError e) {
            LOGGER.log(Level.WARNING, "Unable to open browser", e);
        }
    }

    public final AuthorizationCodeFlow getFlow() {
        return this.flow;
    }

    public final VerificationCodeReceiver getReceiver() {
        return this.receiver;
    }
}

