/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.io.base;

import com.google.appengine.repackaged.com.google.common.base.CharMatcher;
import com.google.appengine.repackaged.com.google.common.base.Splitter;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.net.HostAndPort;

public final class ServerAddress {
    public static final int NO_PORT = -1;
    public final String host;
    public final int port;
    private static final CharMatcher MATCH_COLON = CharMatcher.is(':');
    private static final Splitter SPLIT_HOST_PAIRS = Splitter.on(',').trimResults(CharMatcher.inRange('\u0000', ' ')).omitEmptyStrings();

    public ServerAddress(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public ServerAddress(String spec) {
        this(spec, "");
    }

    public ServerAddress(String spec, String defaultHost) {
        HostAndPort hp = HostAndPort.fromString((String)spec);
        this.host = hp.getHostText().isEmpty() ? defaultHost : hp.getHostText();
        if (this.host.isEmpty()) {
            String string = String.valueOf(spec);
            throw new IllegalArgumentException(string.length() != 0 ? "no hostname: ".concat(string) : new String("no hostname: "));
        }
        if (!hp.hasPort()) {
            String string = String.valueOf(spec);
            throw new IllegalArgumentException(string.length() != 0 ? "no port: ".concat(string) : new String("no port: "));
        }
        this.port = hp.getPort();
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean equals(Object other) {
        if (other instanceof ServerAddress) {
            ServerAddress x = (ServerAddress)other;
            return x.port == this.port && x.host.equals(this.host);
        }
        return false;
    }

    public int hashCode() {
        return this.host.hashCode() + this.port;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.host.length() + 8);
        if (MATCH_COLON.countIn(this.host) >= 2 && this.host.charAt(0) != '[') {
            builder.append('[').append(this.host).append(']');
        } else {
            builder.append(this.host);
        }
        if (this.port != -1) {
            builder.append(':').append(this.port);
        }
        return builder.toString();
    }

    public static ServerAddress[] parseServerAddresses(String spec) {
        ImmutableList<String> hostPortPairs = ImmutableList.copyOf(SPLIT_HOST_PAIRS.split(spec));
        ServerAddress[] servAddrs = new ServerAddress[hostPortPairs.size()];
        for (int i = 0; i < hostPortPairs.size(); ++i) {
            servAddrs[i] = new ServerAddress((String)hostPortPairs.get(i));
        }
        return servAddrs;
    }

    public static ServerAddress valueOf(String spec) {
        return new ServerAddress(spec);
    }
}

