/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib;

import com.google.appengine.repackaged.com.google.common.base.CaseFormat;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.base.Supplier;
import com.google.appengine.repackaged.com.google.common.base.Throwables;
import com.google.appengine.repackaged.com.google.common.cache.AbstractLoadingCache;
import com.google.appengine.repackaged.com.google.common.cache.CacheBuilder;
import com.google.appengine.repackaged.com.google.common.cache.CacheBuilderSpec;
import com.google.appengine.repackaged.com.google.common.cache.CacheLoader;
import com.google.appengine.repackaged.com.google.common.cache.LoadingCache;
import com.google.appengine.repackaged.com.google.common.labs.reflect.ValueType;
import com.google.appengine.repackaged.com.google.common.primitives.Primitives;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistry;
import com.google.appengine.repackaged.com.google.protobuf.ExtensionRegistryLite;
import com.google.appengine.repackaged.com.google.protobuf.InvalidProtocolBufferException;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.MessageLiteOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.MessageOrBuilder;
import java.lang.reflect.Method;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;

public final class MessageReflectorInstance {
    private final LoadingCache<FieldKey, Getter> getters;
    private final LoadingCache<FieldKey, Getter> proto2BuilderGetters;
    private final LoadingCache<FieldKey, HasChecker> hasCheckers;
    private final LoadingCache<FieldKey, Setter> setters;
    private final LoadingCache<Class<? extends MessageLite>, Supplier<MessageLiteOrBuilder>> builderFactories;
    private final LoadingCache<Class<? extends MessageOrBuilder>, Descriptors.Descriptor> descriptorCaches;
    private final Setter absentSetter = new Setter(){

        @Override
        public boolean set(MessageLiteOrBuilder builder, Object value) {
            return false;
        }
    };
    private final Getter absentGetter = new Getter(){

        @Override
        public Object get(MessageLiteOrBuilder messageOrBuilder) {
            return null;
        }
    };
    private final HasChecker absentHasChecker = new HasChecker(){

        @Override
        public boolean has(MessageLite message) {
            return false;
        }
    };

    public MessageReflectorInstance() {
        this(CacheBuilderSpec.parse(""));
    }

    public MessageReflectorInstance(CacheBuilderSpec cacheBuilderSpec) {
        this.getters = this.createGetters(cacheBuilderSpec);
        this.proto2BuilderGetters = this.createProto2BuilderGetters(cacheBuilderSpec);
        this.hasCheckers = this.createHasCheckers(cacheBuilderSpec);
        this.setters = this.createSetters(cacheBuilderSpec);
        this.builderFactories = MessageReflectorInstance.createBuilderFactories(cacheBuilderSpec);
        this.descriptorCaches = MessageReflectorInstance.createDescriptorCaches(cacheBuilderSpec);
    }

    public <T> boolean hasFieldDeclared(Class<? extends MessageLite> messageType, Class<T> fieldType, String fieldName) {
        return this.getters.getUnchecked(new FieldKey(messageType, fieldType, fieldName)) != this.absentGetter;
    }

    public <T> T get(Class<T> fieldType, String fieldName, MessageLite message) {
        Preconditions.checkNotNull(message);
        return fieldType.cast(this.getters.getUnchecked(new FieldKey(message.getClass(), fieldType, fieldName)).get(message));
    }

    public <T> T get(Class<T> fieldType, List<String> fieldPath, MessageLite message) {
        Preconditions.checkNotNull(message);
        int n = fieldPath.size();
        int i = 0;
        for (String fieldName : fieldPath) {
            if (i < n - 1) {
                if ((message = this.get(MessageLite.class, fieldName, message)) == null) {
                    return null;
                }
            } else {
                return this.get(fieldType, fieldName, message);
            }
            ++i;
        }
        throw new IllegalStateException("never reached");
    }

    public <T> boolean has(Class<T> fieldType, String fieldName, MessageLite message) {
        return this.hasCheckers.getUnchecked(new FieldKey(message.getClass(), fieldType, fieldName)).has(message);
    }

    public <T> boolean has(Class<T> fieldType, List<String> fieldPath, MessageLite message) {
        Preconditions.checkNotNull(message);
        int n = fieldPath.size();
        int i = 0;
        for (String fieldName : fieldPath) {
            if (i < n - 1) {
                if (!this.has(MessageLite.class, fieldName, message)) {
                    return false;
                }
            } else {
                return this.has(fieldType, fieldName, message);
            }
            message = this.get(MessageLite.class, fieldName, message);
            ++i;
        }
        throw new IllegalStateException("never reached");
    }

    public MessageLiteOrBuilder newBuilder(Class<? extends MessageLite> type) {
        Preconditions.checkNotNull(type);
        return this.builderFactories.getUnchecked(type).get();
    }

    public static MessageLiteOrBuilder toBuilder(MessageLite message) {
        if (MessageReflectorInstance.isProto1(message.getClass())) {
            return ((ProtocolMessage)message).clone();
        }
        return message.toBuilder();
    }

    public MessageLiteOrBuilder getFieldBuilder(MessageLiteOrBuilder builder, String fieldName) {
        if (builder instanceof ProtocolMessage) {
            return this.get(MessageLite.class, fieldName, (MessageLite)((ProtocolMessage)builder));
        }
        return (MessageLite.Builder)this.proto2BuilderGetters.getUnchecked(new FieldKey(builder.getClass(), MessageLite.Builder.class, fieldName)).get(builder);
    }

    public <T> boolean set(Class<T> fieldType, String fieldName, MessageLiteOrBuilder messageOrBuilder, T value) {
        Preconditions.checkNotNull(messageOrBuilder);
        return this.setters.getUnchecked(new FieldKey(messageOrBuilder.getClass(), fieldType, fieldName)).set(messageOrBuilder, value);
    }

    public <T> boolean set(Class<T> fieldType, List<String> fieldPath, MessageLiteOrBuilder messageOrBuilder, T value) {
        if ((messageOrBuilder = this.getMessage(fieldPath, messageOrBuilder)) == null) {
            return false;
        }
        this.set(fieldType, fieldPath.get(fieldPath.size() - 1), messageOrBuilder, value);
        return true;
    }

    @Nullable
    public MessageLiteOrBuilder getMessage(List<String> fieldPath, MessageLiteOrBuilder messageOrBuilder) {
        Preconditions.checkNotNull(messageOrBuilder);
        int n = fieldPath.size();
        int i = 0;
        for (String fieldName : fieldPath) {
            if (i < n - 1) {
                if ((messageOrBuilder = this.getFieldBuilder(messageOrBuilder, fieldName)) == null) {
                    return null;
                }
            } else {
                return messageOrBuilder;
            }
            ++i;
        }
        throw new IllegalStateException("never reached");
    }

    public boolean set(String fieldName, MessageLiteOrBuilder messageOrBuilder, Object value) {
        Method setter = MessageReflectorInstance.findSetterMethod(messageOrBuilder.getClass(), fieldName, value.getClass());
        if (setter == null) {
            return false;
        }
        this.set(messageOrBuilder, value, setter);
        return true;
    }

    public boolean set(List<String> fieldPath, MessageLiteOrBuilder messageOrBuilder, Object value) {
        if ((messageOrBuilder = this.getMessage(fieldPath, messageOrBuilder)) == null) {
            return false;
        }
        return this.set(fieldPath.get(fieldPath.size() - 1), messageOrBuilder, value);
    }

    public static MessageLite build(MessageLiteOrBuilder message) {
        if (message instanceof ProtocolMessage) {
            return (MessageLite)message;
        }
        return ((MessageLite.Builder)message).build();
    }

    public static boolean isProto1(Class<?> type) {
        return ProtocolMessage.class.isAssignableFrom(type);
    }

    public <T extends MessageLite> T convert(Class<T> toType, MessageLite value) {
        return this.convert(toType, value, ExtensionRegistry.getEmptyRegistry());
    }

    public <T extends MessageLite> T convert(Class<T> toType, MessageLite value, ExtensionRegistry registry) {
        if (value.getClass().equals(toType)) {
            return (T)((MessageLite)toType.cast(value));
        }
        MessageLiteOrBuilder builder = this.newBuilder(toType);
        if (builder instanceof ProtocolMessage) {
            ((ProtocolMessage)builder).mergeFrom(value.toByteArray());
        } else {
            try {
                ((MessageLite.Builder)builder).mergeFrom(value.toByteArray(), (ExtensionRegistryLite)registry);
            }
            catch (InvalidProtocolBufferException e) {
                throw new RuntimeException(e);
            }
        }
        return (T)((MessageLite)toType.cast(MessageReflectorInstance.build(builder)));
    }

    public Descriptors.Descriptor getDescriptor(Class<? extends MessageOrBuilder> type) {
        return this.descriptorCaches.getUnchecked(type);
    }

    private static final <K, V> LoadingCache<K, V> createCacheDisabledLoadingCache(final CacheLoader<K, V> cacheLoader) {
        return new AbstractLoadingCache<K, V>(){

            @Override
            public V get(K key) throws ExecutionException {
                try {
                    return cacheLoader.load(key);
                }
                catch (Exception e) {
                    throw new ExecutionException(e);
                }
            }

            @Override
            @Nullable
            public V getIfPresent(Object key) {
                return this.getUnchecked(key);
            }
        };
    }

    private final CacheLoader<FieldKey, Getter> createGettersCacheLoader() {
        return new CacheLoader<FieldKey, Getter>(){

            @Override
            public Getter load(FieldKey key) throws Exception {
                String fieldName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, key.fieldName);
                if (MessageReflectorInstance.isProto1(key.messageType) && key.fieldType.equals(Boolean.class)) {
                    String string = String.valueOf(fieldName);
                    fieldName = string.length() != 0 ? "is".concat(string) : new String("is");
                } else {
                    String string = String.valueOf(fieldName);
                    fieldName = string.length() != 0 ? "get".concat(string) : new String("get");
                }
                try {
                    final Method getter = key.messageType.getMethod(fieldName, new Class[0]);
                    Class<?> returnType = Primitives.wrap(getter.getReturnType());
                    if (!key.fieldType.isAssignableFrom(returnType)) {
                        return MessageReflectorInstance.this.absentGetter;
                    }
                    return new Getter(){

                        @Override
                        public Object get(MessageLiteOrBuilder message) {
                            try {
                                return getter.invoke((Object)message, new Object[0]);
                            }
                            catch (Exception e) {
                                throw Throwables.propagate(e);
                            }
                        }
                    };
                }
                catch (NoSuchMethodException e) {
                    return MessageReflectorInstance.this.absentGetter;
                }
            }
        };
    }

    private final LoadingCache<FieldKey, Getter> createGetters(CacheBuilderSpec spec) {
        if (spec.equals(CacheBuilderSpec.disableCaching())) {
            return MessageReflectorInstance.createCacheDisabledLoadingCache(this.createGettersCacheLoader());
        }
        return CacheBuilder.from(spec).build(this.createGettersCacheLoader());
    }

    private final CacheLoader<FieldKey, Getter> createProto2BuilderGettersCacheLoader() {
        return new CacheLoader<FieldKey, Getter>(){

            @Override
            public Getter load(FieldKey key) throws Exception {
                String string = String.valueOf(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, key.fieldName));
                String fieldName = new StringBuilder(10 + String.valueOf(string).length()).append("get").append(string).append("Builder").toString();
                try {
                    final Method getter = key.messageType.getMethod(fieldName, new Class[0]);
                    return new Getter(){

                        @Override
                        public Object get(MessageLiteOrBuilder builder) {
                            try {
                                return getter.invoke((Object)builder, new Object[0]);
                            }
                            catch (Exception e) {
                                throw Throwables.propagate(e);
                            }
                        }
                    };
                }
                catch (NoSuchMethodException e) {
                    return MessageReflectorInstance.this.absentGetter;
                }
            }
        };
    }

    private final LoadingCache<FieldKey, Getter> createProto2BuilderGetters(CacheBuilderSpec spec) {
        if (spec.equals(CacheBuilderSpec.disableCaching())) {
            return MessageReflectorInstance.createCacheDisabledLoadingCache(this.createProto2BuilderGettersCacheLoader());
        }
        return CacheBuilder.from(spec).build(this.createProto2BuilderGettersCacheLoader());
    }

    private final CacheLoader<FieldKey, HasChecker> createHasCheckersLoadingCache() {
        return new CacheLoader<FieldKey, HasChecker>(){

            @Override
            public HasChecker load(FieldKey key) throws Exception {
                String string = String.valueOf(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, key.fieldName));
                String name = string.length() != 0 ? "has".concat(string) : new String("has");
                try {
                    final Method method = key.messageType.getMethod(name, new Class[0]);
                    return new HasChecker(){

                        @Override
                        public boolean has(MessageLite message) {
                            try {
                                return (Boolean)method.invoke((Object)message, new Object[0]);
                            }
                            catch (Exception e) {
                                throw Throwables.propagate(e);
                            }
                        }
                    };
                }
                catch (NoSuchMethodException e) {
                    return MessageReflectorInstance.this.absentHasChecker;
                }
            }
        };
    }

    private final LoadingCache<FieldKey, HasChecker> createHasCheckers(CacheBuilderSpec spec) {
        if (spec.equals(CacheBuilderSpec.disableCaching())) {
            return MessageReflectorInstance.createCacheDisabledLoadingCache(this.createHasCheckersLoadingCache());
        }
        return CacheBuilder.from(spec).build(this.createHasCheckersLoadingCache());
    }

    private final CacheLoader<FieldKey, Setter> createSettersCacheLoader() {
        return new CacheLoader<FieldKey, Setter>(){

            @Override
            public Setter load(FieldKey key) throws Exception {
                String fieldName = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, key.fieldName);
                if (!key.fieldType.equals(MessageLite.class)) {
                    try {
                        String string = String.valueOf(fieldName);
                        final Method setter = key.messageType.getMethod(string.length() != 0 ? "set".concat(string) : new String("set"), Primitives.unwrap(key.fieldType));
                        return new Setter(){

                            @Override
                            public boolean set(MessageLiteOrBuilder builder, Object value) {
                                try {
                                    setter.invoke((Object)builder, value);
                                }
                                catch (Exception e) {
                                    throw Throwables.propagate(e);
                                }
                                return true;
                            }
                        };
                    }
                    catch (NoSuchMethodException e) {
                        return MessageReflectorInstance.this.absentSetter;
                    }
                }
                return this.weakSetter(key, key.fieldName);
            }

            private Setter weakSetter(FieldKey key, String fieldName) {
                final Method setter = MessageReflectorInstance.findSetterMethod(key.messageType, fieldName, MessageLite.class);
                if (setter == null) {
                    return MessageReflectorInstance.this.absentSetter;
                }
                return new Setter(){

                    @Override
                    public boolean set(MessageLiteOrBuilder builder, Object value) {
                        if (value != null) {
                            Preconditions.checkState(value instanceof MessageLite);
                        }
                        MessageReflectorInstance.this.set(builder, value, setter);
                        return true;
                    }
                };
            }
        };
    }

    private final LoadingCache<FieldKey, Setter> createSetters(CacheBuilderSpec spec) {
        if (spec.equals(CacheBuilderSpec.disableCaching())) {
            return MessageReflectorInstance.createCacheDisabledLoadingCache(this.createSettersCacheLoader());
        }
        return CacheBuilder.from(spec).build(this.createSettersCacheLoader());
    }

    @Nullable
    private static Method findSetterMethod(Class<?> clazz, String fieldName, Class<?> expectedType) {
        String string = String.valueOf(CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, fieldName));
        String setterName = string.length() != 0 ? "set".concat(string) : new String("set");
        for (Method m : clazz.getMethods()) {
            if (!m.getName().equals(setterName) || m.getParameterTypes().length != 1 || !expectedType.isAssignableFrom(Primitives.wrap(m.getParameterTypes()[0]))) continue;
            return m;
        }
        return null;
    }

    private void set(MessageLiteOrBuilder builder, Object value, Method setter) {
        Class<?> actualFieldType = setter.getParameterTypes()[0];
        try {
            if (value != null && !actualFieldType.isAssignableFrom(value.getClass()) && value instanceof MessageLite) {
                Class<?> actualMessageType = actualFieldType;
                value = this.convert(actualMessageType, (MessageLite)value);
            }
            setter.invoke((Object)builder, value);
        }
        catch (Exception e) {
            throw Throwables.propagate(e);
        }
    }

    private static final LoadingCache<Class<? extends MessageLite>, Supplier<MessageLiteOrBuilder>> createBuilderFactories(CacheBuilderSpec spec) {
        if (spec.equals(CacheBuilderSpec.disableCaching())) {
            return MessageReflectorInstance.createCacheDisabledLoadingCache(MessageReflectorInstance.createBuilderFactoriesCacheLoader());
        }
        return CacheBuilder.from(spec).build(MessageReflectorInstance.createBuilderFactoriesCacheLoader());
    }

    private static final CacheLoader<Class<? extends MessageLite>, Supplier<MessageLiteOrBuilder>> createBuilderFactoriesCacheLoader() {
        return new CacheLoader<Class<? extends MessageLite>, Supplier<MessageLiteOrBuilder>>(){

            @Override
            public Supplier<MessageLiteOrBuilder> load(Class<? extends MessageLite> type) throws Exception {
                final boolean isProto1 = MessageReflectorInstance.isProto1(type);
                final Method builder = isProto1 ? type.getMethod("getDefaultInstance", new Class[0]) : type.getMethod("newBuilder", new Class[0]);
                return new Supplier<MessageLiteOrBuilder>(){

                    @Override
                    public MessageLiteOrBuilder get() {
                        try {
                            if (isProto1) {
                                return ((ProtocolMessage)builder.invoke(null, new Object[0])).clone();
                            }
                            return (MessageLite.Builder)builder.invoke(null, new Object[0]);
                        }
                        catch (Exception e) {
                            throw Throwables.propagate(e);
                        }
                    }
                };
            }
        };
    }

    private static final LoadingCache<Class<? extends MessageOrBuilder>, Descriptors.Descriptor> createDescriptorCaches(CacheBuilderSpec spec) {
        if (spec.equals(CacheBuilderSpec.disableCaching())) {
            return MessageReflectorInstance.createCacheDisabledLoadingCache(MessageReflectorInstance.createDescriptorCachesCacheLoader());
        }
        return CacheBuilder.from(spec).build(MessageReflectorInstance.createDescriptorCachesCacheLoader());
    }

    private static final CacheLoader<Class<? extends MessageOrBuilder>, Descriptors.Descriptor> createDescriptorCachesCacheLoader() {
        return new CacheLoader<Class<? extends MessageOrBuilder>, Descriptors.Descriptor>(){

            @Override
            public Descriptors.Descriptor load(Class<? extends MessageOrBuilder> type) throws Exception {
                Method descriptor = type.getMethod("getDescriptor", new Class[0]);
                try {
                    return (Descriptors.Descriptor)descriptor.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    throw Throwables.propagate(e);
                }
            }
        };
    }

    private static interface HasChecker {
        public boolean has(MessageLite var1);
    }

    private static interface Getter {
        public Object get(MessageLiteOrBuilder var1);
    }

    private static interface Setter {
        public boolean set(MessageLiteOrBuilder var1, Object var2);
    }

    private static class FieldKey
    extends ValueType {
        final Class<?> messageType;
        final Class<?> fieldType;
        final String fieldName;

        public FieldKey(Class<?> messageType, Class<?> fieldType, String fieldName) {
            this.messageType = Preconditions.checkNotNull(messageType);
            this.fieldType = Preconditions.checkNotNull(Primitives.wrap(fieldType));
            this.fieldName = Preconditions.checkNotNull(fieldName);
        }
    }
}

