/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib;

import com.google.appengine.repackaged.com.google.common.base.Function;
import com.google.appengine.repackaged.com.google.common.base.Functions;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Iterables;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.GeneratedMessage;
import com.google.appengine.repackaged.com.google.protobuf.Message;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.ProtocolMessageEnum;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ProtoCopy<F extends GeneratedMessage, T extends GeneratedMessage> {
    private final Iterable<CopyRecipe> recipes;
    private final T prototype;

    private ProtoCopy(Iterable<CopyRecipe> recipes, T prototype) {
        this.recipes = recipes;
        this.prototype = prototype;
    }

    public static <T extends GeneratedMessage> Builder<T, T> newBuilder(T prototype) {
        return new Builder(prototype, prototype, null);
    }

    public static <F extends GeneratedMessage, T extends GeneratedMessage> Builder<F, T> newBuilder(F fromPrototype, T toPrototype) {
        return new Builder(fromPrototype, toPrototype, null);
    }

    public static <F extends GeneratedMessage, T extends GeneratedMessage> Builder<F, T> newBuilder(F fromPrototype, T toPrototype, String ... fieldNames) {
        Builder<F, T> builder = ProtoCopy.newBuilder(fromPrototype, toPrototype);
        for (String fieldName : fieldNames) {
            builder.copy(fieldName);
        }
        return builder;
    }

    public T copyFrom(F source) {
        MessageLite.Builder builder = this.prototype.toBuilder();
        this.mergeFrom((Message.Builder)builder, source);
        GeneratedMessage value = (GeneratedMessage)builder.build();
        return (T)value;
    }

    public void mergeFrom(Message.Builder builder, F source) {
        Descriptors.Descriptor expectedType;
        Descriptors.Descriptor givenType = builder.getDescriptorForType();
        Preconditions.checkState(givenType == (expectedType = ((GeneratedMessage)this.prototype).getDescriptorForType()), String.format("Builder type given: %s, builder type expected: %s", givenType.getFullName(), expectedType.getFullName()));
        for (CopyRecipe recipe : this.recipes) {
            recipe.addToBuilder(builder, (Message)source);
        }
    }

    /* synthetic */ ProtoCopy(Iterable x0, GeneratedMessage x1, 1 x2) {
        this(x0, x1);
    }

    private static class CopyRecipe {
        final Function<?, ?> transform;
        final Descriptors.FieldDescriptor fromField;
        final Descriptors.FieldDescriptor toField;

        CopyRecipe(Descriptors.FieldDescriptor fromField, Descriptors.FieldDescriptor toField, Function<?, ?> transform) {
            this.transform = transform;
            this.fromField = fromField;
            this.toField = toField;
            if (fromField.isRepeated() && !toField.isRepeated()) {
                throw new IllegalStateException(String.format("Cannot copy from repeated field %s to non-repeated field %s", fromField, toField));
            }
        }

        CopyRecipe(Descriptors.FieldDescriptor toField, Function<?, ?> transform) {
            this.transform = transform;
            this.fromField = null;
            this.toField = toField;
        }

        void addToBuilder(Message.Builder builder, Message source) {
            if (this.fromField != null) {
                this.addFieldToBuilder(builder, source);
            } else {
                this.addMultiToBuilder(builder, source);
            }
        }

        private void addMultiToBuilder(Message.Builder builder, Message source) {
            Object transformed = this.transformValue(source);
            if (transformed != null) {
                builder.setField(this.toField, transformed);
            }
        }

        private void addFieldToBuilder(Message.Builder builder, Message source) {
            if (this.fromField.isRepeated()) {
                if (source.getRepeatedFieldCount(this.fromField) > 0) {
                    List values = (List)source.getField(this.fromField);
                    for (Object value : values) {
                        Object transformed = this.transformValue(value);
                        builder.addRepeatedField(this.toField, transformed);
                    }
                }
            } else if (this.toField.isRepeated()) {
                if (source.hasField(this.fromField)) {
                    Object transformed = this.transformValue(source.getField(this.fromField));
                    builder.addRepeatedField(this.toField, transformed);
                }
            } else if (source.hasField(this.fromField)) {
                Object transformed = this.transformValue(source.getField(this.fromField));
                builder.setField(this.toField, transformed);
            }
        }

        Object transformValue(Object value) {
            return this.transform.apply(value);
        }
    }

    public static class Builder<F extends GeneratedMessage, T extends GeneratedMessage> {
        private final ImmutableList.Builder<CopyRecipe> recipesBuilder;
        private final T toPrototype;
        private final F fromPrototype;

        private Builder(F fromPrototype, T toPrototype) {
            this.toPrototype = toPrototype;
            this.fromPrototype = fromPrototype;
            this.recipesBuilder = ImmutableList.builder();
        }

        public Builder<F, T> copy(String fieldName) {
            return this.copy(fieldName, fieldName);
        }

        public Builder<F, T> copy(int fieldNumber) {
            Preconditions.checkState(this.fromPrototype.getClass().equals(this.toPrototype.getClass()), "Source and destination types are different, cannot copy using a single field number");
            return this.copy(fieldNumber, fieldNumber);
        }

        private boolean maybeCompatible(Descriptors.FieldDescriptor fromField, Descriptors.FieldDescriptor toField) {
            Descriptors.FieldDescriptor.JavaType fromType = fromField.getJavaType();
            Descriptors.FieldDescriptor.JavaType toType = toField.getJavaType();
            if (fromType == Descriptors.FieldDescriptor.JavaType.ENUM) {
                return toType == Descriptors.FieldDescriptor.JavaType.ENUM && fromField.getEnumType() == toField.getEnumType();
            }
            if (fromType == Descriptors.FieldDescriptor.JavaType.MESSAGE) {
                return toType == Descriptors.FieldDescriptor.JavaType.MESSAGE && fromField.getMessageType() == toField.getMessageType();
            }
            return true;
        }

        public Builder<F, T> copy(String fromFieldName, String toFieldName) {
            Preconditions.checkArgument(this.maybeCompatible(this.getDescriptorFor(fromFieldName, (Message)this.fromPrototype), this.getDescriptorFor(toFieldName, (Message)this.toPrototype)), "Incompatible fields: from=%s to=%s", fromFieldName, toFieldName);
            return this.copy(fromFieldName, Object.class, toFieldName, Object.class, Functions.identity());
        }

        public Builder<F, T> copy(int fromFieldNumber, int toFieldNumber) {
            Preconditions.checkArgument(this.maybeCompatible(this.getDescriptorFor(fromFieldNumber, (Message)this.fromPrototype), this.getDescriptorFor(toFieldNumber, (Message)this.toPrototype)), "Incompatible fields: from=%s to=%s", fromFieldNumber, toFieldNumber);
            return this.copy(fromFieldNumber, Object.class, toFieldNumber, Object.class, Functions.identity());
        }

        public <P extends GeneratedMessage, Q extends GeneratedMessage> Builder<F, T> copy(String fromFieldName, Class<P> fromFieldType, String toFieldName, Class<Q> toFieldType, final ProtoCopy<P, Q> transform) {
            return this.copy(fromFieldName, fromFieldType, toFieldName, toFieldType, new Function<P, Q>(){

                @Override
                public Q apply(P p) {
                    return transform.copyFrom(p);
                }
            });
        }

        public <P, Q> Builder<F, T> copy(int fromFieldNumber, Class<P> fromFieldType, int toFieldNumber, Class<Q> toFieldType, Function<P, Q> transform) {
            return this.copy(this.getDescriptorFor(fromFieldNumber, (Message)this.fromPrototype), fromFieldType, this.getDescriptorFor(toFieldNumber, (Message)this.toPrototype), toFieldType, transform);
        }

        public <P, Q> Builder<F, T> copy(String fromFieldName, Class<P> fromFieldType, String toFieldName, Class<Q> toFieldType, Function<P, Q> transform) {
            return this.copy(this.getDescriptorFor(fromFieldName, (Message)this.fromPrototype), fromFieldType, this.getDescriptorFor(toFieldName, (Message)this.toPrototype), toFieldType, transform);
        }

        private <P, Q> Builder<F, T> copy(Descriptors.FieldDescriptor fromDescriptor, Class<P> unusedFromFieldType, Descriptors.FieldDescriptor toDescriptor, Class<Q> unusedToFieldType, Function<P, Q> transform) {
            this.recipesBuilder.add((Object)new CopyRecipe(fromDescriptor, toDescriptor, transform));
            return this;
        }

        public <P extends ProtocolMessageEnum, Q extends ProtocolMessageEnum> Builder<F, T> copy(String fromFieldName, String toFieldName, Map<P, Q> mapping) {
            Map.Entry sampleEntry = Iterables.getFirst(mapping.entrySet(), null);
            Preconditions.checkArgument(sampleEntry != null, "Mapping needs to have at least one entry");
            Descriptors.EnumDescriptor fromDescriptor = ((ProtocolMessageEnum)sampleEntry.getKey()).getDescriptorForType();
            Descriptors.EnumDescriptor toDescriptor = ((ProtocolMessageEnum)sampleEntry.getValue()).getDescriptorForType();
            this.checkEnumType(fromFieldName, (Message)this.fromPrototype, fromDescriptor);
            this.checkEnumType(toFieldName, (Message)this.toPrototype, toDescriptor);
            HashMap<Integer, Descriptors.EnumValueDescriptor> valueMap = new HashMap<Integer, Descriptors.EnumValueDescriptor>();
            for (Map.Entry<P, Q> entry : mapping.entrySet()) {
                Descriptors.EnumValueDescriptor value = toDescriptor.findValueByNumber(((ProtocolMessageEnum)entry.getValue()).getNumber());
                Preconditions.checkArgument(value != null, "Could not find value of number %s in the proto.", ((ProtocolMessageEnum)entry.getValue()).getNumber());
                valueMap.put(((ProtocolMessageEnum)entry.getKey()).getNumber(), value);
            }
            for (Descriptors.EnumValueDescriptor key : fromDescriptor.getValues()) {
                Preconditions.checkArgument(valueMap.containsKey(key.getNumber()), "Mapping does not contain a mapping for value %s.", key.getName());
            }
            return this.copy(fromFieldName, Descriptors.EnumValueDescriptor.class, toFieldName, Descriptors.EnumValueDescriptor.class, new EnumMappingFunction(valueMap));
        }

        public <Q> Builder<F, T> copyManyToOne(String toFieldName, Class<Q> toFieldType, Function<F, Q> transform) {
            Descriptors.FieldDescriptor descriptor = this.getDescriptorFor(toFieldName, (Message)this.toPrototype);
            Preconditions.checkArgument(!descriptor.isRepeated(), String.format("Field %s is repeated, only non-repeated are supported for many-to-one", toFieldName));
            this.recipesBuilder.add((Object)new CopyRecipe(descriptor, transform));
            return this;
        }

        public ImmutableSet<Descriptors.FieldDescriptor> remaining() {
            HashSet<Descriptors.FieldDescriptor> remaining = Sets.newHashSet(((GeneratedMessage)this.fromPrototype).getDescriptorForType().getFields());
            for (CopyRecipe present : this.recipesBuilder.build()) {
                remaining.remove(present.fromField);
            }
            return ImmutableSet.copyOf(remaining);
        }

        public ImmutableSet<Descriptors.FieldDescriptor> unset() {
            HashSet<Descriptors.FieldDescriptor> unset = Sets.newHashSet(((GeneratedMessage)this.toPrototype).getDescriptorForType().getFields());
            for (CopyRecipe present : this.recipesBuilder.build()) {
                unset.remove(present.toField);
            }
            return ImmutableSet.copyOf(unset);
        }

        public Builder<F, T> copyRemaining() {
            HashSet<String> destinationNames = Sets.newHashSet();
            for (Descriptors.FieldDescriptor unset : this.unset()) {
                destinationNames.add(unset.getName());
            }
            for (Descriptors.FieldDescriptor remaining : this.remaining()) {
                if (!destinationNames.contains(remaining.getName())) continue;
                this.copy(remaining.getName());
            }
            return this;
        }

        public ProtoCopy<F, T> build() {
            return new ProtoCopy(this.recipesBuilder.build(), (GeneratedMessage)this.toPrototype, null);
        }

        private Descriptors.FieldDescriptor getDescriptorFor(int number, Message prototype) {
            Descriptors.Descriptor descriptor = prototype.getDescriptorForType();
            return Preconditions.checkNotNull(descriptor.findFieldByNumber(number), String.format("Not in proto: number=%d", number));
        }

        private Descriptors.FieldDescriptor getDescriptorFor(String name, Message prototype) {
            Descriptors.Descriptor descriptor = prototype.getDescriptorForType();
            return Preconditions.checkNotNull(descriptor.findFieldByName(name), String.format("Not in proto: name='%s', field='%s'", name, this.getFieldNames(descriptor.getFields())));
        }

        private Iterable<String> getFieldNames(Iterable<Descriptors.FieldDescriptor> fields) {
            return Iterables.transform(fields, new Function<Descriptors.FieldDescriptor, String>(){

                @Override
                public String apply(Descriptors.FieldDescriptor input) {
                    return input.toString();
                }
            });
        }

        private void checkEnumType(String fieldName, Message prototype, Descriptors.EnumDescriptor expected) {
            Descriptors.FieldDescriptor descriptor = this.getDescriptorFor(fieldName, prototype);
            Descriptors.FieldDescriptor.Type type = descriptor.getType();
            Preconditions.checkArgument(type == Descriptors.FieldDescriptor.Type.ENUM, "Expected enum type for field %s, got %s.", new Object[]{fieldName, type});
            Descriptors.EnumDescriptor found = descriptor.getEnumType();
            Preconditions.checkArgument(expected.equals(found), "Expected enum type %s for field %s, got %s.", expected.getName(), fieldName, found.getName());
        }

        /* synthetic */ Builder(GeneratedMessage x0, GeneratedMessage x1, 1 x2) {
            this(x0, x1);
        }

        private static class EnumMappingFunction
        implements Function<Descriptors.EnumValueDescriptor, Descriptors.EnumValueDescriptor> {
            private final Map<Integer, Descriptors.EnumValueDescriptor> valueMap;

            public EnumMappingFunction(Map<Integer, Descriptors.EnumValueDescriptor> valueMap) {
                this.valueMap = Preconditions.checkNotNull(valueMap);
            }

            @Override
            public Descriptors.EnumValueDescriptor apply(Descriptors.EnumValueDescriptor input) {
                Descriptors.EnumValueDescriptor result = this.valueMap.get(input.getNumber());
                Preconditions.checkState(result != null, "Do not know how to map input enum value with number %s.", input.getNumber());
                return result;
            }
        }
    }
}

