/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib.gson;

import com.google.appengine.repackaged.com.google.common.base.Converter;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.util.CharBase64;
import com.google.appengine.repackaged.com.google.gson.JsonArray;
import com.google.appengine.repackaged.com.google.gson.JsonDeserializationContext;
import com.google.appengine.repackaged.com.google.gson.JsonDeserializer;
import com.google.appengine.repackaged.com.google.gson.JsonElement;
import com.google.appengine.repackaged.com.google.gson.JsonObject;
import com.google.appengine.repackaged.com.google.gson.JsonParseException;
import com.google.appengine.repackaged.com.google.gson.JsonPrimitive;
import com.google.appengine.repackaged.com.google.gson.JsonSerializationContext;
import com.google.appengine.repackaged.com.google.gson.JsonSerializer;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.DescriptorProtos;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.GeneratedMessage;
import com.google.appengine.repackaged.com.google.protobuf.MessageOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.ProtocolMessageEnum;
import com.google.appengine.repackaged.com.google.protobuf.contrib.JavaQualifiedNames;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;

public class GsonProtocolBuffer<T extends MessageOrBuilder>
implements JsonSerializer<T>,
JsonDeserializer<T> {
    private final Class<T> concreteClass;
    private final Converter<String, String> fieldNameConverter;

    public GsonProtocolBuffer(Class<T> clazz) {
        this(clazz, Converter.identity());
    }

    public GsonProtocolBuffer(Class<T> clazz, Converter<String, String> fieldNameConverter) {
        this.concreteClass = Preconditions.checkNotNull(clazz);
        this.fieldNameConverter = Preconditions.checkNotNull(fieldNameConverter, "fieldNameConverter");
    }

    public JsonElement serialize(T src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject ret = new JsonObject();
        Map<Descriptors.FieldDescriptor, Object> fields = src.getAllFields();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> fieldPair : fields.entrySet()) {
            Class<?> fieldClass;
            Descriptors.FieldDescriptor desc = fieldPair.getKey();
            try {
                fieldClass = this.getClassForJavaType(desc);
            }
            catch (ClassNotFoundException e) {
                fieldClass = null;
                continue;
            }
            if (fieldClass == null) continue;
            if (desc.isRepeated()) {
                List fieldList = (List)fieldPair.getValue();
                if (fieldList.size() == 0) continue;
                JsonArray array = new JsonArray();
                for (Object o : fieldList) {
                    array.add(this.serializeValue(o, fieldClass, context));
                }
                ret.add(this.getFieldName(desc), (JsonElement)array);
                continue;
            }
            ret.add(this.getFieldName(desc), this.serializeValue(fieldPair.getValue(), fieldClass, context));
        }
        return ret;
    }

    private JsonElement serializeValue(Object value, Class<?> fieldClass, JsonSerializationContext context) {
        if (ProtocolMessageEnum.class.isAssignableFrom(fieldClass)) {
            return this.serializeEnum(fieldClass, (Descriptors.EnumValueDescriptor)value, context);
        }
        if (fieldClass == ByteString.class) {
            return new JsonPrimitive(CharBase64.encode(((ByteString)value).toByteArray()));
        }
        return context.serialize(value, fieldClass);
    }

    private JsonElement serializeEnum(Class<?> fieldClass, Descriptors.EnumValueDescriptor rawValue, JsonSerializationContext context) {
        boolean failed = false;
        Object value = null;
        try {
            Method valueOfMethod = fieldClass.getDeclaredMethod("valueOf", Descriptors.EnumValueDescriptor.class);
            value = valueOfMethod.invoke(null, rawValue);
        }
        catch (IllegalAccessException e) {
            failed = true;
        }
        catch (NoSuchMethodException e) {
            failed = true;
        }
        catch (InvocationTargetException e) {
            failed = true;
        }
        if (failed) {
            return context.serialize((Object)rawValue.getName());
        }
        return context.serialize(value, fieldClass);
    }

    public T deserialize(JsonElement json, Type destType, JsonDeserializationContext context) throws JsonParseException {
        if (!json.isJsonObject()) {
            String string = String.valueOf(json);
            throw new JsonParseException(new StringBuilder(27 + String.valueOf(string).length()).append("Argument is not an object: ").append(string).toString());
        }
        JsonObject obj = json.getAsJsonObject();
        GeneratedMessage.Builder<GeneratedMessage.Builder> resultBuilder = this.getBuilderForType();
        for (Descriptors.FieldDescriptor desc : resultBuilder.getDescriptorForType().getFields()) {
            if (obj.has(this.getFieldName(desc))) {
                Class<?> descClass;
                try {
                    descClass = this.getClassForJavaType(desc);
                }
                catch (ClassNotFoundException e) {
                    String string = String.valueOf(this.concreteClass.getName());
                    throw new JsonParseException(string.length() != 0 ? "Error Instantiating ".concat(string) : new String("Error Instantiating "), (Throwable)e);
                }
                if (descClass == null) {
                    String e = String.valueOf((Object)desc.getJavaType());
                    throw new JsonParseException(new StringBuilder(22 + String.valueOf(e).length()).append("Unexpected Java Type: ").append(e).toString());
                }
                try {
                    JsonElement prop = obj.get(this.getFieldName(desc));
                    if (prop.isJsonNull()) continue;
                    if (desc.isRepeated()) {
                        if (!prop.isJsonArray()) {
                            String string = this.getFieldName(desc);
                            String string2 = String.valueOf(json);
                            throw new JsonParseException(new StringBuilder(25 + String.valueOf(string).length() + String.valueOf(string2).length()).append("Field is not an array: ").append(string).append(": ").append(string2).toString());
                        }
                        for (JsonElement arrayElement : prop.getAsJsonArray()) {
                            if (arrayElement.isJsonNull()) {
                                throw new JsonParseException("JSON nulls in arrays not allowed");
                            }
                            resultBuilder.addRepeatedField(desc, this.deserializeElement(arrayElement, desc, descClass, context));
                        }
                        continue;
                    }
                    resultBuilder.setField(desc, this.deserializeElement(prop, desc, descClass, context));
                    continue;
                }
                catch (ClassCastException e) {
                    String string = String.valueOf(this.concreteClass.getName());
                    throw new JsonParseException(string.length() != 0 ? "Error Instantiating ".concat(string) : new String("Error Instantiating "), (Throwable)e);
                }
            }
            if (!desc.isRequired()) continue;
            String string = this.getFieldName(desc);
            String string3 = String.valueOf(json);
            throw new JsonParseException(new StringBuilder(29 + String.valueOf(string).length() + String.valueOf(string3).length()).append("Required Field: ").append(string).append(" is missing. ").append(string3).toString());
        }
        if (!resultBuilder.isInitialized()) {
            String string = String.valueOf(this.concreteClass.getName());
            throw new JsonParseException(new StringBuilder(51 + String.valueOf(string).length()).append("Error Instantiating ").append(string).append(". Initialization checks failed.").toString());
        }
        try {
            MessageOrBuilder result = (MessageOrBuilder)this.concreteClass.cast(resultBuilder.build());
            return (T)result;
        }
        catch (ClassCastException e) {
            String string = String.valueOf(this.concreteClass.getName());
            throw new JsonParseException(string.length() != 0 ? "Error Instantiating ".concat(string) : new String("Error Instantiating "), (Throwable)e);
        }
    }

    private Object deserializeElement(JsonElement json, Descriptors.FieldDescriptor desc, Class<?> descClass, JsonDeserializationContext context) throws JsonParseException {
        if (descClass == ByteString.class) {
            try {
                return ByteString.copyFrom(CharBase64.decode(json.getAsString()));
            }
            catch (IllegalArgumentException e) {
                String string = String.valueOf(json);
                throw new JsonParseException(new StringBuilder(27 + String.valueOf(string).length()).append("Invalid Base64 bytes data: ").append(string).toString());
            }
        }
        Object deserializedObject = context.deserialize(json, descClass);
        if (deserializedObject == null && desc.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
            throw new JsonParseException(String.format("Error deserializing enum field [%s]. Unrecognized value [%s]", desc.getName(), json.getAsString()));
        }
        return this.fixIfEnum(descClass.cast(deserializedObject));
    }

    private GeneratedMessage.Builder<? extends GeneratedMessage.Builder> getBuilderForType() throws JsonParseException {
        GeneratedMessage.Builder resultBuilder;
        Method newBuilderMethod;
        try {
            newBuilderMethod = this.concreteClass.getDeclaredMethod("newBuilder", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String string = String.valueOf(this.concreteClass.getName());
            throw new JsonParseException(string.length() != 0 ? "Error Instantiating ".concat(string) : new String("Error Instantiating "));
        }
        catch (SecurityException e) {
            String string = String.valueOf(this.concreteClass.getName());
            throw new JsonParseException(string.length() != 0 ? "Error Instantiating ".concat(string) : new String("Error Instantiating "));
        }
        if (!Modifier.isStatic(newBuilderMethod.getModifiers())) {
            String string = String.valueOf(this.concreteClass.getName());
            throw new JsonParseException(string.length() != 0 ? "Error Instantiating ".concat(string) : new String("Error Instantiating "));
        }
        try {
            resultBuilder = (GeneratedMessage.Builder)newBuilderMethod.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            String string = String.valueOf(this.concreteClass.getName());
            throw new JsonParseException(string.length() != 0 ? "Error Instantiating ".concat(string) : new String("Error Instantiating "), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            String string = String.valueOf(this.concreteClass.getName());
            throw new JsonParseException(string.length() != 0 ? "Error Instantiating ".concat(string) : new String("Error Instantiating "), (Throwable)e);
        }
        return resultBuilder;
    }

    private String getFieldName(Descriptors.FieldDescriptor fd) {
        return this.fieldNameConverter.convert(fd.getName());
    }

    private Class<?> getClassForJavaType(Descriptors.FieldDescriptor field) throws ClassNotFoundException {
        switch (field.getJavaType()) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case BYTE_STRING: {
                return ByteString.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case ENUM: {
                return this.getProtoEnumClass(field);
            }
            case FLOAT: {
                return Float.class;
            }
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case MESSAGE: {
                return this.getMessageClass(field);
            }
            case STRING: {
                return String.class;
            }
        }
        return null;
    }

    private Object fixIfEnum(Object result) {
        if (result instanceof ProtocolMessageEnum) {
            return ((ProtocolMessageEnum)result).getValueDescriptor();
        }
        return result;
    }

    private String getJavaPrefix(Descriptors.FileDescriptor fileDesc) {
        String javaPackage;
        StringBuilder result = new StringBuilder();
        DescriptorProtos.FileOptions options = fileDesc.getOptions();
        if (options.hasJavaPackage()) {
            javaPackage = options.getJavaPackage();
        } else {
            String string;
            String protoPackage = fileDesc.getPackage();
            if ("".equals(protoPackage)) {
                string = "";
            } else {
                String string2 = String.valueOf(protoPackage);
                string = string2.length() != 0 ? ".".concat(string2) : new String(".");
            }
            String string3 = String.valueOf(string);
            String string4 = javaPackage = string3.length() != 0 ? "com.google.protos".concat(string3) : new String("com.google.protos");
        }
        if (options.hasJavaApiVersion() && options.getJavaApiVersion() == 1) {
            javaPackage = options.hasJavaAltApiPackage() ? options.getJavaAltApiPackage() : String.valueOf(javaPackage).concat(".proto2api");
        }
        result.append(javaPackage).append(".");
        if (!options.getJavaMultipleFiles()) {
            result.append(JavaQualifiedNames.getOuterClassname(fileDesc)).append("$");
        }
        return result.toString();
    }

    private Class<?> getProtoEnumClass(Descriptors.FieldDescriptor field) throws ClassNotFoundException {
        Descriptors.EnumDescriptor enumDesc = field.getEnumType();
        StringBuilder javaType = new StringBuilder(enumDesc.getName());
        for (Descriptors.Descriptor parent = enumDesc.getContainingType(); parent != null; parent = parent.getContainingType()) {
            javaType.insert(0, "$").insert(0, parent.getName());
        }
        Descriptors.FileDescriptor fileDesc = enumDesc.getFile();
        javaType.insert(0, this.getJavaPrefix(fileDesc));
        return Class.forName(javaType.toString());
    }

    private Class<?> getMessageClass(Descriptors.FieldDescriptor field) throws ClassNotFoundException {
        Descriptors.Descriptor messageDesc = field.getMessageType();
        StringBuilder javaType = new StringBuilder(messageDesc.getName());
        for (Descriptors.Descriptor parent = messageDesc.getContainingType(); parent != null; parent = parent.getContainingType()) {
            javaType.insert(0, "$").insert(0, parent.getName());
        }
        Descriptors.FileDescriptor fileDesc = messageDesc.getFile();
        javaType.insert(0, this.getJavaPrefix(fileDesc));
        return Class.forName(javaType.toString());
    }
}

