/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib.gson;

import com.google.appengine.repackaged.com.google.common.base.Converter;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.gson.JsonArray;
import com.google.appengine.repackaged.com.google.gson.JsonDeserializationContext;
import com.google.appengine.repackaged.com.google.gson.JsonDeserializer;
import com.google.appengine.repackaged.com.google.gson.JsonElement;
import com.google.appengine.repackaged.com.google.gson.JsonNull;
import com.google.appengine.repackaged.com.google.gson.JsonObject;
import com.google.appengine.repackaged.com.google.gson.JsonParseException;
import com.google.appengine.repackaged.com.google.gson.JsonSerializationContext;
import com.google.appengine.repackaged.com.google.gson.JsonSerializer;
import com.google.appengine.repackaged.com.google.io.protocol.Protocol;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolMessage;
import com.google.appengine.repackaged.com.google.io.protocol.ProtocolType;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.List;

public class ProtocolMessageJsonSerializer
implements JsonSerializer<ProtocolMessage<?>>,
JsonDeserializer<ProtocolMessage<?>> {
    private final Converter<String, String> fieldNameConverter;

    public ProtocolMessageJsonSerializer() {
        this(Converter.identity());
    }

    public ProtocolMessageJsonSerializer(Converter<String, String> fieldNameConverter) {
        this.fieldNameConverter = Preconditions.checkNotNull(fieldNameConverter, "fieldNameConverter");
    }

    public JsonElement serialize(ProtocolMessage<?> src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject result = new JsonObject();
        List<ProtocolType.FieldType> tags = ProtocolType.getTags(src);
        for (ProtocolType.FieldType fType : tags) {
            String name = this.getFieldName(fType);
            if (fType.size(src) == 0) {
                result.add(name, (JsonElement)new JsonNull());
                continue;
            }
            result.add(name, this.serializeProtoField(context, src, fType));
        }
        return result;
    }

    public ProtocolMessage<?> deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        JsonObject jsonObject = json.getAsJsonObject();
        Object target = ProtocolMessageJsonSerializer.constructNewInstance((Class)typeOfT);
        List<ProtocolType.FieldType> tags = ProtocolType.getTags(target);
        for (ProtocolType.FieldType fType : tags) {
            String name = this.getFieldName(fType);
            if (jsonObject.has(name)) {
                JsonElement field = jsonObject.get(name);
                this.deserializeProtoField(context, field, (ProtocolMessage<?>)target, fType);
                continue;
            }
            fType.clear((ProtocolMessage)target);
        }
        return target;
    }

    private String getFieldName(ProtocolType.FieldType ft) {
        return this.fieldNameConverter.convert(ft.getName());
    }

    private JsonElement serializeProtoField(JsonSerializationContext context, ProtocolMessage<?> src, ProtocolType.FieldType field) {
        boolean isString = field.getBaseType() == ProtocolType.FieldBaseType.STRING;
        ProtocolType.Presence presence = field.getPresence();
        if (presence == ProtocolType.Presence.REPEATED) {
            JsonArray array = new JsonArray();
            for (int i = 0; i < field.size(src); ++i) {
                Object nthValue = field.getNthValue(src, i);
                JsonElement element = this.serializeValue(context, nthValue, isString);
                array.add(element);
            }
            return array;
        }
        Object value = field.getSingleValue(src);
        return this.serializeValue(context, value, isString);
    }

    private JsonElement serializeValue(JsonSerializationContext context, Object value, boolean isStringType) {
        if (isStringType) {
            value = Protocol.toStringUtf8((byte[])value);
        }
        return context.serialize(value);
    }

    private void deserializeProtoField(JsonDeserializationContext context, JsonElement jsonField, ProtocolMessage<?> target, ProtocolType.FieldType fType) {
        ProtocolType.Presence presence = fType.getPresence();
        if (presence == ProtocolType.Presence.REPEATED) {
            if (!jsonField.isJsonNull()) {
                if (!jsonField.isJsonArray()) {
                    fType.addValue(target, this.deserializeValue(context, jsonField, fType));
                } else {
                    JsonArray array = jsonField.getAsJsonArray();
                    for (JsonElement elem : array) {
                        if (elem.isJsonNull()) {
                            throw new NullPointerException("null values in JSON arrays are not allowed");
                        }
                        fType.addValue(target, this.deserializeValue(context, elem, fType));
                    }
                }
            }
        } else {
            if (jsonField.isJsonNull()) {
                return;
            }
            fType.setSingleValue(target, this.deserializeValue(context, jsonField, fType));
        }
    }

    private Object deserializeValue(JsonDeserializationContext context, JsonElement value, ProtocolType.FieldType fieldType) {
        switch (fieldType.getBaseType()) {
            case BOOL: {
                return context.deserialize(value, Boolean.class);
            }
            case INT32: 
            case FIXED32: {
                return context.deserialize(value, Integer.class);
            }
            case INT64: 
            case UINT64: 
            case FIXED64: {
                return context.deserialize(value, Long.class);
            }
            case STRING: {
                return Protocol.toBytesUtf8((String)context.deserialize(value, String.class));
            }
            case FLOAT: {
                return context.deserialize(value, Float.class);
            }
            case DOUBLE: {
                return context.deserialize(value, Double.class);
            }
            case GROUP: 
            case FOREIGN: {
                return context.deserialize(value, fieldType.getSubclass());
            }
        }
        throw new AssertionError((Object)"Cannot reach here");
    }

    private static <T extends ProtocolMessage<?>> T constructNewInstance(Class<T> protoClass) {
        try {
            Constructor<T> constructor = protoClass.getConstructor(new Class[0]);
            return (T)((ProtocolMessage)constructor.newInstance(new Object[0]));
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException(e);
        }
        catch (InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        catch (InstantiationException e) {
            throw new IllegalStateException(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }
}

