/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf.contrib.gson;

import com.google.appengine.repackaged.com.google.common.base.Converter;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.common.util.CharBase64;
import com.google.appengine.repackaged.com.google.gson.JsonArray;
import com.google.appengine.repackaged.com.google.gson.JsonDeserializationContext;
import com.google.appengine.repackaged.com.google.gson.JsonDeserializer;
import com.google.appengine.repackaged.com.google.gson.JsonElement;
import com.google.appengine.repackaged.com.google.gson.JsonObject;
import com.google.appengine.repackaged.com.google.gson.JsonParseException;
import com.google.appengine.repackaged.com.google.gson.JsonPrimitive;
import com.google.appengine.repackaged.com.google.gson.JsonSerializationContext;
import com.google.appengine.repackaged.com.google.gson.JsonSerializer;
import com.google.appengine.repackaged.com.google.gson.reflect.TypeToken;
import com.google.appengine.repackaged.com.google.protobuf.ByteString;
import com.google.appengine.repackaged.com.google.protobuf.DescriptorProtos;
import com.google.appengine.repackaged.com.google.protobuf.Descriptors;
import com.google.appengine.repackaged.com.google.protobuf.GeneratedMessage;
import com.google.appengine.repackaged.com.google.protobuf.MessageOrBuilder;
import com.google.appengine.repackaged.com.google.protobuf.ProtocolMessageEnum;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ProtocolMessageOrBuilderJsonSerializer
implements JsonSerializer<MessageOrBuilder>,
JsonDeserializer<MessageOrBuilder> {
    private final boolean rejectUnknownFieldNames;
    private Converter<Descriptors.FieldDescriptor, String> fieldNameConverter;

    public ProtocolMessageOrBuilderJsonSerializer() {
        this(false);
    }

    public ProtocolMessageOrBuilderJsonSerializer(boolean rejectUnknownFieldNames) {
        this(rejectUnknownFieldNames, Converter.identity());
    }

    public ProtocolMessageOrBuilderJsonSerializer(boolean rejectUnknownFieldNames, final Converter<String, String> fieldNameConverter) {
        this.rejectUnknownFieldNames = rejectUnknownFieldNames;
        Preconditions.checkNotNull(fieldNameConverter, "fieldNameConverter");
        this.setFieldNameConverter(new Converter<Descriptors.FieldDescriptor, String>(){

            @Override
            protected String doForward(Descriptors.FieldDescriptor field) {
                return (String)fieldNameConverter.convert(field.getName());
            }

            @Override
            protected Descriptors.FieldDescriptor doBackward(String str) {
                throw new UnsupportedOperationException();
            }
        });
    }

    public JsonElement serialize(MessageOrBuilder src, Type typeOfSrc, JsonSerializationContext context) {
        JsonObject ret = new JsonObject();
        Map<Descriptors.FieldDescriptor, Object> fields = src.getAllFields();
        for (Map.Entry<Descriptors.FieldDescriptor, Object> fieldPair : fields.entrySet()) {
            Class<?> fieldClass;
            Descriptors.FieldDescriptor desc = fieldPair.getKey();
            try {
                fieldClass = this.getClassForJavaType(desc);
                if (fieldClass == null) {
                }
            }
            catch (ClassNotFoundException e) {}
            continue;
            if (desc.isRepeated()) {
                List fieldList = (List)fieldPair.getValue();
                if (fieldList.size() == 0) continue;
                JsonArray array = new JsonArray();
                for (Object o : fieldList) {
                    array.add(this.serializeValue(o, fieldClass, context));
                }
                ret.add(this.getFieldName(desc), (JsonElement)array);
                continue;
            }
            ret.add(this.getFieldName(desc), this.serializeValue(fieldPair.getValue(), fieldClass, context));
        }
        return ret;
    }

    private JsonElement serializeValue(Object value, Class<?> fieldClass, JsonSerializationContext context) {
        if (ProtocolMessageEnum.class.isAssignableFrom(fieldClass)) {
            return this.serializeEnum(fieldClass, (Descriptors.EnumValueDescriptor)value, context);
        }
        if (fieldClass == ByteString.class) {
            return new JsonPrimitive(CharBase64.encode(((ByteString)value).toByteArray()));
        }
        return context.serialize(value, fieldClass);
    }

    private String getFieldName(Descriptors.FieldDescriptor fd) {
        return this.fieldNameConverter.convert(fd);
    }

    public ProtocolMessageOrBuilderJsonSerializer setFieldNameConverter(Converter<Descriptors.FieldDescriptor, String> fieldNameConverter) {
        this.fieldNameConverter = Preconditions.checkNotNull(fieldNameConverter, "fieldNameConverter");
        return this;
    }

    private JsonElement serializeEnum(Class<?> fieldClass, Descriptors.EnumValueDescriptor rawValue, JsonSerializationContext context) {
        boolean failed = false;
        Object value = null;
        try {
            Method valueOfMethod = fieldClass.getDeclaredMethod("valueOf", Descriptors.EnumValueDescriptor.class);
            value = valueOfMethod.invoke(null, rawValue);
        }
        catch (IllegalAccessException e) {
            failed = true;
        }
        catch (NoSuchMethodException e) {
            failed = true;
        }
        catch (InvocationTargetException e) {
            failed = true;
        }
        if (failed) {
            return context.serialize((Object)rawValue.getName());
        }
        return context.serialize(value, fieldClass);
    }

    public MessageOrBuilder deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        String string;
        if (!json.isJsonObject()) {
            String string2 = String.valueOf(json);
            throw new JsonParseException(new StringBuilder(27 + String.valueOf(string2).length()).append("Argument is not an object: ").append(string2).toString());
        }
        JsonObject obj = json.getAsJsonObject();
        Class concreteClass = TypeToken.get((Type)typeOfT).getRawType();
        GeneratedMessage.Builder<? extends GeneratedMessage.Builder> resultBuilder = this.getBuilderForType(concreteClass);
        Descriptors.Descriptor descriptorForType = resultBuilder.getDescriptorForType();
        HashSet<String> knownFieldNames = new HashSet<String>();
        for (Descriptors.FieldDescriptor fieldDescriptor : descriptorForType.getFields()) {
            String fieldName = this.getFieldName(fieldDescriptor);
            knownFieldNames.add(fieldName);
            if (obj.has(fieldName)) {
                Class<?> descClass;
                try {
                    descClass = this.getClassForJavaType(fieldDescriptor);
                }
                catch (ClassNotFoundException e) {
                    String string2 = String.valueOf(concreteClass.getName());
                    throw new JsonParseException(string2.length() != 0 ? "Error Instantiating ".concat(string2) : new String("Error Instantiating "), (Throwable)e);
                }
                if (descClass == null) {
                    String e = String.valueOf((Object)fieldDescriptor.getJavaType());
                    throw new JsonParseException(new StringBuilder(22 + String.valueOf(e).length()).append("Unexpected Java Type: ").append(e).toString());
                }
                try {
                    JsonElement prop = obj.get(fieldName);
                    if (prop.isJsonNull()) continue;
                    if (fieldDescriptor.isRepeated()) {
                        if (!prop.isJsonArray()) {
                            resultBuilder.addRepeatedField(fieldDescriptor, this.deserializeElement(prop, fieldDescriptor, descClass, context));
                            continue;
                        }
                        for (JsonElement arrayElement : prop.getAsJsonArray()) {
                            if (arrayElement.isJsonNull()) {
                                throw new NullPointerException("null values in JSON arrays are not allowed");
                            }
                            resultBuilder.addRepeatedField(fieldDescriptor, this.deserializeElement(arrayElement, fieldDescriptor, descClass, context));
                        }
                        continue;
                    }
                    resultBuilder.setField(fieldDescriptor, this.deserializeElement(prop, fieldDescriptor, descClass, context));
                    continue;
                }
                catch (ClassCastException e) {
                    String string3 = String.valueOf(concreteClass.getName());
                    throw new JsonParseException(string3.length() != 0 ? "Error Instantiating ".concat(string3) : new String("Error Instantiating "), (Throwable)e);
                }
            }
            if (!fieldDescriptor.isRequired()) continue;
            string = String.valueOf(json);
            throw new JsonParseException(new StringBuilder(29 + String.valueOf(fieldName).length() + String.valueOf(string).length()).append("Required Field: ").append(fieldName).append(" is missing. ").append(string).toString());
        }
        if (!resultBuilder.isInitialized()) {
            String string5 = String.valueOf(concreteClass.getName());
            throw new JsonParseException(new StringBuilder(49 + String.valueOf(string5).length()).append("Error Instantiating ").append(string5).append("Initialization checks failed.").toString());
        }
        if (this.rejectUnknownFieldNames) {
            HashSet foundFieldNames = new HashSet();
            for (Map.Entry objField : obj.entrySet()) {
                foundFieldNames.add(objField.getKey());
            }
            Sets.SetView setView = Sets.difference(foundFieldNames, knownFieldNames);
            if (!setView.isEmpty()) {
                String string4 = String.valueOf(setView);
                string = String.valueOf(json);
                throw new JsonParseException(new StringBuilder(17 + String.valueOf(string4).length() + String.valueOf(string).length()).append("Unknown fields ").append(string4).append(": ").append(string).toString());
            }
        }
        return resultBuilder.build();
    }

    private Object deserializeElement(JsonElement json, Descriptors.FieldDescriptor desc, Class<?> descClass, JsonDeserializationContext context) throws JsonParseException {
        if (descClass == ByteString.class) {
            try {
                return ByteString.copyFrom(CharBase64.decode(json.getAsString()));
            }
            catch (IllegalArgumentException e) {
                String string = String.valueOf(json);
                throw new JsonParseException(new StringBuilder(27 + String.valueOf(string).length()).append("Invalid Base64 bytes data: ").append(string).toString());
            }
        }
        Object deserializedObject = context.deserialize(json, descClass);
        if (deserializedObject == null && desc.getJavaType() == Descriptors.FieldDescriptor.JavaType.ENUM) {
            throw new JsonParseException(String.format("Error deserializing enum field [%s]. Unrecognized value [%s]", desc.getName(), json.getAsString()));
        }
        return this.fixIfEnum(descClass.cast(deserializedObject));
    }

    private GeneratedMessage.Builder<? extends GeneratedMessage.Builder> getBuilderForType(Class<?> concreteClass) throws JsonParseException {
        Method newBuilderMethod;
        try {
            newBuilderMethod = concreteClass.getDeclaredMethod("newBuilder", new Class[0]);
        }
        catch (NoSuchMethodException e) {
            String string = String.valueOf(concreteClass.getName());
            throw new JsonParseException(string.length() != 0 ? "Error Instantiating ".concat(string) : new String("Error Instantiating "), (Throwable)e);
        }
        catch (SecurityException e) {
            String string = String.valueOf(concreteClass.getName());
            throw new JsonParseException(string.length() != 0 ? "Error Instantiating ".concat(string) : new String("Error Instantiating "), (Throwable)e);
        }
        if (!Modifier.isStatic(newBuilderMethod.getModifiers())) {
            String e = String.valueOf(concreteClass.getName());
            throw new JsonParseException(new StringBuilder(80 + String.valueOf(e).length()).append("Error Instantiating ").append(e).append(" because the \"newBuilder\" method is not static on the class.").toString());
        }
        try {
            GeneratedMessage.Builder builder = (GeneratedMessage.Builder)newBuilderMethod.invoke(null, new Object[0]);
            return builder;
        }
        catch (IllegalAccessException e) {
            String string = String.valueOf(concreteClass.getName());
            throw new JsonParseException(string.length() != 0 ? "Error Instantiating ".concat(string) : new String("Error Instantiating "), (Throwable)e);
        }
        catch (InvocationTargetException e) {
            String string = String.valueOf(concreteClass.getName());
            throw new JsonParseException(string.length() != 0 ? "Error Instantiating ".concat(string) : new String("Error Instantiating "), (Throwable)e);
        }
    }

    private Class<?> getClassForJavaType(Descriptors.FieldDescriptor field) throws ClassNotFoundException {
        switch (field.getJavaType()) {
            case BOOLEAN: {
                return Boolean.class;
            }
            case BYTE_STRING: {
                return ByteString.class;
            }
            case DOUBLE: {
                return Double.class;
            }
            case ENUM: {
                return this.getProtoEnumClass(field);
            }
            case FLOAT: {
                return Float.class;
            }
            case INT: {
                return Integer.class;
            }
            case LONG: {
                return Long.class;
            }
            case MESSAGE: {
                return this.getMessageClass(field);
            }
            case STRING: {
                return String.class;
            }
        }
        return null;
    }

    private Object fixIfEnum(Object result) {
        if (result instanceof ProtocolMessageEnum) {
            return ((ProtocolMessageEnum)result).getValueDescriptor();
        }
        return result;
    }

    private String getJavaPrefix(Descriptors.FileDescriptor fileDesc) {
        String javaPackage;
        StringBuilder result = new StringBuilder();
        DescriptorProtos.FileOptions options = fileDesc.getOptions();
        if (options.hasJavaPackage()) {
            javaPackage = options.getJavaPackage();
        } else {
            String string;
            String protoPackage = fileDesc.getPackage();
            if ("".equals(protoPackage)) {
                string = "";
            } else {
                String string2 = String.valueOf(protoPackage);
                string = string2.length() != 0 ? ".".concat(string2) : new String(".");
            }
            String string3 = String.valueOf(string);
            String string4 = javaPackage = string3.length() != 0 ? "com.google.protos".concat(string3) : new String("com.google.protos");
        }
        if (options.hasJavaApiVersion() && options.getJavaApiVersion() == 1) {
            javaPackage = options.hasJavaAltApiPackage() ? options.getJavaAltApiPackage() : String.valueOf(javaPackage).concat(".proto2api");
        }
        result.append(javaPackage).append(".");
        if (!options.getJavaMultipleFiles()) {
            String className = this.classForFile(fileDesc);
            result.append(className).append("$");
        }
        return result.toString();
    }

    private Class<?> getProtoEnumClass(Descriptors.FieldDescriptor field) throws ClassNotFoundException {
        Descriptors.EnumDescriptor enumDesc = field.getEnumType();
        StringBuilder javaType = new StringBuilder(enumDesc.getName());
        for (Descriptors.Descriptor parent = enumDesc.getContainingType(); parent != null; parent = parent.getContainingType()) {
            javaType.insert(0, "$").insert(0, parent.getName());
        }
        Descriptors.FileDescriptor fileDesc = enumDesc.getFile();
        javaType.insert(0, this.getJavaPrefix(fileDesc));
        return Class.forName(javaType.toString());
    }

    private Class<?> getMessageClass(Descriptors.FieldDescriptor field) throws ClassNotFoundException {
        Descriptors.Descriptor messageDesc = field.getMessageType();
        StringBuilder javaType = new StringBuilder(messageDesc.getName());
        for (Descriptors.Descriptor parent = messageDesc.getContainingType(); parent != null; parent = parent.getContainingType()) {
            javaType.insert(0, "$").insert(0, parent.getName());
        }
        Descriptors.FileDescriptor fileDesc = messageDesc.getFile();
        javaType.insert(0, this.getJavaPrefix(fileDesc));
        return Class.forName(javaType.toString());
    }

    private String classForFile(Descriptors.FileDescriptor fileDesc) {
        DescriptorProtos.FileOptions options = fileDesc.getOptions();
        if (options.hasJavaOuterClassname()) {
            return options.getJavaOuterClassname();
        }
        StringBuilder className = new StringBuilder();
        String fileName = fileDesc.getName();
        int startPoint = fileName.lastIndexOf(47) + 1;
        int lastPoint = fileName.length();
        if (fileName.endsWith(".proto")) {
            lastPoint -= ".proto".length();
        } else if (fileName.endsWith(".protodevel")) {
            lastPoint -= ".protodevel".length();
        }
        String plainName = fileName.substring(startPoint, lastPoint);
        boolean capitalizeNext = true;
        for (int i = 0; i < plainName.length(); ++i) {
            char c = plainName.charAt(i);
            if ('a' <= c && c <= 'z') {
                if (capitalizeNext) {
                    className.append(Character.toChars(c + -32)[0]);
                } else {
                    className.append(c);
                }
                capitalizeNext = false;
                continue;
            }
            if ('A' <= c && c <= 'Z') {
                className.append(c);
                capitalizeNext = false;
                continue;
            }
            if ('0' <= c && c <= '9') {
                className.append(c);
                capitalizeNext = true;
                continue;
            }
            capitalizeNext = true;
        }
        String classNameStr = className.toString();
        for (Descriptors.Descriptor messageDesc : fileDesc.getMessageTypes()) {
            if (!classNameStr.equals(messageDesc.getName())) continue;
            return String.valueOf(classNameStr).concat("OuterClass");
        }
        return classNameStr;
    }
}

