/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools;

import com.google.appengine.tools.admin.OutputPump;
import com.google.appengine.tools.development.DevAppServerMain;
import com.google.appengine.tools.info.SdkInfo;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class KickStart {
    private static final Logger logger = Logger.getLogger(KickStart.class.getName());
    private static final String EXTERNAL_RESOURCE_DIR_FLAG = "--external_resource_dir";
    private static final String EXTERNAL_RESOURCE_DIR_ERROR_MESSAGE = "--external_resource_dir=<path> expected.";
    private static final String GENERATE_WAR_FLAG = "--generate_war";
    private static final String GENERATED_WAR_DIR_FLAG = "--generated_war_dir";
    private static final String NO_JAVA_AGENT_FLAG = "--no_java_agent";
    private static final String JVM_FLAG = "--jvm_flag";
    private static final String JVM_FLAG_ERROR_MESSAGE = "--jvm_flag=<flag> expected.\n--jvm_flag may be repeated to supply multiple flags";
    private static final String START_ON_FIRST_THREAD_FLAG = "--startOnFirstThread";
    private static final String START_ON_FIRST_THREAD_ERROR_MESSAGE = "--startOnFirstThread=<boolean> expected";
    private static final String SDK_ROOT_FLAG = "--sdk_root";
    private static final String SDK_ROOT_ERROR_MESSAGE = "--sdk_root=<path> expected";
    private static final String ENABLE_JACOCO_FLAG = "--enable_jacoco";
    private static final String ENABLE_JACOCO_ERROR_MESSAGE = "--enable_jacoco=true|false expected.";
    private static final String JACOCO_AGENT_JAR_FLAG = "--jacoco_agent_jar";
    private static final String JACOCO_AGENT_JAR_ERROR_MESSAGE = "--jacoco_agent_jar=<path> expected.";
    private static final String JACOCO_AGENT_ARGS_FLAG = "--jacoco_agent_args";
    private static final String JACOCO_AGENT_ARGS_ERROR_MESSAGE = "--jacoco_agent_args=<jacoco agent args> expected.";
    private static final String JACOCO_EXEC_FLAG = "--jacoco_exec";
    private static final String JACOCO_EXEC_ERROR_MESSAGE = "--jacoco_exec=<path> expected.";
    private Process serverProcess = null;

    public static void main(String[] args) {
        new KickStart(args);
    }

    private KickStart(String[] args) {
        String jacocoAgentJar;
        String entryClass = null;
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        String home = System.getProperty("java.home");
        String string = String.valueOf(File.separator);
        String string2 = String.valueOf(File.separator);
        String javaExe = new StringBuilder(7 + String.valueOf(home).length() + String.valueOf(string).length() + String.valueOf(string2).length()).append(home).append(string).append("bin").append(string2).append("java").toString();
        ArrayList<String> jvmArgs = new ArrayList<String>();
        ArrayList<String> appServerArgs = new ArrayList<String>();
        boolean enableJacoco = false;
        String jacocoAgentJarArg = null;
        String jacocoAgentArgs = "";
        String jacocoExecArg = "jacoco.exec";
        List<String> command = builder.command();
        command.add(javaExe);
        boolean startOnFirstThread = System.getProperty("os.name").equalsIgnoreCase("Mac OS X");
        String externalResourceDirArg = null;
        boolean generateWar = false;
        boolean noJavaAgent = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith(EXTERNAL_RESOURCE_DIR_FLAG)) {
                externalResourceDirArg = KickStart.extractValue(args[i], EXTERNAL_RESOURCE_DIR_ERROR_MESSAGE);
            } else if (args[i].startsWith(GENERATED_WAR_DIR_FLAG) || args[i].startsWith(GENERATE_WAR_FLAG)) {
                generateWar = true;
            } else if (args[i].startsWith(NO_JAVA_AGENT_FLAG)) {
                noJavaAgent = true;
            }
            if (args[i].startsWith(JVM_FLAG)) {
                jvmArgs.add(KickStart.extractValue(args[i], JVM_FLAG_ERROR_MESSAGE));
                continue;
            }
            if (args[i].startsWith(START_ON_FIRST_THREAD_FLAG)) {
                startOnFirstThread = Boolean.valueOf(KickStart.extractValue(args[i], START_ON_FIRST_THREAD_ERROR_MESSAGE));
                continue;
            }
            if (args[i].startsWith(ENABLE_JACOCO_FLAG)) {
                enableJacoco = "true".equals(KickStart.extractValue(args[i], ENABLE_JACOCO_ERROR_MESSAGE));
                continue;
            }
            if (args[i].startsWith(JACOCO_AGENT_JAR_FLAG)) {
                jacocoAgentJarArg = KickStart.extractValue(args[i], JACOCO_AGENT_JAR_ERROR_MESSAGE);
                continue;
            }
            if (args[i].startsWith(JACOCO_AGENT_ARGS_FLAG)) {
                jacocoAgentArgs = KickStart.extractValue(args[i], JACOCO_AGENT_ARGS_ERROR_MESSAGE);
                continue;
            }
            if (args[i].startsWith(JACOCO_EXEC_FLAG)) {
                jacocoExecArg = KickStart.extractValue(args[i], JACOCO_EXEC_ERROR_MESSAGE);
                continue;
            }
            if (entryClass == null) {
                if (args[i].charAt(0) == '-') {
                    String string3 = String.valueOf(args[i]);
                    throw new IllegalArgumentException(string3.length() != 0 ? "Only --jvm_flag may precede classname, not ".concat(string3) : new String("Only --jvm_flag may precede classname, not "));
                }
                entryClass = args[i];
                if (entryClass.equals(DevAppServerMain.class.getName())) continue;
                throw new IllegalArgumentException("KickStart only works for DevAppServerMain");
            }
            appServerArgs.add(args[i]);
        }
        if (entryClass == null) {
            throw new IllegalArgumentException("missing entry classname");
        }
        if (externalResourceDirArg == null && generateWar) {
            System.err.println("Generating a war directory requires ----external_resource_dir");
            System.exit(1);
        }
        File newWorkingDir = KickStart.newWorkingDir(externalResourceDirArg, appServerArgs.toArray(new String[appServerArgs.size()]));
        builder.directory(newWorkingDir);
        if (startOnFirstThread) {
            jvmArgs.add("-XstartOnFirstThread");
        }
        String classpath = System.getProperty("java.class.path");
        StringBuilder newClassPath = new StringBuilder();
        assert (classpath != null) : "classpath must not be null";
        String[] paths = classpath.split(File.pathSeparator);
        for (int i = 0; i < paths.length; ++i) {
            newClassPath.append(new File(paths[i]).getAbsolutePath());
            if (i == paths.length - 1) continue;
            newClassPath.append(File.pathSeparator);
        }
        String sdkRoot = null;
        String appDir = null;
        ArrayList<String> absoluteAppServerArgs = new ArrayList<String>(appServerArgs.size());
        for (int i = 0; i < appServerArgs.size(); ++i) {
            File file;
            String arg = (String)appServerArgs.get(i);
            if (arg.startsWith(SDK_ROOT_FLAG)) {
                sdkRoot = new File(KickStart.extractValue(arg, SDK_ROOT_ERROR_MESSAGE)).getAbsolutePath();
                String string4 = String.valueOf("--sdk_root=");
                String string5 = String.valueOf(sdkRoot);
                arg = string5.length() != 0 ? string4.concat(string5) : new String(string4);
            } else if (arg.startsWith(EXTERNAL_RESOURCE_DIR_FLAG)) {
                String string6 = String.valueOf("--external_resource_dir=");
                String string7 = String.valueOf(new File(KickStart.extractValue(arg, EXTERNAL_RESOURCE_DIR_ERROR_MESSAGE)).getAbsolutePath());
                arg = string7.length() != 0 ? string6.concat(string7) : new String(string6);
            } else if (i == appServerArgs.size() - 1 && !arg.startsWith("-") && (file = new File(arg)).exists()) {
                appDir = arg = new File(arg).getAbsolutePath();
            }
            absoluteAppServerArgs.add(arg);
        }
        if (sdkRoot == null) {
            sdkRoot = SdkInfo.getSdkRoot().getAbsolutePath();
        }
        boolean isVM = false;
        if (appDir != null) {
            isVM = KickStart.isVMRuntime(appDir);
        }
        if (isVM) {
            noJavaAgent = true;
            jvmArgs.add("-D--enable_all_permissions=true");
        }
        if (!noJavaAgent) {
            String agentJar = String.valueOf(sdkRoot).concat("/lib/agent/appengine-agent.jar");
            agentJar = agentJar.replace('/', File.separatorChar);
            if (enableJacoco) {
                jvmArgs.add("-D--enable_all_permissions=true");
                jacocoAgentJar = new File(jacocoAgentJarArg).getAbsolutePath();
                if (!jacocoAgentArgs.isEmpty()) {
                    jacocoAgentArgs = String.valueOf(jacocoAgentArgs).concat(",");
                }
                String string8 = jacocoAgentArgs;
                String string9 = String.valueOf(new File(jacocoExecArg).getAbsolutePath());
                string8 = jacocoAgentArgs = new StringBuilder(9 + String.valueOf(string8).length() + String.valueOf(string9).length()).append(string8).append("destfile=").append(string9).toString();
                jvmArgs.add(new StringBuilder(12 + String.valueOf(jacocoAgentJar).length() + String.valueOf(string8).length()).append("-javaagent:").append(jacocoAgentJar).append("=").append(string8).toString());
                if (newClassPath.length() > 0) {
                    newClassPath.append(File.pathSeparator);
                }
                newClassPath.append(agentJar);
            } else {
                String string10 = String.valueOf(agentJar);
                jvmArgs.add(string10.length() != 0 ? "-javaagent:".concat(string10) : new String("-javaagent:"));
            }
        }
        String jdkOverridesJar = String.valueOf(sdkRoot).concat("/lib/override/appengine-dev-jdk-overrides.jar");
        jdkOverridesJar = jdkOverridesJar.replace('/', File.separatorChar);
        String string11 = String.valueOf(jdkOverridesJar);
        jvmArgs.add(string11.length() != 0 ? "-Xbootclasspath/p:".concat(string11) : new String("-Xbootclasspath/p:"));
        command.addAll(jvmArgs);
        command.add("-classpath");
        command.add(newClassPath.toString());
        command.add(entryClass);
        String string12 = String.valueOf(System.getProperty("user.dir"));
        command.add(string12.length() != 0 ? "--property=kickstart.user.dir=".concat(string12) : new String("--property=kickstart.user.dir="));
        if (isVM) {
            command.add(NO_JAVA_AGENT_FLAG);
        }
        command.addAll(absoluteAppServerArgs);
        jacocoAgentJar = String.valueOf(command);
        logger.fine(new StringBuilder(10 + String.valueOf(jacocoAgentJar).length()).append("Executing ").append(jacocoAgentJar).toString());
        jacocoAgentJar = String.valueOf(command);
        System.out.println(new StringBuilder(10 + String.valueOf(jacocoAgentJar).length()).append("Executing ").append(jacocoAgentJar).toString());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (KickStart.this.serverProcess != null) {
                    KickStart.this.serverProcess.destroy();
                }
            }
        });
        try {
            this.serverProcess = builder.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to start the process", e);
        }
        new Thread(new OutputPump(this.serverProcess.getInputStream(), new PrintWriter(System.out, true))).start();
        new Thread(new OutputPump(this.serverProcess.getErrorStream(), new PrintWriter(System.err, true))).start();
        try {
            this.serverProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.serverProcess.destroy();
        this.serverProcess = null;
    }

    private static String extractValue(String argument, String errorMessage) {
        int indexOfEqualSign = argument.indexOf(61);
        if (indexOfEqualSign == -1) {
            throw new IllegalArgumentException(errorMessage);
        }
        return argument.substring(argument.indexOf(61) + 1);
    }

    private static File newWorkingDir(String workingDirectoryArg, String[] args) {
        File workingDir;
        if (workingDirectoryArg != null) {
            workingDir = new File(workingDirectoryArg);
            if (!workingDir.isDirectory()) {
                System.err.println(String.valueOf(workingDirectoryArg).concat(" is not an existing directory."));
                System.exit(1);
            }
        } else {
            if (args.length < 1 || args[args.length - 1].startsWith("-")) {
                new DevAppServerMain().printHelp(System.out);
                System.exit(1);
            }
            workingDir = new File(args[args.length - 1]);
            new DevAppServerMain().validateWarPath(workingDir);
        }
        return workingDir;
    }

    static boolean isVMRuntime(String appDir) {
        if (appDir == null) {
            return false;
        }
        File appengineWeb = new File(appDir, "WEB-INF/appengine-web.xml");
        if (!appengineWeb.exists()) {
            File ear = new File(appDir);
            if (!ear.exists()) {
                String string = String.valueOf(ear.getAbsolutePath());
                System.err.println(string.length() != 0 ? "Application does not exist: ".concat(string) : new String("Application does not exist: "));
                return false;
            }
            boolean isVM = false;
            for (File war : ear.listFiles()) {
                if (!new File(war, "WEB-INF/appengine-web.xml").exists()) continue;
                try {
                    AppEngineWebXmlReader reader = new AppEngineWebXmlReader(war.getAbsolutePath());
                    AppEngineWebXml appEngineWebXml = reader.readAppEngineWebXml();
                    if (!appEngineWebXml.getUseVm() && !appEngineWebXml.getEnv().equals("2")) continue;
                    isVM = true;
                }
                catch (AppEngineConfigException e) {
                    String string = String.valueOf(war.getAbsolutePath());
                    System.err.println(string.length() != 0 ? "Error reading module: ".concat(string) : new String("Error reading module: "));
                }
            }
            return isVM;
        }
        try {
            AppEngineWebXmlReader reader = new AppEngineWebXmlReader(appDir);
            AppEngineWebXml appEngineWebXml = reader.readAppEngineWebXml();
            return appEngineWebXml.getUseVm();
        }
        catch (AppEngineConfigException e) {
            String string = String.valueOf(appengineWeb.getAbsolutePath());
            System.err.println(string.length() != 0 ? "Error reading module: ".concat(string) : new String("Error reading module: "));
            return false;
        }
    }
}

