/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.AppAdmin;
import com.google.appengine.tools.admin.AppAdminImpl;
import com.google.appengine.tools.admin.AppVersionUpload;
import com.google.appengine.tools.admin.Application;
import com.google.appengine.tools.admin.GenericApplication;
import com.google.appengine.tools.admin.Utility;
import com.google.appengine.tools.info.SdkInfo;
import com.google.appengine.tools.util.ClientCookieManager;
import java.io.File;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Set;

public class AppAdminFactory {
    private static final String JAVA_CMD_PROP = "appengine.java";
    private static final String JAVAC_CMD_PROP = "appengine.javac";
    private ApplicationProcessingOptions appOptions = new ApplicationProcessingOptions();
    private Class<? extends AppVersionUpload> appVersionUploadClass = AppVersionUpload.class;

    public AppAdmin createAppAdmin(ConnectOptions options, Application app, PrintWriter errorWriter) {
        return new AppAdminImpl(options, app, errorWriter, this.appOptions, this.appVersionUploadClass);
    }

    public AppAdmin createAppAdmin(ConnectOptions options, GenericApplication app, PrintWriter errorWriter) {
        return new AppAdminImpl(options, app, errorWriter, this.appOptions, this.appVersionUploadClass);
    }

    public ApplicationProcessingOptions getAppOptions() {
        return this.appOptions;
    }

    public Class<? extends AppVersionUpload> getAppVersionUploadClass() {
        return this.appVersionUploadClass;
    }

    public void setAppVersionUploadClass(Class<? extends AppVersionUpload> klass) {
        this.appVersionUploadClass = klass;
    }

    public void setJavaExecutable(File java) {
        this.appOptions.setJavaExecutable(java);
    }

    public void setJavaCompiler(File javac) {
        this.appOptions.setJavaCompiler(javac);
    }

    public void setCompileJsps(boolean flag) {
        this.appOptions.setCompileJsps(flag);
    }

    public void setBatchMode(boolean flag) {
        this.appOptions.setBatchMode(flag);
    }

    public void setJarSplittingEnabled(boolean doSplit) {
        this.appOptions.splitJars(doSplit);
    }

    public void setJarJSPsEnabled(boolean doJarJSPs) {
        this.appOptions.setJarJSPs(doJarJSPs);
    }

    public void setJarClassessEnabled(boolean doJarClasses) {
        this.appOptions.setJarClasses(doJarClasses);
    }

    public void setDeleteJSPs(boolean deleteJSPs) {
        this.appOptions.setDeleteJSPs(deleteJSPs);
    }

    public void setJarSplittingExcludes(Set<String> jarSplittingExcludeSuffixes) {
        this.appOptions.setJarSplittingExcludes(jarSplittingExcludeSuffixes);
    }

    public void setCompileEncoding(String compileEncoding) {
        Charset.forName(compileEncoding);
        this.appOptions.setCompileEncoding(compileEncoding);
    }

    public void setRuntime(String runtime) {
        this.appOptions.setRuntime(runtime);
    }

    public void setAllowAnyRuntime(boolean allowAnyRuntime) {
        this.appOptions.setAllowAnyRuntime(allowAnyRuntime);
    }

    public void setFailOnPrecompilationError(boolean fail) {
        this.appOptions.setFailOnPrecompilationError(fail);
    }

    public void setIgnoreEndpointsFailures(boolean ignore) {
        this.appOptions.setIgnoreEndpointsFailures(ignore);
    }

    public void setQuickstart(boolean enable) {
        this.appOptions.setQuickstart(enable);
    }

    public static class ApplicationProcessingOptions {
        private File java;
        private File javac;
        private boolean compileJsps = true;
        private boolean doBatch = true;
        private String compileEncoding = "UTF-8";
        private boolean splitJars = false;
        private boolean jarJSPs = true;
        private boolean jarClasses = false;
        private boolean deleteJSPs = false;
        private Set<String> splitExcludes = Collections.emptySet();
        private String runtime;
        private boolean allowAnyRuntime = false;
        private boolean failOnPrecompilationError = false;
        private boolean ignoreEndpointsFailures = true;
        private boolean quickstart = false;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public File getJavaExecutable() {
            if (this.java != null) {
                return this.java;
            }
            String javaProp = System.getProperty(AppAdminFactory.JAVA_CMD_PROP);
            if (javaProp != null) {
                this.java = new File(javaProp);
                if (this.java.exists()) return this.java;
                if (!Utility.isOsWindows() || javaProp.endsWith(".exe") || !new File(String.valueOf(javaProp).concat(".exe")).exists()) throw new IllegalStateException(new StringBuilder(30 + String.valueOf(javaProp).length()).append("cannot find java executable \"").append(javaProp).append("\"").toString());
                this.java = new File(String.valueOf(javaProp).concat(".exe"));
                return this.java;
            } else {
                String javaHome = System.getProperty("java.home");
                String string = String.valueOf(File.separator);
                String string2 = String.valueOf(File.separator);
                String string3 = Utility.isOsWindows() ? ".exe" : "";
                String javaCmd = new StringBuilder(7 + String.valueOf(javaHome).length() + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(javaHome).append(string).append("bin").append(string2).append("java").append(string3).toString();
                this.java = new File(javaCmd);
                if (this.java.exists()) return this.java;
                this.java = null;
                string = String.valueOf("cannot find java executable based on java.home, tried \"");
                throw new IllegalStateException(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(javaCmd).length()).append(string).append(javaCmd).append("\"").toString());
            }
        }

        void setJavaExecutable(File java) {
            this.java = java;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public File getJavaCompiler() {
            if (this.javac != null) {
                return this.javac;
            }
            String javacProp = System.getProperty(AppAdminFactory.JAVAC_CMD_PROP);
            if (javacProp != null) {
                this.javac = new File(javacProp);
                if (this.javac.exists()) return this.javac;
                if (!Utility.isOsWindows() || javacProp.endsWith(".exe") || !new File(String.valueOf(javacProp).concat(".exe")).exists()) throw new IllegalStateException(new StringBuilder(31 + String.valueOf(javacProp).length()).append("cannot find javac executable \"").append(javacProp).append("\"").toString());
                this.javac = new File(String.valueOf(javacProp).concat(".exe"));
                return this.javac;
            } else {
                String javaHome;
                String javacDir;
                String string = javacDir = (javaHome = System.getProperty("java.home"));
                String string2 = String.valueOf(File.separator);
                String string3 = String.valueOf(File.separator);
                String string4 = Utility.isOsWindows() ? ".exe" : "";
                String javacCmd = new StringBuilder(8 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length()).append(string).append(string2).append("bin").append(string3).append("javac").append(string4).toString();
                this.javac = new File(javacCmd);
                if (this.javac.exists()) return this.javac;
                this.javac = null;
                string2 = javacDir = new File(javaHome).getParentFile().getPath();
                string3 = String.valueOf(File.separator);
                string4 = String.valueOf(File.separator);
                String string5 = Utility.isOsWindows() ? ".exe" : "";
                String javacCmd2 = new StringBuilder(8 + String.valueOf(string2).length() + String.valueOf(string3).length() + String.valueOf(string4).length() + String.valueOf(string5).length()).append(string2).append(string3).append("bin").append(string4).append("javac").append(string5).toString();
                this.javac = new File(javacCmd2);
                if (this.javac.exists()) return this.javac;
                this.javac = null;
                string2 = String.valueOf("cannot find javac executable based on java.home, tried \"");
                throw new IllegalStateException(new StringBuilder(8 + String.valueOf(string2).length() + String.valueOf(javacCmd).length() + String.valueOf(javacCmd2).length()).append(string2).append(javacCmd).append("\" and \"").append(javacCmd2).append("\"").toString());
            }
        }

        void setJavaCompiler(File javac) {
            this.javac = javac;
        }

        public boolean isCompileJspsSet() {
            return this.compileJsps;
        }

        void setCompileJsps(boolean doJsps) {
            this.compileJsps = doJsps;
        }

        public boolean isBatchModeSet() {
            return this.doBatch;
        }

        void setBatchMode(boolean doBatch) {
            this.doBatch = doBatch;
        }

        public String getCompileEncoding() {
            return this.compileEncoding;
        }

        public void setCompileEncoding(String compileEncoding) {
            this.compileEncoding = compileEncoding;
        }

        public boolean isSplitJarsSet() {
            return this.splitJars;
        }

        public void splitJars(boolean b) {
            this.splitJars = b;
        }

        public void setJarJSPs(boolean b) {
            this.jarJSPs = b;
        }

        public boolean isJarJSPsSet() {
            return this.jarJSPs;
        }

        public void setJarClasses(boolean b) {
            this.jarClasses = b;
        }

        public boolean isJarClassesSet() {
            return this.jarClasses;
        }

        public void setDeleteJSPs(boolean b) {
            this.deleteJSPs = b;
        }

        public boolean isDeleteJSPs() {
            return this.deleteJSPs;
        }

        void setJarSplittingExcludes(Set<String> jarSplittingExcludeSuffixes) {
            this.splitExcludes = jarSplittingExcludeSuffixes;
        }

        public Set<String> getJarSplittingExcludes() {
            return this.splitExcludes;
        }

        public void setRuntime(String s) {
            this.runtime = s;
        }

        public String getRuntime() {
            return this.runtime;
        }

        public void setAllowAnyRuntime(boolean b) {
            this.allowAnyRuntime = b;
        }

        public boolean isAllowAnyRuntime() {
            return this.allowAnyRuntime;
        }

        public void setFailOnPrecompilationError(boolean b) {
            this.failOnPrecompilationError = b;
        }

        public boolean isFailOnPrecompilationError() {
            return this.failOnPrecompilationError;
        }

        public void setIgnoreEndpointsFailures(boolean b) {
            this.ignoreEndpointsFailures = b;
        }

        public boolean isIgnoreEndpointsFailures() {
            return this.ignoreEndpointsFailures;
        }

        public void setQuickstart(boolean b) {
            this.quickstart = b;
        }

        public boolean isQuickstart() {
            return this.quickstart;
        }
    }

    public static class ConnectOptions {
        private String userId;
        private String server = SdkInfo.getDefaultServer();
        private String host;
        private String sdkRoot;
        boolean keepUpload;
        private ClientCookieManager cookies;
        private PasswordPrompt passwordPrompt;
        private boolean secure = true;
        private String oauthToken;
        private boolean usePersistedCredentials = true;

        public String getUserId() {
            return this.userId;
        }

        public void setUserId(String userId) {
            this.userId = userId;
        }

        public PasswordPrompt getPasswordPrompt() {
            return this.passwordPrompt;
        }

        public void setPasswordPrompt(PasswordPrompt prompt) {
            this.passwordPrompt = prompt;
        }

        public String getServer() {
            return this.server;
        }

        public void setServer(String server) {
            this.server = server;
        }

        public String getHost() {
            return this.host;
        }

        public void setHost(String host) {
            this.host = host;
        }

        public void setRetainUploadDir(boolean flag) {
            this.keepUpload = flag;
        }

        public boolean getRetainUploadDir() {
            return this.keepUpload;
        }

        public String getSdkRoot() {
            return this.sdkRoot;
        }

        public void setSdkRoot(String sdkRoot) {
            this.sdkRoot = sdkRoot;
        }

        public ClientCookieManager getCookies() {
            return this.cookies;
        }

        public void setCookies(ClientCookieManager cookies) {
            this.cookies = cookies;
        }

        public boolean getSecure() {
            return this.secure;
        }

        public void setSecure(boolean secure) {
            this.secure = secure;
        }

        public void setOauthToken(String oauthToken) {
            this.oauthToken = oauthToken;
        }

        public String getOauthToken() {
            return this.oauthToken;
        }

        public void setUsePersistedCredentials(boolean usePersistedCredentials) {
            this.usePersistedCredentials = usePersistedCredentials;
        }

        public boolean getUsePersistedCredentials() {
            return this.usePersistedCredentials;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ConnectOptions that = (ConnectOptions)o;
            if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
                return false;
            }
            if (this.server != null ? !this.server.equals(that.server) : that.server != null) {
                return false;
            }
            if (this.userId != null ? !this.userId.equals(that.userId) : that.userId != null) {
                return false;
            }
            return !(this.sdkRoot != null ? !this.sdkRoot.equals(that.sdkRoot) : that.sdkRoot != null);
        }

        public int hashCode() {
            int result = this.userId != null ? this.userId.hashCode() : 0;
            result = 31 * result + (this.server != null ? this.server.hashCode() : 0);
            result = 31 * result + (this.host != null ? this.host.hashCode() : 0);
            result = 31 * result + (this.sdkRoot != null ? this.sdkRoot.hashCode() : 0);
            return result;
        }
    }

    public static interface PasswordPrompt {
        public String getPassword();
    }
}

