/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.tools.admin.AdminException;
import com.google.appengine.tools.admin.AppAdmin;
import com.google.appengine.tools.admin.AppAdminFactory;
import com.google.appengine.tools.admin.AppVersionUpload;
import com.google.appengine.tools.admin.ClientDeploySender;
import com.google.appengine.tools.admin.ConfirmationCallback;
import com.google.appengine.tools.admin.CronEntry;
import com.google.appengine.tools.admin.CronEntryImpl;
import com.google.appengine.tools.admin.GenericApplication;
import com.google.appengine.tools.admin.IndexDeleter;
import com.google.appengine.tools.admin.LogFetcher;
import com.google.appengine.tools.admin.LoggingClientDeploySender;
import com.google.appengine.tools.admin.NoLoggingClientDeploySender;
import com.google.appengine.tools.admin.ResourceLimits;
import com.google.appengine.tools.admin.ServerConnection;
import com.google.appengine.tools.admin.ServerConnectionFactory;
import com.google.appengine.tools.admin.UpdateFailureEvent;
import com.google.appengine.tools.admin.UpdateListener;
import com.google.appengine.tools.admin.UpdateSuccessEvent;
import com.google.apphosting.utils.config.BackendsXml;
import com.google.apphosting.utils.config.BackendsYamlReader;
import com.google.apphosting.utils.config.CronXml;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class AppAdminImpl
implements AppAdmin {
    private final AppAdminFactory.ConnectOptions options;
    private final GenericApplication app;
    private final PrintWriter errorWriter;
    private final AppAdminFactory.ApplicationProcessingOptions appOptions;
    private final Class<? extends AppVersionUpload> appVersionUploadClass;
    private final AppAdmin.UpdateOptions updateOptions;

    protected AppAdminImpl(AppAdminFactory.ConnectOptions options, GenericApplication app, PrintWriter errorWriter, AppAdminFactory.ApplicationProcessingOptions appOptions, Class<? extends AppVersionUpload> appVersionUploadClass) {
        this.options = options;
        this.app = app;
        this.errorWriter = errorWriter;
        this.appOptions = appOptions;
        this.appVersionUploadClass = appVersionUploadClass;
        this.updateOptions = new AppAdmin.UpdateOptions();
    }

    protected ServerConnection getServerConnection(AppAdminFactory.ConnectOptions options) {
        return ServerConnectionFactory.getServerConnection(options);
    }

    @Override
    public void update(UpdateListener listener) {
        ServerConnection connection = this.getServerConnection(this.options);
        this.doUpdate(connection, listener, null);
        listener.onSuccess(new UpdateSuccessEvent(""));
    }

    @Override
    public void updateBackend(String backendName, UpdateListener listener) {
        ServerConnection connection = this.getServerConnection(this.options);
        this.doUpdate(connection, listener, backendName);
        listener.onSuccess(new UpdateSuccessEvent(""));
    }

    @Override
    public void updateBackends(List<String> backendNames, UpdateListener listener) {
        ServerConnection connection = this.getServerConnection(this.options);
        for (String backendName : backendNames) {
            this.doUpdate(connection, listener, backendName);
        }
        listener.onSuccess(new UpdateSuccessEvent(""));
    }

    @Override
    public void updateAllBackends(UpdateListener listener) {
        ServerConnection connection = this.getServerConnection(this.options);
        if (this.app.getBackendsXml() != null) {
            for (BackendsXml.Entry backend : this.app.getBackendsXml().getBackends()) {
                this.doUpdate(connection, listener, backend.getName());
            }
        }
        listener.onSuccess(new UpdateSuccessEvent(""));
    }

    @Override
    public void rollback() {
        this.rollbackBackend(null);
    }

    @Override
    public void rollbackBackend(String backend) {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app, backend);
            uploader.forceRollback();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to rollback:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to rollback app: ".concat(string) : new String("Unable to rollback app: "), t);
        }
    }

    @Override
    public void rollbackAllBackends() {
        ServerConnection connection = this.getServerConnection(this.options);
        if (this.app.getBackendsXml() != null) {
            try {
                for (BackendsXml.Entry backend : this.app.getBackendsXml().getBackends()) {
                    AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app, backend.getName());
                    uploader.forceRollback();
                }
            }
            catch (Throwable t) {
                this.errorWriter.println("Unable to rollback:");
                t.printStackTrace(this.errorWriter);
                String string = String.valueOf(t.getMessage());
                throw new AdminException(string.length() != 0 ? "Unable to rollback app: ".concat(string) : new String("Unable to rollback app: "), t);
            }
        }
    }

    @Override
    public void setBackendState(String backendName, BackendsXml.State newState) {
        String url;
        switch (newState) {
            case START: {
                url = "/api/backends/start";
                break;
            }
            case STOP: {
                url = "/api/backends/stop";
                break;
            }
            default: {
                String string = String.valueOf((Object)newState);
                throw new IllegalArgumentException(new StringBuilder(24 + String.valueOf(string).length()).append("Cannot change to state: ").append(string).toString());
            }
        }
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            connection.post(url, "", "app_id", this.app.getAppId(), "backend", backendName);
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to change backend state:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to change backend state: ".concat(string) : new String("Unable to change backend state: "), t);
        }
    }

    @Override
    public List<BackendsXml.Entry> listBackends() {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            String yaml = connection.post("/api/backends/list", "", "app_id", this.app.getAppId());
            if (yaml.contains("No backends configured")) {
                return Collections.emptyList();
            }
            BackendsXml xml = BackendsYamlReader.parse(yaml);
            return xml.getBackends();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to list backends:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to list backends: ".concat(string) : new String("Unable to list backends: "), t);
        }
    }

    @Override
    public void deleteBackend(String backendName) {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            connection.post("/api/backends/delete", "", "app_id", this.app.getAppId(), "backend", backendName);
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to delete backend:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to delete backend: ".concat(string) : new String("Unable to delete backend: "), t);
        }
    }

    @Override
    public void configureBackend(String backendName) {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            connection.post("/api/backends/configure", this.app.getBackendsXml().toYaml(), "app_id", this.app.getAppId(), "backend", backendName);
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to configure backend:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to configure backend: ".concat(string) : new String("Unable to configure backend: "), t);
        }
    }

    private void changeModuleState(String url) {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            connection.post(url, "", "app_id", this.app.getAppId(), "module", this.app.getModule() != null ? this.app.getModule() : "", "version", this.app.getVersion());
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to change module state:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to change module state: ".concat(string) : new String("Unable to change module state: "), t);
        }
    }

    @Override
    public void startModuleVersion() {
        this.changeModuleState("/api/modules/start");
    }

    @Override
    public void stopModuleVersion() {
        this.changeModuleState("/api/modules/stop");
    }

    @Override
    public void updateIndexes() {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app, null);
            uploader.updateIndexes();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to update indexes:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to update indexes for app: ".concat(string) : new String("Unable to update indexes for app: "), t);
        }
    }

    @Override
    public void updateCron() {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app, null);
            uploader.updateCron();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to update cron entries:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to update cron entries for app: ".concat(string) : new String("Unable to update cron entries for app: "), t);
        }
    }

    @Override
    public void updateQueues() {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app, null);
            uploader.updateQueue();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to upload:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to update task queues for app: ".concat(string) : new String("Unable to update task queues for app: "), t);
        }
    }

    @Override
    public void updateDispatch() {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app, null);
            uploader.updateDispatch();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to update dispatch entries:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to update dispatch entries for app: ".concat(string) : new String("Unable to update dispatch entries for app: "), t);
        }
    }

    @Override
    public void updateDos() {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app, null);
            uploader.updateDos();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to update DoS entries:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to update DoS entries for app: ".concat(string) : new String("Unable to update DoS entries for app: "), t);
        }
    }

    @Override
    public void setDefaultVersion() {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app, null);
            uploader.setDefaultVersion();
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to set default version:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to set default version for app: ".concat(string) : new String("Unable to set default version for app: "), t);
        }
    }

    @Override
    public List<CronEntry> cronInfo() {
        try {
            ArrayList<CronEntry> result = new ArrayList<CronEntry>();
            CronXml cron = this.app.getCronXml();
            if (cron == null) {
                return result;
            }
            for (CronXml.Entry entry : cron.getEntries()) {
                result.add(new CronEntryImpl(entry.getUrl(), entry.getDescription(), entry.getSchedule(), entry.getTimezone()));
            }
            return result;
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to display run times for cron entries:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to display run times for cron entries for app: ".concat(string) : new String("Unable to display run times for cron entries for app: "), t);
        }
    }

    @Override
    public ResourceLimits getResourceLimits() {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            NoLoggingClientDeploySender clientDeploySender = new NoLoggingClientDeploySender(connection);
            return ResourceLimits.request(clientDeploySender, this.app);
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to get resource limits:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to get resource limits: ".concat(string) : new String("Unable to get resource limits: "), t);
        }
    }

    @Override
    public void vacuumIndexes(ConfirmationCallback<IndexDeleter.DeleteIndexAction> callback, UpdateListener listener) {
        String appID = this.app.getAppId();
        if (null == appID || appID.isEmpty()) {
            String message = "This application does not have an ID.";
            String detailMessage = "The vacuum_indexes operation may not be performed for an application that does not have an ID.";
            AdminException e = new AdminException(message);
            listener.onFailure(new UpdateFailureEvent(e, message, detailMessage));
            throw e;
        }
        ServerConnection connection = this.getServerConnection(this.options);
        IndexDeleter deleter = new IndexDeleter(connection, this.app, callback, this.errorWriter, listener);
        try {
            deleter.deleteUnusedIndexes();
        }
        catch (Exception e) {
            String message = "Unable to perform vacuum_indexes";
            listener.onFailure(new UpdateFailureEvent(e, message, e.getMessage()));
            throw new AdminException(message, e);
        }
    }

    @Override
    public Reader requestLogs(int numDays, AppAdmin.LogSeverity severity, boolean includeAll) {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            String string = this.app.getAppId();
            String string2 = this.app.getVersion();
            File logFile = File.createTempFile(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("-").append(string2).toString(), ".log");
            logFile.deleteOnExit();
            LogFetcher logFetcher = new LogFetcher(this.app, connection);
            logFetcher.fetch(numDays, severity, includeAll, new FileOutputStream(logFile));
            return new BufferedReader(new FileReader(logFile));
        }
        catch (Exception ex) {
            throw new AdminException("Unable to retrieve the remote application logs:", ex);
        }
    }

    @Override
    public String listVersions() {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            return connection.post("/api/versions/list", "", "app_id", this.app.getAppId());
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to retrieve versions:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to retrieve versions: ".concat(string) : new String("Unable to retrieve versions: "), t);
        }
    }

    @Override
    public String deleteVersion(String appId, String moduleId, String versionId) {
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            return connection.post("/api/versions/delete", "", "app_id", appId, "module", moduleId != null ? moduleId : "", "version_match", versionId);
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to delete version:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to delete version: ".concat(string) : new String("Unable to delete version: "), t);
        }
    }

    @Override
    public String debugVersion() {
        if (null == this.app.getAppId() || this.app.getAppId().isEmpty()) {
            throw new AdminException("This application does not have an id");
        }
        if (null == this.app.getVersion() || this.app.getVersion().isEmpty()) {
            throw new AdminException("This application does not have a version");
        }
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            return connection.post("/api/vms/debug", "", "app_id", this.app.getAppId(), "module", this.app.getModule() != null ? this.app.getModule() : "", "version_match", this.app.getVersion());
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to debug version:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to debug version: ".concat(string) : new String("Unable to debug version: "), t);
        }
    }

    @Override
    public String debugVersionState() {
        if (null == this.app.getAppId() || this.app.getAppId().isEmpty()) {
            throw new AdminException("This application does not have an id");
        }
        if (null == this.app.getVersion() || this.app.getVersion().isEmpty()) {
            throw new AdminException("This application does not have a version");
        }
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            return connection.post("/api/vms/debugstate", "", "app_id", this.app.getAppId(), "module", this.app.getModule() != null ? this.app.getModule() : "", "version_match", this.app.getVersion());
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to get state for debug version call:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to get state for debug version: ".concat(string) : new String("Unable to get state for debug version: "), t);
        }
    }

    @Override
    public void migrateTraffic() {
        this.requireVersion();
        if (this.app.getModule() != null && !this.app.getModule().equals("") && !this.app.getModule().equals("default")) {
            throw new AdminException("Traffic migration does not support non-default modules yet");
        }
        ServerConnection connection = this.getServerConnection(this.options);
        try {
            connection.post("/api/appversion/migratetraffic", "", "app_id", this.app.getAppId(), "version", this.app.getVersion());
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to migrate traffic:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to migrate version: ".concat(string) : new String("Unable to migrate version: "), t);
        }
    }

    private void requireAppId() {
        if (null == this.app.getAppId() || this.app.getAppId().isEmpty()) {
            throw new AdminException("This application does not have an id");
        }
    }

    private void requireVersion() {
        this.requireAppId();
        if (null == this.app.getVersion() || this.app.getVersion().isEmpty()) {
            throw new AdminException("This application does not have a version");
        }
    }

    @Override
    public void stageApplicationWithDefaultResourceLimits(File stagingDir) {
        this.stageApplication(stagingDir, false);
    }

    @Override
    public void stageApplicationWithRemoteResourceLimits(File stagingDir) {
        this.stageApplication(stagingDir, true);
    }

    void stageApplication(File stagingDir, boolean useRemoteResourceLimits) {
        if (stagingDir == null) {
            throw new AdminException("Staging dir is not a valid directory (it is null)");
        }
        if (stagingDir.exists()) {
            if (!stagingDir.isDirectory()) {
                throw new AdminException(String.valueOf(stagingDir.getPath()).concat(" is not a valid staging directory (it is a regular file)"));
            }
            Path path = stagingDir.toPath();
            try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(path);){
                if (dirStream.iterator().hasNext()) {
                    throw new AdminException(String.valueOf(stagingDir.getPath()).concat(" is not a valid staging directory (it is not empty)"));
                }
            }
            catch (IOException e) {
                throw new AdminException("Unable to stage application.", e);
            }
        }
        StringWriter detailsWriter = new StringWriter();
        try {
            ResourceLimits resourceLimits = ResourceLimits.newDefaultResourceLimits();
            if (useRemoteResourceLimits) {
                ClientDeploySender clientDeploySender;
                ServerConnection connection = this.getServerConnection(this.options);
                if (this.getUpdateOptions().getUpdateUsageReporting()) {
                    String sdkVersion = this.getUpdateOptions().getSdkVersion();
                    clientDeploySender = new LoggingClientDeploySender(connection, sdkVersion);
                } else {
                    clientDeploySender = new NoLoggingClientDeploySender(connection);
                }
                resourceLimits = ResourceLimits.request(clientDeploySender, this.app);
            }
            this.app.resetProgress();
            this.app.setDetailsWriter(new PrintWriter((Writer)detailsWriter, true));
            this.app.createStagingDirectory(this.appOptions, resourceLimits, stagingDir);
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to stage:");
            t.printStackTrace(this.errorWriter);
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to stage app: ".concat(string) : new String("Unable to stage app: "), t);
        }
    }

    private void doUpdate(ServerConnection connection, UpdateListener listener, String backend) {
        StringWriter detailsWriter = new StringWriter();
        try {
            ClientDeploySender clientDeploySender;
            AppVersionUpload uploader = this.createAppVersionUpload(connection, this.app, backend);
            boolean updateGlobalConfigurations = this.getUpdateOptions().getUpdateGlobalConfigurations();
            boolean failOnPrecompilationError = this.appOptions.isFailOnPrecompilationError();
            boolean ignoreEndpointsFailures = this.appOptions.isIgnoreEndpointsFailures();
            if (this.getUpdateOptions().getUpdateUsageReporting()) {
                String sdkVersion = this.getUpdateOptions().getSdkVersion();
                clientDeploySender = new LoggingClientDeploySender(connection, sdkVersion);
            } else {
                clientDeploySender = new NoLoggingClientDeploySender(connection);
            }
            ResourceLimits resourceLimits = ResourceLimits.request(clientDeploySender, this.app);
            this.app.resetProgress();
            this.app.setListener(listener);
            this.app.setDetailsWriter(new PrintWriter((Writer)detailsWriter, true));
            this.app.createStagingDirectory(this.appOptions, resourceLimits);
            this.app.exportRepoInfoFile();
            clientDeploySender.setRuntime(AppVersionUpload.getRuntime(this.app.getAppYaml()));
            uploader.doUpload(resourceLimits, updateGlobalConfigurations, failOnPrecompilationError, ignoreEndpointsFailures, clientDeploySender);
        }
        catch (Throwable t) {
            this.errorWriter.println("Unable to update:");
            t.printStackTrace(this.errorWriter);
            listener.onFailure(new UpdateFailureEvent(t, t.toString(), detailsWriter.toString()));
            String string = String.valueOf(t.getMessage());
            throw new AdminException(string.length() != 0 ? "Unable to update app: ".concat(string) : new String("Unable to update app: "), t);
        }
    }

    private AppVersionUpload createAppVersionUpload(ServerConnection connection, GenericApplication app, String backend) throws Exception {
        Constructor<? extends AppVersionUpload> constructor = this.appVersionUploadClass.getConstructor(ServerConnection.class, GenericApplication.class, String.class, Boolean.TYPE);
        return constructor.newInstance(connection, app, backend, this.appOptions.isBatchModeSet());
    }

    @Override
    public AppAdmin.UpdateOptions getUpdateOptions() {
        return this.updateOptions;
    }
}

