/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.repackaged.com.google.common.base.Optional;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ArrayListMultimap;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.repackaged.com.google.common.hash.Hashing;
import com.google.appengine.repackaged.com.google.common.io.BaseEncoding;
import com.google.appengine.repackaged.com.google.common.io.ByteSource;
import com.google.appengine.repackaged.com.google.common.io.Files;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlException;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlReader;
import com.google.appengine.tools.admin.ClientDeploySender;
import com.google.appengine.tools.admin.GenericApplication;
import com.google.appengine.tools.admin.HttpIoException;
import com.google.appengine.tools.admin.LocalIOException;
import com.google.appengine.tools.admin.NoLoggingClientDeploySender;
import com.google.appengine.tools.admin.RemoteIOException;
import com.google.appengine.tools.admin.ResourceLimits;
import com.google.appengine.tools.admin.ServerConnection;
import com.google.appengine.tools.admin.Utility;
import com.google.appengine.tools.util.FileIterator;
import java.io.File;
import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class AppVersionUpload {
    private static final int MAX_FILES_PER_PRECOMPILE = 50;
    private static final String YAML_EMPTY_STRING = "null";
    private static final String PRECOMPILATION_FAILED_WARNING_MESSAGE = "Precompilation failed.  Consider retrying the update later, or add <precompilation-enabled>false</precompilation-enabled> to your appengine-web.xml to disable precompilation.";
    private static final Logger logger = Logger.getLogger(AppVersionUpload.class.getName());
    protected ServerConnection connection;
    protected GenericApplication app;
    protected final String backend;
    private boolean inTransaction = false;
    private Map<String, FileInfo> files = new HashMap<String, FileInfo>();
    private boolean deployed = false;
    private boolean started = false;
    private boolean checkConfigUpdated = false;
    private final UploadBatcher fileBatcher;
    private final UploadBatcher blobBatcher;
    private ClientDeploySender clientDeploySender;
    private SleepIfShouldRetry sleepIfShouldRetry;
    private static final String LIST_DELIMITER = "\n";
    private static final String TUPLE_DELIMITER = "|";

    public AppVersionUpload(ServerConnection connection, GenericApplication app) {
        this(connection, app, null, true);
    }

    public AppVersionUpload(ServerConnection connection, GenericApplication app, String backend, boolean batchMode) {
        this.connection = connection;
        this.app = app;
        this.backend = backend;
        this.clientDeploySender = new NoLoggingClientDeploySender(connection);
        this.fileBatcher = new UploadBatcher("file", batchMode);
        this.blobBatcher = new UploadBatcher("blob", batchMode);
        this.sleepIfShouldRetry = new DefaultSleepAndRetry();
    }

    @VisibleForTesting
    static AppVersionUpload getStartedAppForTesting(ServerConnection connection, GenericApplication app) {
        AppVersionUpload upload = new AppVersionUpload(connection, app);
        upload.started = true;
        return upload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doUpload(ResourceLimits resourceLimits, boolean updateGlobalConfigurations, boolean failOnPrecompilationError, boolean ignoreEndpointsFailures, ClientDeploySender clientDeploySender) throws LocalIOException, RemoteIOException {
        ClientDeploySender originalClientDeploySender = this.clientDeploySender;
        this.clientDeploySender = Preconditions.checkNotNull(clientDeploySender);
        try {
            this.uploadFilesTransaction(resourceLimits, failOnPrecompilationError, ignoreEndpointsFailures);
        }
        finally {
            this.clientDeploySender = originalClientDeploySender;
        }
        if (updateGlobalConfigurations) {
            this.updateIndexes();
            this.updateCron();
            this.updateQueue();
            this.updateDos();
            this.updatePagespeed();
            this.reportIfSkippingDispatchConfiguration();
        } else {
            this.reportSkippingGlobalConfiguration();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadFilesTransaction(ResourceLimits resourceLimits, boolean failOnPrecompilationError, boolean ignoreEndpointsFailures) throws LocalIOException, RemoteIOException {
        try {
            try {
                File basepath = this.getBasepath();
                this.scanFiles(basepath, resourceLimits);
                Collection<FileInfo> missingFiles = this.beginTransaction(resourceLimits);
                this.uploadFiles(failOnPrecompilationError, basepath, missingFiles);
                this.commit(ignoreEndpointsFailures);
                this.clientDeploySender.logClientDeploy(true, this.addVersionToArgs(new String[0]));
            }
            finally {
                this.rollback();
            }
        }
        catch (HttpIoException e) {
            if (e.isSlaError()) {
                this.clientDeploySender.logClientDeploy(false, this.addVersionToArgs(new String[0]));
            }
            throw e;
        }
        catch (RuntimeException e) {
            this.clientDeploySender.logClientDeploy(false, this.addVersionToArgs(new String[0]));
            throw e;
        }
    }

    private void uploadFiles(boolean failOnPrecompilationError, File basepath, Collection<FileInfo> missingFiles) throws LocalIOException, RemoteIOException {
        int n = missingFiles.size();
        this.app.statusUpdate(new StringBuilder(28).append("Uploading ").append(n).append(" files.").toString(), 50);
        if (!missingFiles.isEmpty()) {
            int numFiles = 0;
            int quarter = Math.max(1, missingFiles.size() / 4);
            for (FileInfo missingFile : missingFiles) {
                String string = String.valueOf(missingFile);
                logger.fine(new StringBuilder(17 + String.valueOf(string).length()).append("Uploading file '").append(string).append("'").toString());
                this.uploadFile(missingFile);
                if (++numFiles % quarter != 0) continue;
                int n2 = numFiles;
                this.app.statusUpdate(new StringBuilder(27).append("Uploaded ").append(n2).append(" files.").toString());
            }
        }
        this.uploadErrorHandlers(this.app.getErrorHandlers(), basepath);
        if (this.app.isPrecompilationEnabled()) {
            this.precompile(failOnPrecompilationError);
        }
        this.fileBatcher.flush();
        this.blobBatcher.flush();
    }

    private void scanFiles(File basepath, ResourceLimits resourceLimits) throws LocalIOException {
        this.app.statusUpdate("Scanning files on local disk.", 20);
        int numFiles = 0;
        long resourceTotal = 0L;
        List<Pattern> skipFiles = AppVersionUpload.loadSkipFiles(this.app.getAppYaml());
        for (File f : new FileIterator(basepath)) {
            long maxFileBlobSize;
            if (AppVersionUpload.shouldSkip(f.getName(), skipFiles)) continue;
            FileInfo fileInfo = new FileInfo(f, basepath);
            fileInfo.setMimeType(this.app);
            String string = String.valueOf(f);
            logger.fine(new StringBuilder(19 + String.valueOf(string).length()).append("Processing file '").append(string).append("'.").toString());
            long l = maxFileBlobSize = fileInfo.mimeType != null ? resourceLimits.maxBlobSize() : resourceLimits.maxFileSize();
            if (f.length() > maxFileBlobSize) {
                String message;
                if (f.getName().toLowerCase().endsWith(".jar")) {
                    String string2 = String.valueOf(f.getPath());
                    message = new StringBuilder(57 + String.valueOf(string2).length()).append("Jar ").append(string2).append(" is too large. Consider ").append("using --enable_jar_splitting.").toString();
                } else {
                    String string3 = String.valueOf(f.getPath());
                    message = new StringBuilder(54 + String.valueOf(string3).length()).append("File ").append(string3).append(" is too large (limit ").append(maxFileBlobSize).append(" bytes).").toString();
                }
                throw new LocalIOException(message);
            }
            resourceTotal += this.addFile(fileInfo);
            if (++numFiles % 250 != 0) continue;
            int n = numFiles;
            this.app.statusUpdate(new StringBuilder(26).append("Scanned ").append(n).append(" files.").toString());
        }
        if ((long)numFiles > resourceLimits.maxFileCount()) {
            long l = resourceLimits.maxFileCount();
            int n = numFiles;
            throw new LocalIOException(new StringBuilder(77).append("Applications are limited to ").append(l).append(" files, you have ").append(n).append(".").toString());
        }
        if (resourceTotal > resourceLimits.maxTotalFileSize()) {
            long l = resourceLimits.maxTotalFileSize();
            long l2 = resourceTotal;
            throw new LocalIOException(new StringBuilder(104).append("Applications are limited to ").append(l).append(" bytes of resource files, ").append("you have ").append(l2).append(".").toString());
        }
    }

    private void reportSkippingGlobalConfiguration() {
        TreeSet<String> skipSet = new TreeSet<String>();
        if (this.app.getIndexesXml() != null) {
            skipSet.add("indexes.xml");
        }
        if (this.app.getCronXml() != null) {
            skipSet.add("cron.xml");
        }
        if (this.app.getQueueXml() != null) {
            skipSet.add("queue.xml");
        }
        if (this.app.getDispatchXml() != null) {
            skipSet.add("dispatch.xml");
        }
        if (this.app.getDosXml() != null) {
            skipSet.add("dos.xml");
        }
        if (this.app.getPagespeedYaml() != null) {
            skipSet.add("pagespeed");
        }
        if (!skipSet.isEmpty()) {
            String string = String.valueOf(Joiner.on(", ").join(skipSet));
            this.app.statusUpdate(string.length() != 0 ? "Skipping global configurations: ".concat(string) : new String("Skipping global configurations: "));
        }
    }

    private void reportIfSkippingDispatchConfiguration() {
        if (this.app.getDispatchXml() != null) {
            this.app.statusUpdate("Skipping dispatch.xml - consider running \"appcfg.sh update_dispatch <war-dir>\"");
        }
    }

    private void uploadErrorHandlers(List<GenericApplication.ErrorHandler> errorHandlers, File basepath) throws LocalIOException, RemoteIOException {
        if (!errorHandlers.isEmpty()) {
            int n = errorHandlers.size();
            this.app.statusUpdate(new StringBuilder(56).append("Uploading ").append(n).append(" file(s) ").append("for static error handlers.").toString());
            for (GenericApplication.ErrorHandler handler : errorHandlers) {
                File file = new File(basepath, handler.getFile());
                FileInfo info = new FileInfo(file, basepath);
                String error = FileInfo.checkValidFilename(info.path);
                if (error != null) {
                    String string = String.valueOf(error);
                    throw new LocalIOException(string.length() != 0 ? "Could not find static error handler: ".concat(string) : new String("Could not find static error handler: "));
                }
                info.mimeType = handler.getMimeType();
                String errorType = handler.getErrorCode();
                if (errorType == null) {
                    errorType = "default";
                }
                this.send("/api/appversion/adderrorblob", info.file, info.mimeType, "path", errorType);
            }
        }
    }

    @VisibleForTesting
    void setSleepIfShouldRetry(SleepIfShouldRetry sleepAndRetry) {
        this.sleepIfShouldRetry = sleepAndRetry;
    }

    public void precompile(boolean failOnPrecompilationError) throws RemoteIOException {
        this.app.statusUpdate("Initializing precompilation...");
        ArrayList<String> filesToCompile = new ArrayList<String>();
        boolean containsGoFiles = false;
        for (String f : this.files.keySet()) {
            boolean isGoFile = f.toLowerCase().endsWith(".go");
            if (isGoFile && !containsGoFiles) {
                containsGoFiles = true;
            }
            if (!isGoFile && !f.toLowerCase().endsWith(".py")) continue;
            filesToCompile.add(f);
        }
        Collections.sort(filesToCompile);
        if (containsGoFiles) {
            failOnPrecompilationError = true;
        }
        int errorCount = 0;
        while (true) {
            try {
                filesToCompile.addAll(this.sendPrecompileRequest(Collections.emptyList()));
            }
            catch (RemoteIOException ex) {
                if (this.sleepIfShouldRetry.sleepIfShouldRetry(++errorCount)) continue;
                if (failOnPrecompilationError) {
                    throw AppVersionUpload.precompilationFailedException("", ex);
                }
                logger.warning(PRECOMPILATION_FAILED_WARNING_MESSAGE);
                return;
            }
            break;
        }
        errorCount = 0;
        while (!filesToCompile.isEmpty()) {
            try {
                if (!this.precompileChunk(filesToCompile)) continue;
                errorCount = 0;
            }
            catch (RemoteIOException ex) {
                Collections.shuffle(filesToCompile);
                if (this.sleepIfShouldRetry.sleepIfShouldRetry(++errorCount)) continue;
                if (failOnPrecompilationError) {
                    int n = filesToCompile.size();
                    String messageFragment = new StringBuilder(35).append(" with ").append(n).append(" file(s) remaining").toString();
                    throw AppVersionUpload.precompilationFailedException(messageFragment, ex);
                }
                logger.warning(PRECOMPILATION_FAILED_WARNING_MESSAGE);
                return;
            }
        }
    }

    private static RemoteIOException precompilationFailedException(String messageFragment, RemoteIOException cause) {
        String message = new StringBuilder(137 + String.valueOf(messageFragment).length()).append("Precompilation failed").append(messageFragment).append(". Consider adding").append(" <precompilation-enabled>false</precompilation-enabled> to your appengine-web.xml").append(" and trying again.").toString();
        if (cause instanceof HttpIoException) {
            HttpIoException httpCause = (HttpIoException)cause;
            return new HttpIoException(message, httpCause.getResponseCode(), httpCause);
        }
        return RemoteIOException.from(cause, message);
    }

    private boolean precompileChunk(List<String> filesToCompile) throws RemoteIOException {
        int filesLeft = filesToCompile.size();
        if (filesLeft == 0) {
            this.app.statusUpdate("Initializing precompilation...");
        } else {
            this.app.statusUpdate(MessageFormat.format("Precompiling... {0} file(s) left.", filesLeft));
        }
        List<String> subset = filesToCompile.subList(0, Math.min(filesLeft, 50));
        List<String> remainingFiles = this.sendPrecompileRequest(subset);
        subset.clear();
        filesToCompile.addAll(remainingFiles);
        return filesToCompile.size() < filesLeft;
    }

    private List<String> sendPrecompileRequest(List<String> filesToCompile) throws RemoteIOException {
        String response = this.send("/api/appversion/precompile", Joiner.on(LIST_DELIMITER).useForNull(YAML_EMPTY_STRING).join(filesToCompile), new String[0]);
        if (response.length() > 0) {
            return Arrays.asList(response.split(LIST_DELIMITER));
        }
        return Collections.emptyList();
    }

    public void updateIndexes() throws RemoteIOException {
        if (this.app.getIndexesXml() != null) {
            this.app.statusUpdate("Uploading index definitions.");
            this.send("/api/datastore/index/add", this.getIndexYaml(), new String[0]);
        }
    }

    public void updateCron() throws RemoteIOException {
        String yaml = this.getCronYaml();
        if (yaml != null) {
            this.app.statusUpdate("Uploading cron jobs.");
            this.send("/api/datastore/cron/update", yaml, new String[0]);
        }
    }

    public void updateQueue() throws RemoteIOException {
        String yaml = this.getQueueYaml();
        if (yaml != null) {
            this.app.statusUpdate("Uploading task queues.");
            this.send("/api/queue/update", yaml, new String[0]);
        }
    }

    public void updateDispatch() throws RemoteIOException {
        String yaml = this.getDispatchYaml();
        if (yaml != null) {
            this.app.statusUpdate("Uploading dispatch entries.");
            this.send("/api/dispatch/update", yaml, new String[0]);
        }
    }

    public void updateDos() throws RemoteIOException {
        String yaml = this.getDosYaml();
        if (yaml != null) {
            this.app.statusUpdate("Uploading DoS entries.");
            this.send("/api/dos/update", yaml, new String[0]);
        }
    }

    public void updatePagespeed() throws RemoteIOException {
        block4: {
            String yaml = this.getPagespeedYaml();
            if (yaml != null) {
                this.app.statusUpdate("Uploading PageSpeed entries.");
                this.send("/api/appversion/updatepagespeed", yaml, new String[0]);
            } else {
                try {
                    this.send("/api/appversion/updatepagespeed", "", new String[0]);
                }
                catch (HttpIoException exc) {
                    if (exc.getResponseCode() == 404) break block4;
                    throw exc;
                }
            }
        }
    }

    public void setDefaultVersion() throws IOException {
        String module = this.app.getModule();
        String url = "/api/appversion/setdefault";
        if (module != null) {
            Object[] modules = module.split(",");
            if (modules.length > 1) {
                String string = String.valueOf(Joiner.on(", ").join(modules));
                Object[] objectArray = this.app.getAppId();
                String string2 = this.app.getVersion();
                this.app.statusUpdate(new StringBuilder(59 + String.valueOf(string).length() + String.valueOf(objectArray).length() + String.valueOf(string2).length()).append("Setting the default version of modules ").append(string).append(" of application ").append((String)objectArray).append(" to ").append(string2).toString());
                ArrayListMultimap<String, String> args = ArrayListMultimap.create();
                args.put("app_id", this.app.getAppId());
                args.put("version", this.app.getVersion());
                for (Object mod : modules) {
                    args.put("module", (String)mod);
                }
                this.connection.post(url, "", args);
                return;
            }
            String string = this.app.getAppId();
            String string3 = this.app.getVersion();
            this.app.statusUpdate(new StringBuilder(58 + String.valueOf(module).length() + String.valueOf(string).length() + String.valueOf(string3).length()).append("Setting the default version of module ").append(module).append(" of application ").append(string).append(" to ").append(string3).toString());
        } else {
            String string = this.app.getAppId();
            String string4 = this.app.getVersion();
            this.app.statusUpdate(new StringBuilder(47 + String.valueOf(string).length() + String.valueOf(string4).length()).append("Setting the default version of application ").append(string).append(" to ").append(string4).toString());
        }
        this.send(url, "", new String[0]);
    }

    protected String getIndexYaml() {
        return this.app.getIndexesXml().toYaml();
    }

    protected String getCronYaml() {
        if (this.app.getCronXml() != null) {
            return this.app.getCronXml().toYaml();
        }
        return null;
    }

    protected String getQueueYaml() {
        if (this.app.getQueueXml() != null) {
            return this.app.getQueueXml().toYaml();
        }
        return null;
    }

    protected String getDispatchYaml() {
        return this.app.getDispatchXml() == null ? null : this.app.getDispatchXml().toYaml();
    }

    protected String getDosYaml() {
        if (this.app.getDosXml() != null) {
            return this.app.getDosXml().toYaml();
        }
        return null;
    }

    protected String getPagespeedYaml() {
        return this.app.getPagespeedYaml();
    }

    @VisibleForTesting
    protected boolean getInTransaction() {
        return this.inTransaction;
    }

    @VisibleForTesting
    protected void setInTransaction(boolean newValue) {
        this.inTransaction = newValue;
    }

    private File getBasepath() {
        File path = this.app.getStagingDir();
        if (path == null) {
            path = new File(this.app.getPath());
        }
        return path;
    }

    @VisibleForTesting
    String getLogUrl() {
        StringBuilder url = new StringBuilder();
        url.append("https://appengine.google.com/logs?app_id=");
        url.append(this.app.getAppId());
        if (this.app.getVersion() != null) {
            url.append("&version_id=");
            if (this.app.getModule() != null) {
                url.append(this.app.getModule());
                url.append("%3A");
            }
            url.append(this.app.getVersion());
        }
        return url.toString();
    }

    @VisibleForTesting
    long addFile(FileInfo info) {
        if (this.inTransaction) {
            throw new IllegalStateException("Already in a transaction.");
        }
        String error = FileInfo.checkValidFilename(info.path);
        if (error != null) {
            logger.severe(error);
            return 0L;
        }
        this.files.put(info.path, info);
        return info.mimeType != null ? 0L : info.file.length();
    }

    private ArrayList<String> validateBeginYaml(String response) {
        YamlReader yaml = new YamlReader(new StringReader(response));
        try {
            Map responseMap;
            Object obj = yaml.read();
            if (obj != null && (responseMap = (Map)obj) != null && (obj = responseMap.get("warnings")) != null) {
                ArrayList warnings = (ArrayList)obj;
                return warnings;
            }
        }
        catch (YamlException yamlException) {
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return new ArrayList<String>();
    }

    @VisibleForTesting
    Collection<FileInfo> beginTransaction(ResourceLimits resourceLimits) throws RemoteIOException {
        if (this.inTransaction) {
            throw new IllegalStateException("Already in a transaction.");
        }
        if (this.backend == null) {
            this.app.statusUpdate("Initiating update.");
        } else {
            String string = this.backend;
            this.app.statusUpdate(new StringBuilder(30 + String.valueOf(string).length()).append("Initiating update of backend ").append(string).append(".").toString());
        }
        String response = this.send("/api/appversion/create", this.app.getAppYaml(), new String[0]);
        ArrayList<String> warnings = this.validateBeginYaml(response);
        for (String warning : warnings) {
            String string = String.valueOf(warning);
            this.app.statusUpdate(string.length() != 0 ? "WARNING: ".concat(string) : new String("WARNING: "));
        }
        this.inTransaction = true;
        ArrayList<FileInfo> blobsToClone = new ArrayList<FileInfo>(this.files.size());
        ArrayList<FileInfo> filesToClone = new ArrayList<FileInfo>(this.files.size());
        for (FileInfo f : this.files.values()) {
            if (f.mimeType == null) {
                filesToClone.add(f);
                continue;
            }
            blobsToClone.add(f);
        }
        TreeMap<String, FileInfo> filesToUpload = new TreeMap<String, FileInfo>();
        this.cloneFiles("/api/appversion/cloneblobs", blobsToClone, "static", filesToUpload, resourceLimits.maxFilesToClone());
        this.cloneFiles("/api/appversion/clonefiles", filesToClone, "application", filesToUpload, resourceLimits.maxFilesToClone());
        logger.fine("Files to upload :");
        for (FileInfo f : filesToUpload.values()) {
            String string = String.valueOf(f);
            logger.fine(new StringBuilder(1 + String.valueOf(string).length()).append("\t").append(string).toString());
        }
        this.files = filesToUpload;
        return new ArrayList<FileInfo>(filesToUpload.values());
    }

    private void cloneFiles(String url, Collection<FileInfo> filesParam, String type, Map<String, FileInfo> filesToUpload, long maxFilesToClone) throws RemoteIOException {
        if (filesParam.isEmpty()) {
            return;
        }
        int n = filesParam.size();
        this.app.statusUpdate(new StringBuilder(27 + String.valueOf(type).length()).append("Cloning ").append(n).append(" ").append(type).append(" files.").toString());
        int cloned = 0;
        int remaining = filesParam.size();
        ArrayList<FileInfo> chunk = new ArrayList<FileInfo>((int)maxFilesToClone);
        for (FileInfo file : filesParam) {
            String result;
            chunk.add(file);
            if (--remaining != 0 && (long)chunk.size() < maxFilesToClone) continue;
            if (cloned > 0) {
                int n2 = cloned;
                this.app.statusUpdate(new StringBuilder(25).append("Cloned ").append(n2).append(" files.").toString());
            }
            if ((result = this.send(url, AppVersionUpload.buildClonePayload(chunk), new String[0])) != null && result.length() > 0) {
                for (String path : result.split(LIST_DELIMITER)) {
                    if (path == null || path.length() == 0) continue;
                    FileInfo info = this.files.get(path);
                    if (info == null) {
                        logger.warning(new StringBuilder(27 + String.valueOf(path).length()).append("Skipping ").append(path).append(": missing FileInfo").toString());
                        continue;
                    }
                    filesToUpload.put(path, info);
                }
            }
            cloned += chunk.size();
            chunk.clear();
        }
    }

    private void uploadFile(FileInfo file) throws RemoteIOException {
        if (!this.inTransaction) {
            throw new IllegalStateException("beginTransaction() must be called before uploadFile().");
        }
        if (!this.files.containsKey(file.path)) {
            String string = file.path;
            throw new IllegalArgumentException(new StringBuilder(49 + String.valueOf(string).length()).append("File ").append(string).append(" is not in the list of files to be uploaded.").toString());
        }
        this.files.remove(file.path);
        if (file.mimeType == null) {
            this.fileBatcher.addToBatch(file);
        } else {
            this.blobBatcher.addToBatch(file);
        }
    }

    @VisibleForTesting
    void commit(boolean ignoreEndpointsFailures) throws RemoteIOException {
        this.deploy();
        try {
            boolean ready = this.retryWithBackoff(1.0, 2.0, 60.0, 20, new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return AppVersionUpload.this.isReady();
                }
            });
            if (!ready) {
                logger.severe("Version still not ready to serve, aborting.");
                throw new RemoteIOException("Version not ready.");
            }
            this.startServing();
            boolean versionIsServing = this.retryWithBackoff(1.0, 2.0, 60.0, 20, new Callable<Boolean>(){

                @Override
                public Boolean call() throws Exception {
                    return AppVersionUpload.this.isServing();
                }
            });
            if (!versionIsServing) {
                logger.severe("Version still not serving, aborting.");
                throw new RemoteIOException("Version not ready.");
            }
            if (this.checkConfigUpdated) {
                Optional<EndpointsStatusAndMessage> result = this.retryWithBackoffOptional(1.0, 2.0, 60.0, 20, new IsConfigUpdatedCallable());
                this.checkEndpointsServingStatusResult(result, ignoreEndpointsFailures);
            }
            this.app.statusUpdate("Closing update: new version is ready to start serving.");
            this.inTransaction = false;
        }
        catch (RemoteIOException | RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @VisibleForTesting
    void checkEndpointsServingStatusResult(Optional<EndpointsStatusAndMessage> callResult, boolean ignoreEndpointsFailures) {
        EndpointsStatusAndMessage configServingStatus = callResult.or(new EndpointsStatusAndMessage(EndpointsServingStatus.PENDING));
        if (configServingStatus.status != EndpointsServingStatus.SERVING) {
            String userMessage = configServingStatus.errorMessage == null ? String.format("Check the app's AppEngine logs for errors: %s", this.getLogUrl()) : configServingStatus.errorMessage;
            String string = String.valueOf(userMessage);
            String errorMessage = string.length() != 0 ? "Endpoints configuration not updated.  ".concat(string) : new String("Endpoints configuration not updated.  ");
            this.app.statusUpdate(errorMessage);
            logger.severe(errorMessage);
            this.app.statusUpdate("See the deployment troubleshooting documentation for more information: https://developers.google.com/appengine/docs/java/endpoints/test_deploy#troubleshooting_a_deployment_failure");
            if (ignoreEndpointsFailures) {
                this.app.statusUpdate("Ignoring Endpoints failure and proceeding with update.");
            } else {
                throw new RuntimeException(errorMessage);
            }
        }
    }

    private void deploy() throws RemoteIOException {
        if (!this.inTransaction) {
            throw new IllegalStateException("beginTransaction() must be called before deploy().");
        }
        if (!this.files.isEmpty()) {
            throw new IllegalStateException("Some required files have not been uploaded.");
        }
        this.app.statusUpdate("Deploying new version.", 20);
        this.send("/api/appversion/deploy", "", new String[0]);
        this.deployed = true;
    }

    private boolean isReady() throws IOException {
        if (!this.deployed) {
            throw new IllegalStateException("deploy() must be called before isReady()");
        }
        String result = this.send("/api/appversion/isready", "", new String[0]);
        return "1".equals(result.trim());
    }

    private void startServing() throws IOException {
        if (!this.deployed) {
            throw new IllegalStateException("deploy() must be called before startServing()");
        }
        this.send("/api/appversion/startserving", "", "willcheckserving", "1");
        this.started = true;
    }

    @VisibleForTesting
    protected Map<String, String> parseIsServingResponse(String isServingResp) {
        ImmutableMap.Builder<String, String> result = ImmutableMap.builder();
        if (isServingResp.isEmpty()) {
            return result.build();
        }
        try {
            YamlReader yamlReader = new YamlReader(isServingResp);
            Map resultMap = yamlReader.read(Map.class, String.class);
            for (Object key : resultMap.keySet()) {
                result.put((String)key, (String)resultMap.get(key));
            }
        }
        catch (YamlException e) {
            String string = String.valueOf(result);
            logger.severe(new StringBuilder(36 + String.valueOf(string).length()).append("Unable to parse Yaml from response: ").append(string).toString());
            throw new RuntimeException(e);
        }
        return result.build();
    }

    private boolean isServing() throws IOException {
        if (!this.started) {
            throw new IllegalStateException("startServing() must be called before isServing().");
        }
        String result = this.send("/api/appversion/isserving", "", "new_serving_resp", "1");
        if ("1".equals(result.trim()) || "0".equals(result.trim())) {
            return "1".equals(result.trim());
        }
        Map<String, String> resultMap = this.parseIsServingResponse(result.trim());
        if (resultMap.containsKey("message") && !YAML_EMPTY_STRING.equals(resultMap.get("message"))) {
            this.app.statusUpdate(resultMap.get("message"));
        }
        if (resultMap.containsKey("fatal") && Boolean.parseBoolean(resultMap.get("fatal").toLowerCase())) {
            throw new RuntimeException("Fatal problem encountered during deployment. Please refer to the logs for more information.");
        }
        if (resultMap.containsKey("check_endpoints_config")) {
            this.checkConfigUpdated = Boolean.parseBoolean(resultMap.get("check_endpoints_config"));
        }
        if (resultMap.containsKey("serving")) {
            return Boolean.parseBoolean(resultMap.get("serving"));
        }
        String string = String.valueOf("Fatal problem encountered during deployment. Unexpected response when checking for serving status. Response: ");
        String string2 = String.valueOf(result);
        throw new RuntimeException(string2.length() != 0 ? string.concat(string2) : new String(string));
    }

    @VisibleForTesting
    Map<String, String> parseIsConfigUpdatedResponse(String isConfigUpdatedResp) {
        ImmutableMap.Builder<String, String> result = ImmutableMap.builder();
        try {
            YamlReader yamlReader = new YamlReader(isConfigUpdatedResp);
            Map resultMap = yamlReader.read(Map.class, String.class);
            if (resultMap == null) {
                return result.build();
            }
            for (Object key : resultMap.keySet()) {
                result.put((String)key, (String)resultMap.get(key));
            }
        }
        catch (YamlException e) {
            String string = String.valueOf(result);
            logger.severe(new StringBuilder(36 + String.valueOf(string).length()).append("Unable to parse Yaml from response: ").append(string).toString());
            throw new RuntimeException(e);
        }
        return result.build();
    }

    private EndpointsStatusAndMessage isConfigUpdated() throws IOException, IllegalArgumentException {
        if (!this.started) {
            throw new IllegalStateException("startServing() must be called before isConfigUpdated().");
        }
        String result = this.send("/api/isconfigupdated", "", new String[0]);
        Map<String, String> resultMap = this.parseIsConfigUpdatedResponse(result.trim());
        if (resultMap.containsKey("updatedDetail2")) {
            return new EndpointsStatusAndMessage(resultMap.get("updatedDetail2"), resultMap.get("errorMessage"));
        }
        if (resultMap.containsKey("updated")) {
            return Boolean.parseBoolean(resultMap.get("updated")) ? new EndpointsStatusAndMessage(EndpointsServingStatus.SERVING) : new EndpointsStatusAndMessage(EndpointsServingStatus.PENDING);
        }
        String string = String.valueOf("Fatal problem encountered during deployment. Unexpected response when checking for configuration update status. Response: ");
        String string2 = String.valueOf(result);
        throw new RuntimeException(string2.length() != 0 ? string.concat(string2) : new String(string));
    }

    public void forceRollback() throws RemoteIOException {
        String string;
        if (this.backend == null) {
            string = ".";
        } else {
            String string2 = this.backend;
            string = new StringBuilder(13 + String.valueOf(string2).length()).append(" on backend ").append(string2).append(".").toString();
        }
        String string3 = String.valueOf(string);
        this.app.statusUpdate(string3.length() != 0 ? "Rolling back the update".concat(string3) : new String("Rolling back the update"));
        this.send("/api/appversion/rollback", "", new String[0]);
    }

    private void rollback() throws RemoteIOException {
        if (!this.inTransaction) {
            return;
        }
        this.forceRollback();
    }

    @VisibleForTesting
    String send(String url, String payload, String ... args) throws RemoteIOException {
        try {
            return this.clientDeploySender.send(url, payload, this.addVersionToArgs(args));
        }
        catch (IOException e) {
            throw RemoteIOException.from(e);
        }
    }

    @VisibleForTesting
    String send(String url, File payload, String mimeType, String ... args) throws RemoteIOException {
        try {
            return this.clientDeploySender.send(url, payload, mimeType, this.addVersionToArgs(args));
        }
        catch (IOException e) {
            throw RemoteIOException.from(e);
        }
    }

    private String[] addVersionToArgs(String ... args) {
        ArrayList<String> result = new ArrayList<String>();
        Collections.addAll(result, args);
        result.add("app_id");
        result.add(this.app.getAppId());
        if (this.backend != null) {
            result.add("backend");
            result.add(this.backend);
        } else if (this.app.getVersion() != null) {
            result.add("version");
            result.add(this.app.getVersion());
        }
        if (this.app.getModule() != null) {
            result.add("module");
            result.add(this.app.getModule());
        }
        return result.toArray(new String[result.size()]);
    }

    private boolean retryWithBackoff(double initialDelay, double backoffFactor, double maxDelay, int maxTries, final Callable<Boolean> callable) throws Exception {
        Optional<Boolean> result = this.retryWithBackoffOptional(initialDelay, backoffFactor, maxDelay, maxTries, new Callable<Optional<Boolean>>(){

            @Override
            public Optional<Boolean> call() throws Exception {
                return (Boolean)callable.call() != false ? Optional.of(true) : Optional.absent();
            }
        });
        return result.or(false);
    }

    @VisibleForTesting
    public <T> Optional<T> retryWithBackoffOptional(double initialDelay, double backoffFactor, double maxDelay, int maxTries, Callable<Optional<T>> callable) throws Exception {
        long delayMillis = (long)(initialDelay * 1000.0);
        long maxDelayMillis = (long)(maxDelay * 1000.0);
        Optional<T> callResult = callable.call();
        if (callResult.isPresent()) {
            return callResult;
        }
        while (maxTries > 1) {
            long l = delayMillis / 1000L;
            this.app.statusUpdate(new StringBuilder(49).append("Will check again in ").append(l).append(" seconds.").toString());
            Thread.sleep(delayMillis);
            delayMillis = (long)((double)delayMillis * backoffFactor);
            if (delayMillis > maxDelayMillis) {
                delayMillis = maxDelayMillis;
            }
            --maxTries;
            callResult = callable.call();
            if (!callResult.isPresent()) continue;
            return callResult;
        }
        return Optional.absent();
    }

    private static String buildClonePayload(Collection<FileInfo> files) {
        StringBuffer data = new StringBuffer();
        boolean first = true;
        for (FileInfo file : files) {
            if (first) {
                first = false;
            } else {
                data.append(LIST_DELIMITER);
            }
            data.append(file.path);
            data.append(TUPLE_DELIMITER);
            data.append(file.hash);
            if (file.mimeType == null) continue;
            data.append(TUPLE_DELIMITER);
            data.append(file.mimeType);
        }
        return data.toString();
    }

    @VisibleForTesting
    static String getRuntime(String appYaml) {
        String result = "?";
        try {
            Map yaml = (Map)new YamlReader(appYaml).read();
            Object runtime = yaml.get("runtime");
            if (runtime instanceof String) {
                result = (String)runtime;
            }
        }
        catch (YamlException ex) {
            logger.severe(ex.toString());
        }
        return result;
    }

    @VisibleForTesting
    static List<Pattern> loadSkipFiles(String appYaml) {
        ArrayList<Pattern> skipFiles = new ArrayList<Pattern>();
        if (appYaml == null) {
            return skipFiles;
        }
        try {
            Map yaml = (Map)new YamlReader(appYaml).read();
            List skipFileList = (List)yaml.get("skip_files");
            if (skipFileList != null) {
                for (Object skipFile : skipFileList) {
                    skipFiles.add(Pattern.compile(skipFile.toString()));
                }
            }
        }
        catch (YamlException ex) {
            logger.severe(ex.toString());
        }
        return skipFiles;
    }

    @VisibleForTesting
    static boolean shouldSkip(String name, List<Pattern> skipFiles) {
        for (Pattern skipPattern : skipFiles) {
            if (!skipPattern.matcher(name).matches()) continue;
            return true;
        }
        return false;
    }

    class UploadBatcher {
        static final int MAX_BATCH_SIZE = 3200000;
        static final int MAX_BATCH_COUNT = 100;
        static final int MAX_BATCH_FILE_SIZE = 200000;
        static final int BATCH_OVERHEAD = 500;
        String what;
        String singleUrl;
        String batchUrl;
        boolean batching = true;
        List<FileInfo> batch = new ArrayList<FileInfo>();
        long batchSize = 0L;

        public UploadBatcher(String what, boolean batching) {
            this.what = what;
            String string = String.valueOf(what);
            this.singleUrl = string.length() != 0 ? "/api/appversion/add".concat(string) : new String("/api/appversion/add");
            this.batchUrl = String.valueOf(this.singleUrl).concat("s");
            this.batching = batching;
        }

        public void sendBatch() throws IOException {
            int n = this.batch.size();
            String string = this.what;
            long l = this.batchSize / 1000L;
            AppVersionUpload.this.app.statusUpdate(new StringBuilder(73 + String.valueOf(string).length()).append("Sending batch containing ").append(n).append(" ").append(string).append("(s) totaling ").append(l).append("KB.").toString());
            AppVersionUpload.this.clientDeploySender.sendBatch(this.batchUrl, this.batch, this.batchSize, AppVersionUpload.this.addVersionToArgs(new String[]{"", ""}));
            this.batch = new ArrayList<FileInfo>();
            this.batchSize = 0L;
        }

        public void flush() throws RemoteIOException {
            if (this.batch.isEmpty()) {
                return;
            }
            try {
                this.sendBatch();
            }
            catch (Exception e) {
                String string = String.valueOf(e.getMessage());
                AppVersionUpload.this.app.statusUpdate(string.length() != 0 ? "Exception in flushing batch payload, so sending 1 by 1...".concat(string) : new String("Exception in flushing batch payload, so sending 1 by 1..."));
                this.batching = false;
                for (FileInfo fileInfo : this.batch) {
                    AppVersionUpload.this.send(this.singleUrl, fileInfo.file, fileInfo.mimeType, "path", fileInfo.path);
                }
                this.batch = new ArrayList<FileInfo>();
                this.batchSize = 0L;
            }
        }

        public void addToBatch(FileInfo fileInfo) throws RemoteIOException {
            long size = fileInfo.file.length();
            if (size <= 200000L) {
                if (this.batch.size() >= 100 || this.batchSize + size > 3200000L) {
                    this.flush();
                }
                if (this.batching) {
                    this.batch.add(fileInfo);
                    this.batchSize += size + 500L;
                    return;
                }
            }
            AppVersionUpload.this.send(this.singleUrl, fileInfo.file, fileInfo.mimeType, "path", fileInfo.path);
        }
    }

    static class FileInfo
    implements Comparable<FileInfo> {
        public File file;
        public String path;
        public String hash;
        public String mimeType;
        private static final Pattern FILE_PATH_POSITIVE_RE = Pattern.compile("^[ 0-9a-zA-Z._+/@$-]{1,256}$");
        private static final Pattern FILE_PATH_NEGATIVE_RE_1 = Pattern.compile("[.][.]|^[.]/|[.]$|/[.]/|^-|^_ah/|^/");
        private static final Pattern FILE_PATH_NEGATIVE_RE_2 = Pattern.compile("//|/$");
        private static final Pattern FILE_PATH_NEGATIVE_RE_3 = Pattern.compile("^ | $|/ | /");
        private static final BaseEncoding SEPARATED_HEX = BaseEncoding.base16().lowerCase().withSeparator("_", 8);

        private FileInfo(String path) {
            this.path = path;
            this.mimeType = "";
        }

        public FileInfo(File f, File base) throws LocalIOException {
            this.file = f;
            this.path = Utility.calculatePath(f, base);
            this.hash = this.calculateHash();
        }

        @VisibleForTesting
        static FileInfo newForTesting(String path) {
            return new FileInfo(path);
        }

        public void setMimeType(GenericApplication app) {
            this.mimeType = app.getMimeTypeIfStatic(this.path);
        }

        public String toString() {
            String string = this.mimeType == null ? "" : this.mimeType;
            String string2 = this.hash;
            String string3 = this.path;
            return new StringBuilder(2 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append("\t").append(string2).append("\t").append(string3).toString();
        }

        @Override
        public int compareTo(FileInfo other) {
            return this.path.compareTo(other.path);
        }

        public int hashCode() {
            return this.path.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof FileInfo) {
                return this.path.equals(((FileInfo)obj).path);
            }
            return false;
        }

        @VisibleForTesting
        static String checkValidFilename(String path) {
            if (!FILE_PATH_POSITIVE_RE.matcher(path).matches()) {
                String string = String.valueOf(path);
                return string.length() != 0 ? "Invalid character in filename: ".concat(string) : new String("Invalid character in filename: ");
            }
            if (FILE_PATH_NEGATIVE_RE_1.matcher(path).find()) {
                String string = String.valueOf(path);
                return string.length() != 0 ? "Filname cannot contain '.' or '..' or start with '-', '_ah/' or '/' : ".concat(string) : new String("Filname cannot contain '.' or '..' or start with '-', '_ah/' or '/' : ");
            }
            if (FILE_PATH_NEGATIVE_RE_2.matcher(path).find()) {
                String string = String.valueOf(path);
                return string.length() != 0 ? "Filname cannot have trailing / or contain //: ".concat(string) : new String("Filname cannot have trailing / or contain //: ");
            }
            if (FILE_PATH_NEGATIVE_RE_3.matcher(path).find()) {
                return new StringBuilder(50 + String.valueOf(path).length()).append("Any spaces must be in the middle of a filename: '").append(path).append("'").toString();
            }
            return null;
        }

        @VisibleForTesting
        static String calculateHash(ByteSource source) throws IOException {
            byte[] hash = source.hash(Hashing.sha1()).asBytes();
            return SEPARATED_HEX.encode(hash);
        }

        public String calculateHash() throws LocalIOException {
            try {
                return FileInfo.calculateHash(Files.asByteSource(this.file));
            }
            catch (IOException e) {
                throw LocalIOException.from(e);
            }
        }
    }

    class IsConfigUpdatedCallable
    implements Callable<Optional<EndpointsStatusAndMessage>> {
        IsConfigUpdatedCallable() {
        }

        @Override
        public Optional<EndpointsStatusAndMessage> call() throws Exception {
            EndpointsStatusAndMessage result = AppVersionUpload.this.isConfigUpdated();
            return result.status == EndpointsServingStatus.PENDING ? Optional.absent() : Optional.of(result);
        }
    }

    private static class DefaultSleepAndRetry
    implements SleepIfShouldRetry {
        private DefaultSleepAndRetry() {
        }

        @Override
        public boolean sleepIfShouldRetry(int errorCount) {
            if (errorCount > 3) {
                return false;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return true;
        }
    }

    @VisibleForTesting
    static interface SleepIfShouldRetry {
        public boolean sleepIfShouldRetry(int var1);
    }

    @VisibleForTesting
    static class EndpointsStatusAndMessage {
        public final EndpointsServingStatus status;
        public final String errorMessage;

        EndpointsStatusAndMessage(String status, String errorMessage) {
            this.status = EndpointsServingStatus.parse(status);
            this.errorMessage = errorMessage;
        }

        EndpointsStatusAndMessage(EndpointsServingStatus status) {
            this.status = status;
            this.errorMessage = null;
        }

        public boolean equals(Object otherObj) {
            if (!(otherObj instanceof EndpointsStatusAndMessage)) {
                return false;
            }
            EndpointsStatusAndMessage other = (EndpointsStatusAndMessage)otherObj;
            if (this.status != other.status) {
                return false;
            }
            if (this.errorMessage == null && other.errorMessage != null || this.errorMessage != null && other.errorMessage == null) {
                return false;
            }
            return this.errorMessage == null || this.errorMessage.equals(other.errorMessage);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.status, this.errorMessage});
        }
    }

    @VisibleForTesting
    static enum EndpointsServingStatus {
        SERVING("serving"),
        PENDING("pending"),
        FAILED("failed");

        private final String parseName;

        private EndpointsServingStatus(String parseName) {
            this.parseName = parseName;
        }

        static EndpointsServingStatus parse(String value) {
            for (EndpointsServingStatus status : EndpointsServingStatus.values()) {
                if (!value.equalsIgnoreCase(status.parseName)) continue;
                return status;
            }
            String string = String.valueOf(value);
            throw new IllegalArgumentException(string.length() != 0 ? "Value is not a recognized EndpointsServingStatus:".concat(string) : new String("Value is not a recognized EndpointsServingStatus:"));
        }
    }
}

