/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableSet;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.appengine.repackaged.com.google.common.collect.Sets;
import com.google.appengine.repackaged.com.google.common.io.Files;
import com.google.appengine.tools.admin.AppAdminFactory;
import com.google.appengine.tools.admin.AppYamlTranslator;
import com.google.appengine.tools.admin.GenericApplication;
import com.google.appengine.tools.admin.JspCompilationException;
import com.google.appengine.tools.admin.OutputPump;
import com.google.appengine.tools.admin.RepoInfo;
import com.google.appengine.tools.admin.ResourceLimits;
import com.google.appengine.tools.admin.UpdateListener;
import com.google.appengine.tools.admin.UpdateProgressEvent;
import com.google.appengine.tools.admin.Utility;
import com.google.appengine.tools.info.SdkImplInfo;
import com.google.appengine.tools.info.SdkInfo;
import com.google.appengine.tools.info.Version;
import com.google.appengine.tools.util.ApiVersionFinder;
import com.google.appengine.tools.util.FileIterator;
import com.google.appengine.tools.util.JarSplitter;
import com.google.appengine.tools.util.JarTool;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import com.google.apphosting.utils.config.AppYamlProcessor;
import com.google.apphosting.utils.config.BackendsXml;
import com.google.apphosting.utils.config.BackendsXmlReader;
import com.google.apphosting.utils.config.BackendsYamlReader;
import com.google.apphosting.utils.config.CronXml;
import com.google.apphosting.utils.config.CronXmlReader;
import com.google.apphosting.utils.config.CronYamlReader;
import com.google.apphosting.utils.config.DispatchXml;
import com.google.apphosting.utils.config.DispatchXmlReader;
import com.google.apphosting.utils.config.DispatchYamlReader;
import com.google.apphosting.utils.config.DosXml;
import com.google.apphosting.utils.config.DosXmlReader;
import com.google.apphosting.utils.config.DosYamlReader;
import com.google.apphosting.utils.config.GenerationDirectory;
import com.google.apphosting.utils.config.IndexesXml;
import com.google.apphosting.utils.config.IndexesXmlReader;
import com.google.apphosting.utils.config.QueueXml;
import com.google.apphosting.utils.config.QueueXmlReader;
import com.google.apphosting.utils.config.QueueYamlReader;
import com.google.apphosting.utils.config.WebXml;
import com.google.apphosting.utils.config.WebXmlReader;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.activation.FileTypeMap;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.mortbay.io.Buffer;
import org.mortbay.jetty.MimeTypes;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Application
implements GenericApplication {
    private static final int MAX_COMPILED_JSP_JAR_SIZE = 0x500000;
    private static final String COMPILED_JSP_JAR_NAME_PREFIX = "_ah_compiled_jsps";
    private static final int MAX_CLASSES_JAR_SIZE = 0x500000;
    private static final String CLASSES_JAR_NAME_PREFIX = "_ah_webinf_classes";
    private static final String JAVA_7_RUNTIME_ID = "java7";
    private static final ImmutableSet<String> ALLOWED_RUNTIME_IDS = ImmutableSet.of("java7");
    private static final String BETA_SOURCE_REFERENCE_KEY = "source_reference";
    private static Pattern JSP_REGEX = Pattern.compile(".*\\.jspx?");
    private static File ln = Utility.findLink();
    private static File sdkDocsDir;
    private static Version sdkVersion;
    private static final String STAGEDIR_PREFIX = "appcfg";
    private static final Logger logger;
    private static final MimeTypes mimeTypes;
    private AppEngineWebXml appEngineWebXml;
    private WebXml webXml;
    private CronXml cronXml;
    private DispatchXml dispatchXml;
    private DosXml dosXml;
    private String pagespeedYaml;
    private QueueXml queueXml;
    private IndexesXml indexesXml;
    private BackendsXml backendsXml;
    private File baseDir;
    private File stageDir;
    private File externalResourceDir;
    private String apiVersion;
    private String appYaml;
    private RepoInfo.SourceContext sourceContext;
    private UpdateListener listener;
    private PrintWriter detailsWriter;
    private int updateProgress = 0;
    private int progressAmount = 0;
    private static final String JSPC_MAIN = "com.google.appengine.tools.development.LocalJspC";
    private static final Pattern SKIP_FILES;

    public static synchronized File getSdkDocsDir() {
        if (null == sdkDocsDir) {
            sdkDocsDir = new File(SdkInfo.getSdkRoot(), "docs");
        }
        return sdkDocsDir;
    }

    public static synchronized Version getSdkVersion() {
        if (null == sdkVersion) {
            sdkVersion = SdkInfo.getLocalVersion();
        }
        return sdkVersion;
    }

    protected Application() {
    }

    private static String buildNormalizedPath(File dir) {
        String normalizedPath = dir.getPath();
        if (File.separatorChar == '\\') {
            normalizedPath = normalizedPath.replace('\\', '/');
        }
        return normalizedPath;
    }

    private Application(String explodedPath, String appId, String module, String appVersion) {
        DosXmlReader dosReader;
        DispatchXmlReader dispatchXmlReader;
        QueueXmlReader queueReader;
        this.baseDir = new File(explodedPath);
        explodedPath = Application.buildNormalizedPath(this.baseDir);
        File webinf = new File(this.baseDir, "WEB-INF");
        if (!webinf.getName().equals("WEB-INF")) {
            throw new AppEngineConfigException("WEB-INF directory must be capitalized.");
        }
        String webinfPath = webinf.getPath();
        AppEngineWebXmlReader aewebReader = new AppEngineWebXmlReader(explodedPath);
        WebXmlReader webXmlReader = new WebXmlReader(explodedPath);
        AppYamlProcessor.convert(webinf, aewebReader.getFilename(), webXmlReader.getFilename());
        if (new File(aewebReader.getFilename()).exists()) {
            XmlUtils.validateXml(aewebReader.getFilename(), new File(Application.getSdkDocsDir(), "appengine-web.xsd"));
        }
        this.appEngineWebXml = aewebReader.readAppEngineWebXml();
        this.appEngineWebXml.setSourcePrefix(explodedPath);
        if (appId == null) {
            if (this.appEngineWebXml.getAppId() == null) {
                throw new AppEngineConfigException("No app id supplied and XML files have no <application> element");
            }
        } else {
            this.appEngineWebXml.setAppId(appId);
        }
        if (module != null) {
            this.appEngineWebXml.setModule(module);
        }
        if (appVersion != null) {
            this.appEngineWebXml.setMajorVersionId(appVersion);
        }
        this.sourceContext = new RepoInfo(this.baseDir).getSourceContext();
        if (this.sourceContext != null) {
            String sourceRef = this.sourceContext.getRevisionId();
            if (this.sourceContext.getRepositoryUrl() != null) {
                String string = this.sourceContext.getRepositoryUrl();
                String string2 = sourceRef;
                sourceRef = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("#").append(string2).toString();
            }
            this.appEngineWebXml.addBetaSetting(BETA_SOURCE_REFERENCE_KEY, sourceRef);
        }
        this.webXml = webXmlReader.readWebXml();
        this.webXml.validate();
        CronXmlReader cronReader = new CronXmlReader(explodedPath);
        if (new File(cronReader.getFilename()).exists()) {
            XmlUtils.validateXml(cronReader.getFilename(), new File(Application.getSdkDocsDir(), "cron.xsd"));
        }
        this.cronXml = cronReader.readCronXml();
        if (this.cronXml == null) {
            CronYamlReader cronYaml = new CronYamlReader(webinfPath);
            this.cronXml = cronYaml.parse();
        }
        if (new File((queueReader = new QueueXmlReader(explodedPath)).getFilename()).exists()) {
            XmlUtils.validateXml(queueReader.getFilename(), new File(Application.getSdkDocsDir(), "queue.xsd"));
        }
        this.queueXml = queueReader.readQueueXml();
        if (this.queueXml == null) {
            QueueYamlReader queueYaml = new QueueYamlReader(webinfPath);
            this.queueXml = queueYaml.parse();
        }
        if (new File((dispatchXmlReader = new DispatchXmlReader(explodedPath, DispatchXmlReader.DEFAULT_RELATIVE_FILENAME)).getFilename()).exists()) {
            XmlUtils.validateXml(dispatchXmlReader.getFilename(), new File(Application.getSdkDocsDir(), "dispatch.xsd"));
        }
        this.dispatchXml = dispatchXmlReader.readDispatchXml();
        if (this.dispatchXml == null) {
            DispatchYamlReader dispatchYamlReader = new DispatchYamlReader(webinfPath);
            this.dispatchXml = dispatchYamlReader.parse();
        }
        if (new File((dosReader = new DosXmlReader(explodedPath)).getFilename()).exists()) {
            XmlUtils.validateXml(dosReader.getFilename(), new File(Application.getSdkDocsDir(), "dos.xsd"));
        }
        this.dosXml = dosReader.readDosXml();
        if (this.dosXml == null) {
            DosYamlReader dosYaml = new DosYamlReader(webinfPath);
            this.dosXml = dosYaml.parse();
        }
        if (this.getAppEngineWebXml().getPagespeed() != null) {
            StringBuilder pagespeedYamlBuilder = new StringBuilder();
            AppYamlTranslator.appendPagespeed(this.getAppEngineWebXml().getPagespeed(), pagespeedYamlBuilder, 0);
            this.pagespeedYaml = pagespeedYamlBuilder.toString();
        }
        IndexesXmlReader indexReader = new IndexesXmlReader(explodedPath);
        File datastoreSchema = new File(Application.getSdkDocsDir(), "datastore-indexes.xsd");
        if (new File(indexReader.getFilename()).exists()) {
            XmlUtils.validateXml(indexReader.getFilename(), datastoreSchema);
        }
        this.indexesXml = indexReader.readIndexesXml();
        BackendsXmlReader backendsReader = new BackendsXmlReader(explodedPath);
        if (new File(backendsReader.getFilename()).exists()) {
            XmlUtils.validateXml(backendsReader.getFilename(), new File(Application.getSdkDocsDir(), "backends.xsd"));
        }
        this.backendsXml = backendsReader.readBackendsXml();
        if (this.backendsXml == null) {
            BackendsYamlReader backendsYaml = new BackendsYamlReader(webinfPath);
            this.backendsXml = backendsYaml.parse();
        }
    }

    public static Application readApplication(String path) throws IOException {
        return new Application(path, null, null, null);
    }

    public void setExternalResourceDir(String path) {
        if (path == null) {
            throw new NullPointerException("path is null");
        }
        if (this.stageDir != null) {
            throw new IllegalStateException("This method must be invoked prior to createStagingDirectory()");
        }
        File dir = new File(path);
        if (!dir.exists()) {
            String string = String.valueOf(path);
            throw new IllegalArgumentException(string.length() != 0 ? "path does not exist: ".concat(string) : new String("path does not exist: "));
        }
        if (!dir.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(path).concat(" is not a directory."));
        }
        this.externalResourceDir = dir;
    }

    public static Application readApplication(String path, String appId, String module, String appVersion) throws IOException {
        return new Application(path, appId, module, appVersion);
    }

    @Override
    public String getAppId() {
        return this.appEngineWebXml.getAppId();
    }

    @Override
    public String getVersion() {
        return this.appEngineWebXml.getMajorVersionId();
    }

    @Override
    public String getSourceLanguage() {
        return this.appEngineWebXml.getSourceLanguage();
    }

    @Override
    public String getModule() {
        return this.appEngineWebXml.getModule();
    }

    @Override
    public String getInstanceClass() {
        return this.appEngineWebXml.getInstanceClass();
    }

    @Override
    public boolean isPrecompilationEnabled() {
        return this.appEngineWebXml.getPrecompilationEnabled();
    }

    @Override
    public List<GenericApplication.ErrorHandler> getErrorHandlers() {
        ArrayList<GenericApplication.ErrorHandler> errorHandlers = new ArrayList<GenericApplication.ErrorHandler>();
        for (AppEngineWebXml.ErrorHandler errorHandler : this.appEngineWebXml.getErrorHandlers()) {
            class ErrorHandlerImpl
            implements GenericApplication.ErrorHandler {
                private final AppEngineWebXml.ErrorHandler errorHandler;

                public ErrorHandlerImpl(AppEngineWebXml.ErrorHandler errorHandler) {
                    this.errorHandler = errorHandler;
                }

                @Override
                public String getFile() {
                    String string = String.valueOf(this.errorHandler.getFile());
                    return string.length() != 0 ? "__static__/".concat(string) : new String("__static__/");
                }

                @Override
                public String getErrorCode() {
                    return this.errorHandler.getErrorCode();
                }

                @Override
                public String getMimeType() {
                    return Application.this.getMimeTypeIfStatic(this.getFile());
                }
            }
            errorHandlers.add(new ErrorHandlerImpl(errorHandler));
        }
        return errorHandlers;
    }

    @Override
    public String getMimeTypeIfStatic(String path) {
        if (!path.contains("__static__/")) {
            return null;
        }
        String mimeType = this.webXml.getMimeTypeForPath(path);
        if (mimeType != null) {
            return mimeType;
        }
        return Application.guessContentTypeFromName(path);
    }

    public static String guessContentTypeFromName(String fileName) {
        String defaultValue = "application/octet-stream";
        try {
            Buffer buffer = mimeTypes.getMimeByExtension(fileName);
            if (buffer != null) {
                return new String(buffer.asArray());
            }
            String lowerName = fileName.toLowerCase();
            if (lowerName.endsWith(".json")) {
                return "application/json";
            }
            FileTypeMap typeMap = FileTypeMap.getDefaultFileTypeMap();
            String ret = typeMap.getContentType(fileName);
            if (ret != null) {
                return ret;
            }
            ret = URLConnection.guessContentTypeFromName(fileName);
            if (ret != null) {
                return ret;
            }
            return defaultValue;
        }
        catch (Throwable t) {
            String string = String.valueOf(fileName);
            logger.log(Level.WARNING, string.length() != 0 ? "Error identify mimetype for ".concat(string) : new String("Error identify mimetype for "), t);
            return defaultValue;
        }
    }

    public AppEngineWebXml getAppEngineWebXml() {
        return this.appEngineWebXml;
    }

    public AppEngineWebXml getScrubbedAppEngineWebXml() {
        AppEngineWebXml scrubbedAppEngineWebXml = this.appEngineWebXml.clone();
        scrubbedAppEngineWebXml.setAppId(null);
        scrubbedAppEngineWebXml.setMajorVersionId(null);
        return scrubbedAppEngineWebXml;
    }

    @Override
    public CronXml getCronXml() {
        return this.cronXml;
    }

    @Override
    public QueueXml getQueueXml() {
        return this.queueXml;
    }

    @Override
    public DispatchXml getDispatchXml() {
        return this.dispatchXml;
    }

    @Override
    public DosXml getDosXml() {
        return this.dosXml;
    }

    @Override
    public String getPagespeedYaml() {
        return this.pagespeedYaml;
    }

    @Override
    public IndexesXml getIndexesXml() {
        return this.indexesXml;
    }

    public WebXml getWebXml() {
        return this.webXml;
    }

    @Override
    public BackendsXml getBackendsXml() {
        return this.backendsXml;
    }

    @Override
    public String getApiVersion() {
        if (this.apiVersion == null) {
            throw new IllegalStateException("Must call createStagingDirectory first.");
        }
        return this.apiVersion;
    }

    @Override
    public String getPath() {
        return this.baseDir.getAbsolutePath();
    }

    @Override
    public File getStagingDir() {
        return this.stageDir;
    }

    @Override
    public void resetProgress() {
        this.updateProgress = 0;
        this.progressAmount = 0;
    }

    @Override
    public File createStagingDirectory(AppAdminFactory.ApplicationProcessingOptions opts, ResourceLimits resourceLimits) throws IOException {
        if (this.stageDir != null) {
            return this.stageDir;
        }
        int i = 0;
        while (this.stageDir == null && i++ < 3) {
            try {
                this.stageDir = File.createTempFile(STAGEDIR_PREFIX, null);
            }
            catch (IOException ex) {
                continue;
            }
            this.stageDir.delete();
            if (this.stageDir.mkdir()) continue;
            this.stageDir = null;
        }
        if (i == 3) {
            throw new IOException("Couldn't create a temporary directory in 3 tries.");
        }
        String ex = String.valueOf(this.stageDir.getPath());
        this.statusUpdate(new StringBuilder(32 + String.valueOf(ex).length()).append("Created staging directory at: '").append(ex).append("'").toString(), 20);
        String runtime = this.getRuntime(opts);
        return this.populateStagingDirectory(opts, resourceLimits, false, runtime);
    }

    @Override
    public File createStagingDirectory(AppAdminFactory.ApplicationProcessingOptions opts, ResourceLimits resourceLimits, File stagingDir) throws IOException {
        if (!stagingDir.exists() && !stagingDir.mkdir()) {
            String string = String.valueOf(stagingDir.getPath());
            throw new IOException(string.length() != 0 ? "Could not create staging directory at ".concat(string) : new String("Could not create staging directory at "));
        }
        this.stageDir = stagingDir;
        ln = null;
        String runtime = this.getRuntime(opts);
        this.populateStagingDirectory(opts, resourceLimits, true, runtime);
        this.copyOrLinkDirectories(GenerationDirectory.getGenerationDirectory(this.stageDir), this.stageDir, runtime);
        return this.stageDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File populateStagingDirectory(AppAdminFactory.ApplicationProcessingOptions opts, ResourceLimits resourceLimits, boolean writeScrubbedAppYaml, String runtime) throws IOException {
        File staticDir = new File(this.stageDir, "__static__");
        staticDir.mkdir();
        this.copyOrLink(this.baseDir, this.stageDir, staticDir, false, opts, runtime);
        if (this.externalResourceDir != null) {
            String previousPrefix = this.appEngineWebXml.getSourcePrefix();
            String newPrefix = Application.buildNormalizedPath(this.externalResourceDir);
            try {
                this.appEngineWebXml.setSourcePrefix(newPrefix);
                this.copyOrLink(this.externalResourceDir, this.stageDir, staticDir, false, opts, runtime);
            }
            finally {
                this.appEngineWebXml.setSourcePrefix(previousPrefix);
            }
        }
        this.apiVersion = Application.findApiVersion(this.stageDir, true);
        if (opts.isCompileJspsSet()) {
            this.compileJsps(this.stageDir, opts, runtime);
        }
        if (opts.isQuickstart()) {
            try {
                this.createQuickstartWebXml(opts);
                this.webXml = new WebXmlReader(this.stageDir.getAbsolutePath(), "/WEB-INF/min-quickstart-web.xml").readWebXml();
            }
            catch (ParserConfigurationException | TransformerException | SAXException e) {
                throw new IOException(e);
            }
        }
        this.appYaml = this.generateAppYaml(this.stageDir, runtime, this.appEngineWebXml);
        if (GenerationDirectory.getGenerationDirectory(this.stageDir).mkdirs()) {
            this.writePreparedYamlFile("app", writeScrubbedAppYaml ? this.generateAppYaml(this.stageDir, runtime, this.getScrubbedAppEngineWebXml()) : this.appYaml);
            this.writePreparedYamlFile("backends", this.backendsXml == null ? null : this.backendsXml.toYaml());
            this.writePreparedYamlFile("index", this.indexesXml.size() == 0 ? null : this.indexesXml.toYaml());
            this.writePreparedYamlFile("cron", this.cronXml == null ? null : this.cronXml.toYaml());
            this.writePreparedYamlFile("queue", this.queueXml == null ? null : this.queueXml.toYaml());
            this.writePreparedYamlFile("dos", this.dosXml == null ? null : this.dosXml.toYaml());
        }
        int maxJarSize = (int)resourceLimits.maxFileSize();
        if (opts.isSplitJarsSet()) {
            Application.splitJars(new File(new File(this.stageDir, "WEB-INF"), "lib"), maxJarSize, opts.getJarSplittingExcludes());
        }
        return this.stageDir;
    }

    @Override
    public void exportRepoInfoFile() {
        File target = new File(this.stageDir, "WEB-INF/classes/source-context.json");
        if (target.exists()) {
            return;
        }
        if (this.sourceContext == null || this.sourceContext.getJson() == null) {
            return;
        }
        try {
            Files.write(this.sourceContext.getJson(), target, StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            logger.log(Level.FINE, "Failed to write git repository information file.", ex);
            return;
        }
        this.statusUpdate("Generated git repository information file.");
    }

    private void writePreparedYamlFile(String yamlName, String yamlString) throws IOException {
        File f = new File(GenerationDirectory.getGenerationDirectory(this.stageDir), String.valueOf(yamlName).concat(".yaml"));
        if (yamlString != null && f.createNewFile()) {
            FileWriter fw = new FileWriter(f);
            fw.write(yamlString);
            fw.close();
        }
    }

    private static String findApiVersion(File baseDir, boolean deleteApiJars) {
        ApiVersionFinder finder = new ApiVersionFinder();
        String foundApiVersion = null;
        File webInf = new File(baseDir, "WEB-INF");
        File libDir = new File(webInf, "lib");
        for (File file : new FileIterator(libDir)) {
            String string;
            if (!file.getPath().endsWith(".jar")) continue;
            try {
                String apiVersion = finder.findApiVersion(file);
                if (apiVersion == null) continue;
                if (foundApiVersion == null) {
                    foundApiVersion = apiVersion;
                } else if (!foundApiVersion.equals(apiVersion)) {
                    string = foundApiVersion;
                    logger.warning(new StringBuilder(46 + String.valueOf(string).length() + String.valueOf(apiVersion).length()).append("Warning: found duplicate API version: ").append(string).append(", using ").append(apiVersion).toString());
                }
                if (!deleteApiJars || file.delete()) continue;
                string = String.valueOf(file);
                logger.log(Level.SEVERE, new StringBuilder(26 + String.valueOf(string).length()).append("Could not delete API jar: ").append(string).toString());
            }
            catch (IOException ex) {
                string = String.valueOf(file);
                logger.log(Level.WARNING, new StringBuilder(34 + String.valueOf(string).length()).append("Could not identify API version in ").append(string).toString(), ex);
            }
        }
        if (foundApiVersion == null) {
            foundApiVersion = "none";
        }
        return foundApiVersion;
    }

    private String getRuntime(AppAdminFactory.ApplicationProcessingOptions opts) {
        boolean vm;
        boolean bl = vm = this.appEngineWebXml.getUseVm() || this.appEngineWebXml.getEnv().equals("2");
        if (vm && new File(this.baseDir, "Dockerfile").exists()) {
            return "custom";
        }
        String runtime = opts.getRuntime();
        if (runtime != null) {
            if (!opts.isAllowAnyRuntime() && !ALLOWED_RUNTIME_IDS.contains(runtime)) {
                throw new AppEngineConfigException(new StringBuilder(46 + String.valueOf(runtime).length()).append("Invalid runtime id: ").append(runtime).append(". Valid ").append("runtime id: java7.").toString());
            }
            return runtime;
        }
        return JAVA_7_RUNTIME_ID;
    }

    private void compileJsps(File stage, AppAdminFactory.ApplicationProcessingOptions opts, String runtime) throws IOException {
        this.statusUpdate("Scanning for jsp files.");
        if (Application.matchingFileExists(new File(stage.getPath()), JSP_REGEX)) {
            this.statusUpdate("Compiling jsp files.");
            File webInf = new File(stage, "WEB-INF");
            for (File file : SdkImplInfo.getUserJspLibFiles()) {
                this.copyOrLinkFile(file, new File(new File(webInf, "lib"), file.getName()), runtime);
            }
            for (File file : SdkImplInfo.getSharedJspLibFiles()) {
                this.copyOrLinkFile(file, new File(new File(webInf, "lib"), file.getName()), runtime);
            }
            File classes = new File(webInf, "classes");
            File generatedWebXml = new File(webInf, "generated_web.xml");
            File tempDir = Files.createTempDir();
            String classpath = this.getJspClasspath(classes, tempDir);
            String javaCmd = opts.getJavaExecutable().getPath();
            String[] args = new String[]{javaCmd, "-classpath", classpath, JSPC_MAIN, "-uriroot", stage.getPath(), "-p", "org.apache.jsp", "-l", "-v", "-webinc", generatedWebXml.getPath(), "-d", tempDir.getPath(), "-javaEncoding", opts.getCompileEncoding()};
            Process jspc = this.startProcess(args);
            int status = 1;
            try {
                status = jspc.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (status != 0) {
                String string = String.valueOf(this.formatCommand(Arrays.asList(args)));
                this.detailsWriter.println(string.length() != 0 ? "Error while executing: ".concat(string) : new String("Error while executing: "));
                throw new JspCompilationException("Failed to compile jsp files.", JspCompilationException.Source.JASPER);
            }
            this.compileJavaFiles(classpath, webInf, tempDir, opts, runtime);
            this.webXml = new WebXmlReader(stage.getPath()).readWebXml();
        }
    }

    private void compileJavaFiles(String classpath, File webInf, File jspClassDir, AppAdminFactory.ApplicationProcessingOptions opts, String runtime) throws IOException {
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        if (compiler == null) {
            throw new RuntimeException("Cannot get the System Java Compiler. Please use a JDK, not a JRE.");
        }
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        ArrayList<File> files = new ArrayList<File>();
        for (File f : new FileIterator(jspClassDir)) {
            if (!f.getPath().toLowerCase().endsWith(".java")) continue;
            files.add(f);
        }
        if (files.isEmpty()) {
            return;
        }
        ArrayList<String> optionList = new ArrayList<String>();
        optionList.addAll(Arrays.asList("-classpath", classpath.toString()));
        optionList.addAll(Arrays.asList("-d", jspClassDir.getPath()));
        optionList.addAll(Arrays.asList("-encoding", opts.getCompileEncoding()));
        if (runtime.equals(JAVA_7_RUNTIME_ID)) {
            optionList.addAll(Arrays.asList("-source", "7"));
            optionList.addAll(Arrays.asList("-target", "7"));
        }
        Iterable<? extends JavaFileObject> compilationUnits = fileManager.getJavaFileObjectsFromFiles(files);
        boolean success = compiler.getTask(null, fileManager, null, optionList, null, compilationUnits).call();
        fileManager.close();
        if (!success) {
            throw new JspCompilationException("Failed to compile the generated JSP java files.", JspCompilationException.Source.JSPC);
        }
        if (opts.isJarJSPsSet()) {
            this.zipJasperGeneratedFiles(webInf, jspClassDir);
        } else {
            this.copyOrLinkDirectories(jspClassDir, new File(webInf, "classes"), runtime);
        }
        if (opts.isDeleteJSPs()) {
            for (File f : new FileIterator(webInf.getParentFile())) {
                if (!f.getPath().toLowerCase().endsWith(".jsp")) continue;
                f.delete();
            }
        }
        if (opts.isJarClassesSet()) {
            this.zipWebInfClassesFiles(webInf);
        }
    }

    private void zipJasperGeneratedFiles(File webInfDir, File jspClassDir) throws IOException {
        ImmutableSet<String> fileTypesToExclude = ImmutableSet.of(".java");
        File libDir = new File(webInfDir, "lib");
        JarTool jarTool = new JarTool(COMPILED_JSP_JAR_NAME_PREFIX, jspClassDir, libDir, 0x500000, fileTypesToExclude);
        jarTool.run();
        Application.recursiveDelete(jspClassDir);
    }

    private void zipWebInfClassesFiles(File webInfDir) throws IOException {
        File libDir = new File(webInfDir, "lib");
        File classesDir = new File(webInfDir, "classes");
        JarTool jarTool = new JarTool(CLASSES_JAR_NAME_PREFIX, classesDir, libDir, 0x500000, null);
        jarTool.run();
        Application.recursiveDelete(classesDir);
        classesDir.mkdir();
    }

    private String getJspClasspath(File classDir, File genDir) {
        StringBuilder classpath = new StringBuilder();
        for (URL uRL : SdkImplInfo.getImplLibs()) {
            classpath.append(uRL.getPath());
            classpath.append(File.pathSeparatorChar);
        }
        for (File file : SdkInfo.getSharedLibFiles()) {
            classpath.append(file.getPath());
            classpath.append(File.pathSeparatorChar);
        }
        classpath.append(classDir.getPath());
        classpath.append(File.pathSeparatorChar);
        classpath.append(genDir.getPath());
        classpath.append(File.pathSeparatorChar);
        for (File file : new FileIterator(new File(classDir.getParentFile(), "lib"))) {
            String filename = file.getPath().toLowerCase();
            if (!filename.endsWith(".jar") && !filename.endsWith(".zip")) continue;
            classpath.append(file.getPath());
            classpath.append(File.pathSeparatorChar);
        }
        return classpath.toString();
    }

    private Process startProcess(String ... args) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(args);
        Process proc = builder.redirectErrorStream(true).start();
        logger.fine(this.formatCommand(builder.command()));
        new Thread(new OutputPump(proc.getInputStream(), this.detailsWriter)).start();
        return proc;
    }

    private String formatCommand(Iterable<String> args) {
        StringBuilder command = new StringBuilder();
        for (String chunk : args) {
            command.append(chunk);
            command.append(" ");
        }
        return command.toString();
    }

    private static boolean matchingFileExists(File dir, Pattern regex) {
        for (File file : dir.listFiles()) {
            if (!(file.isDirectory() ? Application.matchingFileExists(file, regex) : regex.matcher(file.getName()).matches())) continue;
            return true;
        }
        return false;
    }

    private static void splitJars(File dir, int max, Set<String> excludes) throws IOException {
        String[] children = dir.list();
        if (children == null) {
            return;
        }
        for (String name : children) {
            File subfile = new File(dir, name);
            if (subfile.isDirectory()) {
                Application.splitJars(subfile, max, excludes);
                continue;
            }
            if (!name.endsWith(".jar") || subfile.length() <= (long)max) continue;
            new JarSplitter(subfile, dir, max, false, 4, excludes).run();
            subfile.delete();
        }
    }

    private void copyOrLink(File sourceDir, File resDir, File staticDir, boolean forceResource, AppAdminFactory.ApplicationProcessingOptions opts, String runtime) throws FileNotFoundException, IOException {
        for (String name : sourceDir.list()) {
            File file = new File(sourceDir, name);
            String path = file.getPath();
            if (File.separatorChar == '\\') {
                path = path.replace('\\', '/');
            }
            if (file.getName().startsWith(".") || file.equals(GenerationDirectory.getGenerationDirectory(this.baseDir))) continue;
            if (file.isDirectory()) {
                if (file.getName().equals("WEB-INF")) {
                    this.copyOrLink(file, new File(resDir, name), new File(staticDir, name), true, opts, runtime);
                    continue;
                }
                this.copyOrLink(file, new File(resDir, name), new File(staticDir, name), forceResource, opts, runtime);
                continue;
            }
            if (SKIP_FILES.matcher(path).matches()) continue;
            if (forceResource || this.appEngineWebXml.includesResource(path) || opts.isCompileJspsSet() && name.toLowerCase().endsWith(".jsp")) {
                this.copyOrLinkFile(file, new File(resDir, name), runtime);
            }
            if (forceResource || !this.appEngineWebXml.includesStatic(path)) continue;
            this.copyOrLinkFile(file, new File(staticDir, name), runtime);
        }
    }

    private void copyOrLinkFile(File source, File dest, String runtime) throws FileNotFoundException, IOException {
        if (runtime.equals(JAVA_7_RUNTIME_ID)) {
            this.checkJavaVersion(source, 7);
        }
        dest.getParentFile().mkdirs();
        if (ln != null && !source.getName().endsWith("web.xml")) {
            try {
                dest.delete();
            }
            catch (Exception e) {
                String string = String.valueOf(dest.getPath());
                System.err.println(string.length() != 0 ? "Warning: We tried to delete ".concat(string) : new String("Warning: We tried to delete "));
                String string2 = String.valueOf(source.getPath());
                System.err.println(string2.length() != 0 ? "in order to create a symlink from ".concat(string2) : new String("in order to create a symlink from "));
                String string3 = String.valueOf(e.getMessage());
                System.err.println(string3.length() != 0 ? "but the delete failed with message: ".concat(string3) : new String("but the delete failed with message: "));
            }
            Process link = this.startProcess(ln.getAbsolutePath(), "-s", source.getAbsolutePath(), dest.getAbsolutePath());
            try {
                int stat = link.waitFor();
                if (stat == 0) {
                    return;
                }
                String string = String.valueOf(ln.getAbsolutePath());
                System.err.println(new StringBuilder(48 + String.valueOf(string).length()).append(string).append(" returned status ").append(stat).append(", copying instead...").toString());
            }
            catch (InterruptedException ex) {
                System.err.println(String.valueOf(ln.getAbsolutePath()).concat(" was interrupted, copying instead..."));
            }
            if (dest.delete()) {
                String string = String.valueOf(dest.getAbsolutePath());
                System.err.println(string.length() != 0 ? "ln failed but symlink was created, removed: ".concat(string) : new String("ln failed but symlink was created, removed: "));
            }
        }
        try (FileInputStream inStream = new FileInputStream(source);
             FileOutputStream outStream = new FileOutputStream(dest);){
            byte[] buffer = new byte[1024];
            int readlen = inStream.read(buffer);
            while (readlen > 0) {
                outStream.write(buffer, 0, readlen);
                readlen = inStream.read(buffer);
            }
        }
    }

    private void copyOrLinkDirectories(File sourceDir, File destination, String runtime) throws IOException {
        for (String name : sourceDir.list()) {
            File file = new File(sourceDir, name);
            if (file.isDirectory()) {
                this.copyOrLinkDirectories(file, new File(destination, name), runtime);
                continue;
            }
            this.copyOrLinkFile(file, new File(destination, name), runtime);
        }
    }

    private void checkJavaVersion(File file, int maxVersion) {
        String name = file.getName();
        try {
            if (name.endsWith(".class")) {
                this.checkJavaClassVersion(file, maxVersion);
            } else if (name.endsWith(".jar")) {
                this.checkJavaJarVersion(file, maxVersion);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void checkJavaClassVersion(File classFile, int maxVersion) throws IOException {
        try (FileInputStream inputStream = new FileInputStream(classFile);){
            this.checkJavaVersion(inputStream, maxVersion, classFile.getPath());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkJavaJarVersion(File jarFile, int maxVersion) throws IOException {
        try (JarInputStream jarInputStream = new JarInputStream(new FileInputStream(jarFile));){
            while (true) {
                JarEntry jarEntry;
                if ((jarEntry = jarInputStream.getNextJarEntry()) == null) {
                    return;
                }
                if (jarEntry.getName().endsWith(".class")) {
                    String string = String.valueOf(jarEntry.getName());
                    String string2 = String.valueOf(jarFile);
                    this.checkJavaVersion(jarInputStream, maxVersion, new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" in ").append(string2).toString());
                    return;
                }
                continue;
                break;
            }
        }
    }

    private void checkJavaVersion(InputStream inputStream, int maxVersion, String what) throws IOException {
        DataInputStream in = new DataInputStream(inputStream);
        if (in.readInt() == -889275714) {
            in.readShort();
            short majorVersion = in.readShort();
            int actualVersion = majorVersion - 44;
            if (actualVersion > maxVersion) {
                throw new IllegalArgumentException(String.format("Class file is Java %d but max supported is Java %d: %s", actualVersion, maxVersion, what));
            }
        }
    }

    @Override
    public void cleanStagingDirectory() {
        if (this.stageDir != null) {
            Application.recursiveDelete(this.stageDir);
        }
    }

    public static void recursiveDelete(File dead) {
        String[] files = dead.list();
        if (files != null) {
            for (String name : files) {
                Application.recursiveDelete(new File(dead, name));
            }
        }
        dead.delete();
    }

    @Override
    public void setListener(UpdateListener l) {
        this.listener = l;
    }

    @Override
    public void setDetailsWriter(PrintWriter detailsWriter) {
        this.detailsWriter = detailsWriter;
    }

    @Override
    public void statusUpdate(String message, int amount) {
        this.updateProgress += this.progressAmount;
        if (this.updateProgress > 99) {
            this.updateProgress = 99;
        }
        this.progressAmount = amount;
        if (this.listener != null) {
            this.listener.onProgress(new UpdateProgressEvent(Thread.currentThread(), message, this.updateProgress));
        }
    }

    @Override
    public void statusUpdate(String message) {
        int amount = this.progressAmount / 4;
        this.updateProgress += amount;
        if (this.updateProgress > 99) {
            this.updateProgress = 99;
        }
        this.progressAmount -= amount;
        if (this.listener != null) {
            this.listener.onProgress(new UpdateProgressEvent(Thread.currentThread(), message, this.updateProgress));
        }
    }

    private String generateAppYaml(File stageDir, String runtime, AppEngineWebXml aeWebXml) {
        HashSet<String> staticFiles = new HashSet<String>();
        for (File f : new FileIterator(new File(stageDir, "__static__"))) {
            staticFiles.add(Utility.calculatePath(f, stageDir));
        }
        AppYamlTranslator translator = new AppYamlTranslator(aeWebXml, this.getWebXml(), this.getBackendsXml(), this.getApiVersion(), staticFiles, null, runtime, Application.getSdkVersion());
        String yaml = translator.getYaml();
        String string = String.valueOf(yaml);
        logger.fine(string.length() != 0 ? "Generated app.yaml file:\n".concat(string) : new String("Generated app.yaml file:\n"));
        return yaml;
    }

    @Override
    public String getAppYaml() {
        if (this.appYaml == null) {
            throw new IllegalStateException("Must call createStagingDirectory first.");
        }
        return this.appYaml;
    }

    private void createQuickstartWebXml(AppAdminFactory.ApplicationProcessingOptions opts) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        int status;
        String javaCmd = opts.getJavaExecutable().getPath();
        String quickstartJar = new File(SdkInfo.getSdkRoot(), "lib/java-managed-vm/appengine-java-vmruntime/quickstartgenerator.jar").getAbsolutePath();
        String[] args = new String[]{javaCmd, "-jar", quickstartJar, this.stageDir.getAbsolutePath()};
        Process quickstartProcess = this.startProcess(args);
        try {
            status = quickstartProcess.waitFor();
        }
        catch (InterruptedException ex) {
            status = 1;
        }
        if (status != 0) {
            String string = String.valueOf(this.formatCommand(Arrays.asList(args)));
            this.detailsWriter.println(string.length() != 0 ? "Error while executing: ".concat(string) : new String("Error while executing: "));
            throw new RuntimeException("Failed to generate quickstart-web.xml.");
        }
        String string = String.valueOf(SdkInfo.getSdkRoot());
        File webDefaultXml = new File(new StringBuilder(38 + String.valueOf(string).length()).append(string).append("/lib/jetty-base-sdk/etc/webdefault.xml").toString());
        File quickstartXml = new File(this.stageDir, "/WEB-INF/quickstart-web.xml");
        File minimizedQuickstartXml = new File(this.stageDir, "/WEB-INF/min-quickstart-web.xml");
        Document quickstartDoc = Application.getFilteredQuickstartDoc(quickstartXml, webDefaultXml);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("indent", "yes");
        StreamResult result = new StreamResult(new FileWriter(minimizedQuickstartXml));
        DOMSource source = new DOMSource(quickstartDoc);
        transformer.transform(source, result);
    }

    static Document getFilteredQuickstartDoc(File quickstartXml, File webDefaultXml) throws ParserConfigurationException, IOException, SAXException {
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder webDefaultDocBuilder = docBuilderFactory.newDocumentBuilder();
        Document webDefaultDoc = webDefaultDocBuilder.parse(webDefaultXml);
        DocumentBuilder quickstartDocBuilder = docBuilderFactory.newDocumentBuilder();
        Document quickstartDoc = quickstartDocBuilder.parse(quickstartXml);
        ImmutableSet<String> tagsToExamine = ImmutableSet.of("filter-mapping", "servlet-mapping");
        String urlPatternTag = "url-pattern";
        HashSet<String> defaultRoots = Sets.newHashSet();
        ArrayList<Node> nodesToRemove = Lists.newArrayList();
        webDefaultDoc.getDocumentElement().normalize();
        NodeList webDefaultChildren = webDefaultDoc.getDocumentElement().getElementsByTagName("url-pattern");
        for (int i = 0; i < webDefaultChildren.getLength(); ++i) {
            String url;
            Node child = webDefaultChildren.item(i);
            if (!tagsToExamine.contains(child.getParentNode().getNodeName()) || !(url = child.getTextContent().trim()).startsWith("/")) continue;
            defaultRoots.add(url);
        }
        quickstartDoc.getDocumentElement().normalize();
        NodeList quickstartChildren = quickstartDoc.getDocumentElement().getElementsByTagName("url-pattern");
        for (int i = 0; i < quickstartChildren.getLength(); ++i) {
            String url;
            Node child = quickstartChildren.item(i);
            if (!tagsToExamine.contains(child.getParentNode().getNodeName()) || !defaultRoots.contains(url = child.getTextContent().trim())) continue;
            nodesToRemove.add(child.getParentNode());
        }
        for (Node node : nodesToRemove) {
            quickstartDoc.getDocumentElement().removeChild(node);
        }
        return quickstartDoc;
    }

    static {
        logger = Logger.getLogger(Application.class.getName());
        mimeTypes = new MimeTypes();
        SKIP_FILES = Pattern.compile("^(.*/)?((#.*#)|(.*~)|(.*/RCS/.*)|)$");
    }
}

