/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.Credential;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.CredentialStore;
import com.google.appengine.repackaged.com.google.api.client.auth.oauth2.TokenResponseException;
import com.google.appengine.repackaged.com.google.api.client.extensions.java6.auth.oauth2.FileCredentialStore;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleAuthorizationCodeFlow;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleClientSecrets;
import com.google.appengine.repackaged.com.google.api.client.googleapis.auth.oauth2.GoogleTokenResponse;
import com.google.appengine.repackaged.com.google.api.client.http.javanet.NetHttpTransport;
import com.google.appengine.repackaged.com.google.api.client.json.JsonFactory;
import com.google.appengine.repackaged.com.google.api.client.json.jackson.JacksonFactory;
import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.tools.admin.PromptReceiver;
import com.google.appengine.tools.admin.VerificationCodeReceiver;
import com.google.appengine.tools.admin.VerificationCodeReceiverRedirectUriException;
import com.google.appengine.tools.admin.VerificationCodeReceiverStopException;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Arrays;
import java.util.List;

public class OAuth2Native {
    private static final String BROWSER = "google-chrome";
    protected static final String OAUTH2_CLIENT_ID = "550516889912.apps.googleusercontent.com";
    protected static final String OAUTH2_CLIENT_SECRET = "ykPq-0UYfKNprLRjVx1hBBar";
    protected static final String[] OAUTH2_SCOPE = new String[]{"https://www.googleapis.com/auth/appengine.admin", "https://www.googleapis.com/auth/cloud-platform"};
    protected static final long MIN_EXPIRES_SECONDS = 300L;
    protected static final String TOKEN_STORE_BASE = ".appcfg_oauth2_tokens_java";
    private static final GoogleClientSecrets DEFAULT_CLIENT_SECRETS = OAuth2Native.createClientSecrets("550516889912.apps.googleusercontent.com", "ykPq-0UYfKNprLRjVx1hBBar");
    private GoogleClientSecrets clientSecrets;
    private String refreshTokenOverride;
    private GoogleAuthorizationCodeFlow flow;
    private final VerificationCodeReceiver receiver;
    private final String userId;

    private static GoogleClientSecrets createClientSecrets(String clientIdOverride, String clientSecretOverride) {
        return new GoogleClientSecrets().setInstalled(new GoogleClientSecrets.Details().setClientId(clientIdOverride).setClientSecret(clientSecretOverride));
    }

    public OAuth2Native(boolean usePersistedCredentials) {
        this(usePersistedCredentials, null, null, null);
    }

    public OAuth2Native(boolean usePersistedCredentials, String clientIdOverride, String clientSecretOverride, String refreshTokenOverride) {
        this(new PromptReceiver(), System.getProperty("user.name"), null);
        Preconditions.checkArgument(!(clientIdOverride == null ^ clientSecretOverride == null), "If either is given, both a client id and a client secret must be provided");
        if (clientIdOverride != null) {
            this.clientSecrets = OAuth2Native.createClientSecrets(clientIdOverride, clientSecretOverride);
        }
        Preconditions.checkArgument(refreshTokenOverride == null || !usePersistedCredentials, "A credential store cannot be used when overriding the refresh token");
        this.refreshTokenOverride = refreshTokenOverride;
        try {
            this.flow = this.getAuthorizationCodeFlow(usePersistedCredentials);
        }
        catch (IOException e) {
            String string = String.valueOf(e);
            System.err.println(new StringBuilder(39 + String.valueOf(string).length()).append("Error creating the Authorization Flow: ").append(string).toString());
        }
        catch (IllegalArgumentException e) {
            if (OAuth2Native.exceptionMentionsJson(e)) {
                System.err.format("The credentials file is malformed. Please delete the file '%s'.%n", this.getTokenStoreFile());
            }
            throw e;
        }
    }

    public OAuth2Native(VerificationCodeReceiver receiver, String userId, GoogleAuthorizationCodeFlow flow) {
        this.receiver = receiver;
        this.userId = userId;
        this.flow = flow;
        this.clientSecrets = DEFAULT_CLIENT_SECRETS;
        this.refreshTokenOverride = null;
    }

    public GoogleClientSecrets getClientSecrets() {
        return this.clientSecrets;
    }

    protected File getTokenStoreFile() {
        String userDir = System.getProperty("user.home");
        return new File(userDir, TOKEN_STORE_BASE);
    }

    protected CredentialStore getCredentialStore(JsonFactory jsonFactory) throws IOException {
        return new FileCredentialStore(this.getTokenStoreFile(), jsonFactory);
    }

    protected GoogleAuthorizationCodeFlow getAuthorizationCodeFlow(boolean usePersistedCredentials) throws IOException {
        NetHttpTransport httpTransport = new NetHttpTransport();
        JacksonFactory jsonFactory = new JacksonFactory();
        List<String> scopes = Arrays.asList(OAUTH2_SCOPE);
        GoogleClientSecrets clientSecrets = this.getClientSecrets();
        GoogleAuthorizationCodeFlow flow = usePersistedCredentials ? new GoogleAuthorizationCodeFlow.Builder(httpTransport, jsonFactory, clientSecrets, scopes).setAccessType("offline").setApprovalPrompt("force").setCredentialStore(this.getCredentialStore(jsonFactory)).build() : new GoogleAuthorizationCodeFlow.Builder(httpTransport, jsonFactory, clientSecrets, scopes).setAccessType("online").setApprovalPrompt("auto").build();
        return flow;
    }

    private static boolean exceptionMentionsJson(Exception exception) {
        return exception.getMessage().toLowerCase().contains("json");
    }

    protected boolean refreshCredentialIfNeeded(Credential credential) throws IOException {
        if (credential != null) {
            Long expiresInSeconds = credential.getExpiresInSeconds();
            if (credential.getAccessToken() == null || expiresInSeconds == null || expiresInSeconds < 300L) {
                credential.refreshToken();
                if (this.flow.getCredentialStore() != null) {
                    this.flow.getCredentialStore().store(this.userId, credential);
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Credential authorize() {
        if (this.flow == null) {
            return null;
        }
        try {
            String redirectUri = this.receiver.getRedirectUri();
            Credential credential = this.getCredential();
            this.refreshCredentialIfNeeded(credential);
            if (credential != null && credential.getAccessToken() != null) {
                Credential credential2 = credential;
                return credential2;
            }
            this.browse(this.flow.newAuthorizationUrl().setRedirectUri(redirectUri).build());
            String code = this.receiver.waitForCode();
            GoogleTokenResponse response = this.flow.newTokenRequest(code).setRedirectUri(redirectUri).execute();
            Credential credential3 = this.flow.createAndStoreCredential(response, this.userId);
            return credential3;
        }
        catch (TokenResponseException e) {
            System.err.format("Either the access code is invalid or the OAuth token is revoked.Details: %s%n.", e.getDetails().getError());
        }
        catch (IOException e) {
            System.err.println(e);
        }
        catch (VerificationCodeReceiverRedirectUriException e) {
            System.err.println(e.getMessage());
        }
        finally {
            try {
                this.receiver.stop();
            }
            catch (VerificationCodeReceiverStopException e) {
                System.err.println(e.getMessage());
            }
        }
        return null;
    }

    Credential getCredential() throws IOException {
        if (this.refreshTokenOverride == null) {
            return this.flow.loadCredential(this.userId);
        }
        Credential credential = new Credential.Builder(this.flow.getMethod()).setTransport(this.flow.getTransport()).setJsonFactory(this.flow.getJsonFactory()).setTokenServerEncodedUrl(this.flow.getTokenServerEncodedUrl()).setClientAuthentication(this.flow.getClientAuthentication()).setRequestInitializer(this.flow.getRequestInitializer()).setClock(this.flow.getClock()).build();
        credential.setRefreshToken(this.refreshTokenOverride);
        return credential;
    }

    protected void browse(String url) {
        Desktop desktop;
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.BROWSE)) {
            try {
                desktop.browse(URI.create(url));
                return;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            String string = String.valueOf(url);
            Runtime.getRuntime().exec(string.length() != 0 ? "rundll32 url.dll,FileProtocolHandler ".concat(string) : new String("rundll32 url.dll,FileProtocolHandler "));
            return;
        }
        catch (IOException iOException) {
            if (BROWSER != null) {
                try {
                    Runtime.getRuntime().exec(new String[]{BROWSER, url});
                    return;
                }
                catch (IOException iOException2) {
                    // empty catch block
                }
            }
            System.out.format("Please open the following URL in your browser:%n  %s%n", url);
            return;
        }
    }
}

