/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.repackaged.com.google.common.base.Strings;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableCollection;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableMultimap;
import com.google.appengine.repackaged.com.google.common.collect.Multimap;
import com.google.appengine.tools.admin.AutoValue_RepoInfo_SourceContext;
import com.google.appengine.tools.admin.OutputPump;
import com.google.appengine.tools.admin.Utility;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

final class RepoInfo {
    private static final Logger logger = Logger.getLogger(RepoInfo.class.getName());
    private static final String REMOTE_URL_PATTERN = "remote\\.(.*)\\.url";
    private final GitClient git;

    RepoInfo(File baseDir) {
        this(new GitCommandClient(baseDir));
    }

    RepoInfo(GitClient git) {
        this.git = git;
    }

    @Nullable
    SourceContext getSourceContext() {
        Multimap<String, String> remoteUrls;
        String revision = null;
        try {
            revision = this.getGitHeadRevision();
            remoteUrls = this.getGitRemoteUrls();
            if (remoteUrls.isEmpty()) {
                logger.fine("Local git repo has no remote URLs");
                return SourceContext.create(revision);
            }
        }
        catch (GitException e) {
            logger.fine("not a git repository or problem calling git");
            return revision == null ? null : SourceContext.create(revision);
        }
        String repositoryURL = null;
        String sourceContextJson = null;
        for (Map.Entry<String, String> remoteUrl : remoteUrls.entries()) {
            String json = this.buildSourceContextJsonString(remoteUrl.getValue(), revision);
            if (json == null) continue;
            if (sourceContextJson != null && !json.equals(sourceContextJson)) {
                logger.fine("No unambiguous Google Cloud Repository in the remote URLs");
                return SourceContext.create(revision);
            }
            sourceContextJson = json;
            repositoryURL = remoteUrl.getValue();
        }
        if (sourceContextJson == null) {
            logger.fine("Could not find a Google Cloud Repository in the remote URLs");
            return SourceContext.create(revision);
        }
        return SourceContext.create(repositoryURL, revision, sourceContextJson);
    }

    private String getGitRemoteUrlConfigs() throws GitException {
        return this.git.callGit("config", "--get-regexp", REMOTE_URL_PATTERN);
    }

    private Multimap<String, String> getGitRemoteUrls() throws GitException {
        String[] configLines;
        String remoteUrlConfigOutput = this.getGitRemoteUrlConfigs();
        if (remoteUrlConfigOutput.isEmpty()) {
            return ImmutableMultimap.of();
        }
        Pattern remoteUrlRe = Pattern.compile(REMOTE_URL_PATTERN);
        ImmutableMultimap.Builder<String, String> result = ImmutableMultimap.builder();
        for (String configLine : configLines = remoteUrlConfigOutput.split("\\r?\\n")) {
            if (configLine.isEmpty()) continue;
            String[] parts = configLine.split(" +");
            if (parts.length != 2) {
                logger.fine(String.format("Skipping unexpected git config line, incorrect segments: %s", configLine));
                continue;
            }
            String remoteUrlConfigName = parts[0];
            String remoteUrl = parts[1];
            Matcher matcher = remoteUrlRe.matcher(remoteUrlConfigName);
            if (!matcher.matches()) {
                logger.fine(String.format("Skipping unexpected git config line, could not match remote: %s", configLine));
                continue;
            }
            String remoteUrlName = matcher.group(1);
            result.put(remoteUrlName, remoteUrl);
        }
        logger.fine(String.format("Remote git URLs: %s", result.toString()));
        return result.build();
    }

    private String getGitHeadRevision() throws GitException {
        String head = this.git.callGit("rev-parse", "HEAD").trim();
        if (head.isEmpty()) {
            throw new GitException("Empty head revision returned by git");
        }
        return head;
    }

    private String buildSourceContextJsonString(String remoteUrl, String revision) {
        String jsonRepoId;
        Pattern cloudRepoRe = Pattern.compile("^https://(?<hostname>[^/]*)/(?<idtype>p|id)/(?<part1>[^/?#]+)(/r/(?<part2>[^/?#]+))?([/#?].*)?");
        Matcher match = cloudRepoRe.matcher(remoteUrl);
        if (!match.matches()) {
            logger.fine(String.format("Skipping remote URL %s", remoteUrl));
            return null;
        }
        String idType = match.group("idtype");
        if ("id".equals(idType)) {
            String rawRepoId = match.group("part1");
            if (Strings.isNullOrEmpty(rawRepoId) || !Strings.isNullOrEmpty(match.group("part2"))) {
                logger.fine(String.format("Skipping ill-formed remote URL %s", remoteUrl));
                return null;
            }
            jsonRepoId = String.format("{\"uid\": \"%s\"}", Utility.jsonEscape(rawRepoId));
        } else if ("p".equals(idType)) {
            String projectId = match.group("part1");
            if (Strings.isNullOrEmpty(projectId)) {
                logger.fine(String.format("Skipping ill-formed remote URL %s", remoteUrl));
                return null;
            }
            String repoName = match.group("part2");
            if (Strings.isNullOrEmpty(repoName)) {
                repoName = "default";
            }
            jsonRepoId = String.format("{\"projectRepoId\": {\"projectId\": \"%s\", \"repoName\": \"%s\"}}", Utility.jsonEscape(projectId), Utility.jsonEscape(repoName));
        } else {
            logger.fine(String.format("Unexpected ID type %s, skipping remote URL %s", idType, remoteUrl));
            return null;
        }
        return String.format("{\"cloudRepo\": {\"repoId\": %s, \"revisionId\": \"%s\"}}", jsonRepoId, Utility.jsonEscape(revision));
    }

    private static final class GitCommandClient
    implements GitClient {
        private final File baseDir;

        GitCommandClient(File baseDir) {
            this.baseDir = baseDir;
        }

        @Override
        public String callGit(String ... args) throws GitException {
            ImmutableCollection command = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().add(Utility.isOsWindows() ? "git.exe" : "git")).add(args)).build();
            try {
                Process process = new ProcessBuilder((List<String>)((Object)command)).directory(this.baseDir).start();
                StringWriter stdOutWriter = new StringWriter();
                Thread stdOutPumpThread = new Thread(new OutputPump(process.getInputStream(), new PrintWriter(stdOutWriter)));
                stdOutPumpThread.start();
                StringWriter stdErrWriter = new StringWriter();
                Thread stdErrPumpThread = new Thread(new OutputPump(process.getErrorStream(), new PrintWriter(stdErrWriter)));
                stdErrPumpThread.start();
                int rc = process.waitFor();
                stdOutPumpThread.join();
                stdErrPumpThread.join();
                String stdout = stdOutWriter.toString();
                String stderr = stdErrWriter.toString();
                logger.fine(String.format("%s completed with code %d\n%s%s", command, rc, stdout, stderr));
                if (rc != 0) {
                    throw new GitException(String.format("git command failed (exit code = %d), command: %s\n%s%s", rc, command, stdout, stderr));
                }
                return stdout;
            }
            catch (InterruptedException ex) {
                throw new GitException(String.format("InterruptedException caught while executing git command: %s", command), ex);
            }
            catch (IOException ex) {
                throw new GitException(String.format("Failed to invoke git: %s", command), ex);
            }
        }
    }

    static interface GitClient {
        public String callGit(String ... var1) throws GitException;
    }

    static final class GitException
    extends Exception {
        GitException(String message) {
            super(message);
        }

        GitException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    static abstract class SourceContext {
        SourceContext() {
        }

        @Nullable
        abstract String getRepositoryUrl();

        abstract String getRevisionId();

        @Nullable
        abstract String getJson();

        static SourceContext create(String revisionId) {
            return SourceContext.create(null, revisionId, null);
        }

        static SourceContext create(@Nullable String repoUrl, String revisionId, @Nullable String json) {
            return new AutoValue_RepoInfo_SourceContext(repoUrl, revisionId, json);
        }
    }
}

