/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.DevAppServerFactory;
import com.google.appengine.tools.development.SharedMain;
import com.google.appengine.tools.info.SdkInfo;
import com.google.appengine.tools.info.UpdateCheck;
import com.google.appengine.tools.util.Action;
import com.google.appengine.tools.util.Option;
import com.google.appengine.tools.util.Parser;
import java.io.File;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class DevAppServerMain
extends SharedMain {
    public static final String EXTERNAL_RESOURCE_DIR_ARG = "external_resource_dir";
    public static final String GENERATE_WAR_ARG = "generate_war";
    public static final String GENERATED_WAR_DIR_ARG = "generated_war_dir";
    private static final String DEFAULT_RDBMS_PROPERTIES_FILE = ".local.rdbms.properties";
    private static final String RDBMS_PROPERTIES_FILE_SYSTEM_PROPERTY = "rdbms.properties.file";
    private static final String SYSTEM_PROPERTY_STATIC_MODULE_PORT_NUM_PREFIX = "com.google.appengine.devappserver_module.";
    private final Action ACTION = new StartAction();
    private String versionCheckServer = SdkInfo.getDefaultServer();
    private String address = "127.0.0.1";
    private int port = 8080;
    private boolean disableUpdateCheck;
    private String generatedDirectory = null;
    private String defaultGcsBucketName = null;

    @VisibleForTesting
    List<Option> getBuiltInOptions() {
        ArrayList<Option> options = new ArrayList<Option>();
        options.addAll(this.getSharedOptions());
        options.addAll(Arrays.asList(new Option("s", "server", false){

            @Override
            public void apply() {
                DevAppServerMain.this.versionCheckServer = this.getValue();
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --server=SERVER            The server to use to determine the latest", "  -s SERVER                   SDK version.");
            }
        }, new Option("a", "address", false){

            @Override
            public void apply() {
                DevAppServerMain.this.address = this.getValue();
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --address=ADDRESS          The address of the interface on the local machine", "  -a ADDRESS                  to bind to (or 0.0.0.0 for all interfaces).");
            }
        }, new Option("p", "port", false){

            @Override
            public void apply() {
                DevAppServerMain.this.port = Integer.valueOf(this.getValue());
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --port=PORT                The port number to bind to on the local machine.", "  -p PORT");
            }
        }, new Option(null, "disable_update_check", true){

            @Override
            public void apply() {
                DevAppServerMain.this.disableUpdateCheck = true;
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --disable_update_check     Disable the check for newer SDK versions.");
            }
        }, new Option(null, "generated_dir", false){

            @Override
            public void apply() {
                DevAppServerMain.this.generatedDirectory = this.getValue();
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --generated_dir=DIR        Set the directory where generated files are created.");
            }
        }, new Option(null, "default_gcs_bucket", false){

            @Override
            public void apply() {
                DevAppServerMain.this.defaultGcsBucketName = this.getValue();
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --default_gcs_bucket=NAME  Set the default Google Cloud Storage bucket name.");
            }
        }, new Option(null, "instance_port", false){

            @Override
            public void apply() {
                DevAppServerMain.processInstancePorts(this.getValues());
            }
        }, new Option(null, "disable_filesapi_warning", true){

            @Override
            public void apply() {
                System.setProperty("appengine.disableFilesApiWarning", "true");
            }
        }));
        return options;
    }

    private static void processInstancePorts(List<String> optionValues) {
        for (String optionValue : optionValues) {
            String[] keyAndValue = optionValue.split("=", 2);
            if (keyAndValue.length != 2) {
                DevAppServerMain.reportBadInstancePortValue(optionValue);
            }
            try {
                Integer.parseInt(keyAndValue[1]);
            }
            catch (NumberFormatException nfe) {
                DevAppServerMain.reportBadInstancePortValue(optionValue);
            }
            String string = String.valueOf(SYSTEM_PROPERTY_STATIC_MODULE_PORT_NUM_PREFIX);
            String string2 = String.valueOf(keyAndValue[0].trim());
            System.setProperty(new StringBuilder(5 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).append(".port").toString(), keyAndValue[1].trim());
        }
    }

    private static void reportBadInstancePortValue(String optionValue) {
        String string = String.valueOf(optionValue);
        throw new IllegalArgumentException(string.length() != 0 ? "Invalid instance_port value ".concat(string) : new String("Invalid instance_port value "));
    }

    private List<Option> buildOptions() {
        List<Option> options = this.getBuiltInOptions();
        return options;
    }

    public static void main(String[] args) throws Exception {
        SharedMain.sharedInit();
        new DevAppServerMain().run(args);
    }

    public void run(String[] args) throws Exception {
        Parser parser = new Parser();
        Parser.ParseResult result = parser.parseArgs(this.ACTION, this.buildOptions(), args);
        result.applyArgs();
    }

    @Override
    public void printHelp(PrintStream out) {
        out.println("Usage: <dev-appserver> [options] <app directory>");
        out.println("");
        out.println("Options:");
        for (Option option : this.buildOptions()) {
            for (String helpString : option.getHelpLines()) {
                out.println(helpString);
            }
        }
        out.println(" --jvm_flag=FLAG            Pass FLAG as a JVM argument. May be repeated to");
        out.println("                              supply multiple flags.");
    }

    class StartAction
    extends Action {
        StartAction() {
            super("start");
        }

        @Override
        public void apply() {
            List<String> args = this.getArgs();
            try {
                File externalResourceDir = DevAppServerMain.this.getExternalResourceDir();
                if (args.size() != 1) {
                    DevAppServerMain.this.printHelp(System.err);
                    System.exit(1);
                }
                File appDir = new File(args.get(0)).getCanonicalFile();
                DevAppServerMain.this.validateWarPath(appDir);
                UpdateCheck updateCheck = new UpdateCheck(DevAppServerMain.this.versionCheckServer, appDir, true);
                if (updateCheck.allowedToCheckForUpdates() && !DevAppServerMain.this.disableUpdateCheck) {
                    updateCheck.maybePrintNagScreen(System.err);
                }
                updateCheck.checkJavaVersion(System.err);
                DevAppServer server = new DevAppServerFactory().createDevAppServer(appDir, externalResourceDir, DevAppServerMain.this.address, DevAppServerMain.this.port, DevAppServerMain.this.getNoJavaAgent());
                Map<String, String> stringProperties = DevAppServerMain.this.getSystemProperties();
                this.setGeneratedDirectory(stringProperties);
                this.setRdbmsPropertiesFile(stringProperties, appDir, externalResourceDir);
                DevAppServerMain.this.postServerActions(stringProperties);
                this.setDefaultGcsBucketName(stringProperties);
                DevAppServerMain.this.addPropertyOptionToProperties(stringProperties);
                server.setServiceProperties(stringProperties);
                try {
                    server.start().await();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                System.out.println("Shutting down.");
                System.exit(0);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                System.exit(1);
            }
        }

        private void setGeneratedDirectory(Map<String, String> stringProperties) {
            if (DevAppServerMain.this.generatedDirectory != null) {
                File dir = new File(DevAppServerMain.this.generatedDirectory);
                String error = null;
                if (dir.exists()) {
                    if (!dir.isDirectory()) {
                        error = String.valueOf(DevAppServerMain.this.generatedDirectory).concat(" is not a directory.");
                    } else if (!dir.canWrite()) {
                        error = String.valueOf(DevAppServerMain.this.generatedDirectory).concat(" is not writable.");
                    }
                } else if (!dir.mkdirs()) {
                    String string = String.valueOf(DevAppServerMain.this.generatedDirectory);
                    String string2 = error = string.length() != 0 ? "Could not make ".concat(string) : new String("Could not make ");
                }
                if (error != null) {
                    System.err.println(error);
                    System.exit(1);
                }
                stringProperties.put("appengine.generated.dir", DevAppServerMain.this.generatedDirectory);
            }
        }

        private void setDefaultGcsBucketName(Map<String, String> stringProperties) {
            if (DevAppServerMain.this.defaultGcsBucketName != null) {
                stringProperties.put("appengine.default.gcs.bucket.name", DevAppServerMain.this.defaultGcsBucketName);
            }
        }

        private void setRdbmsPropertiesFile(Map<String, String> stringProperties, File appDir, File externalResourceDir) {
            if (stringProperties.get(DevAppServerMain.RDBMS_PROPERTIES_FILE_SYSTEM_PROPERTY) != null) {
                return;
            }
            File file = this.findRdbmsPropertiesFile(externalResourceDir);
            if (file == null) {
                file = this.findRdbmsPropertiesFile(appDir);
            }
            if (file != null) {
                String path = file.getPath();
                String string = String.valueOf(path);
                System.out.println(string.length() != 0 ? "Reading local rdbms properties from ".concat(string) : new String("Reading local rdbms properties from "));
                stringProperties.put(DevAppServerMain.RDBMS_PROPERTIES_FILE_SYSTEM_PROPERTY, path);
            }
        }

        private File findRdbmsPropertiesFile(File dir) {
            File candidate = new File(dir, DevAppServerMain.DEFAULT_RDBMS_PROPERTIES_FILE);
            if (candidate.isFile() && candidate.canRead()) {
                return candidate;
            }
            return null;
        }
    }
}

