/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.repackaged.com.google.common.annotations.VisibleForTesting;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.tools.util.Logging;
import com.google.appengine.tools.util.Option;
import java.awt.Toolkit;
import java.io.File;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;

public abstract class SharedMain {
    private static String originalTimeZone;
    private boolean disableRestrictedCheck = false;
    private boolean noJavaAgent = false;
    private String externalResourceDir = null;
    private List<String> propertyOptions = null;

    protected List<Option> getSharedOptions() {
        return Arrays.asList(new Option("h", "help", true){

            @Override
            public void apply() {
                SharedMain.this.printHelp(System.err);
                System.exit(0);
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --help, -h                 Show this help message and exit.");
            }
        }, new Option(null, "sdk_root", false){

            @Override
            public void apply() {
                System.setProperty("appengine.sdk.root", this.getValue());
            }

            @Override
            public List<String> getHelpLines() {
                return ImmutableList.of(" --sdk_root=DIR             Overrides where the SDK is located.");
            }
        }, new Option(null, "disable_restricted_check", true){

            @Override
            public void apply() {
                SharedMain.this.disableRestrictedCheck = true;
            }
        }, new Option(null, "external_resource_dir", false){

            @Override
            public void apply() {
                SharedMain.this.externalResourceDir = this.getValue();
            }
        }, new Option(null, "property", false){

            @Override
            public void apply() {
                SharedMain.this.propertyOptions = this.getValues();
            }
        }, new Option(null, "allow_remote_shutdown", true){

            @Override
            public void apply() {
                System.setProperty("appengine.allowRemoteShutdown", "true");
            }
        }, new Option(null, "no_java_agent", true){

            @Override
            public void apply() {
                SharedMain.this.noJavaAgent = true;
            }
        });
    }

    protected static void sharedInit() {
        SharedMain.recordTimeZone();
        Logging.initializeLogging();
        if (System.getProperty("os.name").equalsIgnoreCase("Mac OS X")) {
            Toolkit.getDefaultToolkit();
        }
    }

    private static void recordTimeZone() {
        originalTimeZone = System.getProperty("user.timezone");
    }

    protected abstract void printHelp(PrintStream var1);

    protected void postServerActions(Map<String, String> stringProperties) {
        this.setTimeZone(stringProperties);
        if (this.disableRestrictedCheck) {
            stringProperties.put("appengine.disableRestrictedCheck", "");
        }
    }

    protected void addPropertyOptionToProperties(Map<String, String> properties) {
        properties.putAll(SharedMain.parsePropertiesList(this.propertyOptions));
    }

    protected Map<String, String> getSystemProperties() {
        Properties properties = System.getProperties();
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            if (entry.getKey() instanceof String && entry.getValue() instanceof String) continue;
            String string = String.valueOf(entry.getKey());
            throw new IllegalArgumentException(new StringBuilder(20 + String.valueOf(string).length()).append("Non-string property ").append(string).toString());
        }
        Properties stringProperties = properties;
        return Collections.checkedMap(stringProperties, String.class, String.class);
    }

    private void setTimeZone(Map<String, String> serviceProperties) {
        String timeZone = serviceProperties.get("appengine.user.timezone");
        if (timeZone != null) {
            TimeZone.setDefault(TimeZone.getTimeZone(timeZone));
        } else {
            timeZone = originalTimeZone;
        }
        serviceProperties.put("appengine.user.timezone.impl", timeZone);
    }

    protected File getExternalResourceDir() {
        if (this.externalResourceDir == null) {
            return null;
        }
        this.externalResourceDir = this.externalResourceDir.trim();
        String error = null;
        File dir = null;
        if (this.externalResourceDir.isEmpty()) {
            error = "The empty string was specified for external_resource_dir";
        } else {
            dir = new File(this.externalResourceDir);
            if (dir.exists()) {
                if (!dir.isDirectory()) {
                    error = String.valueOf(this.externalResourceDir).concat(" is not a directory.");
                }
            } else {
                String string = String.valueOf(this.externalResourceDir);
                String string2 = error = string.length() != 0 ? "No such directory: ".concat(string) : new String("No such directory: ");
            }
        }
        if (error != null) {
            System.err.println(error);
            System.exit(1);
        }
        return dir;
    }

    public void validateWarPath(File war) {
        if (!war.exists()) {
            String string = String.valueOf(war);
            System.out.println(new StringBuilder(36 + String.valueOf(string).length()).append("Unable to find the webapp directory ").append(string).toString());
            this.printHelp(System.err);
            System.exit(1);
        } else if (!war.isDirectory()) {
            System.out.println("dev_appserver only accepts webapp directories, not war files.");
            this.printHelp(System.err);
            System.exit(1);
        }
    }

    @VisibleForTesting
    static Map<String, String> parsePropertiesList(List<String> properties) {
        HashMap<String, String> parsedProperties = new HashMap<String, String>();
        if (properties != null) {
            for (String property : properties) {
                String[] propertyKeyValue = property.split("=", 2);
                if (propertyKeyValue.length == 2) {
                    parsedProperties.put(propertyKeyValue[0], propertyKeyValue[1]);
                    continue;
                }
                if (propertyKeyValue[0].startsWith("no")) {
                    parsedProperties.put(propertyKeyValue[0].substring(2), "false");
                    continue;
                }
                parsedProperties.put(propertyKeyValue[0], "true");
            }
        }
        return parsedProperties;
    }

    protected boolean getNoJavaAgent() {
        return this.noJavaAgent;
    }
}

