/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.devappserver2;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.tools.development.AppContext;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.agent.AppEngineDevAgent;
import com.google.appengine.tools.development.devappserver2.DevAppServer2ClassLoader;
import com.google.appengine.tools.development.devappserver2.DevAppServer2Impl;
import com.google.apphosting.utils.security.SecurityManagerInstaller;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.PropertyPermission;
import java.util.regex.Pattern;

class DevAppServer2Factory {
    private static final Class<?>[] DEV_APPSERVER_CTOR_ARG_TYPES = new Class[]{File.class, File.class, File.class, File.class, String.class, Integer.TYPE, Boolean.TYPE, Map.class};

    DevAppServer2Factory() {
    }

    DevAppServer createDevAppServer(final File appDir, final File externalResourceDir, final File webXmlLocation, final File appEngineWebXmlLocation, final String address, final int port, final boolean useCustomStreamHandler, final boolean installSecurityManager, final Map<String, ?> containerConfigProperties, final boolean noJavaAgent) {
        return AccessController.doPrivileged(new PrivilegedAction<DevAppServer>(){

            @Override
            public DevAppServer run() {
                return DevAppServer2Factory.this.doCreateDevAppServer(appDir, externalResourceDir, webXmlLocation, appEngineWebXmlLocation, address, port, useCustomStreamHandler, installSecurityManager, containerConfigProperties, noJavaAgent);
            }
        });
    }

    private DevAppServer doCreateDevAppServer(File appDir, File externalResourceDir, File webXmlLocation, File appEngineWebXmlLocation, String address, int port, boolean useCustomStreamHandler, boolean installSecurityManager, Map<String, ?> containerConfigProperties, boolean noJavaAgent) {
        DevAppServer devAppServer;
        if (!noJavaAgent) {
            this.testAgentIsInstalled();
        }
        DevAppServer2ClassLoader loader = DevAppServer2ClassLoader.newClassLoader(this.getClass().getClassLoader());
        try {
            Class<?> devAppServerClass = Class.forName(DevAppServer2Impl.class.getName(), false, loader);
            if (installSecurityManager) {
                SecurityManagerInstaller.install(false, DevAppServer2Factory.getPrivilegedJars(devAppServerClass));
            }
            Constructor<?> cons = devAppServerClass.getDeclaredConstructor(DEV_APPSERVER_CTOR_ARG_TYPES);
            cons.setAccessible(true);
            devAppServer = (DevAppServer)cons.newInstance(appDir, externalResourceDir, webXmlLocation, appEngineWebXmlLocation, address, port, useCustomStreamHandler, containerConfigProperties);
        }
        catch (Exception e) {
            Throwable t = e;
            if (e instanceof InvocationTargetException) {
                t = e.getCause();
            }
            throw new RuntimeException("Unable to create a DevAppServer", t);
        }
        if (installSecurityManager) {
            System.setSecurityManager(new CustomSecurityManager(devAppServer));
        }
        return devAppServer;
    }

    private static URL[] getPrivilegedJars(Class<?> devAppServerClass) {
        HashSet<URL> urls = new HashSet<URL>();
        for (Class privilegedClass : Arrays.asList(devAppServerClass, DevAppServer2Factory.class, SecurityManagerInstaller.class)) {
            URL location;
            CodeSource source;
            ProtectionDomain domain = privilegedClass.getProtectionDomain();
            if (domain == null || (source = domain.getCodeSource()) == null || (location = source.getLocation()) == null) continue;
            urls.add(location);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private void testAgentIsInstalled() {
        try {
            AppEngineDevAgent.getAgent();
        }
        catch (Throwable t) {
            String msg = "Unable to locate the App Engine agent. Please use dev_appserver, KickStart,  or set the jvm flag: \"-javaagent:<sdk_root>/lib/agent/appengine-agent.jar\"";
            throw new RuntimeException(msg, t);
        }
    }

    static class CustomSecurityManager
    extends SecurityManager {
        private static final RuntimePermission PERMISSION_MODIFY_THREAD_GROUP = new RuntimePermission("modifyThreadGroup");
        private static final RuntimePermission PERMISSION_MODIFY_THREAD = new RuntimePermission("modifyThread");
        private static final String KEYCHAIN_JNILIB = "/libkeychain.jnilib";
        private static final Object PERMISSION_LOCK = new Object();
        private final DevAppServer devAppServer;
        private static final Map<String, String> METHOD_WHITELIST = ImmutableMap.of("sun.security.ssl.SSLSocketImpl$NotifyHandshakeThread", "<init>", "com.mysql.jdbc.AbandonedConnectionCleanupThread", "<init>", "com.mysql.jdbc.NonRegisteringDriver", "*", "com.google.appengine.tools.development.devappserver2.RemoteApiDelegate", "makeAsyncCall");

        CustomSecurityManager(DevAppServer devAppServer) {
            this.devAppServer = devAppServer;
        }

        boolean appHasPermissionNonThreadCallerFrame(StackTraceElement frame) {
            String method = METHOD_WHITELIST.get(frame.getClassName());
            return "*".equals(method) || frame.getMethodName().equals(method);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean appHasPermission(Permission perm) {
            Object object = PERMISSION_LOCK;
            synchronized (object) {
                AppContext context = this.devAppServer.getCurrentAppContext();
                if (context.getUserPermissions().implies(perm) || context.getApplicationPermissions().implies(perm)) {
                    return true;
                }
            }
            if (PERMISSION_MODIFY_THREAD_GROUP.equals(perm) || PERMISSION_MODIFY_THREAD.equals(perm)) {
                StackTraceElement frame;
                StackTraceAnalyzer stack = new StackTraceAnalyzer();
                if (PERMISSION_MODIFY_THREAD.equals(perm) && ("java.util.concurrent.ThreadPoolExecutor".equals((frame = stack.getCallerFrame()).getClassName()) || "java.lang.Thread".equals(frame.getClassName()) && "interrupt".equals(frame.getMethodName()) || "java.lang.Thread".equals(frame.getClassName()) && "setUncaughtExceptionHandler".equals(frame.getMethodName()))) {
                    return true;
                }
                if (this.appHasPermissionNonThreadCallerFrame(stack.getFirstRelevantCallerFrame())) {
                    return true;
                }
            }
            if (perm instanceof SocketPermission) {
                return true;
            }
            return "read".equals(perm.getActions()) && perm.getName().endsWith(KEYCHAIN_JNILIB);
        }

        @Override
        public void checkPermission(Permission perm) {
            if (perm instanceof PropertyPermission) {
                return;
            }
            if (this.isDevAppServerThread()) {
                if (this.appHasPermission(perm)) {
                    return;
                }
                super.checkPermission(perm);
            }
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
            if (this.isDevAppServerThread()) {
                if (this.appHasPermission(perm)) {
                    return;
                }
                super.checkPermission(perm, context);
            }
        }

        @Override
        public void checkAccess(ThreadGroup g) {
            if (g == null) {
                throw new NullPointerException("thread group can't be null");
            }
            this.checkPermission(PERMISSION_MODIFY_THREAD_GROUP);
        }

        @Override
        public void checkAccess(Thread t) {
            if (t == null) {
                throw new NullPointerException("thread can't be null");
            }
            this.checkPermission(PERMISSION_MODIFY_THREAD);
        }

        private boolean isDevAppServerThread() {
            String string = String.valueOf(Thread.currentThread().getName());
            return Boolean.getBoolean(string.length() != 0 ? "devappserver-thread-".concat(string) : new String("devappserver-thread-")) && this.devAppServer.getCurrentAppContext() != null;
        }

        private static class StackTraceAnalyzer {
            private final StackTraceElement[] frames = Thread.currentThread().getStackTrace();
            private static final Pattern IGNORE_CLASS_IN_STACK;

            private StackTraceAnalyzer() {
            }

            private boolean isThisOrOuterClass(StackTraceElement frame) {
                return CustomSecurityManager.class.getName().equals(frame.getClassName()) || this.getClass().getName().equals(frame.getClassName());
            }

            StackTraceElement getCallerFrame() {
                for (int i = 1; i < this.frames.length; ++i) {
                    if ("checkAccess".equals(this.frames[i].getMethodName()) || this.isThisOrOuterClass(this.frames[i])) continue;
                    return this.frames[i];
                }
                throw new IllegalStateException("Unable to determine calling frame.");
            }

            StackTraceElement getFirstRelevantCallerFrame() {
                for (int i = 1; i < this.frames.length; ++i) {
                    String frameClass = this.frames[i].getClassName();
                    if (IGNORE_CLASS_IN_STACK.matcher(frameClass).matches()) continue;
                    return this.frames[i];
                }
                throw new IllegalStateException("Unable to determine calling frame.");
            }

            static {
                String string = String.valueOf("java\\.lang\\.Thread(Group)?|java\\.util\\.concurrent\\..*|com\\.google\\.appengine\\.repackaged\\.org\\.apache\\.commons\\.httpclient\\..*|");
                String string2 = String.valueOf(Pattern.quote(CustomSecurityManager.class.getName()));
                String string3 = String.valueOf(Pattern.quote(StackTraceAnalyzer.class.getName()));
                IGNORE_CLASS_IN_STACK = Pattern.compile(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(string2).append("|").append(string3).toString());
            }
        }
    }
}

