/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.enhancer;

import com.google.appengine.tools.enhancer.Enhancer;
import com.google.appengine.tools.info.SdkImplInfo;
import com.google.appengine.tools.util.Logging;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class Enhance {
    static final String DATANUCLEUS_VERSION_ARG = "-enhancerVersion";

    public static void main(String[] args) {
        Logging.initializeLogging();
        new Enhance(args);
    }

    public Enhance(String[] args) {
        PrintWriter writer;
        File logFile;
        try {
            logFile = File.createTempFile("enhance", ".log");
            writer = new PrintWriter((Writer)new FileWriter(logFile), true);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to enable logging.", e);
        }
        try {
            Set<URL> targets = this.getEnhanceTargets();
            Enhancer enhancer = new Enhancer();
            enhancer.setTargets(targets);
            args = Enhance.processArgs(enhancer, args);
            enhancer.setArgs(args);
            enhancer.execute();
        }
        catch (Exception e) {
            String string = String.valueOf(e.getMessage());
            System.out.println(string.length() != 0 ? "Encountered a problem: ".concat(string) : new String("Encountered a problem: "));
            String string2 = String.valueOf(logFile.getAbsolutePath());
            System.out.println(new StringBuilder(47 + String.valueOf(string2).length()).append("Please see the logs [").append(string2).append("] for further information.").toString());
            e.printStackTrace(writer);
            System.exit(1);
        }
    }

    static String[] processArgs(Enhancer enhancer, String[] args) {
        ArrayList<String> processed = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-") || !args[i].equals(DATANUCLEUS_VERSION_ARG)) {
                processed.add(args[i]);
                continue;
            }
            if (++i == args.length) {
                throw new IllegalArgumentException(String.format("Missing value for option %s", DATANUCLEUS_VERSION_ARG));
            }
            enhancer.setDatanucleusVersion(args[i]);
        }
        return processed.toArray(new String[processed.size()]);
    }

    private Set<URL> getEnhanceTargets() {
        URLClassLoader myLoader = (URLClassLoader)this.getClass().getClassLoader();
        URL[] urls = myLoader.getURLs();
        HashSet<URL> enhanceTargets = new HashSet<URL>(Arrays.asList(urls));
        URL toolsJar = SdkImplInfo.getToolsApiJar();
        for (URL url : enhanceTargets) {
            if (!url.sameFile(toolsJar)) continue;
            enhanceTargets.remove(toolsJar);
            break;
        }
        return enhanceTargets;
    }
}

