/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import com.google.appengine.tools.info.Version;
import com.google.appengine.tools.util.ApiVersionFinder;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LocalVersionFactory {
    private static final Logger logger = Logger.getLogger(LocalVersionFactory.class.getName());
    private final Collection<File> apiJars;
    private final ApiVersionFinder versionFinder;

    public LocalVersionFactory(Collection<File> apiJars) {
        this.apiJars = apiJars;
        this.versionFinder = new ApiVersionFinder();
    }

    public Version getVersion() {
        Package toolsPackage = LocalVersionFactory.class.getPackage();
        if (toolsPackage == null) {
            return Version.UNKNOWN;
        }
        String release = toolsPackage.getSpecificationVersion();
        Date timestamp = this.convertToDate(toolsPackage.getImplementationVersion());
        HashSet<String> apiVersions = new HashSet<String>();
        for (File apiJar : this.apiJars) {
            try {
                String apiVersion = this.versionFinder.findApiVersion(apiJar);
                if (apiVersion == null) continue;
                apiVersions.add(apiVersion);
            }
            catch (IOException ex) {
                String string = String.valueOf(apiJar);
                logger.log(Level.FINE, new StringBuilder(32 + String.valueOf(string).length()).append("Could not find API version from ").append(string).toString(), ex);
            }
        }
        return new Version(release, timestamp, apiVersions);
    }

    private Date convertToDate(String timestamp) {
        if (timestamp == null) {
            return null;
        }
        return new Date(Long.valueOf(timestamp) * 1000L);
    }
}

