/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.info;

import com.google.appengine.tools.info.Version;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RemoteVersionFactory {
    private static final Pattern RELEASE_RE = Pattern.compile("^release: *[\"'](.*)[\"']$");
    private static final Pattern TIMESTAMP_RE = Pattern.compile("^timestamp: *(\\d+)$");
    private static final Pattern API_VERSIONS_RE = Pattern.compile("^api_versions: \\[[\"'](.*)[\"']\\]$");
    private static final Pattern API_VERSION_SPLIT_RE = Pattern.compile("[\"'], *[\"']");
    private static final Logger logger = Logger.getLogger(RemoteVersionFactory.class.getName());
    private final Version localVersion;
    private final String server;
    private final boolean secure;

    public RemoteVersionFactory(Version localVersion, String server, boolean secure) {
        if (server == null) {
            throw new NullPointerException("No server specified.");
        }
        this.localVersion = localVersion;
        this.server = server;
        this.secure = secure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Version getVersion() {
        Version version;
        URL checkUrl;
        try {
            checkUrl = this.buildCheckURL();
        }
        catch (IOException ex) {
            logger.log(Level.INFO, "Unable to build remote version URL:", ex);
            return Version.UNKNOWN;
        }
        InputStream stream = checkUrl.openStream();
        try {
            version = RemoteVersionFactory.parseVersionResult(stream);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException ex) {
                String string = String.valueOf(checkUrl);
                logger.log(Level.INFO, new StringBuilder(17 + String.valueOf(string).length()).append("Unable to access ").append(string).toString(), ex);
                return Version.UNKNOWN;
            }
        }
        stream.close();
        return version;
    }

    URL buildCheckURL() throws IOException {
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.secure ? "https://" : "http://");
        buffer.append(this.server);
        buffer.append("/api/updatecheck?runtime=java");
        if (this.localVersion.getRelease() != null) {
            buffer.append("&release=");
            buffer.append(this.localVersion.getRelease());
        }
        if (this.localVersion.getTimestamp() != null) {
            buffer.append("&timestamp=");
            buffer.append(this.localVersion.getTimestamp().getTime() / 1000L);
        }
        if (this.localVersion.getApiVersions() != null) {
            buffer.append("&api_versions=[");
            boolean first = true;
            for (String apiVersion : this.localVersion.getApiVersions()) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(new StringBuilder(2 + String.valueOf(apiVersion).length()).append("'").append(apiVersion).append("'").toString());
            }
            buffer.append("]");
        }
        return new URL(buffer.toString());
    }

    static Version parseVersionResult(InputStream stream) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
        String release = null;
        Date timestamp = null;
        HashSet apiVersions = null;
        while ((line = reader.readLine()) != null) {
            Matcher match = RELEASE_RE.matcher(line);
            if (match.matches()) {
                release = match.group(1);
            }
            if ((match = TIMESTAMP_RE.matcher(line)).matches()) {
                timestamp = new Date(Long.valueOf(match.group(1)) * 1000L);
            }
            if (!(match = API_VERSIONS_RE.matcher(line)).matches()) continue;
            apiVersions = new HashSet();
            Collections.addAll(apiVersions, API_VERSION_SPLIT_RE.split(match.group(1)));
        }
        return new Version(release, timestamp, apiVersions);
    }
}

