/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.util;

import com.google.appengine.tools.util.HttpHeaderParseException;
import com.google.appengine.tools.util.HttpHeaderParser;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

public class ClientCookie
implements Comparable<ClientCookie>,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ClientCookie.class.getName());
    private String name_ = null;
    private String value_ = null;
    private String comment_ = null;
    private String domain_ = null;
    private String effectiveDomain_ = null;
    private String path_ = null;
    private String effectivePath_ = null;
    private boolean secure_ = false;
    private long expires_ = Long.MAX_VALUE;
    private int version_ = 0;
    private int effectiveVersion_ = 0;
    private boolean httponly_ = false;
    private static final String[] SPECIAL_DOMAINS = new String[]{".com", ".edu", ".net", ".org", ".gov", ".mil", ".int"};

    public String getName() {
        return this.name_;
    }

    public String getValue() {
        return this.value_;
    }

    public String getComment() {
        return this.comment_;
    }

    public String getDomain() {
        return this.domain_;
    }

    public String getEffectiveDomain() {
        return this.effectiveDomain_;
    }

    public String getPath() {
        return this.path_;
    }

    public String getEffectivePath() {
        return this.effectivePath_;
    }

    public boolean isSecure() {
        return this.secure_;
    }

    public boolean isHttpOnly() {
        return this.httponly_;
    }

    public long getExpirationTime() {
        return this.expires_;
    }

    public int getVersion() {
        return this.version_;
    }

    public int getEffectiveVersion() {
        return this.effectiveVersion_;
    }

    public boolean match(URL url) {
        String requestHost = url.getHost().toLowerCase();
        String requestPath = url.getPath();
        if (this.effectiveDomain_.startsWith(".") ? !requestHost.endsWith(this.effectiveDomain_) && !requestHost.equals(this.effectiveDomain_.substring(1)) : !requestHost.equals(this.effectiveDomain_)) {
            return false;
        }
        return requestPath.startsWith(this.effectivePath_);
    }

    public StringBuffer encode() {
        if (this.effectiveVersion_ == 0) {
            StringBuffer result = new StringBuffer(this.name_);
            result.append('=');
            result.append(this.value_);
            return result;
        }
        StringBuffer result = HttpHeaderParser.makeAttributeValuePair(this.name_, this.value_);
        if (this.path_ != null) {
            result.append("; ");
            result.append(HttpHeaderParser.makeAttributeValuePair("$Path", this.path_));
        }
        if (this.domain_ != null) {
            result.append("; ");
            result.append(HttpHeaderParser.makeAttributeValuePair("$Domain", this.domain_));
        }
        return result;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ClientCookie)) {
            return false;
        }
        ClientCookie cookie = (ClientCookie)o;
        return cookie.name_.equals(this.name_) && cookie.effectiveDomain_.equals(this.effectiveDomain_) && cookie.effectivePath_.equals(this.effectivePath_);
    }

    @Override
    public int compareTo(ClientCookie cookie) {
        int result = cookie.effectivePath_.length() - this.effectivePath_.length();
        if (result != 0) {
            return result;
        }
        result = cookie.effectivePath_.compareTo(this.effectivePath_);
        if (result != 0) {
            return result;
        }
        result = cookie.effectiveDomain_.compareTo(this.effectiveDomain_);
        if (result != 0) {
            return result;
        }
        return cookie.name_.compareTo(this.name_);
    }

    private static int countOccurrences(String str, char ch) {
        int count = 0;
        int index = 0;
        while ((index = str.indexOf(ch, index)) >= 0) {
            ++count;
            ++index;
        }
        return count;
    }

    private ClientCookie() {
    }

    public static List<ClientCookie> parseSetCookie(String setCookieHeader, URL url) throws HttpHeaderParseException {
        try {
            return ClientCookie.parseSetCookie1(setCookieHeader, url);
        }
        catch (HttpHeaderParseException e) {
            return ClientCookie.parseSetCookie0(setCookieHeader, url);
        }
    }

    private static List<ClientCookie> parseSetCookie1(String setCookie1Header, URL url) throws HttpHeaderParseException {
        HttpHeaderParser parser = new HttpHeaderParser(setCookie1Header);
        ArrayList<ClientCookie> results = new ArrayList<ClientCookie>();
        parser.eatLWS();
        while (true) {
            ClientCookie cookie = new ClientCookie();
            cookie.effectiveVersion_ = 1;
            cookie.name_ = parser.eatToken();
            parser.eatLWS();
            parser.eatChar('=');
            parser.eatLWS();
            cookie.value_ = parser.eatTokenOrQuotedString();
            parser.eatLWS();
            while (parser.peek() == 59) {
                block35: {
                    parser.eatChar(';');
                    parser.eatLWS();
                    String name = parser.eatToken().toLowerCase();
                    parser.eatLWS();
                    if (name.equals("secure")) {
                        cookie.secure_ = true;
                    } else if (name.equals("httponly")) {
                        cookie.httponly_ = true;
                    } else {
                        parser.eatChar('=');
                        parser.eatLWS();
                        String value = parser.eatTokenOrQuotedString();
                        if (name.equals("comment")) {
                            cookie.comment_ = value;
                        } else if (name.equals("domain")) {
                            cookie.domain_ = value.toLowerCase();
                        } else if (name.equals("max-age")) {
                            int maxAge;
                            try {
                                maxAge = Integer.parseInt(value);
                                if (maxAge < 0) {
                                    throw new NumberFormatException(value);
                                }
                            }
                            catch (NumberFormatException e) {
                                String string = String.valueOf(setCookie1Header);
                                throw new HttpHeaderParseException(string.length() != 0 ? "invalid max-age: ".concat(string) : new String("invalid max-age: "));
                            }
                            cookie.expires_ = System.currentTimeMillis() + (long)(1000 * maxAge);
                        } else if (name.equals("path")) {
                            cookie.path_ = value;
                        } else {
                            if (name.equals("version")) {
                                try {
                                    cookie.version_ = Integer.parseInt(value);
                                    if (cookie.version_ <= 0) {
                                        throw new NumberFormatException(value);
                                    }
                                    break block35;
                                }
                                catch (NumberFormatException e) {
                                    String string = String.valueOf(setCookie1Header);
                                    throw new HttpHeaderParseException(string.length() != 0 ? "invalid version: ".concat(string) : new String("invalid version: "));
                                }
                            }
                            if (name.equals("expires")) {
                                throw new HttpHeaderParseException("this is a v0 cookie");
                            }
                            logger.info(new StringBuilder(35 + String.valueOf(name).length() + String.valueOf(value).length()).append("unrecognized v1 cookie attribute: ").append(name).append("=").append(value).toString());
                        }
                    }
                }
                parser.eatLWS();
            }
            boolean valid = true;
            String requestHost = url.getHost().toLowerCase();
            String requestPath = url.getPath();
            if (cookie.domain_ == null) {
                cookie.effectiveDomain_ = requestHost;
            } else if (!cookie.domain_.startsWith(".") || cookie.domain_.substring(1, cookie.domain_.length() - 1).indexOf(46) < 0) {
                String string = String.valueOf(setCookie1Header);
                logger.info(string.length() != 0 ? "rejecting v1 cookie [bad domain - no periods]: ".concat(string) : new String("rejecting v1 cookie [bad domain - no periods]: "));
                valid = false;
            } else if (!requestHost.endsWith(cookie.domain_)) {
                String string = String.valueOf(setCookie1Header);
                logger.info(string.length() != 0 ? "rejecting v1 cookie [bad domain - no match]: ".concat(string) : new String("rejecting v1 cookie [bad domain - no match]: "));
                valid = false;
            } else if (requestHost.substring(0, requestHost.length() - cookie.domain_.length()).indexOf(46) >= 0) {
                String string = String.valueOf(setCookie1Header);
                logger.info(string.length() != 0 ? "rejecting v1 cookie [bad domain - extra periods]: ".concat(string) : new String("rejecting v1 cookie [bad domain - extra periods]: "));
                valid = false;
            } else {
                cookie.effectiveDomain_ = cookie.domain_;
            }
            if (cookie.path_ == null) {
                int index = requestPath.lastIndexOf(47);
                cookie.effectivePath_ = index < 0 ? requestPath : requestPath.substring(0, index);
            } else if (!requestPath.startsWith(cookie.path_)) {
                String string = String.valueOf(setCookie1Header);
                logger.info(string.length() != 0 ? "rejecting v1 cookie [bad path]: ".concat(string) : new String("rejecting v1 cookie [bad path]: "));
                valid = false;
            } else {
                cookie.effectivePath_ = cookie.path_;
            }
            if (valid) {
                results.add(cookie);
            }
            if (parser.isEnd()) break;
            parser.eatChar(',');
        }
        return results;
    }

    private static List<ClientCookie> parseSetCookie0(String setCookie0Header, URL url) throws HttpHeaderParseException {
        HttpHeaderParser parser = new HttpHeaderParser(setCookie0Header);
        ArrayList<ClientCookie> results = new ArrayList<ClientCookie>();
        parser.eatLWS();
        ClientCookie cookie = new ClientCookie();
        cookie.effectiveVersion_ = 0;
        cookie.name_ = parser.eatV0CookieToken();
        parser.eatLWS();
        parser.eatChar('=');
        parser.eatLWS();
        cookie.value_ = parser.eatV0CookieValue();
        parser.eatLWS();
        while (!parser.isEnd()) {
            parser.eatChar(';');
            parser.eatLWS();
            String name = parser.eatV0CookieToken().toLowerCase();
            if (name.equals("secure")) {
                cookie.secure_ = true;
            } else if (name.equals("httponly")) {
                cookie.httponly_ = true;
            } else {
                parser.eatLWS();
                parser.eatChar('=');
                parser.eatLWS();
                if (name.equals("expires")) {
                    cookie.expires_ = parser.eatV0CookieDate().getTime();
                } else {
                    String value = parser.eatV0CookieValue();
                    if (name.equals("domain")) {
                        cookie.domain_ = value.toLowerCase();
                    } else if (name.equals("path")) {
                        cookie.path_ = value;
                    } else {
                        logger.info(new StringBuilder(35 + String.valueOf(name).length() + String.valueOf(value).length()).append("unrecognized v0 cookie attribute: ").append(name).append("=").append(value).toString());
                    }
                }
            }
            parser.eatLWS();
        }
        String requestHost = url.getHost().toLowerCase();
        String requestPath = url.getPath();
        boolean valid = true;
        if (cookie.domain_ == null) {
            cookie.effectiveDomain_ = new StringBuilder(1 + String.valueOf(requestHost).length()).append(".").append(requestHost).toString();
        } else if (!requestHost.equals(cookie.domain_)) {
            if (!cookie.domain_.startsWith(".")) {
                String string = cookie.domain_;
                cookie.effectiveDomain_ = new StringBuilder(1 + String.valueOf(string).length()).append(".").append(string).toString();
            } else {
                cookie.effectiveDomain_ = cookie.domain_;
            }
            if (!requestHost.endsWith(cookie.effectiveDomain_)) {
                String string = String.valueOf(setCookie0Header);
                logger.info(string.length() != 0 ? "rejecting v0 cookie [bad domain - no match]: ".concat(string) : new String("rejecting v0 cookie [bad domain - no match]: "));
                valid = false;
            } else {
                int numPeriods = ClientCookie.countOccurrences(cookie.effectiveDomain_, '.');
                boolean special = false;
                for (int i = 0; i < SPECIAL_DOMAINS.length; ++i) {
                    if (!cookie.effectiveDomain_.endsWith(SPECIAL_DOMAINS[i])) continue;
                    special = true;
                    break;
                }
                if (special ? numPeriods < 2 : numPeriods < 3) {
                    String string = String.valueOf(setCookie0Header);
                    logger.info(string.length() != 0 ? "rejecting v0 cookie [bad domain - no periods]: ".concat(string) : new String("rejecting v0 cookie [bad domain - no periods]: "));
                    valid = false;
                }
            }
        } else {
            String string = cookie.domain_;
            cookie.effectiveDomain_ = new StringBuilder(1 + String.valueOf(string).length()).append(".").append(string).toString();
        }
        cookie.effectivePath_ = cookie.path_ == null ? requestPath : cookie.path_;
        if (valid) {
            results.add(cookie);
        }
        return results;
    }
}

