/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.wargen;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public final class WarGenerator {
    public static final String APP_YAML = "app.yaml";
    private static final String[] YAML_FILES = new String[]{"app.yaml", "backends.yaml", "index.yaml", "cron.yaml", "queue.yaml", "dos.yaml"};
    private final File srcDir;
    private final File destWarDir;
    private File webInfDir;
    private File webInfLibDir;
    private final Set<File> librariesToCopy;

    WarGenerator(File srcDir, File destWarDir) {
        this.srcDir = Preconditions.checkNotNull(srcDir, "srcDir is null.");
        this.destWarDir = Preconditions.checkNotNull(destWarDir, "destWarDir is null");
        this.librariesToCopy = new HashSet<File>(10);
        Preconditions.checkArgument(srcDir.isDirectory(), String.valueOf(srcDir.getPath()).concat(" is not an existing directory."));
        File appYamlFile = new File(srcDir, APP_YAML);
        String string = String.valueOf(srcDir.getPath());
        String string2 = String.valueOf(APP_YAML);
        Preconditions.checkArgument(appYamlFile.isFile(), new StringBuilder(28 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(" must contain a file named ").append(string2).append(".").toString());
    }

    public void addLibrariesToCopy(Set<File> setOfFiles) {
        this.librariesToCopy.addAll(setOfFiles);
    }

    public File generateWarDirectory() throws IOException {
        String string = String.valueOf(this.destWarDir.getPath());
        System.out.println(string.length() != 0 ? "Generating WAR directory at ".concat(string) : new String("Generating WAR directory at "));
        WarGenerator.createDirectory(this.destWarDir);
        this.webInfDir = new File(this.destWarDir, "WEB-INF");
        WarGenerator.createDirectory(this.webInfDir);
        this.webInfLibDir = new File(this.webInfDir, "lib");
        WarGenerator.createDirectory(this.webInfLibDir);
        for (String yamlFileName : YAML_FILES) {
            File srcFile = new File(this.srcDir, yamlFileName);
            if (!srcFile.isFile()) continue;
            Files.copy(srcFile, new File(this.webInfDir, srcFile.getName()));
        }
        for (File jarFile : this.librariesToCopy) {
            if (jarFile == null || !jarFile.exists() || !jarFile.isFile()) continue;
            Files.copy(jarFile, new File(this.webInfLibDir, jarFile.getName()));
        }
        return this.destWarDir;
    }

    private static void createDirectory(File directory) {
        if (!(directory.exists() || directory.mkdirs() || directory.exists())) {
            String string = String.valueOf(directory.getPath());
            throw new RuntimeException(string.length() != 0 ? "Unable to make directory: ".concat(string) : new String("Unable to make directory: "));
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(String.valueOf(directory.getPath()).concat(" is not a directory"));
        }
    }
}

