/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mortbay.xml.XmlParser;
import org.xml.sax.SAXException;

public abstract class AbstractConfigXmlReader<T> {
    protected final String appDir;
    protected final boolean required;
    protected Logger logger;

    public AbstractConfigXmlReader(String appDir, boolean required) {
        if (appDir.length() > 0 && appDir.charAt(appDir.length() - 1) != File.separatorChar) {
            String string = String.valueOf(appDir);
            char c = File.separatorChar;
            appDir = new StringBuilder(1 + String.valueOf(string).length()).append(string).append(c).toString();
        }
        this.appDir = appDir;
        this.required = required;
        this.logger = Logger.getLogger(this.getClass().getName());
    }

    public String getFilename() {
        String string = String.valueOf(this.appDir);
        String string2 = String.valueOf(this.getRelativeFilename());
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    protected abstract String getRelativeFilename();

    protected abstract T processXml(InputStream var1);

    protected T readConfigXml() {
        T configXml;
        InputStream is = null;
        if (!this.required && !this.fileExists()) {
            return null;
        }
        try {
            is = this.getInputStream();
            configXml = this.processXml(is);
            String string = String.valueOf(this.getFilename());
            this.logger.fine(string.length() != 0 ? "Successfully processed ".concat(string) : new String("Successfully processed "));
        }
        catch (Exception e) {
            String string = String.valueOf(this.getFilename());
            String msg = string.length() != 0 ? "Received exception processing ".concat(string) : new String("Received exception processing ");
            this.logger.log(Level.SEVERE, msg, e);
            if (e instanceof AppEngineConfigException) {
                throw (AppEngineConfigException)e;
            }
            throw new AppEngineConfigException(msg, e);
        }
        finally {
            this.close(is);
        }
        return configXml;
    }

    protected boolean fileExists() {
        return new File(this.getFilename()).exists();
    }

    protected InputStream getInputStream() {
        try {
            return new FileInputStream(this.getFilename());
        }
        catch (FileNotFoundException fnfe) {
            String string = String.valueOf(new File(this.getFilename()).getAbsolutePath());
            throw new AppEngineConfigException(string.length() != 0 ? "Could not locate ".concat(string) : new String("Could not locate "), fnfe);
        }
    }

    protected XmlParser createXmlParser() {
        return new XmlParser();
    }

    protected XmlParser.Node getTopLevelNode(InputStream is) {
        XmlParser xmlParser = this.createXmlParser();
        try {
            return xmlParser.parse(is);
        }
        catch (IOException e) {
            String string = String.valueOf(this.getFilename());
            String msg = string.length() != 0 ? "Received IOException parsing the input stream for ".concat(string) : new String("Received IOException parsing the input stream for ");
            this.logger.log(Level.SEVERE, msg, e);
            throw new AppEngineConfigException(msg, e);
        }
        catch (SAXException e) {
            String string = String.valueOf(this.getFilename());
            String msg = string.length() != 0 ? "Received SAXException parsing the input stream for ".concat(string) : new String("Received SAXException parsing the input stream for ");
            this.logger.log(Level.SEVERE, msg, e);
            throw new AppEngineConfigException(msg, e);
        }
    }

    protected void parse(ParserCallback parseCb, InputStream is) {
        Stack<XmlParser.Node> stack = new Stack<XmlParser.Node>();
        XmlParser.Node top = this.getTopLevelNode(is);
        this.parse(top, stack, parseCb);
    }

    protected void parse(XmlParser.Node node, Stack<XmlParser.Node> stack, ParserCallback parseCb) {
        parseCb.newNode(node, stack);
        stack.push(node);
        for (Object child : node) {
            if (!(child instanceof XmlParser.Node)) continue;
            this.parse((XmlParser.Node)child, stack, parseCb);
        }
        stack.pop();
    }

    protected void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                throw new AppEngineConfigException(e);
            }
        }
    }

    protected String getString(XmlParser.Node node) {
        String string = (String)node.get(0);
        if (string == null) {
            return null;
        }
        return string.trim();
    }

    public static interface ParserCallback {
        public void newNode(XmlParser.Node var1, Stack<XmlParser.Node> var2);
    }
}

