/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.ApplicationXml;
import com.google.apphosting.utils.config.XmlUtils;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Set;
import org.mortbay.xml.XmlParser;

public class ApplicationXmlReader {
    public ApplicationXml processXml(InputStream is) {
        ApplicationXml.Builder builder = ApplicationXml.builder();
        HashSet<String> contextRoots = new HashSet<String>();
        for (Object o : XmlUtils.parse(is)) {
            XmlParser.Node node;
            if (!(o instanceof XmlParser.Node) || "icon".equals((node = (XmlParser.Node)o).getTag()) || "display-name".equals(node.getTag()) || "description".equals(node.getTag())) continue;
            if ("module".equals(node.getTag())) {
                this.handleModuleNode(node, builder.getModulesBuilder(), contextRoots);
                continue;
            }
            if ("security-role".equals(node.getTag()) || "library-directory".equals(node.getTag())) continue;
            this.reportUnrecognizedTag(node.getTag());
        }
        return builder.build();
    }

    private void handleModuleNode(XmlParser.Node module, ApplicationXml.Modules.Builder builder, Set<String> contextRoots) {
        for (Object o : module) {
            XmlParser.Node node;
            if (!(o instanceof XmlParser.Node) || "alt-dd".equals((node = (XmlParser.Node)o).getTag()) || "connector".equals(node.getTag()) || "ejb".equals(node.getTag()) || "java".equals(node.getTag())) continue;
            if ("web".equals(node.getTag())) {
                this.handleWebNode(node, builder, contextRoots);
                continue;
            }
            this.reportUnrecognizedTag(node.getTag());
        }
    }

    private void handleWebNode(XmlParser.Node web, ApplicationXml.Modules.Builder builder, Set<String> contextRoots) {
        String contextRoot = null;
        String webUri = null;
        for (Object o : web) {
            if (!(o instanceof XmlParser.Node)) continue;
            XmlParser.Node node = (XmlParser.Node)o;
            if ("web-uri".equals(node.getTag())) {
                if (webUri != null) {
                    throw new AppEngineConfigException("web-uri multiply defined in application.xml web module.");
                }
                webUri = XmlUtils.getText(node);
                if (!webUri.isEmpty()) continue;
                throw new AppEngineConfigException("web-uri is empty in application.xml web module.");
            }
            if ("context-root".equals(node.getTag())) {
                if (contextRoot != null) {
                    throw new AppEngineConfigException("context-root multiply defined in application.xml web module.");
                }
                contextRoot = XmlUtils.getText(node);
                if (contextRoot.isEmpty()) {
                    throw new AppEngineConfigException("context-root is empty in application.xml web module.");
                }
                if (contextRoots.contains(contextRoot)) {
                    String string = contextRoot;
                    throw new AppEngineConfigException(new StringBuilder(36 + String.valueOf(string).length()).append("context-root value '").append(string).append("' is not unique.").toString());
                }
                contextRoots.add(contextRoot);
                continue;
            }
            this.reportUnrecognizedTag(node.getTag());
        }
        if (null == webUri) {
            throw new AppEngineConfigException("web-uri not defined in application.xml web module.");
        }
        if (null == contextRoot) {
            throw new AppEngineConfigException("context-root not defined in application.xml web module.");
        }
        builder.addWeb(new ApplicationXml.Modules.Web(webUri, contextRoot));
    }

    private void reportUnrecognizedTag(String tag) throws AppEngineConfigException {
        throw new AppEngineConfigException(new StringBuilder(43 + String.valueOf(tag).length()).append("Unrecognized element <").append(tag).append("> in application.xml.").toString());
    }
}

