/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.config;

import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlException;
import com.google.appengine.repackaged.net.sourceforge.yamlbeans.YamlReader;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.DosXml;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;

public class DosYamlReader {
    private static final String FILENAME = "dos.yaml";
    private String appDir;

    public DosYamlReader(String appDir) {
        if (appDir.length() > 0 && appDir.charAt(appDir.length() - 1) != File.separatorChar) {
            String string = String.valueOf(appDir);
            char c = File.separatorChar;
            appDir = new StringBuilder(1 + String.valueOf(string).length()).append(string).append(c).toString();
        }
        this.appDir = appDir;
    }

    public String getFilename() {
        String string = String.valueOf(this.appDir);
        String string2 = String.valueOf(FILENAME);
        return string2.length() != 0 ? string.concat(string2) : new String(string);
    }

    public DosXml parse() {
        if (new File(this.getFilename()).exists()) {
            try {
                return DosYamlReader.parse(new FileReader(this.getFilename()));
            }
            catch (FileNotFoundException ex) {
                String string = String.valueOf(this.getFilename());
                throw new AppEngineConfigException(string.length() != 0 ? "Cannot find file ".concat(string) : new String("Cannot find file "), ex);
            }
        }
        return null;
    }

    public static DosXml parse(Reader yaml) {
        YamlReader reader = new YamlReader(yaml);
        reader.getConfig().setPropertyElementType(DosYaml.class, "blacklist", DosXml.BlacklistEntry.class);
        try {
            DosYaml dosYaml = reader.read(DosYaml.class);
            if (dosYaml == null) {
                throw new AppEngineConfigException("Empty dos configuration.");
            }
            return dosYaml.toXml();
        }
        catch (YamlException ex) {
            throw new AppEngineConfigException(ex.getMessage(), ex);
        }
    }

    public static DosXml parse(String yaml) {
        return DosYamlReader.parse(new StringReader(yaml));
    }

    public static class DosYaml {
        private List<DosXml.BlacklistEntry> entries;

        public List<DosXml.BlacklistEntry> getBlacklist() {
            return this.entries;
        }

        public void setBlacklist(List<DosXml.BlacklistEntry> entries) {
            this.entries = entries;
        }

        public DosXml toXml() {
            DosXml xml = new DosXml();
            if (this.entries != null) {
                for (DosXml.BlacklistEntry entry : this.entries) {
                    xml.addBlacklistEntry(entry);
                }
            }
            return xml;
        }
    }
}

