/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.utils.security;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AllPermission;
import java.security.Permission;
import java.security.Policy;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SecurityManagerInstaller {
    private static final transient Logger logger = Logger.getLogger(SecurityManagerInstaller.class.getName());
    private static final String EXT_DIRS_PROPERTY = "java.ext.dirs";
    private static boolean isInstalled = false;

    public static void install(URL ... urls) {
        SecurityManagerInstaller.install(true, urls);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void install(boolean paranoid, URL ... urls) {
        File file;
        if (isInstalled) {
            return;
        }
        if (System.getSecurityManager() != null) {
            if (paranoid) {
                String string = String.valueOf(System.getSecurityManager());
                throw new IllegalStateException(new StringBuilder(35 + String.valueOf(string).length()).append("SecurityManager already installed: ").append(string).toString());
            }
            isInstalled = true;
            return;
        }
        try {
            file = SecurityManagerInstaller.generatePolicyFile(paranoid, urls);
        }
        catch (IOException ex) {
            throw new RuntimeException("Cannot generate policy file.", ex);
        }
        try {
            String string = String.valueOf(file.getPath());
            System.setProperty("java.security.policy", string.length() != 0 ? "=".concat(string) : new String("="));
            System.setSecurityManager(new SecurityManager());
            Policy.getPolicy().refresh();
        }
        finally {
            try {
                if (!file.delete()) {
                    String ex = String.valueOf(file);
                    logger.warning(new StringBuilder(38 + String.valueOf(ex).length()).append("Unable to delete dynamic policy file: ").append(ex).toString());
                }
            }
            catch (SecurityException e) {
                String string = String.valueOf(file);
                logger.log(Level.WARNING, new StringBuilder(38 + String.valueOf(string).length()).append("Unable to delete dynamic policy file: ").append(string).toString(), e);
            }
        }
        isInstalled = true;
    }

    private static File generatePolicyFile(boolean paranoid, URL[] urls) throws IOException {
        ClassLoader ourClassLoader = SecurityManagerInstaller.class.getClassLoader();
        if (paranoid && ourClassLoader != ClassLoader.getSystemClassLoader()) {
            String string = String.valueOf("SecurityManagerInstaller must be loaded in the system ClassLoader; was ");
            String string2 = String.valueOf(ourClassLoader);
            throw new IllegalStateException(new StringBuilder(0 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append(string2).toString());
        }
        if (!(ourClassLoader instanceof URLClassLoader)) {
            String string = String.valueOf(ourClassLoader);
            throw new ClassCastException(new StringBuilder(38 + String.valueOf(string).length()).append("ClassLoader is ").append(string).append(", not a URLClassLoader.").toString());
        }
        URLClassLoader urlClassLoader = (URLClassLoader)ourClassLoader;
        File file = File.createTempFile("test", ".policy");
        String string = String.valueOf(file);
        logger.fine(new StringBuilder(32 + String.valueOf(string).length()).append("Auto-generating policy file at: ").append(string).toString());
        PrintWriter writer = new PrintWriter(new FileWriter(file));
        for (URL url : urlClassLoader.getURLs()) {
            SecurityManagerInstaller.grantToUrl(url, AllPermission.class, writer);
        }
        for (URL url : urls) {
            SecurityManagerInstaller.grantToUrl(url, AllPermission.class, writer);
        }
        SecurityManagerInstaller.grantToExtDirs(AllPermission.class, writer);
        writer.close();
        return file;
    }

    private static void grantToExtDirs(Class<? extends Permission> permissionClass, PrintWriter writer) {
        StringTokenizer tokenizer = new StringTokenizer(System.getProperty(EXT_DIRS_PROPERTY), File.pathSeparator);
        while (tokenizer.hasMoreTokens()) {
            SecurityManagerInstaller.grantToDir(new File(tokenizer.nextToken()), permissionClass, writer);
        }
    }

    private static void grantToDir(File dir, Class<? extends Permission> permissionClass, PrintWriter writer) {
        if (dir.isFile()) {
            try {
                SecurityManagerInstaller.grantToUrl(dir.toURI().toURL(), permissionClass, writer);
            }
            catch (MalformedURLException ex) {
                String string = String.valueOf(dir);
                logger.log(Level.WARNING, new StringBuilder(38 + String.valueOf(string).length()).append("Ignoring malformed URL JRE extension: ").append(string).toString(), ex);
            }
        } else if (dir.isDirectory()) {
            for (File file : dir.listFiles()) {
                SecurityManagerInstaller.grantToDir(file, permissionClass, writer);
            }
        } else {
            String string = String.valueOf(dir);
            logger.fine(new StringBuilder(47 + String.valueOf(string).length()).append("Ignoring non-file/non-directory JRE extension: ").append(string).toString());
        }
    }

    private static void grantToUrl(URL url, Class<? extends Permission> permissionClass, PrintWriter writer) {
        String permissionClassName = permissionClass.getName();
        logger.fine(String.format("Granting %s permission %s", url, permissionClassName));
        writer.println(String.format("grant codebase \"%s\" { permission %s; };", url, permissionClassName));
    }
}

