/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.Portable;
import org.mortbay.io.View;

public abstract class AbstractBuffer
implements Buffer {
    protected static final String __IMMUTABLE = "IMMUTABLE";
    protected static final String __READONLY = "READONLY";
    protected static final String __READWRITE = "READWRITE";
    protected static final String __VOLATILE = "VOLATILE";
    protected int _access;
    protected boolean _volatile;
    protected int _get;
    protected int _put;
    protected int _hash;
    protected int _hashGet;
    protected int _hashPut;
    protected int _mark;
    protected String _string;
    protected View _view;

    public AbstractBuffer(int n, boolean bl) {
        if (n == 0 && bl) {
            throw new IllegalArgumentException("IMMUTABLE && VOLATILE");
        }
        this.setMarkIndex(-1);
        this._access = n;
        this._volatile = bl;
    }

    @Override
    public byte[] asArray() {
        byte[] byArray = new byte[this.length()];
        byte[] byArray2 = this.array();
        if (byArray2 != null) {
            Portable.arraycopy(byArray2, this.getIndex(), byArray, 0, byArray.length);
        } else {
            this.peek(this.getIndex(), byArray, 0, this.length());
        }
        return byArray;
    }

    public ByteArrayBuffer duplicate(int n) {
        Buffer buffer = this.buffer();
        if (buffer instanceof Buffer.CaseInsensitve) {
            return new ByteArrayBuffer.CaseInsensitive(this.asArray(), 0, this.length(), n);
        }
        return new ByteArrayBuffer(this.asArray(), 0, this.length(), n);
    }

    @Override
    public Buffer asNonVolatileBuffer() {
        if (!this.isVolatile()) {
            return this;
        }
        return this.duplicate(this._access);
    }

    @Override
    public Buffer asImmutableBuffer() {
        if (this.isImmutable()) {
            return this;
        }
        return this.duplicate(0);
    }

    @Override
    public Buffer asReadOnlyBuffer() {
        if (this.isReadOnly()) {
            return this;
        }
        return new View(this, this.markIndex(), this.getIndex(), this.putIndex(), 1);
    }

    @Override
    public Buffer asMutableBuffer() {
        if (!this.isImmutable()) {
            return this;
        }
        Buffer buffer = this.buffer();
        if (buffer.isReadOnly()) {
            return this.duplicate(2);
        }
        return new View(buffer, this.markIndex(), this.getIndex(), this.putIndex(), this._access);
    }

    @Override
    public Buffer buffer() {
        return this;
    }

    @Override
    public void clear() {
        this.setMarkIndex(-1);
        this.setGetIndex(0);
        this.setPutIndex(0);
    }

    @Override
    public void compact() {
        int n;
        if (this.isReadOnly()) {
            throw new IllegalStateException(__READONLY);
        }
        int n2 = n = this.markIndex() >= 0 ? this.markIndex() : this.getIndex();
        if (n > 0) {
            byte[] byArray = this.array();
            int n3 = this.putIndex() - n;
            if (n3 > 0) {
                if (byArray != null) {
                    Portable.arraycopy(this.array(), n, this.array(), 0, n3);
                } else {
                    this.poke(0, this.peek(n, n3));
                }
            }
            if (this.markIndex() > 0) {
                this.setMarkIndex(this.markIndex() - n);
            }
            this.setGetIndex(this.getIndex() - n);
            this.setPutIndex(this.putIndex() - n);
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof Buffer)) {
            return false;
        }
        Buffer buffer = (Buffer)object;
        if (this instanceof Buffer.CaseInsensitve || buffer instanceof Buffer.CaseInsensitve) {
            return this.equalsIgnoreCase(buffer);
        }
        if (buffer.length() != this.length()) {
            return false;
        }
        if (this._hash != 0 && object instanceof AbstractBuffer) {
            AbstractBuffer abstractBuffer = (AbstractBuffer)object;
            if (abstractBuffer._hash != 0 && this._hash != abstractBuffer._hash) {
                return false;
            }
        }
        int n = this.getIndex();
        int n2 = buffer.putIndex();
        int n3 = this.putIndex();
        while (n3-- > n) {
            byte by;
            byte by2 = this.peek(n3);
            if (by2 == (by = buffer.peek(--n2))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equalsIgnoreCase(Buffer buffer) {
        if (buffer == this) {
            return true;
        }
        if (buffer.length() != this.length()) {
            return false;
        }
        if (this._hash != 0 && buffer instanceof AbstractBuffer) {
            AbstractBuffer abstractBuffer = (AbstractBuffer)buffer;
            if (abstractBuffer._hash != 0 && this._hash != abstractBuffer._hash) {
                return false;
            }
        }
        int n = this.getIndex();
        int n2 = buffer.putIndex();
        byte[] byArray = this.array();
        byte[] byArray2 = buffer.array();
        if (byArray != null && byArray2 != null) {
            int n3 = this.putIndex();
            while (n3-- > n) {
                byte by;
                byte by2 = byArray[n3];
                if (by2 == (by = byArray2[--n2])) continue;
                if (97 <= by2 && by2 <= 122) {
                    by2 = (byte)(by2 - 97 + 65);
                }
                if (97 <= by && by <= 122) {
                    by = (byte)(by - 97 + 65);
                }
                if (by2 == by) continue;
                return false;
            }
        } else {
            int n4 = this.putIndex();
            while (n4-- > n) {
                byte by;
                byte by3 = this.peek(n4);
                if (by3 == (by = buffer.peek(--n2))) continue;
                if (97 <= by3 && by3 <= 122) {
                    by3 = (byte)(by3 - 97 + 65);
                }
                if (97 <= by && by <= 122) {
                    by = (byte)(by - 97 + 65);
                }
                if (by3 == by) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public byte get() {
        return this.peek(this._get++);
    }

    @Override
    public int get(byte[] byArray, int n, int n2) {
        int n3 = this.getIndex();
        int n4 = this.length();
        if (n4 == 0) {
            return -1;
        }
        if (n2 > n4) {
            n2 = n4;
        }
        if ((n2 = this.peek(n3, byArray, n, n2)) > 0) {
            this.setGetIndex(n3 + n2);
        }
        return n2;
    }

    @Override
    public Buffer get(int n) {
        int n2 = this.getIndex();
        Buffer buffer = this.peek(n2, n);
        this.setGetIndex(n2 + n);
        return buffer;
    }

    @Override
    public final int getIndex() {
        return this._get;
    }

    @Override
    public boolean hasContent() {
        return this._put > this._get;
    }

    public int hashCode() {
        if (this._hash == 0 || this._hashGet != this._get || this._hashPut != this._put) {
            int n = this.getIndex();
            byte[] byArray = this.array();
            if (byArray == null) {
                int n2 = this.putIndex();
                while (n2-- > n) {
                    byte by = this.peek(n2);
                    if (97 <= by && by <= 122) {
                        by = (byte)(by - 97 + 65);
                    }
                    this._hash = 31 * this._hash + by;
                }
            } else {
                int n3 = this.putIndex();
                while (n3-- > n) {
                    byte by = byArray[n3];
                    if (97 <= by && by <= 122) {
                        by = (byte)(by - 97 + 65);
                    }
                    this._hash = 31 * this._hash + by;
                }
            }
            if (this._hash == 0) {
                this._hash = -1;
            }
            this._hashGet = this._get;
            this._hashPut = this._put;
        }
        return this._hash;
    }

    @Override
    public boolean isImmutable() {
        return this._access <= 0;
    }

    @Override
    public boolean isReadOnly() {
        return this._access <= 1;
    }

    @Override
    public boolean isVolatile() {
        return this._volatile;
    }

    @Override
    public int length() {
        return this._put - this._get;
    }

    @Override
    public void mark() {
        this.setMarkIndex(this._get - 1);
    }

    @Override
    public void mark(int n) {
        this.setMarkIndex(this._get + n);
    }

    @Override
    public int markIndex() {
        return this._mark;
    }

    @Override
    public byte peek() {
        return this.peek(this._get);
    }

    @Override
    public Buffer peek(int n, int n2) {
        if (this._view == null) {
            this._view = new View(this, -1, n, n + n2, this.isReadOnly() ? 1 : 2);
        } else {
            this._view.update(this.buffer());
            this._view.setMarkIndex(-1);
            this._view.setGetIndex(0);
            this._view.setPutIndex(n + n2);
            this._view.setGetIndex(n);
        }
        return this._view;
    }

    @Override
    public int poke(int n, Buffer buffer) {
        this._hash = 0;
        int n2 = buffer.length();
        if (n + n2 > this.capacity()) {
            n2 = this.capacity() - n;
        }
        byte[] byArray = buffer.array();
        byte[] byArray2 = this.array();
        if (byArray != null && byArray2 != null) {
            Portable.arraycopy(byArray, buffer.getIndex(), byArray2, n, n2);
        } else if (byArray != null) {
            int n3 = buffer.getIndex();
            for (int i = 0; i < n2; ++i) {
                this.poke(n++, byArray[n3++]);
            }
        } else if (byArray2 != null) {
            int n4 = buffer.getIndex();
            for (int i = 0; i < n2; ++i) {
                byArray2[n++] = buffer.peek(n4++);
            }
        } else {
            int n5 = buffer.getIndex();
            for (int i = 0; i < n2; ++i) {
                this.poke(n++, buffer.peek(n5++));
            }
        }
        return n2;
    }

    @Override
    public int poke(int n, byte[] byArray, int n2, int n3) {
        byte[] byArray2;
        this._hash = 0;
        if (n + n3 > this.capacity()) {
            n3 = this.capacity() - n;
        }
        if ((byArray2 = this.array()) != null) {
            Portable.arraycopy(byArray, n2, byArray2, n, n3);
        } else {
            int n4 = n2;
            for (int i = 0; i < n3; ++i) {
                this.poke(n++, byArray[n4++]);
            }
        }
        return n3;
    }

    @Override
    public int put(Buffer buffer) {
        int n = this.putIndex();
        int n2 = this.poke(n, buffer);
        this.setPutIndex(n + n2);
        return n2;
    }

    @Override
    public void put(byte by) {
        int n = this.putIndex();
        this.poke(n, by);
        this.setPutIndex(n + 1);
    }

    @Override
    public int put(byte[] byArray, int n, int n2) {
        int n3 = this.putIndex();
        int n4 = this.poke(n3, byArray, n, n2);
        this.setPutIndex(n3 + n4);
        return n4;
    }

    @Override
    public int put(byte[] byArray) {
        int n = this.putIndex();
        int n2 = this.poke(n, byArray, 0, byArray.length);
        this.setPutIndex(n + n2);
        return n2;
    }

    @Override
    public final int putIndex() {
        return this._put;
    }

    @Override
    public void reset() {
        if (this.markIndex() >= 0) {
            this.setGetIndex(this.markIndex());
        }
    }

    public void rewind() {
        this.setGetIndex(0);
        this.setMarkIndex(-1);
    }

    @Override
    public void setGetIndex(int n) {
        this._get = n;
        this._hash = 0;
    }

    @Override
    public void setMarkIndex(int n) {
        this._mark = n;
    }

    @Override
    public void setPutIndex(int n) {
        this._put = n;
        this._hash = 0;
    }

    @Override
    public int skip(int n) {
        if (this.length() < n) {
            n = this.length();
        }
        this.setGetIndex(this.getIndex() + n);
        return n;
    }

    @Override
    public Buffer slice() {
        return this.peek(this.getIndex(), this.length());
    }

    @Override
    public Buffer sliceFromMark() {
        return this.sliceFromMark(this.getIndex() - this.markIndex() - 1);
    }

    @Override
    public Buffer sliceFromMark(int n) {
        if (this.markIndex() < 0) {
            return null;
        }
        Buffer buffer = this.peek(this.markIndex(), n);
        this.setMarkIndex(-1);
        return buffer;
    }

    @Override
    public int space() {
        return this.capacity() - this._put;
    }

    @Override
    public String toDetailString() {
        int n;
        int n2;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        stringBuffer.append(super.hashCode());
        stringBuffer.append(",");
        stringBuffer.append(this.array().hashCode());
        stringBuffer.append(",m=");
        stringBuffer.append(this.markIndex());
        stringBuffer.append(",g=");
        stringBuffer.append(this.getIndex());
        stringBuffer.append(",p=");
        stringBuffer.append(this.putIndex());
        stringBuffer.append(",c=");
        stringBuffer.append(this.capacity());
        stringBuffer.append("]={");
        if (this.markIndex() >= 0) {
            for (n2 = this.markIndex(); n2 < this.getIndex(); ++n2) {
                n = (char)this.peek(n2);
                if (Character.isISOControl((char)n)) {
                    stringBuffer.append(n < 16 ? "\\0" : "\\");
                    stringBuffer.append(Integer.toString(n, 16));
                    continue;
                }
                stringBuffer.append((char)n);
            }
            stringBuffer.append("}{");
        }
        n2 = 0;
        for (n = this.getIndex(); n < this.putIndex(); ++n) {
            char c = (char)this.peek(n);
            if (Character.isISOControl(c)) {
                stringBuffer.append(c < '\u0010' ? "\\0" : "\\");
                stringBuffer.append(Integer.toString(c, 16));
            } else {
                stringBuffer.append(c);
            }
            if (n2++ != 50 || this.putIndex() - n <= 20) continue;
            stringBuffer.append(" ... ");
            n = this.putIndex() - 20;
        }
        stringBuffer.append('}');
        return stringBuffer.toString();
    }

    public String toString() {
        if (this.isImmutable()) {
            if (this._string == null) {
                this._string = new String(this.asArray(), 0, this.length());
            }
            return this._string;
        }
        return new String(this.asArray(), 0, this.length());
    }

    public String toDebugString() {
        return this.getClass() + "@" + super.hashCode();
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        byte[] byArray = this.array();
        if (byArray != null) {
            outputStream.write(byArray, this.getIndex(), this.length());
        } else {
            int n = this.length();
            byte[] byArray2 = new byte[n > 1024 ? 1024 : n];
            int n2 = this._get;
            while (n > 0) {
                int n3 = this.peek(n2, byArray2, 0, n > byArray2.length ? byArray2.length : n);
                outputStream.write(byArray2, 0, n3);
                n2 += n3;
                n -= n3;
            }
        }
        this.clear();
    }

    @Override
    public int readFrom(InputStream inputStream, int n) throws IOException {
        byte[] byArray = this.array();
        int n2 = this.space();
        if (n2 > n) {
            n2 = n;
        }
        if (byArray != null) {
            int n3 = inputStream.read(byArray, this._put, n2);
            if (n3 > 0) {
                this._put += n3;
            }
            return n3;
        }
        byte[] byArray2 = new byte[n2 > 1024 ? 1024 : n2];
        int n4 = 0;
        while (n2 > 0) {
            int n5 = inputStream.read(byArray2, 0, byArray2.length);
            if (n5 < 0) {
                return n4 > 0 ? n4 : -1;
            }
            int n6 = this.put(byArray2, 0, n5);
            assert (n5 == n6);
            n2 -= n5;
        }
        return n4;
    }
}

