/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io;

import java.io.UnsupportedEncodingException;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.util.StringUtil;

public class BufferUtil {
    static final byte SPACE = 32;
    static final byte MINUS = 45;
    static final byte[] DIGIT = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 65, 66, 67, 68, 69, 70};
    private static int[] decDivisors = new int[]{1000000000, 100000000, 10000000, 1000000, 100000, 10000, 1000, 100, 10, 1};
    private static int[] hexDivisors = new int[]{0x10000000, 0x1000000, 0x100000, 65536, 4096, 256, 16, 1};

    public static int toInt(Buffer buffer) {
        int n = 0;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = buffer.getIndex(); i < buffer.putIndex(); ++i) {
            byte by = buffer.peek(i);
            if (by <= 32) {
                if (!bl) continue;
                break;
            }
            if (by >= 48 && by <= 57) {
                n = n * 10 + (by - 48);
                bl = true;
                continue;
            }
            if (by != 45 || bl) break;
            bl2 = true;
        }
        if (bl) {
            return bl2 ? -n : n;
        }
        throw new NumberFormatException(buffer.toString());
    }

    public static long toLong(Buffer buffer) {
        long l = 0L;
        boolean bl = false;
        boolean bl2 = false;
        for (int i = buffer.getIndex(); i < buffer.putIndex(); ++i) {
            byte by = buffer.peek(i);
            if (by <= 32) {
                if (!bl) continue;
                break;
            }
            if (by >= 48 && by <= 57) {
                l = l * 10L + (long)(by - 48);
                bl = true;
                continue;
            }
            if (by != 45 || bl) break;
            bl2 = true;
        }
        if (bl) {
            return bl2 ? -l : l;
        }
        throw new NumberFormatException(buffer.toString());
    }

    public static void putHexInt(Buffer buffer, int n) {
        if (n < 0) {
            buffer.put((byte)45);
            if (n == Integer.MIN_VALUE) {
                buffer.put((byte)56);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                buffer.put((byte)48);
                return;
            }
            n = -n;
        }
        if (n < 16) {
            buffer.put(DIGIT[n]);
        } else {
            boolean bl = false;
            for (int i = 0; i < hexDivisors.length; ++i) {
                if (n < hexDivisors[i]) {
                    if (!bl) continue;
                    buffer.put((byte)48);
                    continue;
                }
                bl = true;
                int n2 = n / hexDivisors[i];
                buffer.put(DIGIT[n2]);
                n -= n2 * hexDivisors[i];
            }
        }
    }

    public static void prependHexInt(Buffer buffer, int n) {
        if (n == 0) {
            int n2 = buffer.getIndex();
            buffer.poke(--n2, (byte)48);
            buffer.setGetIndex(n2);
        } else {
            boolean bl = false;
            if (n < 0) {
                bl = true;
                n = -n;
            }
            int n3 = buffer.getIndex();
            while (n > 0) {
                int n4 = 0xF & n;
                n >>= 4;
                buffer.poke(--n3, DIGIT[n4]);
            }
            if (bl) {
                buffer.poke(--n3, (byte)45);
            }
            buffer.setGetIndex(n3);
        }
    }

    public static void putDecInt(Buffer buffer, int n) {
        if (n < 0) {
            buffer.put((byte)45);
            if (n == Integer.MIN_VALUE) {
                buffer.put((byte)50);
                n = 147483648;
            } else {
                n = -n;
            }
        }
        if (n < 10) {
            buffer.put(DIGIT[n]);
        } else {
            boolean bl = false;
            for (int i = 0; i < decDivisors.length; ++i) {
                if (n < decDivisors[i]) {
                    if (!bl) continue;
                    buffer.put((byte)48);
                    continue;
                }
                bl = true;
                int n2 = n / decDivisors[i];
                buffer.put(DIGIT[n2]);
                n -= n2 * decDivisors[i];
            }
        }
    }

    public static void putDecLong(Buffer buffer, long l) {
        if (l < 0L) {
            buffer.put((byte)45);
            if (l == Long.MIN_VALUE) {
                buffer.put((byte)57);
                l = 223372036854775808L;
            } else {
                l = -l;
            }
        }
        if (l < 10L) {
            buffer.put(DIGIT[(int)l]);
        } else {
            boolean bl = false;
            for (int i = 0; i < decDivisors.length; ++i) {
                if (l < (long)decDivisors[i]) {
                    if (!bl) continue;
                    buffer.put((byte)48);
                    continue;
                }
                bl = true;
                long l2 = l / (long)decDivisors[i];
                buffer.put(DIGIT[(int)l2]);
                l -= l2 * (long)decDivisors[i];
            }
        }
    }

    public static Buffer toBuffer(long l) {
        ByteArrayBuffer byteArrayBuffer = new ByteArrayBuffer(16);
        BufferUtil.putDecLong(byteArrayBuffer, l);
        return byteArrayBuffer;
    }

    public static void putCRLF(Buffer buffer) {
        buffer.put((byte)13);
        buffer.put((byte)10);
    }

    public static boolean isPrefix(Buffer buffer, Buffer buffer2) {
        if (buffer.length() > buffer2.length()) {
            return false;
        }
        int n = buffer2.getIndex();
        for (int i = buffer.getIndex(); i < buffer.putIndex(); ++i) {
            if (buffer.peek(i) == buffer2.peek(n++)) continue;
            return false;
        }
        return true;
    }

    public static String to8859_1_String(Buffer buffer) {
        if (buffer.isImmutable()) {
            return buffer.toString();
        }
        try {
            byte[] byArray = buffer.array();
            if (byArray != null) {
                return new String(byArray, buffer.getIndex(), buffer.length(), StringUtil.__ISO_8859_1);
            }
            StringBuffer stringBuffer = new StringBuffer(buffer.length());
            int n = buffer.getIndex();
            for (int i = 0; i < buffer.length(); ++i) {
                stringBuffer.append((char)(0x7F & buffer.peek(n)));
                ++n;
            }
            return stringBuffer.toString();
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            return buffer.toString();
        }
    }
}

