/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.bio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.mortbay.io.bio.StreamEndPoint;

public class StringEndPoint
extends StreamEndPoint {
    String _encoding = "UTF-8";
    ByteArrayInputStream _bin = new ByteArrayInputStream(new byte[0]);
    ByteArrayOutputStream _bout = new ByteArrayOutputStream();

    public StringEndPoint() {
        super(null, null);
        this._in = this._bin;
        this._out = this._bout;
    }

    public StringEndPoint(String string) throws IOException {
        this();
        if (string != null) {
            this._encoding = string;
        }
    }

    public void setInput(String string) {
        try {
            byte[] byArray = string.getBytes(this._encoding);
            this._bin = new ByteArrayInputStream(byArray);
            this._in = this._bin;
            this._bout = new ByteArrayOutputStream();
            this._out = this._bout;
        }
        catch (Exception exception) {
            throw new IllegalStateException(exception.toString());
        }
    }

    public String getOutput() {
        try {
            String string = new String(this._bout.toByteArray(), this._encoding);
            this._bout.reset();
            return string;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new IllegalStateException(this._encoding + ": " + exception.toString());
        }
    }

    public boolean hasMore() {
        return this._bin.available() > 0;
    }
}

