/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.nio;

import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import org.mortbay.component.AbstractLifeCycle;
import org.mortbay.io.Connection;
import org.mortbay.io.EndPoint;
import org.mortbay.io.nio.SelectChannelEndPoint;
import org.mortbay.log.Log;
import org.mortbay.thread.Timeout;

public abstract class SelectorManager
extends AbstractLifeCycle {
    private static final int __JVMBUG_THRESHHOLD = Integer.getInteger("org.mortbay.io.nio.JVMBUG_THRESHHOLD", 512);
    private static final int __MONITOR_PERIOD = Integer.getInteger("org.mortbay.io.nio.MONITOR_PERIOD", 1000);
    private static final int __MAX_SELECTS = Integer.getInteger("org.mortbay.io.nio.MAX_SELECTS", 15000);
    private static final int __BUSY_PAUSE = Integer.getInteger("org.mortbay.io.nio.BUSY_PAUSE", 50);
    private static final int __BUSY_KEY = Integer.getInteger("org.mortbay.io.nio.BUSY_KEY", -1);
    private boolean _delaySelectKeyUpdate = true;
    private long _maxIdleTime;
    private long _lowResourcesConnections;
    private long _lowResourcesMaxIdleTime;
    private transient SelectSet[] _selectSet;
    private int _selectSets = 1;
    private volatile int _set;

    public void setMaxIdleTime(long l) {
        this._maxIdleTime = l;
    }

    public void setSelectSets(int n) {
        long l = this._lowResourcesConnections * (long)this._selectSets;
        this._selectSets = n;
        this._lowResourcesConnections = l / (long)this._selectSets;
    }

    public long getMaxIdleTime() {
        return this._maxIdleTime;
    }

    public int getSelectSets() {
        return this._selectSets;
    }

    public boolean isDelaySelectKeyUpdate() {
        return this._delaySelectKeyUpdate;
    }

    public void register(SocketChannel socketChannel, Object object) throws IOException {
        int n = this._set++;
        n %= this._selectSets;
        SelectSet[] selectSetArray = this._selectSet;
        if (selectSetArray != null) {
            SelectSet selectSet = selectSetArray[n];
            selectSet.addChange(socketChannel, object);
            selectSet.wakeup();
        }
    }

    public void register(ServerSocketChannel serverSocketChannel) throws IOException {
        int n = this._set++;
        SelectSet selectSet = this._selectSet[n %= this._selectSets];
        selectSet.addChange(serverSocketChannel);
        selectSet.wakeup();
    }

    public long getLowResourcesConnections() {
        return this._lowResourcesConnections * (long)this._selectSets;
    }

    public void setLowResourcesConnections(long l) {
        this._lowResourcesConnections = (l + (long)this._selectSets - 1L) / (long)this._selectSets;
    }

    public long getLowResourcesMaxIdleTime() {
        return this._lowResourcesMaxIdleTime;
    }

    public void setLowResourcesMaxIdleTime(long l) {
        this._lowResourcesMaxIdleTime = l;
    }

    public void doSelect(int n) throws IOException {
        SelectSet[] selectSetArray = this._selectSet;
        if (selectSetArray != null && selectSetArray.length > n && selectSetArray[n] != null) {
            selectSetArray[n].doSelect();
        }
    }

    public void setDelaySelectKeyUpdate(boolean bl) {
        this._delaySelectKeyUpdate = bl;
    }

    protected abstract SocketChannel acceptChannel(SelectionKey var1) throws IOException;

    public abstract boolean dispatch(Runnable var1) throws IOException;

    protected void doStart() throws Exception {
        this._selectSet = new SelectSet[this._selectSets];
        for (int i = 0; i < this._selectSet.length; ++i) {
            this._selectSet[i] = new SelectSet(i);
        }
        super.doStart();
    }

    protected void doStop() throws Exception {
        SelectSet[] selectSetArray = this._selectSet;
        this._selectSet = null;
        if (selectSetArray != null) {
            for (int i = 0; i < selectSetArray.length; ++i) {
                SelectSet selectSet = selectSetArray[i];
                if (selectSet == null) continue;
                selectSet.stop();
            }
        }
        super.doStop();
    }

    protected abstract void endPointClosed(SelectChannelEndPoint var1);

    protected abstract void endPointOpened(SelectChannelEndPoint var1);

    protected abstract Connection newConnection(SocketChannel var1, SelectChannelEndPoint var2);

    protected abstract SelectChannelEndPoint newEndPoint(SocketChannel var1, SelectSet var2, SelectionKey var3) throws IOException;

    protected void connectionFailed(SocketChannel socketChannel, Throwable throwable, Object object) {
        Log.warn(throwable);
    }

    static /* synthetic */ long access$100(SelectorManager selectorManager) {
        return selectorManager._lowResourcesConnections;
    }

    static /* synthetic */ long access$200(SelectorManager selectorManager) {
        return selectorManager._lowResourcesMaxIdleTime;
    }

    static /* synthetic */ long access$300(SelectorManager selectorManager) {
        return selectorManager._maxIdleTime;
    }

    static /* synthetic */ int access$400() {
        return __BUSY_PAUSE;
    }

    static /* synthetic */ int access$500() {
        return __MAX_SELECTS;
    }

    static /* synthetic */ int access$600() {
        return __JVMBUG_THRESHHOLD;
    }

    static /* synthetic */ int access$700() {
        return __BUSY_KEY;
    }

    static /* synthetic */ SelectSet[] access$800(SelectorManager selectorManager) {
        return selectorManager._selectSet;
    }

    private static interface ChangeTask {
        public void run();
    }

    private static class ChangeSelectableChannel {
        final SelectableChannel _channel;
        final Object _attachment;

        public ChangeSelectableChannel(SelectableChannel selectableChannel, Object object) {
            this._channel = selectableChannel;
            this._attachment = object;
        }
    }

    public class SelectSet {
        private transient int _change;
        private transient List[] _changes;
        private transient Timeout _idleTimeout;
        private transient int _nextSet;
        private transient Timeout _retryTimeout;
        private transient Selector _selector;
        private transient int _setID;
        private volatile boolean _selecting;
        private transient int _jvmBug;
        private int _selects;
        private long _monitorStart;
        private long _monitorNext;
        private boolean _pausing;
        private SelectionKey _busyKey;
        private int _busyKeyCount;
        private long _log;
        private int _paused;
        private int _jvmFix0;
        private int _jvmFix1;
        private int _jvmFix2;

        SelectSet(int n) throws Exception {
            this._setID = n;
            this._idleTimeout = new Timeout((Object)this);
            this._idleTimeout.setDuration(SelectorManager.this.getMaxIdleTime());
            this._retryTimeout = new Timeout((Object)this);
            this._retryTimeout.setDuration(0L);
            this._selector = Selector.open();
            this._changes = new ArrayList[]{new ArrayList(), new ArrayList()};
            this._change = 0;
            this._monitorStart = System.currentTimeMillis();
            this._monitorNext = this._monitorStart + (long)__MONITOR_PERIOD;
            this._log = this._monitorStart + 60000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addChange(Object object) {
            List[] listArray = this._changes;
            synchronized (this._changes) {
                this._changes[this._change].add(object);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        public void addChange(SelectableChannel selectableChannel, Object object) {
            if (object == null) {
                this.addChange(selectableChannel);
            } else if (object instanceof EndPoint) {
                this.addChange(object);
            } else {
                this.addChange(new ChangeSelectableChannel(selectableChannel, object));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancelIdle(Timeout.Task task) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                task.cancel();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void doSelect() throws IOException {
            var1_1 = null;
            try {
                var2_2 = this._changes;
                synchronized (this._changes) {
                    block71: {
                        block73: {
                            block77: {
                                block76: {
                                    block74: {
                                        block75: {
                                            var3_4 = this._changes[this._change];
                                            this._change = this._change == 0 ? 1 : 0;
                                            this._selecting = true;
                                            var4_6 = this._selector;
                                            // ** MonitorExit[var2_2] (shouldn't be in output)
                                            for (var2_3 = 0; var2_3 < var3_4.size(); ++var2_3) {
                                                try {
                                                    var5_7 = var3_4.get(var2_3);
                                                    if (var5_7 instanceof EndPoint) {
                                                        var6_9 = (SelectChannelEndPoint)var5_7;
                                                        var6_9.doUpdateKey();
                                                        continue;
                                                    }
                                                    if (var5_7 instanceof Runnable) {
                                                        SelectorManager.this.dispatch((Runnable)var5_7);
                                                        continue;
                                                    }
                                                    if (var5_7 instanceof ChangeSelectableChannel) {
                                                        var6_9 = (ChangeSelectableChannel)var5_7;
                                                        var7_10 = var6_9._channel;
                                                        var8_11 = var6_9._attachment;
                                                        if (var7_10 instanceof SocketChannel && ((SocketChannel)var7_10).isConnected()) {
                                                            var1_1 = var7_10.register(var4_6, 1, var8_11);
                                                            var9_12 = SelectorManager.this.newEndPoint((SocketChannel)var7_10, this, var1_1);
                                                            var1_1.attach(var9_12);
                                                            var9_12.dispatch();
                                                            continue;
                                                        }
                                                        if (!var7_10.isOpen()) continue;
                                                        var7_10.register(var4_6, 8, var8_11);
                                                        continue;
                                                    }
                                                    if (var5_7 instanceof SocketChannel) {
                                                        var6_9 = (SocketChannel)var5_7;
                                                        if (var6_9.isConnected()) {
                                                            var1_1 = var6_9.register(var4_6, 1, null);
                                                            var7_10 = SelectorManager.this.newEndPoint((SocketChannel)var6_9, this, var1_1);
                                                            var1_1.attach(var7_10);
                                                            var7_10.dispatch();
                                                            continue;
                                                        }
                                                        if (!var6_9.isOpen()) continue;
                                                        var6_9.register(var4_6, 8, null);
                                                        continue;
                                                    }
                                                    if (var5_7 instanceof ServerSocketChannel) {
                                                        var6_9 = (ServerSocketChannel)var5_7;
                                                        var6_9.register(this.getSelector(), 16);
                                                        continue;
                                                    }
                                                    if (var5_7 instanceof ChangeTask == false) throw new IllegalArgumentException(var5_7.toString());
                                                    ((ChangeTask)var5_7).run();
                                                    continue;
                                                }
                                                catch (Exception var5_8) {
                                                    if (SelectorManager.this.isRunning()) {
                                                        Log.warn(var5_8);
                                                        continue;
                                                    }
                                                    Log.debug(var5_8);
                                                }
                                            }
                                            var3_4.clear();
                                            var10_13 = 0L;
                                            var12_14 = 0L;
                                            var14_15 = System.currentTimeMillis();
                                            var16_16 = this;
                                            synchronized (var16_16) {
                                                this._idleTimeout.setNow(var14_15);
                                                this._retryTimeout.setNow(var14_15);
                                                if (SelectorManager.access$100(SelectorManager.this) > 0L && (long)var4_6.keys().size() > SelectorManager.access$100(SelectorManager.this)) {
                                                    this._idleTimeout.setDuration(SelectorManager.access$200(SelectorManager.this));
                                                } else {
                                                    this._idleTimeout.setDuration(SelectorManager.access$300(SelectorManager.this));
                                                }
                                                var10_13 = this._idleTimeout.getTimeToNext();
                                                var12_14 = this._retryTimeout.getTimeToNext();
                                            }
                                            var18_17 = 1000L;
                                            if (var10_13 >= 0L && var18_17 > var10_13) {
                                                var18_17 = var10_13;
                                            }
                                            if (var18_17 > 0L && var12_14 >= 0L && var18_17 > var12_14) {
                                                var18_17 = var12_14;
                                            }
                                            if (var18_17 <= 2L) break block73;
                                            if (this._pausing) {
                                                try {
                                                    Thread.sleep(SelectorManager.access$400());
                                                }
                                                catch (InterruptedException var20_18) {
                                                    Log.ignore(var20_18);
                                                }
                                            }
                                            var21_20 = var14_15;
                                            var23_21 = var4_6.select(var18_17);
                                            var14_15 = System.currentTimeMillis();
                                            this._idleTimeout.setNow(var14_15);
                                            this._retryTimeout.setNow(var14_15);
                                            ++this._selects;
                                            if (var14_15 > this._monitorNext) {
                                                this._selects = (int)((long)(this._selects * SelectorManager.access$000()) / (var14_15 - this._monitorStart));
                                                v0 = this._pausing = this._selects > SelectorManager.access$500();
                                                if (this._pausing) {
                                                    ++this._paused;
                                                }
                                                this._selects = 0;
                                                this._jvmBug = 0;
                                                this._monitorStart = var14_15;
                                                this._monitorNext = var14_15 + (long)SelectorManager.access$000();
                                            }
                                            if (var14_15 > this._log) {
                                                if (this._paused > 0) {
                                                    Log.info(this + " Busy selector - injecting delay " + this._paused + " times");
                                                }
                                                if (this._jvmFix2 > 0) {
                                                    Log.info(this + " JVM BUG(s) - injecting delay" + this._jvmFix2 + " times");
                                                }
                                                if (this._jvmFix1 > 0) {
                                                    Log.info(this + " JVM BUG(s) - recreating selector " + this._jvmFix1 + " times, canceled keys " + this._jvmFix0 + " times");
                                                } else if (Log.isDebugEnabled() && this._jvmFix0 > 0) {
                                                    Log.info(this + " JVM BUG(s) - canceled keys " + this._jvmFix0 + " times");
                                                }
                                                this._paused = 0;
                                                this._jvmFix2 = 0;
                                                this._jvmFix1 = 0;
                                                this._jvmFix0 = 0;
                                                this._log = var14_15 + 60000L;
                                            }
                                            if (var23_21 != 0 || var18_17 <= 10L || var14_15 - var21_20 >= var18_17 / 2L) break block74;
                                            ++this._jvmBug;
                                            if (this._jvmBug <= SelectorManager.access$600()) break block75;
                                            try {
                                                if (this._jvmBug == SelectorManager.access$600() + 1) {
                                                    ++this._jvmFix2;
                                                }
                                                Thread.sleep(SelectorManager.access$400());
                                            }
                                            catch (InterruptedException var24_23) {
                                                Log.ignore(var24_23);
                                            }
                                            break block71;
                                        }
                                        if (this._jvmBug != SelectorManager.access$600()) ** GOTO lbl-1000
                                        var24_24 = this;
                                        synchronized (var24_24) {
                                            ++this._jvmFix1;
                                            var25_30 = Selector.open();
                                            var26_34 = this._selector.keys().iterator();
                                            while (true) {
                                                if (!var26_34.hasNext()) {
                                                    this._selector.close();
                                                    this._selector = var25_30;
                                                    return;
                                                }
                                                var27_36 = var26_34.next();
                                                if (!var27_36.isValid() || var27_36.interestOps() == 0) continue;
                                                var28_37 = var27_36.channel();
                                                var29_38 = var27_36.attachment();
                                                if (var29_38 == null) {
                                                    this.addChange(var28_37);
                                                    continue;
                                                }
                                                this.addChange(var28_37, var29_38);
                                            }
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            if (this._jvmBug % 32 != 31) break block71;
                                            var24_25 = 0;
                                            ** break block72
                                        }
                                    }
                                    if (SelectorManager.access$700() <= 0 || var23_21 != 1 || this._selects <= SelectorManager.access$500()) break block71;
                                    var24_26 = var4_6.selectedKeys().iterator().next();
                                    if (var24_26 != this._busyKey) break block76;
                                    if (++this._busyKeyCount > SelectorManager.access$700() && !(var24_26.channel() instanceof ServerSocketChannel)) {
                                        var25_32 = (SelectChannelEndPoint)var24_26.attachment();
                                        Log.warn("Busy Key " + var24_26.channel() + " " + var25_32);
                                        var24_26.cancel();
                                        if (var25_32 != null) {
                                            var25_32.close();
                                        }
                                    }
                                    break block77;
                                }
                                this._busyKeyCount = 0;
                            }
                            this._busyKey = var24_26;
                            break block71;
                        }
                        var4_6.selectNow();
                        ++this._selects;
                    }
                    if (this._selector == null) return;
                    if (!var4_6.isOpen()) {
                        return;
                    }
                    for (SelectionKey var1_1 : var4_6.selectedKeys()) {
                        try {
                            block79: {
                                block80: {
                                    block78: {
                                        if (!var1_1.isValid()) {
                                            var1_1.cancel();
                                            var31_39 = (SelectChannelEndPoint)var1_1.attachment();
                                            if (var31_39 == null) continue;
                                            var31_39.doUpdateKey();
                                            continue;
                                        }
                                        var31_39 = var1_1.attachment();
                                        if (!(var31_39 instanceof SelectChannelEndPoint)) break block78;
                                        var23_22 = (SelectChannelEndPoint)var31_39;
                                        var23_22.dispatch();
                                        break block79;
                                    }
                                    if (!var1_1.isAcceptable()) break block80;
                                    var23_22 = SelectorManager.this.acceptChannel(var1_1);
                                    if (var23_22 == null) continue;
                                    var23_22.configureBlocking(false);
                                    ++this._nextSet;
                                    this._nextSet %= SelectorManager.access$800(SelectorManager.this).length;
                                    if (this._nextSet == this._setID) {
                                        var24_27 = var23_22.register(SelectorManager.access$800(SelectorManager.this)[this._nextSet].getSelector(), 1);
                                        var25_32 = SelectorManager.this.newEndPoint((SocketChannel)var23_22, SelectorManager.access$800(SelectorManager.this)[this._nextSet], var24_27);
                                        var24_27.attach(var25_32);
                                        if (var25_32 != null) {
                                            var25_32.dispatch();
                                        }
                                        break block79;
                                    } else {
                                        SelectorManager.access$800(SelectorManager.this)[this._nextSet].addChange(var23_22);
                                        SelectorManager.access$800(SelectorManager.this)[this._nextSet].wakeup();
                                    }
                                    break block79;
                                }
                                if (var1_1.isConnectable()) {
                                    var23_22 = (SocketChannel)var1_1.channel();
                                    var24_28 = false;
                                    try {
                                        var24_28 = var23_22.finishConnect();
                                    }
                                    catch (Exception var25_33) {
                                        SelectorManager.this.connectionFailed((SocketChannel)var23_22, var25_33, var31_39);
                                    }
                                    finally {
                                        if (var24_28) {
                                            var1_1.interestOps(1);
                                            var25_32 = SelectorManager.this.newEndPoint((SocketChannel)var23_22, this, var1_1);
                                            var1_1.attach(var25_32);
                                            var25_32.dispatch();
                                        } else {
                                            var1_1.cancel();
                                        }
                                    }
                                } else {
                                    var23_22 = (SocketChannel)var1_1.channel();
                                    var24_29 = SelectorManager.this.newEndPoint((SocketChannel)var23_22, this, var1_1);
                                    var1_1.attach(var24_29);
                                    if (var1_1.isReadable()) {
                                        var24_29.dispatch();
                                    }
                                }
                            }
                            var1_1 = null;
                        }
                        catch (CancelledKeyException var31_40) {
                            Log.ignore(var31_40);
                        }
                        catch (Exception var31_41) {
                            if (SelectorManager.this.isRunning()) {
                                Log.warn(var31_41);
                            } else {
                                Log.ignore(var31_41);
                            }
                            if (var1_1 == null || var1_1.channel() instanceof ServerSocketChannel || !var1_1.isValid()) continue;
                            var1_1.interestOps(0);
                            var1_1.cancel();
                        }
                    }
                    var4_6.selectedKeys().clear();
                    this._idleTimeout.tick(var14_15);
                    this._retryTimeout.tick(var14_15);
                    return;
                }
            }
            catch (CancelledKeyException var3_5) {
                Log.ignore(var3_5);
                return;
            }
lbl-1000:
            // 1 sources

            {
                for (SelectionKey var26_35 : var4_6.keys()) {
                    if (!var26_35.isValid() || var26_35.interestOps() != 0) continue;
                    var26_35.cancel();
                    ++var24_25;
                }
                if (var24_25 > 0) {
                    ++this._jvmFix0;
                }
                this._selecting = false;
                return;
            }
            finally {
                this._selecting = false;
            }
        }

        public SelectorManager getManager() {
            return SelectorManager.this;
        }

        public long getNow() {
            return this._idleTimeout.getNow();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleIdle(Timeout.Task task) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                if (this._idleTimeout.getDuration() <= 0L) {
                    return;
                }
                task.schedule(this._idleTimeout);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void scheduleTimeout(Timeout.Task task, long l) {
            SelectSet selectSet = this;
            synchronized (selectSet) {
                this._retryTimeout.schedule(task, l);
            }
        }

        public void wakeup() {
            Selector selector = this._selector;
            if (selector != null) {
                selector.wakeup();
            }
        }

        Selector getSelector() {
            return this._selector;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stop() throws Exception {
            boolean bl = true;
            while (bl) {
                this.wakeup();
                bl = this._selecting;
            }
            ArrayList<SelectionKey> arrayList = new ArrayList<SelectionKey>(this._selector.keys());
            for (SelectionKey object2 : arrayList) {
                Object iOException;
                if (object2 == null || !((iOException = object2.attachment()) instanceof EndPoint)) continue;
                EndPoint endPoint = (EndPoint)iOException;
                try {
                    endPoint.close();
                }
                catch (IOException iOException2) {
                    Log.ignore(iOException2);
                }
            }
            SelectSet selectSet = this;
            synchronized (selectSet) {
                bl = this._selecting;
                while (bl) {
                    this.wakeup();
                    bl = this._selecting;
                }
                this._idleTimeout.cancelAll();
                this._retryTimeout.cancelAll();
                try {
                    if (this._selector != null) {
                        this._selector.close();
                    }
                }
                catch (IOException iOException) {
                    Log.ignore(iOException);
                }
                this._selector = null;
            }
        }
    }
}

