/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.log;

import org.mortbay.log.Logger;
import org.mortbay.util.DateCache;

public class StdErrLog
implements Logger {
    private static DateCache _dateCache;
    private static boolean __debug;
    private String _name;
    StringBuffer _buffer = new StringBuffer();

    public StdErrLog() {
        this(null);
    }

    public StdErrLog(String string) {
        this._name = string == null ? "" : string;
    }

    @Override
    public boolean isDebugEnabled() {
        return __debug;
    }

    @Override
    public void setDebugEnabled(boolean bl) {
        __debug = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void info(String string, Object object, Object object2) {
        String string2 = _dateCache.now();
        int n = _dateCache.lastMs();
        StringBuffer stringBuffer = this._buffer;
        synchronized (stringBuffer) {
            this.tag(string2, n, ":INFO:");
            this.format(string, object, object2);
            System.err.println(this._buffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void debug(String string, Throwable throwable) {
        if (__debug) {
            String string2 = _dateCache.now();
            int n = _dateCache.lastMs();
            StringBuffer stringBuffer = this._buffer;
            synchronized (stringBuffer) {
                this.tag(string2, n, ":DBUG:");
                this.format(string);
                this.format(throwable);
                System.err.println(this._buffer.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void debug(String string, Object object, Object object2) {
        if (__debug) {
            String string2 = _dateCache.now();
            int n = _dateCache.lastMs();
            StringBuffer stringBuffer = this._buffer;
            synchronized (stringBuffer) {
                this.tag(string2, n, ":DBUG:");
                this.format(string, object, object2);
                System.err.println(this._buffer.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void warn(String string, Object object, Object object2) {
        String string2 = _dateCache.now();
        int n = _dateCache.lastMs();
        StringBuffer stringBuffer = this._buffer;
        synchronized (stringBuffer) {
            this.tag(string2, n, ":WARN:");
            this.format(string, object, object2);
            System.err.println(this._buffer.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void warn(String string, Throwable throwable) {
        String string2 = _dateCache.now();
        int n = _dateCache.lastMs();
        StringBuffer stringBuffer = this._buffer;
        synchronized (stringBuffer) {
            this.tag(string2, n, ":WARN:");
            this.format(string);
            this.format(throwable);
            System.err.println(this._buffer.toString());
        }
    }

    private void tag(String string, int n, String string2) {
        this._buffer.setLength(0);
        this._buffer.append(string);
        if (n > 99) {
            this._buffer.append('.');
        } else if (n > 9) {
            this._buffer.append(".0");
        } else {
            this._buffer.append(".00");
        }
        this._buffer.append(n).append(string2).append(this._name).append(':');
    }

    private void format(String string, Object object, Object object2) {
        int n;
        int n2 = string.indexOf("{}");
        int n3 = n = n2 < 0 ? -1 : string.indexOf("{}", n2 + 2);
        if (n2 >= 0) {
            this.format(string.substring(0, n2));
            this.format(String.valueOf(object));
            if (n >= 0) {
                this.format(string.substring(n2 + 2, n));
                this.format(String.valueOf(object2));
                this.format(string.substring(n + 2));
            } else {
                this.format(string.substring(n2 + 2));
                if (object2 != null) {
                    this._buffer.append(' ');
                    this.format(String.valueOf(object2));
                }
            }
        } else {
            this.format(string);
            if (object != null) {
                this._buffer.append(' ');
                this.format(String.valueOf(object));
            }
            if (object2 != null) {
                this._buffer.append(' ');
                this.format(String.valueOf(object2));
            }
        }
    }

    private void format(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (Character.isISOControl(c)) {
                if (c == '\n') {
                    this._buffer.append('|');
                    continue;
                }
                if (c == '\r') {
                    this._buffer.append('<');
                    continue;
                }
                this._buffer.append('?');
                continue;
            }
            this._buffer.append(c);
        }
    }

    private void format(Throwable throwable) {
        this._buffer.append('\n');
        this.format(throwable.toString());
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; stackTraceElementArray != null && i < stackTraceElementArray.length; ++i) {
            this._buffer.append("\n\tat ");
            this.format(stackTraceElementArray[i].toString());
        }
    }

    @Override
    public Logger getLogger(String string) {
        if (string == null && this._name == null || string != null && string.equals(this._name)) {
            return this;
        }
        return new StdErrLog(string);
    }

    public String toString() {
        return "STDERR" + this._name;
    }

    static {
        __debug = System.getProperty("DEBUG", null) != null;
        try {
            _dateCache = new DateCache("yyyy-MM-dd HH:mm:ss");
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

