/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import com.google.appengine.repackaged.org.apache.commons.logging.Log;
import java.io.File;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.mortbay.log.LogFactory;
import org.mortbay.util.JarResource;
import org.mortbay.util.LogSupport;

class JarFileResource
extends JarResource {
    private static Log log = LogFactory.getLog(JarFileResource.class);
    transient JarFile _jarFile;
    transient File _file;
    transient String[] _list;
    transient JarEntry _entry;
    transient boolean _directory;
    transient String _jarUrl;
    transient String _path;
    transient boolean _exists;

    JarFileResource(URL url) {
        super(url);
    }

    public synchronized void release() {
        this._list = null;
        this._entry = null;
        this._file = null;
        this._jarFile = null;
        super.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean checkConnection() {
        try {
            super.checkConnection();
        }
        finally {
            if (this._jarConnection == null) {
                this._entry = null;
                this._file = null;
                this._jarFile = null;
                this._list = null;
            }
        }
        return this._jarFile != null;
    }

    protected void newConnection() throws IOException {
        super.newConnection();
        this._entry = null;
        this._file = null;
        this._jarFile = null;
        this._list = null;
        int sep = this._urlString.indexOf("!/");
        this._jarUrl = this._urlString.substring(0, sep + 2);
        this._path = this._urlString.substring(sep + 2);
        if (this._path.length() == 0) {
            this._path = null;
        }
        this._jarFile = this._jarConnection.getJarFile();
        this._file = new File(this._jarFile.getName());
    }

    public boolean exists() {
        if (this._exists) {
            return true;
        }
        if (this._urlString.endsWith("!/")) {
            String file_url = this._urlString.substring(4, this._urlString.length() - 2);
            try {
                return JarFileResource.newResource(file_url).exists();
            }
            catch (Exception e) {
                LogSupport.ignore(log, e);
                return false;
            }
        }
        boolean check = this.checkConnection();
        if (this._jarUrl != null && this._path == null) {
            this._directory = check;
            return true;
        }
        JarFile jarFile = null;
        if (check) {
            jarFile = this._jarFile;
        } else {
            try {
                jarFile = ((JarURLConnection)new URL(this._jarUrl).openConnection()).getJarFile();
            }
            catch (Exception e) {
                LogSupport.ignore(log, e);
            }
        }
        if (jarFile != null && this._entry == null && !this._directory) {
            Enumeration<JarEntry> e = jarFile.entries();
            while (e.hasMoreElements()) {
                JarEntry entry = e.nextElement();
                String name = entry.getName().replace('\\', '/');
                if (name.equals(this._path)) {
                    this._entry = entry;
                    this._directory = this._path.endsWith("/");
                    break;
                }
                if (this._path.endsWith("/")) {
                    if (!name.startsWith(this._path)) continue;
                    this._directory = true;
                    break;
                }
                if (!name.startsWith(this._path) || name.length() <= this._path.length() || name.charAt(this._path.length()) != '/') continue;
                this._directory = true;
                break;
            }
        }
        this._exists = this._directory || this._entry != null;
        return this._exists;
    }

    public boolean isDirectory() {
        return this._urlString.endsWith("/") || this.exists() && this._directory;
    }

    public long lastModified() {
        if (this.checkConnection() && this._file != null) {
            return this._file.lastModified();
        }
        return -1L;
    }

    public synchronized String[] list() {
        if (this.isDirectory() && this._list == null) {
            ArrayList<String> list = new ArrayList<String>(32);
            this.checkConnection();
            JarFile jarFile = this._jarFile;
            if (jarFile == null) {
                try {
                    jarFile = ((JarURLConnection)new URL(this._jarUrl).openConnection()).getJarFile();
                }
                catch (Exception e) {
                    LogSupport.ignore(log, e);
                }
            }
            Enumeration<JarEntry> e = jarFile.entries();
            String dir = this._urlString.substring(this._urlString.indexOf("!/") + 2);
            while (e.hasMoreElements()) {
                String listName;
                int dash;
                JarEntry entry = e.nextElement();
                String name = entry.getName().replace('\\', '/');
                if (!name.startsWith(dir) || name.length() == dir.length() || (dash = (listName = name.substring(dir.length())).indexOf(47)) >= 0 && list.contains(listName = listName.substring(0, dash + 1))) continue;
                list.add(listName);
            }
            this._list = new String[list.size()];
            list.toArray(this._list);
        }
        return this._list;
    }

    public long length() {
        if (this.isDirectory()) {
            return -1L;
        }
        if (this._entry != null) {
            return this._entry.getSize();
        }
        return -1L;
    }

    public String encode(String uri) {
        return uri;
    }
}

