/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util.ajax;

import java.lang.reflect.Method;
import java.util.Map;
import org.mortbay.log.Log;
import org.mortbay.util.Loader;
import org.mortbay.util.ajax.JSON;

public class JSONEnumConvertor
implements JSON.Convertor {
    private boolean _fromJSON;
    private Method _valueOf;

    public JSONEnumConvertor() {
        this(false);
    }

    public JSONEnumConvertor(boolean bl) {
        try {
            Class clazz = Loader.loadClass(this.getClass(), "java.lang.Enum");
            this._valueOf = clazz.getMethod("valueOf", Class.class, String.class);
        }
        catch (Exception exception) {
            throw new RuntimeException("!Enums", exception);
        }
        this._fromJSON = bl;
    }

    @Override
    public Object fromJSON(Map map) {
        if (!this._fromJSON) {
            throw new UnsupportedOperationException();
        }
        try {
            Class clazz = Loader.loadClass(this.getClass(), (String)map.get("class"));
            return this._valueOf.invoke(null, clazz, map.get("value"));
        }
        catch (Exception exception) {
            Log.warn(exception);
            return null;
        }
    }

    @Override
    public void toJSON(Object object, JSON.Output output) {
        if (this._fromJSON) {
            output.addClass(object.getClass());
            output.add("value", object.toString());
        } else {
            output.add(object.toString());
        }
    }
}

