/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.repackaged.com.google.protobuf;

import com.google.appengine.repackaged.com.google.protobuf.FieldType;
import com.google.appengine.repackaged.com.google.protobuf.Int2ObjectHashMap;
import com.google.appengine.repackaged.com.google.protobuf.Internal;
import com.google.appengine.repackaged.com.google.protobuf.MessageInfo;
import com.google.appengine.repackaged.com.google.protobuf.MessageLite;
import com.google.appengine.repackaged.com.google.protobuf.ProtoSyntax;
import com.google.appengine.repackaged.com.google.protobuf.SchemaUtil;
import java.lang.reflect.Field;

final class RawMessageInfo
implements MessageInfo {
    private final MessageLite defaultInstance;
    private final String info;
    private final RawMessageInfoReader reader;

    RawMessageInfo(MessageLite defaultInstance, String info, Object[] objects) {
        this.defaultInstance = defaultInstance;
        this.info = info;
        this.reader = new RawMessageInfoReader(defaultInstance.getClass(), info, objects);
    }

    RawMessageInfoReader getReader() {
        return this.reader;
    }

    String getStringInfo() {
        return this.info;
    }

    Object[] getObjects() {
        return this.reader.objects;
    }

    @Override
    public ProtoSyntax getSyntax() {
        return (this.reader.flags & 1) == 1 ? ProtoSyntax.PROTO2 : ProtoSyntax.PROTO3;
    }

    @Override
    public boolean isMessageSetWireFormat() {
        return (this.reader.flags & 2) == 2;
    }

    @Override
    public MessageLite getDefaultInstance() {
        return this.defaultInstance;
    }

    @Override
    public boolean shouldUseTableSwitch() {
        return SchemaUtil.shouldUseTableSwitch(this.reader.minFieldNumber, this.reader.maxFieldNumber, this.reader.fieldCount);
    }

    public int getMinFieldNumber() {
        return this.reader.minFieldNumber;
    }

    public int getMaxFieldNumber() {
        return this.reader.maxFieldNumber;
    }

    public int getFieldCount() {
        return this.reader.fieldCount;
    }

    public int getMapFieldCount() {
        return this.reader.mapFieldCount;
    }

    public int getRepeatedFieldCount() {
        return this.reader.repeatedFieldCount;
    }

    int[] getCheckInitialized() {
        return this.reader.checkInitialized;
    }

    static final class RawMessageInfoReader {
        private final StringToIntDecoder decoder;
        private final Object[] objects;
        private Class<?> messageClass;
        private final int flags;
        private final int fieldCount;
        private final int oneofCount;
        private final int hasBitsCount;
        private final int minFieldNumber;
        private final int maxFieldNumber;
        private final int mapFieldCount;
        private final int repeatedFieldCount;
        private final int[] checkInitialized;
        private int objectsPosition;
        private int checkInitializedPosition;
        private int fieldNumber;
        private int fieldTypeWithExtraBits;
        private int fieldType;
        private int oneofIndex;
        private int hasBitsIndex;
        private Field field;
        private Int2ObjectHashMap<Class<?>> messageFieldClassMap = Int2ObjectHashMap.getEmptyInstance();
        private Int2ObjectHashMap<Internal.EnumLiteMap<?>> enumFieldMap = Int2ObjectHashMap.getEmptyInstance();
        private Int2ObjectHashMap<Object> mapFieldDefaultEntryMap = Int2ObjectHashMap.getEmptyInstance();

        RawMessageInfoReader(Class<?> messageClass, String info, Object[] objects) {
            this.messageClass = messageClass;
            this.decoder = new StringToIntDecoder(info);
            this.objects = objects;
            this.flags = this.nextInt();
            this.fieldCount = this.nextInt();
            if (this.fieldCount == 0) {
                this.oneofCount = 0;
                this.hasBitsCount = 0;
                this.minFieldNumber = 0;
                this.maxFieldNumber = 0;
                this.mapFieldCount = 0;
                this.repeatedFieldCount = 0;
                this.checkInitialized = null;
            } else {
                this.oneofCount = this.nextInt();
                this.hasBitsCount = this.nextInt();
                this.minFieldNumber = this.nextInt();
                this.maxFieldNumber = this.nextInt();
                this.mapFieldCount = this.nextInt();
                this.repeatedFieldCount = this.nextInt();
                this.checkInitialized = this.allocateCheckInitialized();
                this.objectsPosition = this.oneofCount * 2 + this.hasBitsCount;
            }
        }

        private int nextInt() {
            return this.decoder.next();
        }

        private Object nextObject() {
            return this.objects[this.objectsPosition++];
        }

        boolean next() {
            if (!this.decoder.hasNext()) {
                return false;
            }
            this.fieldNumber = this.nextInt();
            this.fieldTypeWithExtraBits = this.nextInt();
            this.fieldType = this.fieldTypeWithExtraBits & 0xFF;
            if (this.needsIsInitializedCheck()) {
                this.checkInitialized[this.checkInitializedPosition++] = this.fieldNumber;
            }
            if (this.isOneof()) {
                this.oneofIndex = this.nextInt();
                if (this.fieldType == FieldType.MESSAGE.id() + 51 || this.fieldType == FieldType.GROUP.id() + 51) {
                    this.addToMessageFieldClassMap(this.fieldNumber, (Class)this.nextObject());
                } else if (this.fieldType == FieldType.ENUM.id() + 51 && this.isProto2()) {
                    this.addToEnumFieldMap(this.fieldNumber, (Internal.EnumLiteMap)this.nextObject());
                }
            } else {
                this.field = RawMessageInfoReader.reflectField(this.messageClass, (String)this.nextObject());
                if (this.hasFieldPresence()) {
                    this.hasBitsIndex = this.nextInt();
                }
                if (this.fieldType == FieldType.MESSAGE.id() || this.fieldType == FieldType.GROUP.id()) {
                    this.addToMessageFieldClassMap(this.fieldNumber, this.field.getType());
                } else if (this.fieldType == FieldType.MESSAGE_LIST.id() || this.fieldType == FieldType.GROUP_LIST.id()) {
                    this.addToMessageFieldClassMap(this.fieldNumber, (Class)this.nextObject());
                } else if (this.fieldType == FieldType.ENUM.id() || this.fieldType == FieldType.ENUM_LIST.id() || this.fieldType == FieldType.ENUM_LIST_PACKED.id()) {
                    if (this.isProto2()) {
                        this.addToEnumFieldMap(this.fieldNumber, (Internal.EnumLiteMap)this.nextObject());
                    }
                } else if (this.fieldType == FieldType.MAP.id()) {
                    this.addToMapFieldDefaultEntryMap(this.fieldNumber, this.nextObject());
                    if (this.isMapFieldWithProto2Enum()) {
                        this.addToEnumFieldMap(this.fieldNumber, (Internal.EnumLiteMap)this.nextObject());
                    }
                }
            }
            return true;
        }

        int getFieldNumber() {
            return this.fieldNumber;
        }

        int getFieldType() {
            return this.fieldType;
        }

        boolean isProto2() {
            return (this.flags & 1) == 1;
        }

        boolean isOneof() {
            return this.fieldType > FieldType.MAP.id();
        }

        Field getOneofField() {
            int index = this.oneofIndex * 2;
            Object o = this.objects[index];
            if (o instanceof Field) {
                return (Field)o;
            }
            Field f = RawMessageInfoReader.reflectField(this.messageClass, (String)o);
            this.objects[index] = f;
            return f;
        }

        Field getOneofCaseField() {
            int index = this.oneofIndex * 2 + 1;
            Object o = this.objects[index];
            if (o instanceof Field) {
                return (Field)o;
            }
            Field f = RawMessageInfoReader.reflectField(this.messageClass, (String)o);
            this.objects[index] = f;
            return f;
        }

        Field getField() {
            return this.field;
        }

        boolean hasFieldPresence() {
            return this.isProto2() && this.fieldType <= FieldType.GROUP.id();
        }

        Field getHasBitsField() {
            int index = this.oneofCount * 2 + this.hasBitsIndex / 32;
            Object o = this.objects[index];
            if (o instanceof Field) {
                return (Field)o;
            }
            Field f = RawMessageInfoReader.reflectField(this.messageClass, (String)o);
            this.objects[index] = f;
            return f;
        }

        int getHasBitsMaskShift() {
            return this.hasBitsIndex % 32;
        }

        boolean isRequired() {
            return (this.fieldTypeWithExtraBits & 0x100) != 0;
        }

        boolean isEnforceUtf8() {
            return (this.fieldTypeWithExtraBits & 0x200) != 0;
        }

        boolean needsIsInitializedCheck() {
            return (this.fieldTypeWithExtraBits & 0x400) != 0;
        }

        boolean isMapFieldWithProto2Enum() {
            return (this.fieldTypeWithExtraBits & 0x800) != 0;
        }

        private void assertDone() {
            if (this.decoder.hasNext()) {
                int n = this.decoder.position;
                int n2 = this.decoder.info.length();
                throw new IllegalStateException(new StringBuilder(66).append("decoder position = ").append(n).append(" is not at end (length = ").append(n2).toString());
            }
            if (this.objects != null && this.objectsPosition != this.objects.length) {
                int n = this.objectsPosition;
                int n3 = this.objects.length;
                throw new IllegalStateException(new StringBuilder(65).append("objectsPosition = ").append(n).append(" is not at end (length = ").append(n3).toString());
            }
            if (this.checkInitialized != null && this.checkInitializedPosition != this.checkInitialized.length) {
                int n = this.checkInitializedPosition;
                int n4 = this.checkInitialized.length;
                throw new IllegalStateException(new StringBuilder(74).append("checkInitializedPosition = ").append(n).append(" is not at end (length = ").append(n4).toString());
            }
        }

        private int[] allocateCheckInitialized() {
            int len = this.nextInt();
            if (len == 0) {
                return null;
            }
            return new int[len];
        }

        private void addToMessageFieldClassMap(int key, Class<?> value) {
            if (this.messageFieldClassMap == Int2ObjectHashMap.getEmptyInstance()) {
                this.messageFieldClassMap = new Int2ObjectHashMap();
            }
            this.messageFieldClassMap.put(key, value);
        }

        Int2ObjectHashMap<Class<?>> getMessageFieldClassMap() {
            this.assertDone();
            return this.messageFieldClassMap;
        }

        private void addToEnumFieldMap(int key, Internal.EnumLiteMap<?> value) {
            if (this.enumFieldMap == Int2ObjectHashMap.getEmptyInstance()) {
                this.enumFieldMap = new Int2ObjectHashMap();
            }
            this.enumFieldMap.put(key, value);
        }

        Int2ObjectHashMap<Internal.EnumLiteMap<?>> getEnumFieldMap() {
            this.assertDone();
            return this.enumFieldMap;
        }

        private void addToMapFieldDefaultEntryMap(int key, Object value) {
            if (this.mapFieldDefaultEntryMap == Int2ObjectHashMap.getEmptyInstance()) {
                this.mapFieldDefaultEntryMap = new Int2ObjectHashMap();
            }
            this.mapFieldDefaultEntryMap.put(key, value);
        }

        Int2ObjectHashMap<Object> getMapFieldDefaultEntryMap() {
            this.assertDone();
            return this.mapFieldDefaultEntryMap;
        }

        private static Field reflectField(Class<?> messageClass, String fieldName) {
            try {
                return messageClass.getDeclaredField(fieldName);
            }
            catch (NoSuchFieldException e) {
                throw new RuntimeException(e);
            }
        }

        static final class StringToIntDecoder {
            private final String info;
            private int position;

            StringToIntDecoder(String info) {
                this.info = info;
                this.position = 0;
            }

            boolean hasNext() {
                return this.position < this.info.length();
            }

            int next() {
                char value;
                if ((value = this.info.charAt(this.position++)) < '\ud800') {
                    return value;
                }
                int result = value & 0x1FFF;
                int shift = 13;
                while ((value = this.info.charAt(this.position++)) >= '\ud800') {
                    result |= (value & 0x1FFF) << shift;
                    shift += 13;
                }
                return result | value << shift;
            }
        }
    }
}

