/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools;

import com.google.appengine.tools.admin.OutputPump;
import com.google.appengine.tools.development.DevAppServerMain;
import com.google.appengine.tools.info.AppengineSdk;
import com.google.apphosting.utils.config.AppEngineConfigException;
import com.google.apphosting.utils.config.AppEngineWebXml;
import com.google.apphosting.utils.config.AppEngineWebXmlReader;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;

public class KickStart {
    private static final Logger logger = Logger.getLogger(KickStart.class.getName());
    private static final String NO_JAVA_AGENT_FLAG = "--no_java_agent";
    private static final String JVM_FLAG = "--jvm_flag";
    private static final String JVM_FLAG_ERROR_MESSAGE = "--jvm_flag=<flag> expected.\n--jvm_flag may be repeated to supply multiple flags";
    private static final String START_ON_FIRST_THREAD_FLAG = "--startOnFirstThread";
    private static final String START_ON_FIRST_THREAD_ERROR_MESSAGE = "--startOnFirstThread=<boolean> expected";
    private static final String SDK_ROOT_FLAG = "--sdk_root";
    private static final String SDK_ROOT_ERROR_MESSAGE = "--sdk_root=<path> expected";
    private static final String ENABLE_JACOCO_FLAG = "--enable_jacoco";
    private static final String ENABLE_JACOCO_ERROR_MESSAGE = "--enable_jacoco=true|false expected.";
    private static final String JACOCO_AGENT_JAR_FLAG = "--jacoco_agent_jar";
    private static final String JACOCO_AGENT_JAR_ERROR_MESSAGE = "--jacoco_agent_jar=<path> expected.";
    private static final String JACOCO_AGENT_ARGS_FLAG = "--jacoco_agent_args";
    private static final String JACOCO_AGENT_ARGS_ERROR_MESSAGE = "--jacoco_agent_args=<jacoco agent args> expected.";
    private static final String JACOCO_EXEC_FLAG = "--jacoco_exec";
    private static final String JACOCO_EXEC_ERROR_MESSAGE = "--jacoco_exec=<path> expected.";
    private Process serverProcess = null;

    public static void main(String[] args) {
        new KickStart(args);
    }

    private KickStart(String[] args) {
        String string;
        String encoding;
        String classpath;
        String entryClass = null;
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        String home = System.getProperty("java.home");
        String string2 = File.separator;
        String string3 = File.separator;
        String javaExe = new StringBuilder(7 + String.valueOf(home).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(home).append(string2).append("bin").append(string3).append("java").toString();
        ArrayList<String> jvmArgs = new ArrayList<String>();
        ArrayList<String> appServerArgs = new ArrayList<String>();
        boolean enableJacoco = false;
        String jacocoAgentJarArg = null;
        String jacocoAgentArgs = "";
        String jacocoExecArg = "jacoco.exec";
        List<String> command = builder.command();
        command.add(javaExe);
        boolean startOnFirstThread = System.getProperty("os.name").equalsIgnoreCase("Mac OS X");
        boolean noJavaAgent = false;
        boolean testMode = false;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith(NO_JAVA_AGENT_FLAG)) {
                noJavaAgent = true;
            }
            if (args[i].startsWith(JVM_FLAG)) {
                jvmArgs.add(KickStart.extractValue(args[i], JVM_FLAG_ERROR_MESSAGE));
                continue;
            }
            if (args[i].startsWith(START_ON_FIRST_THREAD_FLAG)) {
                startOnFirstThread = Boolean.valueOf(KickStart.extractValue(args[i], START_ON_FIRST_THREAD_ERROR_MESSAGE));
                continue;
            }
            if (args[i].startsWith(ENABLE_JACOCO_FLAG)) {
                enableJacoco = "true".equals(KickStart.extractValue(args[i], ENABLE_JACOCO_ERROR_MESSAGE));
                continue;
            }
            if (args[i].startsWith(JACOCO_AGENT_JAR_FLAG)) {
                jacocoAgentJarArg = KickStart.extractValue(args[i], JACOCO_AGENT_JAR_ERROR_MESSAGE);
                continue;
            }
            if (args[i].startsWith(JACOCO_AGENT_ARGS_FLAG)) {
                jacocoAgentArgs = KickStart.extractValue(args[i], JACOCO_AGENT_ARGS_ERROR_MESSAGE);
                continue;
            }
            if (args[i].startsWith(JACOCO_EXEC_FLAG)) {
                jacocoExecArg = KickStart.extractValue(args[i], JACOCO_EXEC_ERROR_MESSAGE);
                continue;
            }
            if (args[i].equals("--test_mode")) {
                testMode = true;
                continue;
            }
            if (entryClass == null) {
                if (args[i].charAt(0) == '-') {
                    String string4 = String.valueOf(args[i]);
                    throw new IllegalArgumentException(string4.length() != 0 ? "Only --jvm_flag may precede classname, not ".concat(string4) : new String("Only --jvm_flag may precede classname, not "));
                }
                entryClass = args[i];
                if (entryClass.equals(DevAppServerMain.class.getName()) || testMode) continue;
                throw new IllegalArgumentException("KickStart only works for DevAppServerMain");
            }
            appServerArgs.add(args[i]);
        }
        if (entryClass == null) {
            throw new IllegalArgumentException("missing entry classname");
        }
        File newWorkingDir = KickStart.newWorkingDir(appServerArgs.toArray(new String[appServerArgs.size()]));
        builder.directory(newWorkingDir);
        if (startOnFirstThread) {
            jvmArgs.add("-XstartOnFirstThread");
        }
        if ((classpath = System.getProperty("java.class.path")) == null) {
            throw new IllegalArgumentException("classpath must not be null");
        }
        StringBuilder newClassPath = new StringBuilder();
        String[] paths = classpath.split(File.pathSeparator);
        for (int i = 0; i < paths.length; ++i) {
            newClassPath.append(new File(paths[i]).getAbsolutePath());
            if (i == paths.length - 1) continue;
            newClassPath.append(File.pathSeparator);
        }
        String appDir = null;
        ArrayList<String> absoluteAppServerArgs = new ArrayList<String>(appServerArgs.size());
        for (int i = 0; i < appServerArgs.size(); ++i) {
            File file;
            String arg = (String)appServerArgs.get(i);
            if (arg.startsWith(SDK_ROOT_FLAG)) {
                String sdkRoot = new File(KickStart.extractValue(arg, SDK_ROOT_ERROR_MESSAGE)).getAbsolutePath();
                String string5 = String.valueOf("--sdk_root=");
                String string6 = String.valueOf(sdkRoot);
                arg = string6.length() != 0 ? string5.concat(string6) : new String(string5);
            } else if (i == appServerArgs.size() - 1 && !arg.startsWith("-") && (file = new File(arg)).exists()) {
                appDir = arg = new File(arg).getAbsolutePath();
            }
            absoluteAppServerArgs.add(arg);
        }
        AppEnvironment appEnvironment = KickStart.readAppEnvironment(appDir);
        if (appEnvironment.isVMRuntime || appEnvironment.isJava8) {
            noJavaAgent = true;
            jvmArgs.add("-D--enable_all_permissions=true");
        }
        if (appEnvironment.isJava8) {
            jvmArgs.add("-Duse_jetty9_runtime=true");
        }
        if ((encoding = appEnvironment.encoding) == null && appEnvironment.isJava8) {
            encoding = "UTF-8";
        }
        if (encoding != null) {
            String string7 = String.valueOf(encoding);
            jvmArgs.add(string7.length() != 0 ? "-Dfile.encoding=".concat(string7) : new String("-Dfile.encoding="));
        }
        if (!noJavaAgent) {
            String agentJar = AppengineSdk.getSdk().getAgentJarFile().getAbsolutePath();
            if (enableJacoco) {
                jvmArgs.add("-D--enable_all_permissions=true");
                String jacocoAgentJar = new File(jacocoAgentJarArg).getAbsolutePath();
                if (!jacocoAgentArgs.isEmpty()) {
                    jacocoAgentArgs = String.valueOf(jacocoAgentArgs).concat(",");
                }
                string = jacocoAgentArgs;
                String string8 = new File(jacocoExecArg).getAbsolutePath();
                string = jacocoAgentArgs = new StringBuilder(9 + String.valueOf(string).length() + String.valueOf(string8).length()).append(string).append("destfile=").append(string8).toString();
                jvmArgs.add(new StringBuilder(12 + String.valueOf(jacocoAgentJar).length() + String.valueOf(string).length()).append("-javaagent:").append(jacocoAgentJar).append("=").append(string).toString());
                if (newClassPath.length() > 0) {
                    newClassPath.append(File.pathSeparator);
                }
                newClassPath.append(agentJar);
            } else {
                String string9 = String.valueOf(agentJar);
                jvmArgs.add(string9.length() != 0 ? "-javaagent:".concat(string9) : new String("-javaagent:"));
            }
        }
        command.addAll(jvmArgs);
        command.add("-classpath");
        command.add(newClassPath.toString());
        command.add(entryClass);
        String string10 = String.valueOf(System.getProperty("user.dir"));
        command.add(string10.length() != 0 ? "--property=kickstart.user.dir=".concat(string10) : new String("--property=kickstart.user.dir="));
        if (appEnvironment.isVMRuntime || appEnvironment.isJava8) {
            command.add(NO_JAVA_AGENT_FLAG);
        }
        command.addAll(absoluteAppServerArgs);
        String gaeEnv = "localdev";
        String gaeRuntime = "java7";
        if (appEnvironment.isJava8) {
            gaeRuntime = "java8";
        }
        builder.environment().put("GAE_ENV", gaeEnv);
        builder.environment().put("GAE_RUNTIME", gaeRuntime);
        builder.environment().put("GAE_SERVICE", appEnvironment.serviceName);
        builder.environment().put("GAE_INSTANCE", UUID.randomUUID().toString());
        string = String.valueOf(command);
        logger.logp(Level.FINE, "com.google.appengine.tools.KickStart", "<init>", new StringBuilder(10 + String.valueOf(string).length()).append("Executing ").append(string).toString());
        string = String.valueOf(command);
        System.out.println(new StringBuilder(10 + String.valueOf(string).length()).append("Executing ").append(string).toString());
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                if (KickStart.this.serverProcess != null) {
                    KickStart.this.serverProcess.destroy();
                }
            }
        });
        try {
            this.serverProcess = builder.start();
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to start the process", e);
        }
        new Thread(new OutputPump(this.serverProcess.getInputStream(), new PrintWriter(System.out, true))).start();
        new Thread(new OutputPump(this.serverProcess.getErrorStream(), new PrintWriter(System.err, true))).start();
        try {
            this.serverProcess.waitFor();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.serverProcess.destroy();
        this.serverProcess = null;
    }

    private static String extractValue(String argument, String errorMessage) {
        int indexOfEqualSign = argument.indexOf(61);
        if (indexOfEqualSign == -1) {
            throw new IllegalArgumentException(errorMessage);
        }
        return argument.substring(argument.indexOf(61) + 1);
    }

    private static File newWorkingDir(String[] args) {
        if (args.length < 1 || args[args.length - 1].startsWith("-")) {
            new DevAppServerMain().printHelp(System.out);
            System.exit(1);
        }
        File workingDir = new File(args[args.length - 1]);
        new DevAppServerMain().validateWarPath(workingDir);
        return workingDir;
    }

    private static boolean isVMRuntime(AppEngineWebXml appEngineWebXml) {
        return appEngineWebXml.getUseVm() || appEngineWebXml.isFlexible();
    }

    private static boolean isJava8(AppEngineWebXml appEngineWebXml) {
        String runtime = appEngineWebXml.getRuntime();
        return runtime != null ? runtime.startsWith("java8") : false;
    }

    static AppEnvironment readAppEnvironment(String appDir) {
        if (appDir == null) {
            return AppEnvironment.DEFAULT;
        }
        ArrayList<AppEngineWebXml> configs = new ArrayList<AppEngineWebXml>();
        File config = new File(appDir, "WEB-INF/appengine-web.xml");
        if (config.exists()) {
            try {
                configs.add(new AppEngineWebXmlReader(appDir).readAppEngineWebXml());
            }
            catch (AppEngineConfigException e) {
                String string = String.valueOf(config.getAbsolutePath());
                System.err.println(string.length() != 0 ? "Error reading module: ".concat(string) : new String("Error reading module: "));
                return AppEnvironment.DEFAULT;
            }
        } else {
            File ear = new File(appDir);
            if (!ear.exists()) {
                String string = String.valueOf(ear.getAbsolutePath());
                System.err.println(string.length() != 0 ? "Application does not exist: ".concat(string) : new String("Application does not exist: "));
                return AppEnvironment.DEFAULT;
            }
            for (File war : ear.listFiles()) {
                File file = new File(war, "WEB-INF/appengine-web.xml");
                if (!file.exists()) continue;
                try {
                    configs.add(new AppEngineWebXmlReader(war.getAbsolutePath()).readAppEngineWebXml());
                }
                catch (AppEngineConfigException e) {
                    String string = String.valueOf(war.getAbsolutePath());
                    System.err.println(string.length() != 0 ? "Error reading module: ".concat(string) : new String("Error reading module: "));
                }
            }
        }
        boolean isVMRuntime = false;
        boolean isJava8 = false;
        String serviceName = "default";
        String encoding = null;
        for (AppEngineWebXml appEngineWebXml : configs) {
            Map<String, String> systemProperties;
            isVMRuntime |= KickStart.isVMRuntime(appEngineWebXml);
            isJava8 |= KickStart.isJava8(appEngineWebXml);
            if (appEngineWebXml.getService() != null) {
                serviceName = appEngineWebXml.getService();
            } else if (appEngineWebXml.getModule() != null) {
                serviceName = appEngineWebXml.getModule();
            }
            if (!(systemProperties = appEngineWebXml.getSystemProperties()).containsKey("appengine.file.encoding")) continue;
            encoding = systemProperties.get("appengine.file.encoding");
        }
        return new AppEnvironment(isVMRuntime, isJava8, serviceName, encoding);
    }

    static class AppEnvironment {
        static final AppEnvironment DEFAULT = new AppEnvironment(false, false, "default", null);
        final boolean isVMRuntime;
        final boolean isJava8;
        final String serviceName;
        final String encoding;

        AppEnvironment(boolean isVMRuntime, boolean isJava8, String serviceName, String encoding) {
            this.isVMRuntime = isVMRuntime;
            this.isJava8 = isJava8;
            this.serviceName = serviceName;
            this.encoding = encoding;
        }
    }
}

