/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.admin;

import com.google.appengine.repackaged.com.google.common.base.Joiner;
import com.google.appengine.tools.admin.AbstractServerConnection;
import com.google.appengine.tools.admin.OutputPump;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.logging.Level;

public class Utility {
    private static final String FORWARD_SLASH = "/";
    private static final File ln = Utility.findLink();

    public static File findLink() {
        File ln = null;
        if (Utility.isOsUnix() && !(ln = new File("/bin/ln")).exists() && !(ln = new File("/usr/bin/ln")).exists()) {
            ln = null;
        }
        return ln;
    }

    public static boolean isOsUnix() {
        return File.separator.equals(FORWARD_SLASH);
    }

    public static boolean isOsWindows() {
        return !Utility.isOsUnix();
    }

    public static String calculatePath(File f, File base) {
        int offset = base.getPath().length();
        String path = f.getPath().substring(offset);
        if (File.separatorChar == '\\') {
            path = path.replace('\\', '/');
        }
        offset = 0;
        while (path.charAt(offset) == '/') {
            ++offset;
        }
        if (offset > 0) {
            path = path.substring(offset);
        }
        return path;
    }

    public static String jsonEscape(String s) {
        StringBuilder stringBuilder = new StringBuilder();
        block10: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\"': {
                    stringBuilder.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    stringBuilder.append("\\\\");
                    continue block10;
                }
                case '\b': {
                    stringBuilder.append("\\b");
                    continue block10;
                }
                case '\f': {
                    stringBuilder.append("\\f");
                    continue block10;
                }
                case '\n': {
                    stringBuilder.append("\\n");
                    continue block10;
                }
                case '\r': {
                    stringBuilder.append("\\r");
                    continue block10;
                }
                case '\t': {
                    stringBuilder.append("\\t");
                    continue block10;
                }
                case '/': {
                    stringBuilder.append("\\/");
                    continue block10;
                }
                default: {
                    if (ch >= ' ' && ch < '\u007f') {
                        stringBuilder.append(ch);
                        continue block10;
                    }
                    stringBuilder.append(String.format("\\u%04x", ch));
                }
            }
        }
        return stringBuilder.toString();
    }

    private Utility() {
    }

    static Process startProcess(PrintWriter detailsWriter, String ... args) throws IOException {
        ProcessBuilder builder = new ProcessBuilder(args);
        Process proc = builder.redirectErrorStream(true).start();
        AbstractServerConnection.logger.logp(Level.FINE, "com.google.appengine.tools.admin.Utility", "startProcess", Joiner.on(" ").join(builder.command()));
        new Thread(new OutputPump(proc.getInputStream(), detailsWriter)).start();
        return proc;
    }

    static void copyOrLinkFile(File source, File dest) throws IOException {
        dest.getParentFile().mkdirs();
        if (ln != null && !source.getName().endsWith("web.xml")) {
            if (!dest.delete()) {
                String string = String.valueOf(dest.getPath());
                System.err.println(string.length() != 0 ? "Warning: We tried to delete ".concat(string) : new String("Warning: We tried to delete "));
                String string2 = String.valueOf(source.getPath());
                System.err.println(string2.length() != 0 ? "in order to create a symlink from ".concat(string2) : new String("in order to create a symlink from "));
                System.err.println("but the delete failed.");
            }
            Process link = Utility.startProcess(new PrintWriter((Writer)new StringWriter(), true), ln.getAbsolutePath(), "-s", source.getAbsolutePath(), dest.getAbsolutePath());
            try {
                int stat = link.waitFor();
                if (stat == 0) {
                    return;
                }
                String string = ln.getAbsolutePath();
                System.err.println(new StringBuilder(48 + String.valueOf(string).length()).append(string).append(" returned status ").append(stat).append(", copying instead...").toString());
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                System.err.println(String.valueOf(ln.getAbsolutePath()).concat(" was interrupted, copying instead..."));
            }
            if (dest.delete()) {
                String string = String.valueOf(dest.getAbsolutePath());
                System.err.println(string.length() != 0 ? "ln failed but symlink was created, removed: ".concat(string) : new String("ln failed but symlink was created, removed: "));
            }
        }
        Files.copy(source.toPath(), dest.toPath(), new CopyOption[0]);
    }

    static void copyOrLinkDirectories(File sourceDir, File destination) throws IOException {
        for (String name : sourceDir.list()) {
            File file = new File(sourceDir, name);
            if (file.isDirectory()) {
                Utility.copyOrLinkDirectories(file, new File(destination, name));
                continue;
            }
            Utility.copyOrLinkFile(file, new File(destination, name));
        }
    }
}

