/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development;

import com.google.appengine.tools.development.AppContext;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.DevAppServerClassLoader;
import com.google.appengine.tools.development.agent.AppEngineDevAgent;
import com.google.apphosting.utils.security.SecurityManagerInstaller;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PropertyPermission;

public class DevAppServerFactory {
    static final String DEV_APP_SERVER_CLASS = "com.google.appengine.tools.development.DevAppServerImpl";
    private static final Class<?>[] DEV_APPSERVER_CTOR_ARG_TYPES = new Class[]{File.class, File.class, File.class, File.class, String.class, Integer.TYPE, Boolean.TYPE, Map.class};
    private static final String USER_CODE_CLASSPATH_MANAGER_PROP = "devappserver.userCodeClasspathManager";
    private static final String USER_CODE_CLASSPATH = "devappserver.userCodeClasspathManager.classpath";
    private static final String USER_CODE_REQUIRES_WEB_INF = "devappserver.userCodeClasspathManager.requiresWebInf";

    public DevAppServer createDevAppServer(File appDir, String address, int port) {
        return this.createDevAppServer(appDir, null, address, port);
    }

    public DevAppServer createDevAppServer(File appDir, File externalResourceDir, String address, int port) {
        boolean installSecurityManager = !Boolean.getBoolean("use_jetty9_runtime");
        return this.createDevAppServer(appDir, new File(new File(appDir, "WEB-INF"), "web.xml"), new File(new File(appDir, "WEB-INF"), "appengine-web.xml"), address, port, true, installSecurityManager, new HashMap<String, Object>(), false);
    }

    public DevAppServer createDevAppServer(File appDir, File externalResourceDir, String address, int port, boolean noJavaAgent) {
        return this.createDevAppServer(appDir, null, null, address, port, true, true, new HashMap<String, Object>(), noJavaAgent);
    }

    public DevAppServer createDevAppServer(File appDir, File webXmlLocation, File appEngineWebXmlLocation, String address, int port, boolean useCustomStreamHandler, boolean installSecurityManager, Collection<URL> classpath) {
        Map<String, Object> containerConfigProps = this.newContainerConfigPropertiesForTest(classpath);
        return this.createDevAppServer(appDir, webXmlLocation, appEngineWebXmlLocation, address, port, useCustomStreamHandler, installSecurityManager, containerConfigProps, false);
    }

    public DevAppServer createDevAppServer(File appDir, File webXmlLocation, File appEngineWebXmlLocation, String address, int port, boolean useCustomStreamHandler, boolean installSecurityManager, Collection<URL> classpath, boolean noJavaAgent) {
        Map<String, Object> containerConfigProps = this.newContainerConfigPropertiesForTest(classpath);
        return this.createDevAppServer(appDir, webXmlLocation, appEngineWebXmlLocation, address, port, useCustomStreamHandler, installSecurityManager, containerConfigProps, noJavaAgent);
    }

    public DevAppServer createDevAppServer(File appDir, File webXmlLocation, File appEngineWebXmlLocation, String address, int port, boolean useCustomStreamHandler, boolean installSecurityManager, Map<String, Object> containerConfigProperties) {
        return this.createDevAppServer(appDir, webXmlLocation, appEngineWebXmlLocation, address, port, useCustomStreamHandler, installSecurityManager, containerConfigProperties, false);
    }

    private Map<String, Object> newContainerConfigPropertiesForTest(Collection<URL> classpath) {
        HashMap<String, Object> containerConfigProps = new HashMap<String, Object>();
        HashMap<String, Object> userCodeClasspathManagerProps = new HashMap<String, Object>();
        userCodeClasspathManagerProps.put(USER_CODE_CLASSPATH, classpath);
        userCodeClasspathManagerProps.put(USER_CODE_REQUIRES_WEB_INF, false);
        containerConfigProps.put(USER_CODE_CLASSPATH_MANAGER_PROP, userCodeClasspathManagerProps);
        return containerConfigProps;
    }

    public DevAppServer createDevAppServer(final File appDir, final File webXmlLocation, final File appEngineWebXmlLocation, final String address, final int port, final boolean useCustomStreamHandler, final boolean installSecurityManager, final Map<String, Object> containerConfigProperties, final boolean noJavaAgent) {
        return AccessController.doPrivileged(new PrivilegedAction<DevAppServer>(){

            @Override
            public DevAppServer run() {
                return DevAppServerFactory.this.doCreateDevAppServer(appDir, webXmlLocation, appEngineWebXmlLocation, address, port, useCustomStreamHandler, installSecurityManager, containerConfigProperties, noJavaAgent);
            }
        });
    }

    private DevAppServer doCreateDevAppServer(File appDir, File webXmlLocation, File appEngineWebXmlLocation, String address, int port, boolean useCustomStreamHandler, boolean installSecurityManager, Map<String, Object> containerConfigProperties, boolean noJavaAgent) {
        DevAppServer devAppServer;
        if (!noJavaAgent) {
            this.testAgentIsInstalled();
        }
        if (webXmlLocation == null) {
            webXmlLocation = new File(appDir, "WEB-INF/web.xml");
        }
        if (appEngineWebXmlLocation == null) {
            appEngineWebXmlLocation = new File(appDir, "WEB-INF/appengine-web.xml");
        }
        DevAppServerClassLoader loader = DevAppServerClassLoader.newClassLoader(DevAppServerFactory.class.getClassLoader());
        try {
            Class<?> devAppServerClass = Class.forName(DEV_APP_SERVER_CLASS, false, loader);
            if (installSecurityManager) {
                SecurityManagerInstaller.install(false, DevAppServerFactory.getPrivilegedJars(devAppServerClass));
            }
            Constructor<?> cons = devAppServerClass.getConstructor(DEV_APPSERVER_CTOR_ARG_TYPES);
            cons.setAccessible(true);
            devAppServer = (DevAppServer)cons.newInstance(appDir, null, webXmlLocation, appEngineWebXmlLocation, address, port, useCustomStreamHandler, containerConfigProperties);
        }
        catch (Exception e) {
            Throwable t = e;
            if (e instanceof InvocationTargetException) {
                t = e.getCause();
            }
            throw new RuntimeException("Unable to create a DevAppServer", t);
        }
        if (installSecurityManager) {
            System.setSecurityManager(new CustomSecurityManager(devAppServer));
        }
        return devAppServer;
    }

    private static URL[] getPrivilegedJars(Class<?> devAppServerClass) {
        HashSet<URL> urls = new HashSet<URL>();
        for (Class privilegedClass : new Class[]{devAppServerClass, DevAppServerFactory.class, SecurityManagerInstaller.class}) {
            URL location;
            CodeSource source;
            ProtectionDomain domain = privilegedClass.getProtectionDomain();
            if (domain == null || (source = domain.getCodeSource()) == null || (location = source.getLocation()) == null) continue;
            urls.add(location);
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private void testAgentIsInstalled() {
        try {
            AppEngineDevAgent.getAgent();
        }
        catch (Throwable t) {
            String msg = "Unable to locate the App Engine agent. Please use dev_appserver, KickStart,  or set the jvm flag: \"-javaagent:<sdk_root>/lib/agent/appengine-agent.jar\"";
            throw new RuntimeException(msg, t);
        }
    }

    static class CustomSecurityManager
    extends SecurityManager {
        private static final RuntimePermission PERMISSION_MODIFY_THREAD_GROUP = new RuntimePermission("modifyThreadGroup");
        private static final RuntimePermission PERMISSION_MODIFY_THREAD = new RuntimePermission("modifyThread");
        private static final String KEYCHAIN_JNILIB = "/libkeychain.jnilib";
        private static final Object PERMISSION_LOCK = new Object();
        private final DevAppServer devAppServer;

        public CustomSecurityManager(DevAppServer devAppServer) {
            this.devAppServer = devAppServer;
        }

        boolean appHasPermissionNonThreadCallerFrame(StackTraceElement frame) {
            if ("sun.security.ssl.SSLSocketImpl$NotifyHandshakeThread".equals(frame.getClassName()) && "<init>".equals(frame.getMethodName())) {
                return true;
            }
            return "com.mysql.jdbc.AbandonedConnectionCleanupThread".equals(frame.getClassName()) && "<init>".equals(frame.getMethodName()) || frame.getClassName().startsWith("com.mysql.jdbc.NonRegisteringDriver");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized boolean appHasPermission(Permission perm) {
            Object object = PERMISSION_LOCK;
            synchronized (object) {
                AppContext context = this.devAppServer.getCurrentAppContext();
                if (context.getUserPermissions().implies(perm) || context.getApplicationPermissions().implies(perm)) {
                    return true;
                }
            }
            if (PERMISSION_MODIFY_THREAD_GROUP.equals(perm) || PERMISSION_MODIFY_THREAD.equals(perm)) {
                StackTraceElement frame;
                StackTraceAnalyzer stack = new StackTraceAnalyzer();
                if (PERMISSION_MODIFY_THREAD.equals(perm) && ("java.util.concurrent.ThreadPoolExecutor".equals((frame = stack.getCallerFrame()).getClassName()) || "java.lang.Thread".equals(frame.getClassName()) && "interrupt".equals(frame.getMethodName()) || "java.lang.Thread".equals(frame.getClassName()) && "setUncaughtExceptionHandler".equals(frame.getMethodName()))) {
                    return true;
                }
                if (this.appHasPermissionNonThreadCallerFrame(stack.getNonThreadCallerFrame())) {
                    return true;
                }
            }
            if (perm instanceof SocketPermission) {
                return true;
            }
            return "read".equals(perm.getActions()) && perm.getName().endsWith(KEYCHAIN_JNILIB);
        }

        @Override
        public void checkPermission(Permission perm) {
            if (perm instanceof PropertyPermission) {
                return;
            }
            if (this.isDevAppServerThread()) {
                if (this.appHasPermission(perm)) {
                    return;
                }
                super.checkPermission(perm);
            }
        }

        @Override
        public void checkPermission(Permission perm, Object context) {
            if (this.isDevAppServerThread()) {
                if (this.appHasPermission(perm)) {
                    return;
                }
                super.checkPermission(perm, context);
            }
        }

        @Override
        public void checkAccess(ThreadGroup g) {
            if (g == null) {
                throw new NullPointerException("thread group can't be null");
            }
            this.checkPermission(PERMISSION_MODIFY_THREAD_GROUP);
        }

        @Override
        public void checkAccess(Thread t) {
            if (t == null) {
                throw new NullPointerException("thread can't be null");
            }
            this.checkPermission(PERMISSION_MODIFY_THREAD);
        }

        private boolean isDevAppServerThread() {
            String string = String.valueOf(Thread.currentThread().getName());
            return Boolean.getBoolean(string.length() != 0 ? "devappserver-thread-".concat(string) : new String("devappserver-thread-")) && this.devAppServer.getCurrentAppContext() != null;
        }

        private class StackTraceAnalyzer {
            private final StackTraceElement[] frames = Thread.currentThread().getStackTrace();

            private StackTraceAnalyzer() {
            }

            private boolean isThisOrOuterClass(StackTraceElement frame) {
                return CustomSecurityManager.this.getClass().getName().equals(frame.getClassName()) || this.getClass().getName().equals(frame.getClassName());
            }

            StackTraceElement getCallerFrame() {
                for (int i = 1; i < this.frames.length; ++i) {
                    if ("checkAccess".equals(this.frames[i].getMethodName()) || this.isThisOrOuterClass(this.frames[i])) continue;
                    return this.frames[i];
                }
                throw new IllegalStateException("Unable to determine calling frame.");
            }

            StackTraceElement getNonThreadCallerFrame() {
                for (int i = 1; i < this.frames.length; ++i) {
                    if ("java.lang.ThreadGroup".equals(this.frames[i].getClassName()) || "java.lang.Thread".equals(this.frames[i].getClassName()) || this.isThisOrOuterClass(this.frames[i])) continue;
                    return this.frames[i];
                }
                throw new IllegalStateException("Unable to determine calling frame.");
            }
        }
    }
}

