/*
 * Decompiled with CFR 0.152.
 */
package com.google.appengine.tools.development.devappserver2;

import com.google.appengine.repackaged.com.google.common.collect.ImmutableMap;
import com.google.appengine.tools.development.DevAppServer;
import com.google.appengine.tools.development.SharedMain;
import com.google.appengine.tools.development.devappserver2.DevAppServer2Factory;
import com.google.appengine.tools.development.proto.Config;
import com.google.appengine.tools.util.Action;
import com.google.appengine.tools.util.Option;
import com.google.appengine.tools.util.Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StandaloneInstance
extends SharedMain {
    private static final String SDK_ROOT_ENVIRONMENT_VAR = "SDKROOT";
    private static final String JAVA_PATH_PREFIX = "google/appengine/tools/java/";
    private static final String JAVA_LIB_PATH = "google/appengine/tools/java/lib";
    private static final Logger logger = Logger.getLogger(StandaloneInstance.class.getName());
    private final Action startAction = new StartAction();
    private final File sdkRoot;
    private final File javaLibs;

    public static void main(String[] args) throws Exception {
        SharedMain.sharedInit();
        System.setProperty("com.google.appengine.devappserver2", "true");
        new StandaloneInstance().run(args);
    }

    private StandaloneInstance() {
        String sdkRootPath = System.getenv(SDK_ROOT_ENVIRONMENT_VAR);
        if (sdkRootPath == null) {
            logger.logp(Level.SEVERE, "com.google.appengine.tools.development.devappserver2.StandaloneInstance", "<init>", "Environment does not have SDKROOT variable set");
            System.exit(1);
        }
        this.sdkRoot = new File(sdkRootPath);
        this.javaLibs = new File(this.sdkRoot, JAVA_LIB_PATH);
        if (!this.javaLibs.isDirectory()) {
            logger.logp(Level.SEVERE, "com.google.appengine.tools.development.devappserver2.StandaloneInstance", "<init>", "Java libraries directory does not exist or cannot be read: {0}", this.javaLibs);
            System.exit(1);
        }
    }

    private void run(String[] args) throws Exception {
        Parser parser = new Parser();
        Parser.ParseResult result = parser.parseArgs(this.startAction, this.buildOptions(), args);
        result.applyArgs();
    }

    @Override
    protected void printHelp(PrintStream out) {
        out.println("Usage: <StandaloneInstance> [options] <app directory> <port file>");
        out.println("  where <port file> is the file to which the HTTP server port is written");
        out.println("");
        out.println("Options:");
        for (Option option : this.buildOptions()) {
            for (String helpString : option.getHelpLines()) {
                out.println(helpString);
            }
        }
    }

    private List<Option> buildOptions() {
        return this.getSharedOptions();
    }

    class StartAction
    extends Action {
        StartAction() {
            super("start");
        }

        @Override
        public void apply() {
            List<String> args = this.getArgs();
            if (args.size() != 2) {
                StandaloneInstance.this.printHelp(System.err);
                System.exit(1);
            }
            try {
                this.apply(args);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void apply(List<String> args) throws IOException {
            Config inputConfig;
            File inputConfigFile = new File(args.get(0));
            try (FileInputStream in = new FileInputStream(inputConfigFile);){
                inputConfig = Config.parseFrom(in);
            }
            finally {
                boolean deleted = inputConfigFile.delete();
                if (!deleted) {
                    logger.logp(Level.WARNING, "com.google.appengine.tools.development.devappserver2.StandaloneInstance$StartAction", "apply", "Could not delete {0}", inputConfigFile);
                }
            }
            String apiHost = inputConfig.getApiHost();
            int apiPort = inputConfig.getApiPort();
            String applicationRoot = inputConfig.getApplicationRoot().toStringUtf8();
            File appDir = new File(applicationRoot);
            StandaloneInstance.this.validateWarPath(appDir);
            StandaloneInstance.this.configureRuntime(appDir);
            boolean noJavaAgent = true;
            ImmutableMap<String, Integer> containerConfigOptions = ImmutableMap.of("com.google.appengine.apiHost", apiHost, "com.google.appengine.apiPort", apiPort);
            DevAppServer2Factory devAppServer2Factory = new DevAppServer2Factory();
            File externalResourceDir = null;
            File webXmlLocation = null;
            File appEngineWebXmlLocation = null;
            boolean useCustomStreamHandler = true;
            String runtime = System.getProperty("appengine.runtime");
            boolean installSecurityManager = !inputConfig.getVm() && "java7".equals(runtime);
            DevAppServer server = devAppServer2Factory.createDevAppServer(appDir, externalResourceDir, webXmlLocation, appEngineWebXmlLocation, "localhost", 0, useCustomStreamHandler, installSecurityManager, containerConfigOptions, noJavaAgent);
            Map stringProperties = StandaloneInstance.this.getSystemProperties();
            StandaloneInstance.this.postServerActions(stringProperties);
            StandaloneInstance.this.addPropertyOptionToProperties(stringProperties);
            server.setServiceProperties(stringProperties);
            try {
                CountDownLatch serverLatch = server.start();
                int port = server.getPort();
                File outputPortFile = new File(args.get(1));
                try (PrintWriter printWriter = new PrintWriter(outputPortFile, StandardCharsets.UTF_8.name());){
                    printWriter.println(port);
                }
                serverLatch.await();
            }
            catch (Exception e) {
                logger.logp(Level.SEVERE, "com.google.appengine.tools.development.devappserver2.StandaloneInstance$StartAction", "apply", "Failed to start server", e);
            }
        }
    }
}

