/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.mortbay.io.Buffer;
import org.mortbay.io.ByteArrayBuffer;
import org.mortbay.io.View;
import org.mortbay.util.StringMap;

public class BufferCache {
    private HashMap _bufferMap = new HashMap();
    private StringMap _stringMap = new StringMap(true);
    private ArrayList _index = new ArrayList();

    public CachedBuffer add(String string, int n) {
        CachedBuffer cachedBuffer = new CachedBuffer(string, n);
        this._bufferMap.put(cachedBuffer, cachedBuffer);
        this._stringMap.put(string, (Object)cachedBuffer);
        while (n - this._index.size() > 0) {
            this._index.add(null);
        }
        this._index.add(n, cachedBuffer);
        return cachedBuffer;
    }

    public CachedBuffer get(int n) {
        if (n < 0 || n >= this._index.size()) {
            return null;
        }
        return (CachedBuffer)this._index.get(n);
    }

    public CachedBuffer get(Buffer buffer) {
        return (CachedBuffer)this._bufferMap.get(buffer);
    }

    public CachedBuffer get(String string) {
        return (CachedBuffer)this._stringMap.get(string);
    }

    public Buffer lookup(Buffer buffer) {
        CachedBuffer cachedBuffer = this.get(buffer);
        if (cachedBuffer == null) {
            if (buffer instanceof Buffer.CaseInsensitve) {
                return buffer;
            }
            return new View.CaseInsensitive(buffer);
        }
        return cachedBuffer;
    }

    public CachedBuffer getBest(byte[] byArray, int n, int n2) {
        Map.Entry entry = this._stringMap.getBestEntry(byArray, n, n2);
        if (entry != null) {
            return (CachedBuffer)entry.getValue();
        }
        return null;
    }

    public Buffer lookup(String string) {
        CachedBuffer cachedBuffer = this.get(string);
        if (cachedBuffer == null) {
            return new CachedBuffer(string, -1);
        }
        return cachedBuffer;
    }

    public String toString(Buffer buffer) {
        return this.lookup(buffer).toString();
    }

    public int getOrdinal(Buffer buffer) {
        if (buffer instanceof CachedBuffer) {
            return ((CachedBuffer)buffer).getOrdinal();
        }
        if ((buffer = this.lookup(buffer)) != null && buffer instanceof CachedBuffer) {
            return ((CachedBuffer)buffer).getOrdinal();
        }
        return -1;
    }

    public String toString() {
        return "CACHE[bufferMap=" + this._bufferMap + ",stringMap=" + this._stringMap + ",index=" + this._index + "]";
    }

    public static class CachedBuffer
    extends ByteArrayBuffer.CaseInsensitive {
        private int _ordinal;
        private HashMap _associateMap = null;

        public CachedBuffer(String string, int n) {
            super(string);
            this._ordinal = n;
        }

        public int getOrdinal() {
            return this._ordinal;
        }

        public CachedBuffer getAssociate(Object object) {
            if (this._associateMap == null) {
                return null;
            }
            return (CachedBuffer)this._associateMap.get(object);
        }

        public void setAssociate(Object object, CachedBuffer cachedBuffer) {
            if (this._associateMap == null) {
                this._associateMap = new HashMap();
            }
            this._associateMap.put(object, cachedBuffer);
        }
    }
}

