/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.io.bio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mortbay.io.Buffer;
import org.mortbay.io.EndPoint;

public class StreamEndPoint
implements EndPoint {
    InputStream _in;
    OutputStream _out;

    public StreamEndPoint(InputStream inputStream, OutputStream outputStream) {
        this._in = inputStream;
        this._out = outputStream;
    }

    @Override
    public boolean isBlocking() {
        return true;
    }

    @Override
    public boolean blockReadable(long l) throws IOException {
        return true;
    }

    @Override
    public boolean blockWritable(long l) throws IOException {
        return true;
    }

    @Override
    public boolean isOpen() {
        return this._in != null;
    }

    public final boolean isClosed() {
        return !this.isOpen();
    }

    @Override
    public void close() throws IOException {
        if (this._in != null) {
            this._in.close();
        }
        this._in = null;
        if (this._out != null) {
            this._out.close();
        }
        this._out = null;
    }

    @Override
    public int fill(Buffer buffer) throws IOException {
        if (this._in == null) {
            return 0;
        }
        int n = buffer.space();
        if (n <= 0) {
            if (buffer.hasContent()) {
                return 0;
            }
            throw new IOException("FULL");
        }
        int n2 = buffer.readFrom(this._in, n);
        return n2;
    }

    @Override
    public int flush(Buffer buffer) throws IOException {
        if (this._out == null) {
            return -1;
        }
        int n = buffer.length();
        if (n > 0) {
            buffer.writeTo(this._out);
        }
        buffer.clear();
        return n;
    }

    @Override
    public int flush(Buffer buffer, Buffer buffer2, Buffer buffer3) throws IOException {
        int n;
        int n2;
        int n3 = 0;
        if (buffer != null && (n2 = buffer.length()) > 0) {
            n3 = n = this.flush(buffer);
            if (n < n2) {
                return n3;
            }
        }
        if (buffer2 != null && (n2 = buffer2.length()) > 0) {
            n = this.flush(buffer2);
            if (n < 0) {
                return n3 > 0 ? n3 : n;
            }
            n3 += n;
            if (n < n2) {
                return n3;
            }
        }
        if (buffer3 != null && (n2 = buffer3.length()) > 0) {
            n = this.flush(buffer3);
            if (n < 0) {
                return n3 > 0 ? n3 : n;
            }
            n3 += n;
        }
        return n3;
    }

    @Override
    public String getLocalAddr() {
        return null;
    }

    @Override
    public String getLocalHost() {
        return null;
    }

    @Override
    public int getLocalPort() {
        return 0;
    }

    @Override
    public String getRemoteAddr() {
        return null;
    }

    @Override
    public String getRemoteHost() {
        return null;
    }

    @Override
    public int getRemotePort() {
        return 0;
    }

    @Override
    public Object getTransport() {
        return null;
    }

    public InputStream getInputStream() {
        return this._in;
    }

    public void setInputStream(InputStream inputStream) {
        this._in = inputStream;
    }

    public OutputStream getOutputStream() {
        return this._out;
    }

    public void setOutputStream(OutputStream outputStream) {
        this._out = outputStream;
    }

    @Override
    public void flush() throws IOException {
        this._out.flush();
    }

    @Override
    public boolean isBufferingInput() {
        return false;
    }

    @Override
    public boolean isBufferingOutput() {
        return false;
    }

    @Override
    public boolean isBufferred() {
        return false;
    }
}

