/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.jetty;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.mortbay.io.Buffer;
import org.mortbay.io.BufferCache;
import org.mortbay.log.Log;
import org.mortbay.util.StringUtil;

public class MimeTypes {
    public static final String FORM_ENCODED = "application/x-www-form-urlencoded";
    public static final String MESSAGE_HTTP = "message/http";
    public static final String MULTIPART_BYTERANGES = "multipart/byteranges";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String TEXT_XML = "text/xml";
    public static final String TEXT_HTML_8859_1 = "text/html; charset=iso-8859-1";
    public static final String TEXT_PLAIN_8859_1 = "text/plain; charset=iso-8859-1";
    public static final String TEXT_XML_8859_1 = "text/xml; charset=iso-8859-1";
    public static final String TEXT_HTML_UTF_8 = "text/html; charset=utf-8";
    public static final String TEXT_PLAIN_UTF_8 = "text/plain; charset=utf-8";
    public static final String TEXT_XML_UTF_8 = "text/xml; charset=utf-8";
    public static final String TEXT_JSON = "text/json";
    public static final String TEXT_JSON_UTF_8 = "text/json;charset=UTF-8";
    private static final int FORM_ENCODED_ORDINAL = 1;
    private static final int MESSAGE_HTTP_ORDINAL = 2;
    private static final int MULTIPART_BYTERANGES_ORDINAL = 3;
    private static final int TEXT_HTML_ORDINAL = 4;
    private static final int TEXT_PLAIN_ORDINAL = 5;
    private static final int TEXT_XML_ORDINAL = 6;
    private static final int TEXT_HTML_8859_1_ORDINAL = 7;
    private static final int TEXT_PLAIN_8859_1_ORDINAL = 8;
    private static final int TEXT_XML_8859_1_ORDINAL = 9;
    private static final int TEXT_HTML_UTF_8_ORDINAL = 10;
    private static final int TEXT_PLAIN_UTF_8_ORDINAL = 11;
    private static final int TEXT_XML_UTF_8_ORDINAL = 12;
    private static final int TEXT_JSON_ORDINAL = 13;
    private static final int TEXT_JSON_UTF_8_ORDINAL = 14;
    private static int __index;
    public static final BufferCache CACHE;
    public static final BufferCache.CachedBuffer FORM_ENCODED_BUFFER;
    public static final BufferCache.CachedBuffer MESSAGE_HTTP_BUFFER;
    public static final BufferCache.CachedBuffer MULTIPART_BYTERANGES_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_HTML_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_PLAIN_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_XML_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_HTML_8859_1_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_PLAIN_8859_1_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_XML_8859_1_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_HTML_UTF_8_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_PLAIN_UTF_8_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_XML_UTF_8_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_JSON_BUFFER;
    public static final BufferCache.CachedBuffer TEXT_JSON_UTF_8_BUFFER;
    private static final Map __dftMimeMap;
    private static final Map __encodings;
    private Map _mimeMap;

    public synchronized Map getMimeMap() {
        return this._mimeMap;
    }

    public void setMimeMap(Map map) {
        if (map == null) {
            this._mimeMap = null;
            return;
        }
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : map.entrySet()) {
            hashMap.put(entry.getKey(), MimeTypes.normalizeMimeType(entry.getValue().toString()));
        }
        this._mimeMap = hashMap;
    }

    public Buffer getMimeByExtension(String string) {
        Buffer buffer = null;
        if (string != null) {
            int n = -1;
            while (buffer == null && (n = string.indexOf(".", n + 1)) >= 0 && n < string.length()) {
                String string2 = StringUtil.asciiToLowerCase(string.substring(n + 1));
                if (this._mimeMap != null) {
                    buffer = (Buffer)this._mimeMap.get(string2);
                }
                if (buffer != null) continue;
                buffer = (Buffer)__dftMimeMap.get(string2);
            }
        }
        if (buffer == null) {
            if (this._mimeMap != null) {
                buffer = (Buffer)this._mimeMap.get("*");
            }
            if (buffer == null) {
                buffer = (Buffer)__dftMimeMap.get("*");
            }
        }
        return buffer;
    }

    public void addMimeMapping(String string, String string2) {
        if (this._mimeMap == null) {
            this._mimeMap = new HashMap();
        }
        this._mimeMap.put(StringUtil.asciiToLowerCase(string), MimeTypes.normalizeMimeType(string2));
    }

    private static synchronized Buffer normalizeMimeType(String string) {
        BufferCache.CachedBuffer cachedBuffer = CACHE.get(string);
        if (cachedBuffer == null) {
            cachedBuffer = CACHE.add(string, __index++);
        }
        return cachedBuffer;
    }

    public static String getCharsetFromContentType(Buffer buffer) {
        int n;
        if (buffer instanceof BufferCache.CachedBuffer) {
            switch (((BufferCache.CachedBuffer)buffer).getOrdinal()) {
                case 7: 
                case 8: 
                case 9: {
                    return StringUtil.__ISO_8859_1;
                }
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: {
                    return "UTF-8";
                }
            }
        }
        int n2 = buffer.putIndex();
        int n3 = 0;
        int n4 = 0;
        boolean bl = false;
        block17: for (n = buffer.getIndex(); n < n2; ++n) {
            byte by = buffer.peek(n);
            if (bl && n3 != 10) {
                if (34 != by) continue;
                bl = false;
                continue;
            }
            switch (n3) {
                case 0: {
                    if (34 == by) {
                        bl = true;
                        continue block17;
                    }
                    if (59 != by) continue block17;
                    n3 = 1;
                    continue block17;
                }
                case 1: {
                    if (99 == by) {
                        n3 = 2;
                        continue block17;
                    }
                    if (32 == by) continue block17;
                    n3 = 0;
                    continue block17;
                }
                case 2: {
                    if (104 == by) {
                        n3 = 3;
                        continue block17;
                    }
                    n3 = 0;
                    continue block17;
                }
                case 3: {
                    if (97 == by) {
                        n3 = 4;
                        continue block17;
                    }
                    n3 = 0;
                    continue block17;
                }
                case 4: {
                    if (114 == by) {
                        n3 = 5;
                        continue block17;
                    }
                    n3 = 0;
                    continue block17;
                }
                case 5: {
                    if (115 == by) {
                        n3 = 6;
                        continue block17;
                    }
                    n3 = 0;
                    continue block17;
                }
                case 6: {
                    if (101 == by) {
                        n3 = 7;
                        continue block17;
                    }
                    n3 = 0;
                    continue block17;
                }
                case 7: {
                    if (116 == by) {
                        n3 = 8;
                        continue block17;
                    }
                    n3 = 0;
                    continue block17;
                }
                case 8: {
                    if (61 == by) {
                        n3 = 9;
                        continue block17;
                    }
                    if (32 == by) continue block17;
                    n3 = 0;
                    continue block17;
                }
                case 9: {
                    if (32 == by) continue block17;
                    if (34 == by) {
                        bl = true;
                        n4 = n + 1;
                        n3 = 10;
                        continue block17;
                    }
                    n4 = n;
                    n3 = 10;
                    continue block17;
                }
                case 10: {
                    if ((bl || 59 != by && 32 != by) && (!bl || 34 != by)) continue block17;
                    return CACHE.lookup(buffer.peek(n4, n - n4)).toString();
                }
            }
        }
        if (n3 == 10) {
            return CACHE.lookup(buffer.peek(n4, n - n4)).toString();
        }
        return null;
    }

    static {
        Object object;
        Enumeration<String> enumeration;
        ResourceBundle resourceBundle;
        __index = 15;
        CACHE = new BufferCache();
        FORM_ENCODED_BUFFER = CACHE.add(FORM_ENCODED, 1);
        MESSAGE_HTTP_BUFFER = CACHE.add(MESSAGE_HTTP, 2);
        MULTIPART_BYTERANGES_BUFFER = CACHE.add(MULTIPART_BYTERANGES, 3);
        TEXT_HTML_BUFFER = CACHE.add(TEXT_HTML, 4);
        TEXT_PLAIN_BUFFER = CACHE.add(TEXT_PLAIN, 5);
        TEXT_XML_BUFFER = CACHE.add(TEXT_XML, 6);
        TEXT_HTML_8859_1_BUFFER = new BufferCache.CachedBuffer(TEXT_HTML_8859_1, 7);
        TEXT_PLAIN_8859_1_BUFFER = new BufferCache.CachedBuffer(TEXT_PLAIN_8859_1, 8);
        TEXT_XML_8859_1_BUFFER = new BufferCache.CachedBuffer(TEXT_XML_8859_1, 9);
        TEXT_HTML_UTF_8_BUFFER = new BufferCache.CachedBuffer(TEXT_HTML_UTF_8, 10);
        TEXT_PLAIN_UTF_8_BUFFER = new BufferCache.CachedBuffer(TEXT_PLAIN_UTF_8, 11);
        TEXT_XML_UTF_8_BUFFER = new BufferCache.CachedBuffer(TEXT_XML_UTF_8, 12);
        TEXT_JSON_BUFFER = CACHE.add(TEXT_JSON, 13);
        TEXT_JSON_UTF_8_BUFFER = CACHE.add(TEXT_JSON_UTF_8, 14);
        __dftMimeMap = new HashMap();
        __encodings = new HashMap();
        try {
            resourceBundle = ResourceBundle.getBundle("org/mortbay/jetty/mime");
            enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                object = enumeration.nextElement();
                String string = resourceBundle.getString((String)object);
                __dftMimeMap.put(StringUtil.asciiToLowerCase((String)object), MimeTypes.normalizeMimeType(string));
            }
        }
        catch (MissingResourceException missingResourceException) {
            Log.warn(missingResourceException.toString());
            Log.debug(missingResourceException);
        }
        try {
            resourceBundle = ResourceBundle.getBundle("org/mortbay/jetty/encoding");
            enumeration = resourceBundle.getKeys();
            while (enumeration.hasMoreElements()) {
                object = MimeTypes.normalizeMimeType(enumeration.nextElement());
                __encodings.put(object, resourceBundle.getString(object.toString()));
            }
        }
        catch (MissingResourceException missingResourceException) {
            Log.warn(missingResourceException.toString());
            Log.debug(missingResourceException);
        }
        TEXT_HTML_BUFFER.setAssociate("ISO-8859-1", TEXT_HTML_8859_1_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("ISO_8859_1", TEXT_HTML_8859_1_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("iso-8859-1", TEXT_HTML_8859_1_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("ISO-8859-1", TEXT_PLAIN_8859_1_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("ISO_8859_1", TEXT_PLAIN_8859_1_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("iso-8859-1", TEXT_PLAIN_8859_1_BUFFER);
        TEXT_XML_BUFFER.setAssociate("ISO-8859-1", TEXT_XML_8859_1_BUFFER);
        TEXT_XML_BUFFER.setAssociate("ISO_8859_1", TEXT_XML_8859_1_BUFFER);
        TEXT_XML_BUFFER.setAssociate("iso-8859-1", TEXT_XML_8859_1_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("UTF-8", TEXT_HTML_UTF_8_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("UTF8", TEXT_HTML_UTF_8_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("utf8", TEXT_HTML_UTF_8_BUFFER);
        TEXT_HTML_BUFFER.setAssociate("utf-8", TEXT_HTML_UTF_8_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("UTF-8", TEXT_PLAIN_UTF_8_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("UTF8", TEXT_PLAIN_UTF_8_BUFFER);
        TEXT_PLAIN_BUFFER.setAssociate("utf-8", TEXT_PLAIN_UTF_8_BUFFER);
        TEXT_XML_BUFFER.setAssociate("UTF-8", TEXT_XML_UTF_8_BUFFER);
        TEXT_XML_BUFFER.setAssociate("utf8", TEXT_XML_UTF_8_BUFFER);
        TEXT_XML_BUFFER.setAssociate("UTF8", TEXT_XML_UTF_8_BUFFER);
        TEXT_XML_BUFFER.setAssociate("utf-8", TEXT_XML_UTF_8_BUFFER);
        TEXT_JSON_BUFFER.setAssociate("UTF-8", TEXT_JSON_UTF_8_BUFFER);
        TEXT_JSON_BUFFER.setAssociate("utf8", TEXT_JSON_UTF_8_BUFFER);
        TEXT_JSON_BUFFER.setAssociate("UTF8", TEXT_JSON_UTF_8_BUFFER);
        TEXT_JSON_BUFFER.setAssociate("utf-8", TEXT_JSON_UTF_8_BUFFER);
    }
}

