/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.mortbay.util.ByteArrayOutputStream2;
import org.mortbay.util.StringUtil;

public class ByteArrayISO8859Writer
extends Writer {
    private byte[] _buf;
    private int _size;
    private ByteArrayOutputStream2 _bout = null;
    private OutputStreamWriter _writer = null;
    private boolean _fixed = false;

    public ByteArrayISO8859Writer() {
        this._buf = new byte[2048];
    }

    public ByteArrayISO8859Writer(int n) {
        this._buf = new byte[n];
    }

    public ByteArrayISO8859Writer(byte[] byArray) {
        this._buf = byArray;
        this._fixed = true;
    }

    public Object getLock() {
        return this.lock;
    }

    public int size() {
        return this._size;
    }

    public int capacity() {
        return this._buf.length;
    }

    public int spareCapacity() {
        return this._buf.length - this._size;
    }

    public void setLength(int n) {
        this._size = n;
    }

    public byte[] getBuf() {
        return this._buf;
    }

    public void writeTo(OutputStream outputStream) throws IOException {
        outputStream.write(this._buf, 0, this._size);
    }

    public void write(char c) throws IOException {
        this.ensureSpareCapacity(1);
        if (c >= '\u0000' && c <= '\u007f') {
            this._buf[this._size++] = (byte)c;
        } else {
            char[] cArray = new char[]{c};
            this.writeEncoded(cArray, 0, 1);
        }
    }

    @Override
    public void write(char[] cArray) throws IOException {
        this.ensureSpareCapacity(cArray.length);
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c < '\u0000' || c > '\u007f') {
                this.writeEncoded(cArray, i, cArray.length - i);
                break;
            }
            this._buf[this._size++] = (byte)c;
        }
    }

    @Override
    public void write(char[] cArray, int n, int n2) throws IOException {
        this.ensureSpareCapacity(n2);
        for (int i = 0; i < n2; ++i) {
            char c = cArray[n + i];
            if (c < '\u0000' || c > '\u007f') {
                this.writeEncoded(cArray, n + i, n2 - i);
                break;
            }
            this._buf[this._size++] = (byte)c;
        }
    }

    @Override
    public void write(String string) throws IOException {
        if (string == null) {
            this.write("null", 0, 4);
            return;
        }
        int n = string.length();
        this.ensureSpareCapacity(n);
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c < '\u0000' || c > '\u007f') {
                this.writeEncoded(string.toCharArray(), i, n - i);
                break;
            }
            this._buf[this._size++] = (byte)c;
        }
    }

    @Override
    public void write(String string, int n, int n2) throws IOException {
        this.ensureSpareCapacity(n2);
        for (int i = 0; i < n2; ++i) {
            char c = string.charAt(n + i);
            if (c < '\u0000' || c > '\u007f') {
                this.writeEncoded(string.toCharArray(), n + i, n2 - i);
                break;
            }
            this._buf[this._size++] = (byte)c;
        }
    }

    private void writeEncoded(char[] cArray, int n, int n2) throws IOException {
        if (this._bout == null) {
            this._bout = new ByteArrayOutputStream2(2 * n2);
            this._writer = new OutputStreamWriter((OutputStream)this._bout, StringUtil.__ISO_8859_1);
        } else {
            this._bout.reset();
        }
        this._writer.write(cArray, n, n2);
        this._writer.flush();
        this.ensureSpareCapacity(this._bout.getCount());
        System.arraycopy(this._bout.getBuf(), 0, this._buf, this._size, this._bout.getCount());
        this._size += this._bout.getCount();
    }

    @Override
    public void flush() {
    }

    public void resetWriter() {
        this._size = 0;
    }

    @Override
    public void close() {
    }

    public void destroy() {
        this._buf = null;
    }

    public void ensureSpareCapacity(int n) throws IOException {
        if (this._size + n > this._buf.length) {
            if (this._fixed) {
                throw new IOException("Buffer overflow: " + this._buf.length);
            }
            byte[] byArray = new byte[(this._buf.length + n) * 4 / 3];
            System.arraycopy(this._buf, 0, byArray, 0, this._size);
            this._buf = byArray;
        }
    }

    public byte[] getByteArray() {
        byte[] byArray = new byte[this._size];
        System.arraycopy(this._buf, 0, byArray, 0, this._size);
        return byArray;
    }
}

