/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.text.DateFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class DateCache {
    public static String DEFAULT_FORMAT = "EEE MMM dd HH:mm:ss zzz yyyy";
    private static long __hitWindow = 3600L;
    private String _formatString;
    private String _tzFormatString;
    private SimpleDateFormat _tzFormat;
    private String _minFormatString;
    private SimpleDateFormat _minFormat;
    private String _secFormatString;
    private String _secFormatString0;
    private String _secFormatString1;
    private long _lastMinutes = -1L;
    private long _lastSeconds = -1L;
    private int _lastMs = -1;
    private String _lastResult = null;
    private Locale _locale = null;
    private DateFormatSymbols _dfs = null;

    public DateCache() {
        this(DEFAULT_FORMAT);
        this.getFormat().setTimeZone(TimeZone.getDefault());
    }

    public DateCache(String string) {
        this._formatString = string;
        this.setTimeZone(TimeZone.getDefault());
    }

    public DateCache(String string, Locale locale) {
        this._formatString = string;
        this._locale = locale;
        this.setTimeZone(TimeZone.getDefault());
    }

    public DateCache(String string, DateFormatSymbols dateFormatSymbols) {
        this._formatString = string;
        this._dfs = dateFormatSymbols;
        this.setTimeZone(TimeZone.getDefault());
    }

    public void setTimeZone(TimeZone timeZone) {
        this.setTzFormatString(timeZone);
        if (this._locale != null) {
            this._tzFormat = new SimpleDateFormat(this._tzFormatString, this._locale);
            this._minFormat = new SimpleDateFormat(this._minFormatString, this._locale);
        } else if (this._dfs != null) {
            this._tzFormat = new SimpleDateFormat(this._tzFormatString, this._dfs);
            this._minFormat = new SimpleDateFormat(this._minFormatString, this._dfs);
        } else {
            this._tzFormat = new SimpleDateFormat(this._tzFormatString);
            this._minFormat = new SimpleDateFormat(this._minFormatString);
        }
        this._tzFormat.setTimeZone(timeZone);
        this._minFormat.setTimeZone(timeZone);
        this._lastSeconds = -1L;
        this._lastMinutes = -1L;
    }

    public TimeZone getTimeZone() {
        return this._tzFormat.getTimeZone();
    }

    public void setTimeZoneID(String string) {
        this.setTimeZone(TimeZone.getTimeZone(string));
    }

    private void setTzFormatString(TimeZone timeZone) {
        int n = this._formatString.indexOf("ZZZ");
        if (n >= 0) {
            String string = this._formatString.substring(0, n);
            String string2 = this._formatString.substring(n + 3);
            int n2 = timeZone.getRawOffset();
            StringBuffer stringBuffer = new StringBuffer(this._formatString.length() + 10);
            stringBuffer.append(string);
            stringBuffer.append("'");
            if (n2 >= 0) {
                stringBuffer.append('+');
            } else {
                n2 = -n2;
                stringBuffer.append('-');
            }
            int n3 = n2 / 60000;
            int n4 = n3 / 60;
            int n5 = n3 % 60;
            if (n4 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n4);
            if (n5 < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n5);
            stringBuffer.append('\'');
            stringBuffer.append(string2);
            this._tzFormatString = stringBuffer.toString();
        } else {
            this._tzFormatString = this._formatString;
        }
        this.setMinFormatString();
    }

    private void setMinFormatString() {
        int n = this._tzFormatString.indexOf("ss.SSS");
        int n2 = 6;
        if (n >= 0) {
            throw new IllegalStateException("ms not supported");
        }
        n = this._tzFormatString.indexOf("ss");
        n2 = 2;
        String string = this._tzFormatString.substring(0, n);
        String string2 = this._tzFormatString.substring(n + n2);
        this._minFormatString = string + "'ss'" + string2;
    }

    public synchronized String format(Date date) {
        return this.format(date.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String format(long l) {
        StringBuffer stringBuffer;
        long l2 = l / 1000L;
        if (l2 < this._lastSeconds || this._lastSeconds > 0L && l2 > this._lastSeconds + __hitWindow) {
            Date date = new Date(l);
            return this._tzFormat.format(date);
        }
        if (this._lastSeconds == l2) {
            return this._lastResult;
        }
        Date date = new Date(l);
        long l3 = l2 / 60L;
        if (this._lastMinutes != l3) {
            this._lastMinutes = l3;
            this._secFormatString = this._minFormat.format(date);
            int n = this._secFormatString.indexOf("ss");
            int n2 = 2;
            this._secFormatString0 = this._secFormatString.substring(0, n);
            this._secFormatString1 = this._secFormatString.substring(n + n2);
        }
        this._lastSeconds = l2;
        StringBuffer stringBuffer2 = stringBuffer = new StringBuffer(this._secFormatString.length());
        synchronized (stringBuffer2) {
            stringBuffer.append(this._secFormatString0);
            int n = (int)(l2 % 60L);
            if (n < 10) {
                stringBuffer.append('0');
            }
            stringBuffer.append(n);
            stringBuffer.append(this._secFormatString1);
            this._lastResult = stringBuffer.toString();
        }
        return this._lastResult;
    }

    public void format(long l, StringBuffer stringBuffer) {
        stringBuffer.append(this.format(l));
    }

    public SimpleDateFormat getFormat() {
        return this._minFormat;
    }

    public String getFormatString() {
        return this._formatString;
    }

    public String now() {
        long l = System.currentTimeMillis();
        this._lastMs = (int)(l % 1000L);
        return this.format(l);
    }

    public int lastMs() {
        return this._lastMs;
    }
}

