/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import org.mortbay.log.Log;
import org.mortbay.thread.BoundedThreadPool;

public class IO
extends BoundedThreadPool {
    public static final String CRLF = "\r\n";
    public static final byte[] CRLF_BYTES = new byte[]{13, 10};
    public static int bufferSize = 16384;
    private static NullOS __nullStream = new NullOS();
    private static ClosedIS __closedStream = new ClosedIS();
    private static NullWrite __nullWriter = new NullWrite();

    public static IO instance() {
        return Singleton.__instance;
    }

    public static void copyThread(InputStream inputStream, OutputStream outputStream) {
        try {
            Job job = new Job(inputStream, outputStream);
            if (!IO.instance().dispatch(job)) {
                job.run();
            }
        }
        catch (Exception exception) {
            Log.warn(exception);
        }
    }

    public static void copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        IO.copy(inputStream, outputStream, -1L);
    }

    public static void copyThread(Reader reader, Writer writer) {
        try {
            Job job = new Job(reader, writer);
            if (!IO.instance().dispatch(job)) {
                job.run();
            }
        }
        catch (Exception exception) {
            Log.warn(exception);
        }
    }

    public static void copy(Reader reader, Writer writer) throws IOException {
        IO.copy(reader, writer, -1L);
    }

    public static void copy(InputStream inputStream, OutputStream outputStream, long l) throws IOException {
        byte[] byArray = new byte[bufferSize];
        int n = bufferSize;
        if (l >= 0L) {
            while (l > 0L && (n = l < (long)bufferSize ? inputStream.read(byArray, 0, (int)l) : inputStream.read(byArray, 0, bufferSize)) != -1) {
                l -= (long)n;
                outputStream.write(byArray, 0, n);
            }
        } else {
            while ((n = inputStream.read(byArray, 0, bufferSize)) >= 0) {
                outputStream.write(byArray, 0, n);
            }
        }
    }

    public static void copy(Reader reader, Writer writer, long l) throws IOException {
        char[] cArray = new char[bufferSize];
        int n = bufferSize;
        if (l >= 0L) {
            while (l > 0L && (n = l < (long)bufferSize ? reader.read(cArray, 0, (int)l) : reader.read(cArray, 0, bufferSize)) != -1) {
                l -= (long)n;
                writer.write(cArray, 0, n);
            }
        } else if (writer instanceof PrintWriter) {
            PrintWriter printWriter = (PrintWriter)writer;
            while (!printWriter.checkError() && (n = reader.read(cArray, 0, bufferSize)) != -1) {
                writer.write(cArray, 0, n);
            }
        } else {
            while ((n = reader.read(cArray, 0, bufferSize)) != -1) {
                writer.write(cArray, 0, n);
            }
        }
    }

    public static void copy(File file, File file2) throws IOException {
        if (file.isDirectory()) {
            IO.copyDir(file, file2);
        } else {
            IO.copyFile(file, file2);
        }
    }

    public static void copyDir(File file, File file2) throws IOException {
        File[] fileArray;
        if (file2.exists()) {
            if (!file2.isDirectory()) {
                throw new IllegalArgumentException(file2.toString());
            }
        } else {
            file2.mkdirs();
        }
        if ((fileArray = file.listFiles()) != null) {
            for (int i = 0; i < fileArray.length; ++i) {
                String string = fileArray[i].getName();
                if (".".equals(string) || "..".equals(string)) continue;
                IO.copy(fileArray[i], new File(file2, string));
            }
        }
    }

    public static void copyFile(File file, File file2) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(file);
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        IO.copy(fileInputStream, fileOutputStream);
        fileInputStream.close();
        fileOutputStream.close();
    }

    public static String toString(InputStream inputStream) throws IOException {
        return IO.toString(inputStream, null);
    }

    public static String toString(InputStream inputStream, String string) throws IOException {
        StringWriter stringWriter = new StringWriter();
        InputStreamReader inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        IO.copy(inputStreamReader, stringWriter);
        return stringWriter.toString();
    }

    public static String toString(Reader reader) throws IOException {
        StringWriter stringWriter = new StringWriter();
        IO.copy(reader, stringWriter);
        return stringWriter.toString();
    }

    public static boolean delete(File file) {
        if (!file.exists()) {
            return false;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            for (int i = 0; fileArray != null && i < fileArray.length; ++i) {
                IO.delete(fileArray[i]);
            }
        }
        return file.delete();
    }

    public static void close(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            Log.ignore(iOException);
        }
    }

    public static byte[] readBytes(InputStream inputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        IO.copy(inputStream, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static void close(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            Log.ignore(iOException);
        }
    }

    public static OutputStream getNullStream() {
        return __nullStream;
    }

    public static InputStream getClosedStream() {
        return __closedStream;
    }

    public static Writer getNullWriter() {
        return __nullWriter;
    }

    private static class NullWrite
    extends Writer {
        private NullWrite() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(char[] cArray) {
        }

        @Override
        public void write(char[] cArray, int n, int n2) {
        }

        @Override
        public void write(int n) {
        }

        @Override
        public void write(String string) {
        }

        @Override
        public void write(String string, int n, int n2) {
        }
    }

    private static class ClosedIS
    extends InputStream {
        private ClosedIS() {
        }

        @Override
        public int read() throws IOException {
            return -1;
        }
    }

    private static class NullOS
    extends OutputStream {
        private NullOS() {
        }

        @Override
        public void close() {
        }

        @Override
        public void flush() {
        }

        @Override
        public void write(byte[] byArray) {
        }

        @Override
        public void write(byte[] byArray, int n, int n2) {
        }

        @Override
        public void write(int n) {
        }
    }

    static class Job
    implements Runnable {
        InputStream in;
        OutputStream out;
        Reader read;
        Writer write;

        Job(InputStream inputStream, OutputStream outputStream) {
            this.in = inputStream;
            this.out = outputStream;
            this.read = null;
            this.write = null;
        }

        Job(Reader reader, Writer writer) {
            this.in = null;
            this.out = null;
            this.read = reader;
            this.write = writer;
        }

        @Override
        public void run() {
            try {
                if (this.in != null) {
                    IO.copy(this.in, this.out, -1L);
                } else {
                    IO.copy(this.read, this.write, -1L);
                }
            }
            catch (IOException iOException) {
                Log.ignore(iOException);
                try {
                    if (this.out != null) {
                        this.out.close();
                    }
                    if (this.write != null) {
                        this.write.close();
                    }
                }
                catch (IOException iOException2) {
                    Log.ignore(iOException2);
                }
            }
        }
    }

    private static class Singleton {
        static final IO __instance = new IO();

        private Singleton() {
        }

        static {
            try {
                __instance.start();
            }
            catch (Exception exception) {
                Log.warn(exception);
                System.exit(1);
            }
        }
    }
}

