/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import org.mortbay.util.LazyList;

public class MultiException
extends Exception {
    private Object nested;

    public MultiException() {
        super("Multiple exceptions");
    }

    public void add(Throwable throwable) {
        if (throwable instanceof MultiException) {
            MultiException multiException = (MultiException)throwable;
            for (int i = 0; i < LazyList.size(multiException.nested); ++i) {
                this.nested = LazyList.add(this.nested, LazyList.get(multiException.nested, i));
            }
        } else {
            this.nested = LazyList.add(this.nested, throwable);
        }
    }

    public int size() {
        return LazyList.size(this.nested);
    }

    public List getThrowables() {
        return LazyList.getList(this.nested);
    }

    public Throwable getThrowable(int n) {
        return (Throwable)LazyList.get(this.nested, n);
    }

    public void ifExceptionThrow() throws Exception {
        switch (LazyList.size(this.nested)) {
            case 0: {
                break;
            }
            case 1: {
                Throwable throwable = (Throwable)LazyList.get(this.nested, 0);
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
            }
            default: {
                throw this;
            }
        }
    }

    public void ifExceptionThrowRuntime() throws Error {
        switch (LazyList.size(this.nested)) {
            case 0: {
                break;
            }
            case 1: {
                Throwable throwable = (Throwable)LazyList.get(this.nested, 0);
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new RuntimeException(throwable);
            }
            default: {
                throw new RuntimeException(this);
            }
        }
    }

    public void ifExceptionThrowMulti() throws MultiException {
        if (LazyList.size(this.nested) > 0) {
            throw this;
        }
    }

    @Override
    public String toString() {
        if (LazyList.size(this.nested) > 0) {
            return "org.mortbay.util.MultiException" + LazyList.getList(this.nested);
        }
        return "org.mortbay.util.MultiException[]";
    }

    @Override
    public void printStackTrace() {
        super.printStackTrace();
        for (int i = 0; i < LazyList.size(this.nested); ++i) {
            ((Throwable)LazyList.get(this.nested, i)).printStackTrace();
        }
    }

    @Override
    public void printStackTrace(PrintStream printStream) {
        super.printStackTrace(printStream);
        for (int i = 0; i < LazyList.size(this.nested); ++i) {
            ((Throwable)LazyList.get(this.nested, i)).printStackTrace(printStream);
        }
    }

    @Override
    public void printStackTrace(PrintWriter printWriter) {
        super.printStackTrace(printWriter);
        for (int i = 0; i < LazyList.size(this.nested); ++i) {
            ((Throwable)LazyList.get(this.nested, i)).printStackTrace(printWriter);
        }
    }
}

