/*
 * Decompiled with CFR 0.152.
 */
package org.mortbay.util;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class SingletonList
extends AbstractList {
    private Object o;

    private SingletonList(Object object) {
        this.o = object;
    }

    public static SingletonList newSingletonList(Object object) {
        return new SingletonList(object);
    }

    @Override
    public Object get(int n) {
        if (n != 0) {
            throw new IndexOutOfBoundsException("index " + n);
        }
        return this.o;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public ListIterator listIterator() {
        return new SIterator();
    }

    @Override
    public ListIterator listIterator(int n) {
        return new SIterator(n);
    }

    @Override
    public Iterator iterator() {
        return new SIterator();
    }

    private class SIterator
    implements ListIterator {
        int i;

        SIterator() {
            this.i = 0;
        }

        SIterator(int n) {
            if (n < 0 || n > 1) {
                throw new IndexOutOfBoundsException("index " + n);
            }
            this.i = n;
        }

        public void add(Object object) {
            throw new UnsupportedOperationException("SingletonList.add()");
        }

        @Override
        public boolean hasNext() {
            return this.i == 0;
        }

        @Override
        public boolean hasPrevious() {
            return this.i == 1;
        }

        @Override
        public Object next() {
            if (this.i != 0) {
                throw new NoSuchElementException();
            }
            ++this.i;
            return SingletonList.this.o;
        }

        @Override
        public int nextIndex() {
            return this.i;
        }

        public Object previous() {
            if (this.i != 1) {
                throw new NoSuchElementException();
            }
            --this.i;
            return SingletonList.this.o;
        }

        @Override
        public int previousIndex() {
            return this.i - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("SingletonList.remove()");
        }

        public void set(Object object) {
            throw new UnsupportedOperationException("SingletonList.add()");
        }
    }
}

